/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.multibranch;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Functions;
import hudson.model.Action;
import hudson.model.Computer;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.scm.SCM;
import hudson.slaves.WorkspaceList;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import jenkins.branch.Branch;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMFileSystem;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMRevisionAction;
import jenkins.scm.api.SCMSource;
import jenkins.security.HMACConfidentialKey;
import org.jenkinsci.plugins.workflow.cps.CpsScmFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.multibranch.BranchJobProperty;
import org.jenkinsci.plugins.workflow.multibranch.Messages;
import org.jenkinsci.plugins.workflow.multibranch.SCMBinder;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.scm.GenericSCMStep;
import org.kohsuke.stapler.DataBoundConstructor;

public class ReadTrustedStep
extends Step {
    private static final HMACConfidentialKey CHECKOUT_DIR_KEY = new HMACConfidentialKey(CpsScmFlowDefinition.class, "filePathWithSuffix", 32);
    private final String path;

    @DataBoundConstructor
    public ReadTrustedStep(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public static class Execution
    extends SynchronousNonBlockingStepExecution<String> {
        private final transient ReadTrustedStep step;
        private static final long serialVersionUID = 1L;

        Execution(ReadTrustedStep step, StepContext context) {
            super(context);
            this.step = step;
        }

        protected String run() throws Exception {
            String content;
            String untrustedFile;
            boolean trustCheck;
            block60: {
                SCMRevision tip;
                FilePath baseWorkspace;
                Run build = (Run)this.getContext().get(Run.class);
                TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
                Job job = build.getParent();
                SCM standaloneSCM = null;
                BranchJobProperty property = (BranchJobProperty)job.getProperty(BranchJobProperty.class);
                if (property == null) {
                    FlowDefinition defn;
                    boolean ok = false;
                    if (job instanceof WorkflowJob && (defn = ((WorkflowJob)job).getDefinition()) instanceof CpsScmFlowDefinition) {
                        standaloneSCM = ((CpsScmFlowDefinition)defn).getScm();
                        try (SCMFileSystem fs = SCMBinder.USE_HEAVYWEIGHT_CHECKOUT ? null : SCMFileSystem.of((Item)job, (SCM)standaloneSCM);){
                            if (fs != null) {
                                try {
                                    String text = fs.child(this.step.path).contentAsString();
                                    listener.getLogger().println("Obtained " + this.step.path + " from " + standaloneSCM.getKey());
                                    String string = text;
                                    return string;
                                }
                                catch (IOException | InterruptedException x) {
                                    listener.error("Could not do lightweight checkout, falling back to heavyweight").println(Functions.printThrowable((Throwable)x).trim());
                                }
                            } else if (!SCMBinder.USE_HEAVYWEIGHT_CHECKOUT) {
                                listener.getLogger().println("No lightweight checkout support in this SCM configuration");
                            }
                        }
                        ok = true;
                    }
                    if (!ok) {
                        throw new AbortException("\u2018readTrusted\u2019 is only available when using \u201c" + ((WorkflowMultiBranchProject.DescriptorImpl)Jenkins.get().getDescriptorByType(WorkflowMultiBranchProject.DescriptorImpl.class)).getDisplayName() + "\u201d or \u201c" + ((CpsScmFlowDefinition.DescriptorImpl)Jenkins.get().getDescriptorByType(CpsScmFlowDefinition.DescriptorImpl.class)).getDisplayName() + "\u201d");
                    }
                }
                Jenkins node = Jenkins.get();
                if (job instanceof TopLevelItem) {
                    baseWorkspace = node.getWorkspaceFor((TopLevelItem)job);
                    if (baseWorkspace == null) {
                        throw new AbortException(node.getDisplayName() + " may be offline");
                    }
                } else {
                    throw new IllegalStateException(String.valueOf(job) + " was not top level");
                }
                Computer computer = node.toComputer();
                if (computer == null) {
                    throw new IOException(node.getDisplayName() + " may be offline");
                }
                if (standaloneSCM != null) {
                    FilePath dir = this.getFilePathWithSuffix(baseWorkspace, standaloneSCM);
                    FilePath file = dir.child(this.step.path);
                    try (WorkspaceList.Lease lease = computer.getWorkspaceList().acquire(dir);){
                        dir.withSuffix("-scm-key.txt").write(standaloneSCM.getKey(), "UTF-8");
                        GenericSCMStep delegate = new GenericSCMStep(standaloneSCM);
                        delegate.setPoll(true);
                        delegate.setChangelog(true);
                        delegate.checkout(build, dir, listener, node.createLauncher(listener));
                        if (!Execution.isDescendant(file, dir)) {
                            throw new AbortException(String.valueOf(file) + " references a file that is not inside " + String.valueOf(dir));
                        }
                        if (!file.exists()) {
                            throw new AbortException(String.valueOf(file) + " not found");
                        }
                        String string = file.readToString();
                        return string;
                    }
                }
                Branch branch = property.getBranch();
                ItemGroup parent = job.getParent();
                if (!(parent instanceof WorkflowMultiBranchProject)) {
                    throw new IllegalStateException("inappropriate context");
                }
                SCMSource scmSource = ((WorkflowMultiBranchProject)parent).getSCMSource(branch.getSourceId());
                if (scmSource == null) {
                    throw new IllegalStateException(branch.getSourceId() + " not found");
                }
                SCMHead head = branch.getHead();
                SCMRevisionAction action = (SCMRevisionAction)build.getAction(SCMRevisionAction.class);
                if (action != null) {
                    tip = action.getRevision();
                } else {
                    tip = scmSource.fetch(head, listener);
                    if (tip == null) {
                        throw new AbortException("Could not determine exact tip revision of " + branch.getName());
                    }
                    build.addAction((Action)new SCMRevisionAction(scmSource, tip));
                }
                SCMRevision trusted = scmSource.getTrustedRevision(tip, listener);
                trustCheck = !tip.equals((Object)trusted);
                untrustedFile = null;
                try (SCMFileSystem tipFS = trustCheck && !SCMBinder.USE_HEAVYWEIGHT_CHECKOUT ? SCMFileSystem.of((SCMSource)scmSource, (SCMHead)head, (SCMRevision)tip) : null;
                     SCMFileSystem trustedFS = SCMBinder.USE_HEAVYWEIGHT_CHECKOUT ? null : SCMFileSystem.of((SCMSource)scmSource, (SCMHead)head, (SCMRevision)trusted);){
                    if (!(trustedFS == null || trustCheck && tipFS == null)) {
                        if (trustCheck) {
                            untrustedFile = tipFS.child(this.step.path).contentAsString();
                        }
                        content = trustedFS.child(this.step.path).contentAsString();
                        listener.getLogger().println("Obtained " + this.step.path + " from " + String.valueOf(trusted));
                        break block60;
                    }
                    listener.getLogger().println("Checking out " + head.getName() + " to read " + this.step.path);
                    SCM trustedScm = scmSource.build(head, trusted);
                    FilePath dir = this.getFilePathWithSuffix(baseWorkspace, trustedScm);
                    FilePath file = dir.child(this.step.path);
                    try (WorkspaceList.Lease lease = computer.getWorkspaceList().acquire(dir);){
                        GenericSCMStep delegate;
                        dir.withSuffix("-scm-key.txt").write(trustedScm.getKey(), "UTF-8");
                        if (trustCheck) {
                            delegate = new GenericSCMStep(scmSource.build(head, tip));
                            delegate.setPoll(false);
                            delegate.setChangelog(false);
                            delegate.checkout(build, dir, listener, node.createLauncher(listener));
                            if (!Execution.isDescendant(file, dir)) {
                                throw new AbortException(String.valueOf(file) + " references a file that is not inside " + String.valueOf(dir));
                            }
                            if (!file.exists()) {
                                throw new AbortException(String.valueOf(file) + " not found");
                            }
                            untrustedFile = file.readToString();
                        }
                        delegate = new GenericSCMStep(trustedScm);
                        delegate.setPoll(true);
                        delegate.setChangelog(true);
                        delegate.checkout(build, dir, listener, node.createLauncher(listener));
                        if (!Execution.isDescendant(file, dir)) {
                            throw new AbortException(String.valueOf(file) + " references a file that is not inside " + String.valueOf(dir));
                        }
                        if (!file.exists()) {
                            throw new AbortException(String.valueOf(file) + " not found");
                        }
                        content = file.readToString();
                    }
                }
            }
            if (trustCheck && !untrustedFile.equals(content)) {
                throw new AbortException(Messages.ReadTrustedStep__has_been_modified_in_an_untrusted_revis(this.step.path));
            }
            return content;
        }

        private FilePath getFilePathWithSuffix(FilePath baseWorkspace, SCM scm) {
            return baseWorkspace.withSuffix(this.getFilePathSuffix() + "script").child(CHECKOUT_DIR_KEY.mac(scm.getKey()));
        }

        private String getFilePathSuffix() {
            return System.getProperty(WorkspaceList.class.getName(), "@");
        }

        private static boolean isDescendant(FilePath child, FilePath parent) throws IOException, InterruptedException {
            if (child.isRemote() || parent.isRemote()) {
                throw new IllegalStateException();
            }
            return new File(child.getRemote()).getCanonicalFile().toPath().startsWith(new File(parent.getRemote()).getCanonicalPath());
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "readTrusted";
        }

        @NonNull
        public String getDisplayName() {
            return "Read trusted file from SCM";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Set.of(Run.class, TaskListener.class);
        }
    }
}

