/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.multibranch;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.AbstractItem;
import hudson.model.Item;
import hudson.model.JobPropertyDescriptor;
import hudson.security.ACL;
import hudson.security.Permission;
import hudson.util.AlternativeUiTextProvider;
import jenkins.branch.Branch;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowJobProperty;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.springframework.security.core.Authentication;

@ExportedBean
public class BranchJobProperty
extends WorkflowJobProperty {
    @NonNull
    private Branch branch;

    BranchJobProperty(@NonNull Branch branch) {
        this.branch = branch;
    }

    @Exported
    @NonNull
    public synchronized Branch getBranch() {
        return this.branch;
    }

    synchronized void setBranch(@NonNull Branch branch) {
        branch.getClass();
        this.branch = branch;
    }

    @NonNull
    public ACL decorateACL(final @NonNull ACL acl) {
        return new ACL(){

            public boolean hasPermission2(@NonNull Authentication a, @NonNull Permission permission) {
                if (ACL.SYSTEM2.equals((Object)a)) {
                    return true;
                }
                if (permission == Item.CONFIGURE) {
                    return false;
                }
                if (permission == Item.DELETE && !(BranchJobProperty.this.branch instanceof Branch.Dead)) {
                    return false;
                }
                return acl.hasPermission2(a, permission);
            }
        };
    }

    public Boolean isBuildable() {
        if (this.branch instanceof Branch.Dead) {
            return false;
        }
        return null;
    }

    @Extension
    public static class AlternativeUiTextProviderImpl
    extends AlternativeUiTextProvider {
        public <T> String getText(AlternativeUiTextProvider.Message<T> text, T context) {
            WorkflowJob job;
            BranchJobProperty property;
            if (text == AbstractItem.PRONOUN && context instanceof WorkflowJob && (property = (BranchJobProperty)(job = (WorkflowJob)context).getProperty(BranchJobProperty.class)) != null) {
                return property.getBranch().getHead().getPronoun();
            }
            return null;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends JobPropertyDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Based on branch";
        }
    }
}

