/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.multibranch;

import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.User;
import hudson.model.View;
import hudson.security.ACL;
import hudson.security.AuthorizationStrategy;
import hudson.security.FullControlOnceLoggedInAuthorizationStrategy;
import hudson.security.SecurityRealm;
import java.io.File;
import java.io.OutputStream;
import java.util.List;
import jenkins.branch.MultiBranchProject;
import jenkins.branch.OrganizationFolder;
import jenkins.plugins.git.GitSampleRepoRule;
import jenkins.scm.api.SCMSource;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.multibranch.GitDirectorySCMNavigator;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProjectFactory;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProjectTest;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.jvnet.hudson.test.BuildWatcher;
import org.jvnet.hudson.test.JenkinsRule;
import org.springframework.security.core.Authentication;

public class WorkflowMultiBranchProjectFactoryTest {
    @ClassRule
    public static BuildWatcher buildWatcher = new BuildWatcher();
    @Rule
    public JenkinsRule r = new JenkinsRule();
    @Rule
    public GitSampleRepoRule sampleRepo1 = new GitSampleRepoRule();
    @Rule
    public GitSampleRepoRule sampleRepo2 = new GitSampleRepoRule();
    @Rule
    public GitSampleRepoRule sampleRepo3 = new GitSampleRepoRule();
    @Rule
    public TemporaryFolder tmp = new TemporaryFolder();

    @Test
    public void smokes() throws Exception {
        File clones = this.tmp.newFolder();
        this.sampleRepo1.init();
        this.sampleRepo1.write("Jenkinsfile", "echo 'ran one'");
        this.sampleRepo1.git(new String[]{"add", "Jenkinsfile"});
        this.sampleRepo1.git(new String[]{"commit", "--all", "--message=flow"});
        this.sampleRepo1.git(new String[]{"clone", ".", new File(clones, "one").getAbsolutePath()});
        this.sampleRepo3.init();
        this.sampleRepo3.git(new String[]{"clone", ".", new File(clones, "three").getAbsolutePath()});
        this.r.jenkins.setSecurityRealm((SecurityRealm)this.r.createDummySecurityRealm());
        this.r.jenkins.setAuthorizationStrategy((AuthorizationStrategy)new FullControlOnceLoggedInAuthorizationStrategy());
        OrganizationFolder top = (OrganizationFolder)this.r.jenkins.createProject(OrganizationFolder.class, "top");
        top.getNavigators().add((Object)new GitDirectorySCMNavigator(clones.getAbsolutePath()));
        top.scheduleBuild2(0, new Action[0]).getFuture().get();
        top.getComputation().writeWholeLogTo((OutputStream)System.out);
        Assert.assertEquals((long)1L, (long)top.getItems().size());
        MultiBranchProject one = top.getItem("one");
        Assert.assertThat((Object)one, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(WorkflowMultiBranchProject.class)));
        List sources = one.getSCMSources();
        Assert.assertEquals((long)1L, (long)sources.size());
        Assert.assertEquals((Object)"GitSCMSource", (Object)((SCMSource)sources.get(0)).getClass().getSimpleName());
        Authentication admin = User.getById((String)"admin", (boolean)true).impersonate2();
        ACL acl = one.getACL();
        Assert.assertTrue((boolean)acl.hasPermission2(ACL.SYSTEM2, Item.CONFIGURE));
        Assert.assertTrue((boolean)acl.hasPermission2(ACL.SYSTEM2, Item.DELETE));
        Assert.assertFalse((boolean)acl.hasPermission2(admin, Item.CONFIGURE));
        Assert.assertFalse((boolean)acl.hasPermission2(admin, View.CONFIGURE));
        Assert.assertFalse((boolean)acl.hasPermission2(admin, View.CREATE));
        Assert.assertFalse((boolean)acl.hasPermission2(admin, View.DELETE));
        Assert.assertFalse((boolean)acl.hasPermission2(admin, Item.DELETE));
        Assert.assertTrue((boolean)acl.hasPermission2(admin, Item.EXTENDED_READ));
        Assert.assertTrue((boolean)acl.hasPermission2(admin, Item.READ));
        Assert.assertTrue((boolean)acl.hasPermission2(admin, View.READ));
        this.r.waitUntilNoActivity();
        WorkflowJob p = WorkflowMultiBranchProjectTest.findBranchProject((WorkflowMultiBranchProject)one, "master");
        WorkflowRun b1 = p.getLastBuild();
        Assert.assertEquals((long)1L, (long)b1.getNumber());
        this.r.assertLogContains("ran one", (Run)b1);
        this.sampleRepo2.init();
        this.sampleRepo2.write("Jenkinsfile", "echo 'ran two'");
        this.sampleRepo2.git(new String[]{"add", "Jenkinsfile"});
        this.sampleRepo2.git(new String[]{"commit", "--all", "--message=flow"});
        this.sampleRepo2.git(new String[]{"clone", ".", new File(clones, "two").getAbsolutePath()});
        top.scheduleBuild2(0, new Action[0]).getFuture().get();
        top.getComputation().writeWholeLogTo((OutputStream)System.out);
        Assert.assertEquals((long)2L, (long)top.getItems().size());
        MultiBranchProject two = top.getItem("two");
        Assert.assertThat((Object)two, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(WorkflowMultiBranchProject.class)));
        this.r.waitUntilNoActivity();
        p = WorkflowMultiBranchProjectTest.findBranchProject((WorkflowMultiBranchProject)two, "master");
        b1 = p.getLastBuild();
        Assert.assertEquals((long)1L, (long)b1.getNumber());
        this.r.assertLogContains("ran two", (Run)b1);
        this.sampleRepo2.git(new String[]{"rm", "Jenkinsfile"});
        this.sampleRepo2.git(new String[]{"commit", "--message=noflow"});
        top.scheduleBuild2(0, new Action[0]).getFuture().get();
        top.getComputation().writeWholeLogTo((OutputStream)System.out);
        Assert.assertEquals((long)1L, (long)top.getItems().size());
    }

    @Test
    public void configuredScriptName() throws Exception {
        String alternativeJenkinsFileName = "alternative_Jenkinsfile_name.groovy";
        File clones = this.tmp.newFolder();
        this.sampleRepo1.init();
        this.sampleRepo1.write("Jenkinsfile", "echo 'echo from Jenkinsfile'");
        this.sampleRepo1.git(new String[]{"add", "Jenkinsfile"});
        this.sampleRepo1.git(new String[]{"commit", "--all", "--message=flow"});
        String repoWithJenkinsfile = "repo_with_jenkinsfile";
        this.sampleRepo1.git(new String[]{"clone", ".", new File(clones, repoWithJenkinsfile).getAbsolutePath()});
        this.r.jenkins.setSecurityRealm((SecurityRealm)this.r.createDummySecurityRealm());
        this.r.jenkins.setAuthorizationStrategy((AuthorizationStrategy)new FullControlOnceLoggedInAuthorizationStrategy());
        OrganizationFolder top = (OrganizationFolder)this.r.jenkins.createProject(OrganizationFolder.class, "top");
        top.getNavigators().add((Object)new GitDirectorySCMNavigator(clones.getAbsolutePath()));
        top.scheduleBuild2(0, new Action[0]).getFuture().get();
        top.getComputation().writeWholeLogTo((OutputStream)System.out);
        Assert.assertEquals((long)1L, (long)top.getItems().size());
        top.scheduleBuild2(0, new Action[0]).getFuture().get();
        top.getComputation().writeWholeLogTo((OutputStream)System.out);
        Assert.assertEquals((long)1L, (long)top.getItems().size());
        MultiBranchProject projectFromJenkinsfile = top.getItem(repoWithJenkinsfile);
        Assert.assertThat((Object)projectFromJenkinsfile, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(WorkflowMultiBranchProject.class)));
        this.r.waitUntilNoActivity();
        WorkflowJob p = WorkflowMultiBranchProjectTest.findBranchProject((WorkflowMultiBranchProject)projectFromJenkinsfile, "master");
        WorkflowRun b1 = p.getLastBuild();
        Assert.assertEquals((long)1L, (long)b1.getNumber());
        this.r.assertLogContains("echo from Jenkinsfile", (Run)b1);
        WorkflowMultiBranchProjectFactory workflowMultiBranchProjectFactory = new WorkflowMultiBranchProjectFactory();
        workflowMultiBranchProjectFactory.setScriptPath(alternativeJenkinsFileName);
        top.getProjectFactories().add((Object)workflowMultiBranchProjectFactory);
        this.sampleRepo2.init();
        this.sampleRepo2.write(alternativeJenkinsFileName, "echo 'echo from " + alternativeJenkinsFileName + "'");
        this.sampleRepo2.git(new String[]{"add", alternativeJenkinsFileName});
        this.sampleRepo2.git(new String[]{"commit", "--all", "--message=flow"});
        String repoWithAlternativeJenkinsfile = "repo_with_alternative_jenkinsfile";
        this.sampleRepo2.git(new String[]{"clone", ".", new File(clones, repoWithAlternativeJenkinsfile).getAbsolutePath()});
        top.scheduleBuild2(0, new Action[0]).getFuture().get();
        top.getComputation().writeWholeLogTo((OutputStream)System.out);
        Assert.assertEquals((long)2L, (long)top.getItems().size());
        MultiBranchProject projectFromAlternativeJenkinsFile = top.getItem(repoWithAlternativeJenkinsfile);
        Assert.assertThat((Object)projectFromAlternativeJenkinsFile, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(WorkflowMultiBranchProject.class)));
        this.r.waitUntilNoActivity();
        p = WorkflowMultiBranchProjectTest.findBranchProject((WorkflowMultiBranchProject)projectFromAlternativeJenkinsFile, "master");
        b1 = p.getLastBuild();
        Assert.assertEquals((long)1L, (long)b1.getNumber());
        this.r.assertLogContains("echo from alternative_Jenkinsfile_name", (Run)b1);
    }
}

