/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.multibranch;

import hudson.model.Job;
import hudson.model.TopLevelItem;
import jenkins.scm.impl.mock.MockRepositoryFlags;
import jenkins.scm.impl.mock.MockSCMController;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;

public class ResolveScmStepTest {
    @ClassRule
    public static JenkinsRule j = new JenkinsRule();

    @Before
    public void cleanOutAllItems() throws Exception {
        for (TopLevelItem i : j.getInstance().getItems()) {
            i.delete();
        }
    }

    @Test
    public void given_existingHeadName_when_invoked_then_existingHeadNameReturned() throws Exception {
        try (MockSCMController c = MockSCMController.create();){
            c.createRepository("repo", new MockRepositoryFlags[0]);
            c.createBranch("repo", "foo");
            c.addFile("repo", "foo", "Add file", "new-file.txt", "content".getBytes());
            WorkflowJob job = (WorkflowJob)ResolveScmStepTest.j.jenkins.createProject(WorkflowJob.class, "workflow");
            job.setDefinition((FlowDefinition)new CpsFlowDefinition("node {\n  def tests = resolveScm source: mockScm(controllerId:'" + c.getId() + "', repository:'repo', traits: [discoverBranches()]), targets:['foo']\n  checkout tests\n  if (!fileExists('new-file.txt')) { error 'wrong branch checked out' }\n}", true));
            j.buildAndAssertSuccess((Job)job);
        }
    }

    @Test
    public void given_nonExistingHeadName_when_invokedIgnoringErrors_then_nullReturned() throws Exception {
        try (MockSCMController c = MockSCMController.create();){
            c.createRepository("repo", new MockRepositoryFlags[0]);
            c.createBranch("repo", "foo");
            WorkflowJob job = (WorkflowJob)ResolveScmStepTest.j.jenkins.createProject(WorkflowJob.class, "workflow");
            job.setDefinition((FlowDefinition)new CpsFlowDefinition("node {\n  def tests = resolveScm source: mockScm(controllerId:'" + c.getId() + "', repository:'repo', traits: [discoverBranches()]), targets:['bar'], ignoreErrors: true\n  if (tests != null) { error \"resolved as ${tests}\"}\n}", true));
            j.buildAndAssertSuccess((Job)job);
        }
    }

    @Test
    public void given_nonExistingHeadName_when_invoked_then_abortThrown() throws Exception {
        try (MockSCMController c = MockSCMController.create();){
            c.createRepository("repo", new MockRepositoryFlags[0]);
            c.createBranch("repo", "foo");
            WorkflowJob job = (WorkflowJob)ResolveScmStepTest.j.jenkins.createProject(WorkflowJob.class, "workflow");
            job.setDefinition((FlowDefinition)new CpsFlowDefinition("node {\n  def ok = true\n  try {\n  def tests = resolveScm source: mockScm(controllerId:'" + c.getId() + "', repository:'repo', traits: [discoverBranches()]), targets:['bar']\n    ok = false\n  } catch (e) {}\n  if (!ok) { error 'abort not thrown' }\n}", true));
            j.buildAndAssertSuccess((Job)job);
        }
    }

    @Test
    public void given_nonExistingHeadName_when_invokedWithDefault_then_defaultReturned() throws Exception {
        try (MockSCMController c = MockSCMController.create();){
            c.createRepository("repo", new MockRepositoryFlags[0]);
            c.createBranch("repo", "manchu");
            c.addFile("repo", "manchu", "Add file", "new-file.txt", "content".getBytes());
            WorkflowJob job = (WorkflowJob)ResolveScmStepTest.j.jenkins.createProject(WorkflowJob.class, "workflow");
            job.setDefinition((FlowDefinition)new CpsFlowDefinition("node {\n  def tests = resolveScm source: mockScm(controllerId:'" + c.getId() + "', repository:'repo', traits: [discoverBranches()]), targets:['bar', 'manchu']\n  checkout tests\n  if (!fileExists('new-file.txt')) { error 'wrong branch checked out' }\n}", true));
            j.buildAndAssertSuccess((Job)job);
        }
    }
}

