/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.multibranch;

import hudson.model.Action;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Run;
import hudson.model.User;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.security.AuthorizationStrategy;
import hudson.security.Permission;
import hudson.security.SecurityRealm;
import java.io.File;
import java.io.OutputStream;
import java.util.Collections;
import java.util.concurrent.Future;
import jenkins.branch.BranchProperty;
import jenkins.branch.BranchPropertyStrategy;
import jenkins.branch.BranchSource;
import jenkins.branch.DefaultBranchPropertyStrategy;
import jenkins.branch.MultiBranchProject;
import jenkins.branch.OrganizationFolder;
import jenkins.model.Jenkins;
import jenkins.plugins.git.GitSCMSource;
import jenkins.plugins.git.GitSampleRepoRule;
import jenkins.plugins.git.GitStep;
import jenkins.scm.api.SCMSource;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.cps.CpsScmFlowDefinition;
import org.jenkinsci.plugins.workflow.cps.replay.ReplayAction;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.multibranch.GitDirectorySCMNavigator;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProjectTest;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.jvnet.hudson.test.BuildWatcher;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.MockAuthorizationStrategy;

public class ReplayActionTest {
    @ClassRule
    public static BuildWatcher buildWatcher = new BuildWatcher();
    @Rule
    public JenkinsRule r = new JenkinsRule();
    @Rule
    public GitSampleRepoRule sampleRepo = new GitSampleRepoRule();
    @Rule
    public TemporaryFolder tmp = new TemporaryFolder();

    @Test
    public void scriptFromSCM() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.write("Jenkinsfile", "node {checkout scm; echo \"loaded ${readFile 'file'}\"}");
        this.sampleRepo.git(new String[]{"add", "Jenkinsfile"});
        this.sampleRepo.write("file", "initial content");
        this.sampleRepo.git(new String[]{"add", "file"});
        this.sampleRepo.git(new String[]{"commit", "--message=init"});
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsScmFlowDefinition(new GitStep(this.sampleRepo.toString()).createSCM(), "Jenkinsfile"));
        WorkflowRun b = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[0]));
        this.r.assertLogContains("loaded initial content", (Run)b);
        this.sampleRepo.write("file", "subsequent content");
        this.sampleRepo.git(new String[]{"add", "file"});
        this.sampleRepo.git(new String[]{"commit", "--message=next"});
        b = (WorkflowRun)((ReplayAction)b.getAction(ReplayAction.class)).run("node {checkout scm; echo \"this time loaded ${readFile 'file'}\"}", Collections.emptyMap()).get();
        Assert.assertEquals((long)2L, (long)b.number);
        this.r.assertLogContains("this time loaded subsequent content", (Run)b);
    }

    @Test
    public void multibranch() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.write("Jenkinsfile", "node {checkout scm; echo readFile('file')}");
        this.sampleRepo.write("file", "initial content");
        this.sampleRepo.git(new String[]{"add", "Jenkinsfile"});
        this.sampleRepo.git(new String[]{"commit", "--all", "--message=init"});
        WorkflowMultiBranchProject mp = (WorkflowMultiBranchProject)this.r.jenkins.createProject(WorkflowMultiBranchProject.class, "p");
        mp.getSourcesList().add((Object)new BranchSource((SCMSource)new GitSCMSource(null, this.sampleRepo.toString(), "", "*", "", false), (BranchPropertyStrategy)new DefaultBranchPropertyStrategy(new BranchProperty[0])));
        WorkflowJob p = WorkflowMultiBranchProjectTest.scheduleAndFindBranchProject(mp, "master");
        this.r.waitUntilNoActivity();
        WorkflowRun b1 = p.getLastBuild();
        Assert.assertNotNull((Object)b1);
        Assert.assertEquals((long)1L, (long)b1.getNumber());
        this.r.assertLogContains("initial content", (Run)b1);
        this.sampleRepo.write("file", "subsequent content");
        this.sampleRepo.git(new String[]{"add", "file"});
        this.sampleRepo.git(new String[]{"commit", "--message=next"});
        WorkflowRun b2 = (WorkflowRun)((ReplayAction)b1.getAction(ReplayAction.class)).run("node {checkout scm; echo readFile('file').toUpperCase()}", Collections.emptyMap()).get();
        Assert.assertEquals((long)2L, (long)b2.number);
        this.r.assertLogContains("INITIAL CONTENT", (Run)b2);
    }

    @Test
    public void permissions() throws Exception {
        File clones = this.tmp.newFolder();
        this.sampleRepo.init();
        this.sampleRepo.write("Jenkinsfile", "");
        this.sampleRepo.git(new String[]{"add", "Jenkinsfile"});
        this.sampleRepo.git(new String[]{"commit", "--all", "--message=init"});
        this.sampleRepo.git(new String[]{"clone", ".", new File(clones, "one").getAbsolutePath()});
        this.r.jenkins.setSecurityRealm((SecurityRealm)this.r.createDummySecurityRealm());
        OrganizationFolder top = (OrganizationFolder)this.r.jenkins.createProject(OrganizationFolder.class, "top");
        this.r.jenkins.setAuthorizationStrategy((AuthorizationStrategy)new MockAuthorizationStrategy().grant(new Permission[]{Jenkins.ADMINISTER}).everywhere().to(new String[]{"admin"}).grant(new Permission[]{Jenkins.READ}).everywhere().to(new String[]{"dev1", "dev2", "dev3"}).grant(new Permission[]{Item.CONFIGURE}).onFolders(new ItemGroup[]{top}).to(new String[]{"dev1"}).grant(new Permission[]{ReplayAction.REPLAY}).onFolders(new ItemGroup[]{top}).to(new String[]{"dev2"}).grant(new Permission[]{Item.BUILD}).onFolders(new ItemGroup[]{top}).to(new String[]{"dev3"}));
        top.getNavigators().add((Object)new GitDirectorySCMNavigator(clones.getAbsolutePath()));
        top.scheduleBuild2(0, new Action[0]).getFuture().get();
        top.getComputation().writeWholeLogTo((OutputStream)System.out);
        Assert.assertEquals((long)1L, (long)top.getItems().size());
        MultiBranchProject one = top.getItem("one");
        this.r.waitUntilNoActivity();
        WorkflowJob p = WorkflowMultiBranchProjectTest.findBranchProject((WorkflowMultiBranchProject)one, "master");
        WorkflowRun b1 = p.getLastBuild();
        Assert.assertEquals((long)1L, (long)b1.getNumber());
        Assert.assertTrue((boolean)ReplayActionTest.canReplay(b1, "admin"));
        Assert.assertTrue((boolean)ReplayActionTest.canReplay(b1, "dev1"));
        Assert.assertTrue((boolean)ReplayActionTest.canReplay(b1, "dev2"));
        Assert.assertFalse((boolean)ReplayActionTest.canReplay(b1, "dev3"));
        p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("", false));
        b1 = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).get();
        Assert.assertTrue((boolean)ReplayActionTest.canReplay(b1, "admin"));
        Assert.assertFalse((String)"not sandboxed, so only safe for admins", (boolean)ReplayActionTest.canReplay(b1, "dev1"));
        Assert.assertFalse((boolean)ReplayActionTest.canReplay(b1, "dev2"));
        Assert.assertFalse((boolean)ReplayActionTest.canReplay(b1, "dev3"));
    }

    private static boolean canReplay(WorkflowRun b, String user) {
        ReplayAction a = (ReplayAction)b.getAction(ReplayAction.class);
        try (ACLContext context = ACL.as((User)User.getById((String)user, (boolean)true));){
            boolean bl = a.isEnabled();
            return bl;
        }
    }
}

