/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.multibranch;

import com.cloudbees.hudson.plugins.folder.computed.FolderComputation;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TopLevelItem;
import java.io.IOException;
import java.io.OutputStream;
import jenkins.branch.MultiBranchProject;
import jenkins.branch.OrganizationFolder;
import jenkins.scm.api.SCMRevisionAction;
import jenkins.scm.api.trait.SCMTrait;
import jenkins.scm.impl.mock.MockRepositoryFlags;
import jenkins.scm.impl.mock.MockSCMController;
import jenkins.scm.impl.mock.MockSCMDiscoverBranches;
import jenkins.scm.impl.mock.MockSCMNavigator;
import junit.framework.TestCase;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.multibranch.BranchJobProperty;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.recipes.LocalData;

public class RepairBranchPropertyTest {
    @Rule
    public JenkinsRule j = new JenkinsRule();
    private MockSCMController controller;

    @Before
    public void setUp() throws IOException {
        this.setup(MockSCMController.create());
    }

    void setup(MockSCMController co) throws IOException {
        this.controller = co;
        this.controller.createRepository("repo", new MockRepositoryFlags[0]);
        this.controller.createBranch("repo", "master");
        this.controller.addFile("repo", "master", "First!", "Jenkinsfile", "echo 'hello'".getBytes());
    }

    @Test
    public void removedProperty() throws Exception {
        OrganizationFolder org = (OrganizationFolder)this.j.createProject(OrganizationFolder.class, "org");
        org.getNavigators().add((Object)new MockSCMNavigator(this.controller.getId(), new SCMTrait[]{new MockSCMDiscoverBranches()}));
        org.save();
        org.scheduleBuild((Cause)new Cause.UserIdCause("anonymous"));
        this.j.waitUntilNoActivity();
        MultiBranchProject repo = org.getItem("repo");
        TestCase.assertNotNull((Object)repo);
        Job master = repo.getItem("master");
        TestCase.assertNotNull((Object)master);
        TestCase.assertNotNull((Object)master.getProperty(BranchJobProperty.class));
        TestCase.assertNotNull((Object)master.getLastBuild());
        master.removeProperty(BranchJobProperty.class);
        this.j.jenkins.reload();
        org = (OrganizationFolder)this.j.jenkins.getItem("org", (ItemGroup)this.j.jenkins, OrganizationFolder.class);
        TestCase.assertNotNull((Object)org);
        repo = org.getItem("repo");
        TestCase.assertNotNull((Object)repo);
        master = repo.getItem("master");
        TestCase.assertNotNull((Object)master);
        TestCase.assertNotNull((Object)master.getProperty(BranchJobProperty.class));
        TestCase.assertTrue((boolean)repo.getProjectFactory().isProject((Item)master));
        TestCase.assertTrue((boolean)repo.getPrimaryView().contains((TopLevelItem)master));
    }

    @Test
    public void removedPropertyLastBuildCorrupt() throws Exception {
        OrganizationFolder org = (OrganizationFolder)this.j.createProject(OrganizationFolder.class, "org");
        org.getNavigators().add((Object)new MockSCMNavigator(this.controller.getId(), new SCMTrait[]{new MockSCMDiscoverBranches()}));
        org.save();
        org.scheduleBuild((Cause)new Cause.UserIdCause("anonymous"));
        this.j.waitUntilNoActivity();
        MultiBranchProject repo = org.getItem("repo");
        TestCase.assertNotNull((Object)repo);
        Job master = repo.getItem("master");
        TestCase.assertNotNull((Object)master);
        TestCase.assertNotNull((Object)master.getProperty(BranchJobProperty.class));
        TestCase.assertNotNull((Object)master.getLastBuild());
        this.controller.addFile("repo", "master", "Second", "README.txt", "Hello".getBytes());
        repo.scheduleBuild();
        this.j.waitUntilNoActivity();
        TestCase.assertEquals((int)2, (int)master.getBuilds().size());
        Run lastBuild = master.getLastBuild();
        lastBuild.removeAction(lastBuild.getAction(SCMRevisionAction.class));
        TestCase.assertNull((Object)lastBuild.getAction(SCMRevisionAction.class));
        master.removeProperty(BranchJobProperty.class);
        this.j.jenkins.reload();
        org = (OrganizationFolder)this.j.jenkins.getItem("org", (ItemGroup)this.j.jenkins, OrganizationFolder.class);
        TestCase.assertNotNull((Object)org);
        repo = org.getItem("repo");
        TestCase.assertNotNull((Object)repo);
        master = repo.getItem("master");
        TestCase.assertNotNull((Object)master);
        TestCase.assertNotNull((Object)master.getProperty(BranchJobProperty.class));
        TestCase.assertTrue((boolean)repo.getProjectFactory().isProject((Item)master));
        TestCase.assertTrue((boolean)repo.getPrimaryView().contains((TopLevelItem)master));
    }

    @Test
    @LocalData
    public void removedPropertyAtStartup() throws Exception {
        MockSCMController cont = MockSCMController.recreate((String)"9ea2ef21-aa07-4973-a942-6c4c4c7851d1");
        this.setup(cont);
        OrganizationFolder org = (OrganizationFolder)this.j.jenkins.getItem("org", (ItemGroup)this.j.jenkins, OrganizationFolder.class);
        TestCase.assertNotNull((Object)org);
        MultiBranchProject repo = org.getItem("repo");
        TestCase.assertNotNull((Object)repo);
        WorkflowJob master = (WorkflowJob)repo.getItem("master");
        TestCase.assertNotNull((Object)master);
        TestCase.assertNotNull((Object)master.getProperty(BranchJobProperty.class));
        TestCase.assertTrue((boolean)((WorkflowMultiBranchProject)master.getParent()).getProjectFactory().isProject((Item)master));
        TestCase.assertTrue((boolean)repo.getPrimaryView().contains((TopLevelItem)master));
        Queue.Item item = repo.scheduleBuild2(0, new Action[0]);
        TestCase.assertNotNull((Object)item);
        Queue.Executable executable = (Queue.Executable)item.getFuture().get();
        TestCase.assertNotNull((Object)executable);
        FolderComputation computation = (FolderComputation)executable;
        computation.writeWholeLogTo((OutputStream)System.out);
        TestCase.assertEquals((Object)Result.SUCCESS, (Object)computation.getResult());
        this.j.waitUntilNoActivity();
        TestCase.assertEquals((int)2, (int)master.getBuilds().size());
        this.j.assertBuildStatusSuccess((Run)master.getBuildByNumber(2));
    }
}

