/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.multibranch;

import hudson.Functions;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TopLevelItem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Future;
import jenkins.branch.BranchSource;
import jenkins.plugins.git.GitSampleRepoRule;
import jenkins.plugins.git.GitStep;
import jenkins.scm.api.SCMSource;
import org.jenkinsci.plugins.workflow.cps.CpsScmFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.multibranch.Messages;
import org.jenkinsci.plugins.workflow.multibranch.SCMBinder;
import org.jenkinsci.plugins.workflow.multibranch.SCMBinderTest;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProjectTest;
import org.jenkinsci.plugins.workflow.test.steps.SemaphoreStep;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.BuildWatcher;
import org.jvnet.hudson.test.FlagRule;
import org.jvnet.hudson.test.JenkinsRule;

public class ReadTrustedStepTest {
    @ClassRule
    public static BuildWatcher buildWatcher = new BuildWatcher();
    @Rule
    public JenkinsRule r = new JenkinsRule();
    @Rule
    public GitSampleRepoRule sampleRepo = new GitSampleRepoRule();
    @Rule
    public FlagRule<Boolean> heavyweightCheckoutFlag = new FlagRule(() -> SCMBinder.USE_HEAVYWEIGHT_CHECKOUT, v -> {
        SCMBinder.USE_HEAVYWEIGHT_CHECKOUT = v;
    });

    @Test
    public void smokes() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.write("Jenkinsfile", "echo \"said ${readTrusted 'message'}\"");
        this.sampleRepo.write("message", "how do you do");
        this.sampleRepo.git(new String[]{"add", "Jenkinsfile", "message"});
        this.sampleRepo.git(new String[]{"commit", "--all", "--message=defined"});
        WorkflowMultiBranchProject mp = (WorkflowMultiBranchProject)this.r.jenkins.createProject(WorkflowMultiBranchProject.class, "p");
        mp.getSourcesList().add((Object)new BranchSource((SCMSource)new SCMBinderTest.WarySource(null, this.sampleRepo.toString(), "", "*", "", false)));
        WorkflowJob p = WorkflowMultiBranchProjectTest.scheduleAndFindBranchProject(mp, "master");
        this.r.waitUntilNoActivity();
        WorkflowRun b = p.getLastBuild();
        Assert.assertNotNull((Object)b);
        Assert.assertEquals((long)1L, (long)b.getNumber());
        SCMBinderTest.assertRevisionAction(b);
        this.r.assertBuildStatusSuccess((Run)b);
        this.r.assertLogContains("said how do you do", (Run)b);
        this.r.assertLogContains("Obtained message from ", (Run)b);
        String branch = "evil";
        this.sampleRepo.git(new String[]{"checkout", "-b", branch});
        this.sampleRepo.write("message", "your father smelt of elderberries");
        this.sampleRepo.git(new String[]{"commit", "--all", "--message=rude"});
        p = WorkflowMultiBranchProjectTest.scheduleAndFindBranchProject(mp, branch);
        this.r.waitUntilNoActivity();
        b = p.getLastBuild();
        Assert.assertNotNull((Object)b);
        Assert.assertEquals((long)1L, (long)b.getNumber());
        SCMBinderTest.assertRevisionAction(b);
        this.r.assertBuildStatus(Result.FAILURE, (Run)b);
        this.r.assertLogContains(Messages.ReadTrustedStep__has_been_modified_in_an_untrusted_revis((Object)"message"), (Run)b);
        this.r.assertLogContains("Obtained message from ", (Run)b);
        this.sampleRepo.write("message", "how do you do");
        this.sampleRepo.write("ignored-message", "I fart in your general direction");
        this.sampleRepo.git(new String[]{"add", "ignored-message"});
        this.sampleRepo.git(new String[]{"commit", "--all", "--message=less rude"});
        this.sampleRepo.notifyCommit(this.r);
        b = p.getLastBuild();
        Assert.assertEquals((long)2L, (long)b.getNumber());
        SCMBinderTest.assertRevisionAction(b);
        this.r.assertBuildStatusSuccess((Run)b);
        this.r.assertLogContains("said how do you do", (Run)b);
        this.r.assertLogContains("Obtained message from ", (Run)b);
    }

    @Test
    public void exactRevision() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.write("Jenkinsfile", "node {checkout scm; semaphore 'wait1'; def alpha = readTrusted 'alpha'; semaphore 'wait2'; echo \"first got ${alpha} then ${readTrusted 'beta'} vs. disk ${readFile 'alpha'} then ${readFile 'beta'}\"}");
        this.sampleRepo.write("alpha", "1");
        this.sampleRepo.write("beta", "1");
        this.sampleRepo.git(new String[]{"add", "Jenkinsfile", "alpha", "beta"});
        this.sampleRepo.git(new String[]{"commit", "--all", "--message=defined"});
        WorkflowMultiBranchProject mp = (WorkflowMultiBranchProject)this.r.jenkins.createProject(WorkflowMultiBranchProject.class, "p");
        mp.getSourcesList().add((Object)new BranchSource((SCMSource)new SCMBinderTest.WarySource(null, this.sampleRepo.toString(), "", "*", "", false)));
        WorkflowJob p = WorkflowMultiBranchProjectTest.scheduleAndFindBranchProject(mp, "master");
        SemaphoreStep.waitForStart((String)"wait1/1", null);
        WorkflowRun b = p.getLastBuild();
        Assert.assertNotNull((Object)b);
        Assert.assertEquals((long)1L, (long)b.getNumber());
        SCMBinderTest.assertRevisionAction(b);
        this.sampleRepo.write("alpha", "2");
        this.sampleRepo.git(new String[]{"commit", "--all", "--message=alpha-2"});
        SemaphoreStep.success((String)"wait1/1", null);
        SemaphoreStep.waitForStart((String)"wait2/1", (Run)b);
        this.sampleRepo.write("beta", "2");
        this.sampleRepo.git(new String[]{"commit", "--all", "--message=beta-2"});
        SemaphoreStep.success((String)"wait2/1", null);
        this.r.assertLogContains("first got 1 then 1 vs. disk 1 then 1", this.r.assertBuildStatusSuccess((Run)((WorkflowRun)this.r.waitForCompletion((Run)b))));
        this.sampleRepo.write("Jenkinsfile", "def alpha = readTrusted 'alpha'; semaphore 'wait1'; node {checkout scm; semaphore 'wait2'; echo \"now got ${alpha} then ${readTrusted 'beta'} vs. disk ${readFile 'alpha'} then ${readFile 'beta'}\"}");
        this.sampleRepo.git(new String[]{"commit", "--all", "--message=new definition"});
        b = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).waitForStart();
        SemaphoreStep.waitForStart((String)"wait1/2", (Run)b);
        this.sampleRepo.write("alpha", "3");
        this.sampleRepo.git(new String[]{"commit", "--all", "--message=alpha-3"});
        SemaphoreStep.success((String)"wait1/2", null);
        SemaphoreStep.waitForStart((String)"wait2/2", (Run)b);
        this.sampleRepo.write("beta", "3");
        this.sampleRepo.git(new String[]{"commit", "--all", "--message=beta-3"});
        SemaphoreStep.success((String)"wait2/2", null);
        this.r.assertLogContains("now got 2 then 2 vs. disk 2 then 2", this.r.assertBuildStatusSuccess((Run)((WorkflowRun)this.r.waitForCompletion((Run)b))));
    }

    @Test
    public void evaluate() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.write("Jenkinsfile", "evaluate readTrusted('lib.groovy')");
        this.sampleRepo.write("lib.groovy", "echo 'trustworthy library'");
        this.sampleRepo.git(new String[]{"add", "Jenkinsfile", "lib.groovy"});
        this.sampleRepo.git(new String[]{"commit", "--all", "--message=defined"});
        WorkflowMultiBranchProject mp = (WorkflowMultiBranchProject)this.r.jenkins.createProject(WorkflowMultiBranchProject.class, "p");
        mp.getSourcesList().add((Object)new BranchSource((SCMSource)new SCMBinderTest.WarySource(null, this.sampleRepo.toString(), "", "*", "", false)));
        WorkflowJob p = WorkflowMultiBranchProjectTest.scheduleAndFindBranchProject(mp, "master");
        this.r.waitUntilNoActivity();
        WorkflowRun b = p.getLastBuild();
        Assert.assertNotNull((Object)b);
        Assert.assertEquals((long)1L, (long)b.getNumber());
        SCMBinderTest.assertRevisionAction(b);
        this.r.assertBuildStatusSuccess((Run)b);
        this.r.assertLogContains("trustworthy library", (Run)b);
        String branch = "evil";
        this.sampleRepo.git(new String[]{"checkout", "-b", branch});
        this.sampleRepo.write("lib.groovy", "echo 'not trustworthy'");
        this.sampleRepo.git(new String[]{"commit", "--all", "--message=evil"});
        p = WorkflowMultiBranchProjectTest.scheduleAndFindBranchProject(mp, branch);
        this.r.waitUntilNoActivity();
        b = p.getLastBuild();
        Assert.assertNotNull((Object)b);
        Assert.assertEquals((long)1L, (long)b.getNumber());
        SCMBinderTest.assertRevisionAction(b);
        this.r.assertBuildStatus(Result.FAILURE, (Run)b);
        this.r.assertLogContains(Messages.ReadTrustedStep__has_been_modified_in_an_untrusted_revis((Object)"lib.groovy"), (Run)b);
        this.r.assertLogNotContains("not trustworthy", (Run)b);
    }

    @Test
    public void nonMultibranch() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.write("Jenkinsfile", "echo \"said ${readTrusted 'message'}\"");
        this.sampleRepo.write("message", "how do you do");
        this.sampleRepo.git(new String[]{"add", "Jenkinsfile", "message"});
        this.sampleRepo.git(new String[]{"commit", "--all", "--message=defined"});
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        GitStep step = new GitStep(this.sampleRepo.toString());
        p.setDefinition((FlowDefinition)new CpsScmFlowDefinition(step.createSCM(), "Jenkinsfile"));
        WorkflowRun b = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[0]));
        this.r.assertLogContains("said how do you do", (Run)b);
        this.r.assertLogContains("Obtained message from git ", (Run)b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void nonMultibranchHeavyweight() throws Exception {
        SCMBinder.USE_HEAVYWEIGHT_CHECKOUT = true;
        try {
            this.sampleRepo.init();
            this.sampleRepo.write("Jenkinsfile", "echo \"said ${readTrusted 'message'}\"");
            this.sampleRepo.write("message", "how do you do");
            this.sampleRepo.git(new String[]{"add", "Jenkinsfile", "message"});
            this.sampleRepo.git(new String[]{"commit", "--all", "--message=defined"});
            WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
            GitStep step = new GitStep(this.sampleRepo.toString());
            CpsScmFlowDefinition def = new CpsScmFlowDefinition(step.createSCM(), "Jenkinsfile");
            def.setLightweight(true);
            p.setDefinition((FlowDefinition)def);
            WorkflowRun b = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[0]));
            this.r.assertLogContains("said how do you do", (Run)b);
        }
        finally {
            SCMBinder.USE_HEAVYWEIGHT_CHECKOUT = false;
        }
    }

    @Test
    public void pathTraversalRejected() throws Exception {
        SCMBinder.USE_HEAVYWEIGHT_CHECKOUT = true;
        this.sampleRepo.init();
        this.sampleRepo.write("Jenkinsfile", "node { checkout scm; echo \"${readTrusted '../../secrets/master.key'}\"}");
        Path secrets = Paths.get(this.sampleRepo.getRoot().getPath(), "secrets");
        Files.createSymbolicLink(secrets, Paths.get(String.valueOf(this.r.jenkins.getRootDir()) + "/secrets", new String[0]), new FileAttribute[0]);
        this.sampleRepo.git(new String[]{"add", "."});
        this.sampleRepo.git(new String[]{"commit", "-m", "init"});
        WorkflowMultiBranchProject mp = (WorkflowMultiBranchProject)this.r.jenkins.createProject(WorkflowMultiBranchProject.class, "p");
        mp.getSourcesList().add((Object)new BranchSource((SCMSource)new SCMBinderTest.WarySource(null, this.sampleRepo.toString(), "", "*", "", false)));
        WorkflowJob p = WorkflowMultiBranchProjectTest.scheduleAndFindBranchProject(mp, "master");
        this.r.waitUntilNoActivity();
        WorkflowRun b = p.getLastBuild();
        Assert.assertEquals((long)1L, (long)b.getNumber());
        this.r.assertLogContains("master.key references a file that is not inside " + this.r.jenkins.getWorkspaceFor((TopLevelItem)p).getRemote(), (Run)b);
    }

    @Test
    public void symlinksInReadTrustedCannotEscapeWorkspaceContext() throws Exception {
        Assume.assumeFalse((boolean)Functions.isWindows());
        SCMBinder.USE_HEAVYWEIGHT_CHECKOUT = true;
        this.sampleRepo.init();
        this.sampleRepo.write("Jenkinsfile", "node { checkout scm; echo \"${readTrusted 'secrets/master.key'}\"}");
        Path secrets = Paths.get(this.sampleRepo.getRoot().getPath(), "secrets");
        Files.createSymbolicLink(secrets, Paths.get(String.valueOf(this.r.jenkins.getRootDir()) + "/secrets", new String[0]), new FileAttribute[0]);
        this.sampleRepo.git(new String[]{"add", "."});
        this.sampleRepo.git(new String[]{"commit", "-m", "init"});
        WorkflowMultiBranchProject mp = (WorkflowMultiBranchProject)this.r.jenkins.createProject(WorkflowMultiBranchProject.class, "p");
        mp.getSourcesList().add((Object)new BranchSource((SCMSource)new SCMBinderTest.WarySource(null, this.sampleRepo.toString(), "", "*", "", false)));
        WorkflowJob p = WorkflowMultiBranchProjectTest.scheduleAndFindBranchProject(mp, "master");
        this.r.waitUntilNoActivity();
        WorkflowRun run = p.getLastBuild();
        Assert.assertEquals((long)1L, (long)run.getNumber());
        this.r.assertLogContains("secrets/master.key references a file that is not inside " + this.r.jenkins.getWorkspaceFor((TopLevelItem)p).getRemote(), (Run)run);
    }

    @Test
    public void symlinksInUntrustedRevisionCannotEscapeWorkspace() throws Exception {
        Assume.assumeFalse((boolean)Functions.isWindows());
        SCMBinder.USE_HEAVYWEIGHT_CHECKOUT = true;
        this.sampleRepo.init();
        this.sampleRepo.write("Jenkinsfile", "node { checkout scm; echo \"${readTrusted 'secrets/master.key'}\"}");
        this.sampleRepo.write("secrets/master.key", "secret info");
        this.sampleRepo.git(new String[]{"add", "."});
        this.sampleRepo.git(new String[]{"commit", "-m", "init"});
        this.sampleRepo.git(new String[]{"checkout", "-b", "feature"});
        Path secrets = Paths.get(this.sampleRepo.getRoot().getPath(), "secrets");
        Files.delete(Paths.get(secrets.toString(), "master.key"));
        Files.delete(secrets);
        Files.createSymbolicLink(secrets, Paths.get(String.valueOf(this.r.jenkins.getRootDir()) + "/secrets", new String[0]), new FileAttribute[0]);
        this.sampleRepo.git(new String[]{"add", "."});
        this.sampleRepo.git(new String[]{"commit", "-m", "now with unsafe symlink"});
        WorkflowMultiBranchProject mp = (WorkflowMultiBranchProject)this.r.jenkins.createProject(WorkflowMultiBranchProject.class, "p");
        mp.getSourcesList().add((Object)new BranchSource((SCMSource)new SCMBinderTest.WarySource(null, this.sampleRepo.toString(), "", "*", "", false)));
        WorkflowJob p = WorkflowMultiBranchProjectTest.scheduleAndFindBranchProject(mp, "feature");
        this.r.waitUntilNoActivity();
        WorkflowRun run = p.getLastBuild();
        Assert.assertEquals((long)1L, (long)run.getNumber());
        this.r.assertLogContains("secrets/master.key references a file that is not inside ", (Run)run);
    }

    @Test
    public void symlinksInNonMultibranchCannotEscapeWorkspaceContextViaReadTrusted() throws Exception {
        Assume.assumeFalse((boolean)Functions.isWindows());
        SCMBinder.USE_HEAVYWEIGHT_CHECKOUT = true;
        this.sampleRepo.init();
        this.sampleRepo.write("Jenkinsfile", "echo \"${readTrusted 'master.key'}\"");
        Path secrets = Paths.get(this.sampleRepo.getRoot().getPath(), "master.key");
        Files.createSymbolicLink(secrets, Paths.get(String.valueOf(this.r.jenkins.getRootDir()) + "/secrets/master.key", new String[0]), new FileAttribute[0]);
        this.sampleRepo.git(new String[]{"add", "."});
        this.sampleRepo.git(new String[]{"commit", "-m", "init"});
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        GitStep step = new GitStep(this.sampleRepo.toString());
        p.setDefinition((FlowDefinition)new CpsScmFlowDefinition(step.createSCM(), "Jenkinsfile"));
        WorkflowRun run = (WorkflowRun)this.r.buildAndAssertStatus(Result.FAILURE, (Job)p);
        this.r.assertLogContains("master.key references a file that is not inside " + String.valueOf(this.r.jenkins.getWorkspaceFor((TopLevelItem)p)), (Run)run);
    }
}

