/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.multibranch;

import hudson.model.Action;
import hudson.model.Describable;
import hudson.model.queue.QueueTaskFuture;
import java.io.OutputStream;
import java.util.Collections;
import jenkins.branch.BranchProperty;
import jenkins.branch.BranchPropertyStrategy;
import jenkins.branch.BranchSource;
import jenkins.branch.NamedExceptionsBranchPropertyStrategy;
import jenkins.branch.NoTriggerBranchProperty;
import jenkins.branch.NoTriggerOrganizationFolderProperty;
import jenkins.branch.OrganizationFolder;
import jenkins.plugins.git.GitSCMSource;
import jenkins.plugins.git.GitSampleRepoRule;
import jenkins.scm.api.SCMSource;
import jenkins.scm.impl.SingleSCMNavigator;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProjectTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;

public class NoTriggerBranchPropertyWorkflowTest {
    @Rule
    public JenkinsRule r = new JenkinsRule();
    @Rule
    public GitSampleRepoRule sampleRepo = new GitSampleRepoRule();

    @Test
    public void singleRepo() throws Exception {
        this.round1();
        WorkflowMultiBranchProject p = (WorkflowMultiBranchProject)this.r.jenkins.createProject(WorkflowMultiBranchProject.class, "p");
        BranchSource branchSource = new BranchSource((SCMSource)new GitSCMSource("source-id", this.sampleRepo.toString(), "", "*", "", false));
        branchSource.setStrategy((BranchPropertyStrategy)new NamedExceptionsBranchPropertyStrategy(new BranchProperty[0], new NamedExceptionsBranchPropertyStrategy.Named[]{new NamedExceptionsBranchPropertyStrategy.Named("release*", new BranchProperty[]{new NoTriggerBranchProperty()})}));
        p.getSourcesList().add((Object)branchSource);
        WorkflowJob master = WorkflowMultiBranchProjectTest.scheduleAndFindBranchProject(p, "master");
        this.r.waitUntilNoActivity();
        Assert.assertEquals((long)2L, (long)master.getNextBuildNumber());
        WorkflowJob release = WorkflowMultiBranchProjectTest.scheduleAndFindBranchProject(p, "release");
        Assert.assertEquals((long)1L, (long)release.getNextBuildNumber());
        WorkflowJob newfeature = WorkflowMultiBranchProjectTest.scheduleAndFindBranchProject(p, "newfeature");
        Assert.assertEquals((long)2L, (long)newfeature.getNextBuildNumber());
        this.round2();
        WorkflowMultiBranchProjectTest.showIndexing(p);
        Assert.assertEquals((long)3L, (long)master.getNextBuildNumber());
        Assert.assertEquals((long)1L, (long)release.getNextBuildNumber());
        Assert.assertEquals((long)3L, (long)newfeature.getNextBuildNumber());
        QueueTaskFuture releaseBuild = release.scheduleBuild2(0, new Action[0]);
        Assert.assertNotNull((Object)releaseBuild);
        Assert.assertEquals((long)1L, (long)((WorkflowRun)releaseBuild.get()).getNumber());
        Assert.assertEquals((long)2L, (long)release.getNextBuildNumber());
        branchSource = new BranchSource((SCMSource)new GitSCMSource("source-id", this.sampleRepo.toString(), "", "*", "", false));
        branchSource.setStrategy((BranchPropertyStrategy)new NamedExceptionsBranchPropertyStrategy(new BranchProperty[0], new NamedExceptionsBranchPropertyStrategy.Named[]{new NamedExceptionsBranchPropertyStrategy.Named("master", new BranchProperty[]{new NoTriggerBranchProperty()})}));
        p.getSourcesList().clear();
        p.getSourcesList().add((Object)branchSource);
        this.round3();
        WorkflowMultiBranchProjectTest.showIndexing(p);
        Assert.assertEquals((long)3L, (long)master.getNextBuildNumber());
        Assert.assertEquals((long)3L, (long)release.getNextBuildNumber());
        Assert.assertEquals((long)4L, (long)newfeature.getNextBuildNumber());
    }

    @Test
    public void organizationFolder() throws Exception {
        this.round1();
        OrganizationFolder top = (OrganizationFolder)this.r.jenkins.createProject(OrganizationFolder.class, "top");
        top.getProperties().add((Object)new NoTriggerOrganizationFolderProperty("(?!release.*).*"));
        top.getNavigators().add((Object)new SingleSCMNavigator("p", Collections.singletonList(new GitSCMSource("source-id", this.sampleRepo.toString(), "", "*", "", false))));
        top.scheduleBuild2(0, new Action[0]).getFuture().get();
        this.r.waitUntilNoActivity();
        top.getComputation().writeWholeLogTo((OutputStream)System.out);
        WorkflowMultiBranchProject p = (WorkflowMultiBranchProject)this.r.jenkins.getItemByFullName("top/p", WorkflowMultiBranchProject.class);
        Assert.assertNotNull((Object)p);
        WorkflowJob master = WorkflowMultiBranchProjectTest.scheduleAndFindBranchProject(p, "master");
        this.r.waitUntilNoActivity();
        Assert.assertEquals((long)2L, (long)master.getNextBuildNumber());
        WorkflowJob release = WorkflowMultiBranchProjectTest.scheduleAndFindBranchProject(p, "release");
        Assert.assertEquals((long)1L, (long)release.getNextBuildNumber());
        WorkflowJob newfeature = WorkflowMultiBranchProjectTest.scheduleAndFindBranchProject(p, "newfeature");
        Assert.assertEquals((long)2L, (long)newfeature.getNextBuildNumber());
        this.round2();
        WorkflowMultiBranchProjectTest.showIndexing(p);
        Assert.assertEquals((long)3L, (long)master.getNextBuildNumber());
        Assert.assertEquals((long)1L, (long)release.getNextBuildNumber());
        Assert.assertEquals((long)3L, (long)newfeature.getNextBuildNumber());
        QueueTaskFuture releaseBuild = release.scheduleBuild2(0, new Action[0]);
        Assert.assertNotNull((Object)releaseBuild);
        Assert.assertEquals((long)1L, (long)((WorkflowRun)releaseBuild.get()).getNumber());
        Assert.assertEquals((long)2L, (long)release.getNextBuildNumber());
        top.getProperties().replace((Describable)new NoTriggerOrganizationFolderProperty("(?!master$).*"));
        this.round3();
        WorkflowMultiBranchProjectTest.showIndexing(p);
        Assert.assertEquals((long)3L, (long)master.getNextBuildNumber());
        Assert.assertEquals((long)3L, (long)release.getNextBuildNumber());
        Assert.assertEquals((long)4L, (long)newfeature.getNextBuildNumber());
    }

    private void round1() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.write("Jenkinsfile", "");
        this.sampleRepo.git(new String[]{"add", "Jenkinsfile"});
        this.sampleRepo.git(new String[]{"commit", "--message=init"});
        this.sampleRepo.git(new String[]{"checkout", "-b", "newfeature"});
        this.sampleRepo.write("Jenkinsfile", "// newfeature");
        this.sampleRepo.git(new String[]{"commit", "--all", "--message=newfeature"});
        this.sampleRepo.git(new String[]{"checkout", "-b", "release", "master"});
        this.sampleRepo.write("Jenkinsfile", "// release");
        this.sampleRepo.git(new String[]{"commit", "--all", "--message=release"});
    }

    private void round2() throws Exception {
        this.sampleRepo.git(new String[]{"checkout", "master"});
        this.sampleRepo.write("Jenkinsfile", "// more");
        this.sampleRepo.git(new String[]{"commit", "--all", "--message=master-2"});
        this.sampleRepo.git(new String[]{"checkout", "newfeature"});
        this.sampleRepo.write("Jenkinsfile", "// more");
        this.sampleRepo.git(new String[]{"commit", "--all", "--message=newfeature-2"});
        this.sampleRepo.git(new String[]{"checkout", "release"});
        this.sampleRepo.write("Jenkinsfile", "// more");
        this.sampleRepo.git(new String[]{"commit", "--all", "--message=release-2"});
        this.sampleRepo.notifyCommit(this.r);
    }

    private void round3() throws Exception {
        this.sampleRepo.git(new String[]{"checkout", "master"});
        this.sampleRepo.write("Jenkinsfile", "// yet more");
        this.sampleRepo.git(new String[]{"commit", "--all", "--message=master-3"});
        this.sampleRepo.git(new String[]{"checkout", "newfeature"});
        this.sampleRepo.write("Jenkinsfile", "// yet more");
        this.sampleRepo.git(new String[]{"commit", "--all", "--message=newfeature-3"});
        this.sampleRepo.git(new String[]{"checkout", "release"});
        this.sampleRepo.write("Jenkinsfile", "// yet more");
        this.sampleRepo.git(new String[]{"commit", "--all", "--message=release-3"});
        this.sampleRepo.notifyCommit(this.r);
    }
}

