/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.multibranch;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.TaskListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.plugins.git.GitSCMSource;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMNavigatorDescriptor;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceObserver;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.Symbol;
import org.junit.Assert;
import org.kohsuke.stapler.DataBoundConstructor;

public class GitDirectorySCMNavigator
extends SCMNavigator {
    private final String directory;
    private static final Pattern ORIGIN = Pattern.compile("origin\t(.+) [(]fetch[)]");

    @DataBoundConstructor
    public GitDirectorySCMNavigator(String directory) {
        this.directory = directory;
    }

    public String getDirectory() {
        return this.directory;
    }

    @NonNull
    protected String id() {
        return this.directory;
    }

    public void visitSources(SCMSourceObserver observer) throws IOException, InterruptedException {
        TaskListener listener = observer.getListener();
        File[] kids = new File(this.directory).listFiles();
        if (kids == null) {
            listener.error(this.directory + " does not exist");
            return;
        }
        for (File kid : kids) {
            if (!observer.isObserving()) {
                return;
            }
            if (!new File(kid, ".git").isDirectory()) {
                listener.getLogger().format("Ignoring %s since it does not look like a Git checkout%n", kid);
                continue;
            }
            listener.getLogger().format("Considering: %s%n", kid);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Proc proc = new Launcher.LocalLauncher(listener).launch().pwd(kid).cmds(new String[]{"git", "remote", "-v"}).stdout((OutputStream)baos).start();
            if (proc.join() != 0) {
                listener.error("git-remote failed");
                continue;
            }
            String origin = kid.getAbsolutePath();
            for (String line : IOUtils.readLines((InputStream)new ByteArrayInputStream(baos.toByteArray()))) {
                Matcher m = ORIGIN.matcher(line);
                if (!m.matches()) continue;
                origin = m.group(1);
                listener.getLogger().format("Found origin URL: %s%n", origin);
                Assert.assertFalse((boolean)origin.startsWith("git@"));
                break;
            }
            SCMSourceObserver.ProjectObserver projectObserver = observer.observe(kid.getName());
            projectObserver.addSource((SCMSource)new GitSCMSource(this.getId() + "::" + kid.getName(), origin, "", "*", "", false));
            projectObserver.complete();
        }
    }

    @Extension
    @Symbol(value={"gitDirectory"})
    public static class DescriptorImpl
    extends SCMNavigatorDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Directory of Git checkouts";
        }

        public SCMNavigator newInstance(String name) {
            return null;
        }
    }
}

