/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.multibranch;

import hudson.model.Item;
import hudson.model.Result;
import jenkins.branch.BranchProperty;
import jenkins.branch.BranchPropertyStrategy;
import jenkins.branch.BranchSource;
import jenkins.branch.DefaultBranchPropertyStrategy;
import jenkins.plugins.git.GitSCMSource;
import jenkins.plugins.git.GitSampleRepoRule;
import jenkins.scm.api.SCMSource;
import org.jenkinsci.plugins.workflow.flow.DurabilityHintProvider;
import org.jenkinsci.plugins.workflow.flow.FlowDurabilityHint;
import org.jenkinsci.plugins.workflow.flow.GlobalDefaultFlowDurabilityLevel;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.job.properties.DurabilityHintJobProperty;
import org.jenkinsci.plugins.workflow.multibranch.DurabilityHintBranchProperty;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProjectTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;

public class DurabilityHintBranchPropertyWorkflowTest {
    @Rule
    public JenkinsRule r = new JenkinsRule();
    @Rule
    public GitSampleRepoRule sampleRepo = new GitSampleRepoRule();

    @Test
    public void configRoundtrip() throws Exception {
        WorkflowMultiBranchProject mp = (WorkflowMultiBranchProject)this.r.jenkins.createProject(WorkflowMultiBranchProject.class, "p");
        BranchSource bs = new BranchSource((SCMSource)new GitSCMSource(null, this.sampleRepo.toString(), "", "*", "", false));
        mp.getSourcesList().add((Object)bs);
        bs.setStrategy((BranchPropertyStrategy)new DefaultBranchPropertyStrategy(new BranchProperty[]{new DurabilityHintBranchProperty(FlowDurabilityHint.SURVIVABLE_NONATOMIC)}));
        this.r.configRoundtrip((Item)mp);
        DefaultBranchPropertyStrategy strat = (DefaultBranchPropertyStrategy)mp.getBranchPropertyStrategy((SCMSource)mp.getSCMSources().get(0));
        DurabilityHintBranchProperty prop = null;
        for (BranchProperty bp : strat.getProps()) {
            if (!(bp instanceof DurabilityHintBranchProperty)) continue;
            prop = (DurabilityHintBranchProperty)bp;
            break;
        }
        Assert.assertNotNull(prop);
        Assert.assertEquals((Object)FlowDurabilityHint.SURVIVABLE_NONATOMIC, (Object)prop.getHint());
    }

    @Test
    public void durabilityHintByPropertyStep() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.write("Jenkinsfile", "properties([durabilityHint('" + FlowDurabilityHint.SURVIVABLE_NONATOMIC.getName() + "')])\necho 'whynot'");
        this.sampleRepo.git(new String[]{"add", "Jenkinsfile"});
        this.sampleRepo.git(new String[]{"commit", "--all", "--message=flow"});
        WorkflowMultiBranchProject mp = (WorkflowMultiBranchProject)this.r.jenkins.createProject(WorkflowMultiBranchProject.class, "p");
        mp.getSourcesList().add((Object)new BranchSource((SCMSource)new GitSCMSource(null, this.sampleRepo.toString(), "", "*", "", false)));
        WorkflowJob p = WorkflowMultiBranchProjectTest.scheduleAndFindBranchProject(mp, "master");
        this.r.waitUntilNoActivity();
        WorkflowRun b1 = p.getLastBuild();
        Assert.assertEquals((Object)Result.SUCCESS, (Object)b1.getResult());
        DurabilityHintJobProperty prop = (DurabilityHintJobProperty)p.getProperty(DurabilityHintJobProperty.class);
        Assert.assertEquals((Object)FlowDurabilityHint.SURVIVABLE_NONATOMIC, (Object)prop.getHint());
    }

    @Test
    public void durabilityHintByBranchProperty() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.write("Jenkinsfile", "echo 'whynot'");
        this.sampleRepo.git(new String[]{"add", "Jenkinsfile"});
        this.sampleRepo.git(new String[]{"commit", "--all", "--message=flow"});
        WorkflowMultiBranchProject mp = (WorkflowMultiBranchProject)this.r.jenkins.createProject(WorkflowMultiBranchProject.class, "p");
        BranchSource bs = new BranchSource((SCMSource)new GitSCMSource(null, this.sampleRepo.toString(), "", "*", "", false));
        mp.getSourcesList().add((Object)bs);
        bs.setStrategy((BranchPropertyStrategy)new DefaultBranchPropertyStrategy(new BranchProperty[]{new DurabilityHintBranchProperty(FlowDurabilityHint.SURVIVABLE_NONATOMIC)}));
        WorkflowJob p = WorkflowMultiBranchProjectTest.scheduleAndFindBranchProject(mp, "master");
        this.r.waitUntilNoActivity();
        Assert.assertEquals((Object)FlowDurabilityHint.SURVIVABLE_NONATOMIC, (Object)DurabilityHintProvider.suggestedFor((Item)p));
        WorkflowRun b1 = p.getLastBuild();
        Assert.assertEquals((Object)Result.SUCCESS, (Object)b1.getResult());
        bs.setStrategy((BranchPropertyStrategy)new DefaultBranchPropertyStrategy(new BranchProperty[0]));
        p = WorkflowMultiBranchProjectTest.scheduleAndFindBranchProject(mp, "master");
        this.r.waitUntilNoActivity();
        Assert.assertEquals((Object)GlobalDefaultFlowDurabilityLevel.getDefaultDurabilityHint(), (Object)DurabilityHintProvider.suggestedFor((Item)((Item)mp.getItems().iterator().next())));
    }
}

