// CHECKSTYLE:OFF

package org.jenkinsci.plugins.workflow.multibranch;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code WorkflowMultiBranchProject.DisplayName}: {@code Multibranch
     * Pipeline}.
     * 
     * @return
     *     {@code Multibranch Pipeline}
     */
    public static String WorkflowMultiBranchProject_DisplayName() {
        return holder.format("WorkflowMultiBranchProject.DisplayName");
    }

    /**
     * Key {@code WorkflowMultiBranchProject.DisplayName}: {@code Multibranch
     * Pipeline}.
     * 
     * @return
     *     {@code Multibranch Pipeline}
     */
    public static Localizable _WorkflowMultiBranchProject_DisplayName() {
        return new Localizable(holder, "WorkflowMultiBranchProject.DisplayName");
    }

    /**
     * Key {@code WorkflowMultiBranchProject.Description}: {@code Creates a
     * set of Pipeline projects according to detected branches in one SCM
     * repository.}.
     * 
     * @return
     *     {@code Creates a set of Pipeline projects according to detected
     *     branches in one SCM repository.}
     */
    public static String WorkflowMultiBranchProject_Description() {
        return holder.format("WorkflowMultiBranchProject.Description");
    }

    /**
     * Key {@code WorkflowMultiBranchProject.Description}: {@code Creates a
     * set of Pipeline projects according to detected branches in one SCM
     * repository.}.
     * 
     * @return
     *     {@code Creates a set of Pipeline projects according to detected
     *     branches in one SCM repository.}
     */
    public static Localizable _WorkflowMultiBranchProject_Description() {
        return new Localizable(holder, "WorkflowMultiBranchProject.Description");
    }

    /**
     * Key {@code ReadTrustedStep._has_been_modified_in_an_untrusted_revis}:
     * {@code ‘{0}’ has been modified in an untrusted revision}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code ‘{0}’ has been modified in an untrusted revision}
     */
    public static String ReadTrustedStep__has_been_modified_in_an_untrusted_revis(Object arg0) {
        return holder.format("ReadTrustedStep._has_been_modified_in_an_untrusted_revis", arg0);
    }

    /**
     * Key {@code ReadTrustedStep._has_been_modified_in_an_untrusted_revis}:
     * {@code ‘{0}’ has been modified in an untrusted revision}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code ‘{0}’ has been modified in an untrusted revision}
     */
    public static Localizable _ReadTrustedStep__has_been_modified_in_an_untrusted_revis(Object arg0) {
        return new Localizable(holder, "ReadTrustedStep._has_been_modified_in_an_untrusted_revis", arg0);
    }

}
