/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.job.properties;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.console.ModelHyperlinkNote;
import hudson.model.Run;
import hudson.model.TaskListener;
import jenkins.model.CauseOfInterruption;
import jenkins.model.OptionalJobProperty;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.properties.Messages;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class DisableConcurrentBuildsJobProperty
extends OptionalJobProperty<WorkflowJob> {
    private boolean abortPrevious;

    @DataBoundConstructor
    public DisableConcurrentBuildsJobProperty() {
    }

    public boolean isAbortPrevious() {
        return this.abortPrevious;
    }

    @DataBoundSetter
    public void setAbortPrevious(boolean abortPrevious) {
        this.abortPrevious = abortPrevious;
    }

    public static final class CancelledCause
    extends CauseOfInterruption {
        private static final long serialVersionUID = 1L;
        private final String newerBuild;
        private final String displayName;

        public CancelledCause(Run<?, ?> newerBuild) {
            this.newerBuild = newerBuild.getExternalizableId();
            this.displayName = newerBuild.getDisplayName();
        }

        @Exported
        @Nullable
        public Run<?, ?> getNewerBuild() {
            return this.newerBuild != null ? Run.fromExternalizableId((String)this.newerBuild) : null;
        }

        public String getShortDescription() {
            return "Superseded by " + this.displayName;
        }

        public void print(TaskListener listener) {
            Run<?, ?> b = this.getNewerBuild();
            if (b != null) {
                listener.getLogger().println("Superseded by " + ModelHyperlinkNote.encodeTo(b));
            } else {
                super.print(listener);
            }
        }
    }

    @Extension
    @Symbol(value={"disableConcurrentBuilds"})
    public static class DescriptorImpl
    extends OptionalJobProperty.OptionalJobPropertyDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.do_not_allow_concurrent_builds();
        }
    }
}

