/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.job;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import hudson.model.Action;
import hudson.model.Executor;
import hudson.model.InvisibleAction;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import jenkins.model.RunAction2;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDurabilityHint;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionList;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionListener;
import org.jenkinsci.plugins.workflow.flow.GraphListener;
import org.jenkinsci.plugins.workflow.graph.FlowEndNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graph.FlowStartNode;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.job.properties.DurabilityHintJobProperty;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.test.steps.SemaphoreStep;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.LogRecorder;
import org.jvnet.hudson.test.TestExtension;
import org.jvnet.hudson.test.junit.jupiter.BuildWatcherExtension;
import org.jvnet.hudson.test.junit.jupiter.JenkinsSessionExtension;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

class WorkflowRunRestartTest {
    @RegisterExtension
    private static final BuildWatcherExtension BUILD_WATCHER = new BuildWatcherExtension();
    @RegisterExtension
    private final JenkinsSessionExtension sessions = new JenkinsSessionExtension();
    private final LogRecorder logging = new LogRecorder();

    WorkflowRunRestartTest() {
    }

    @Test
    void disabled() throws Throwable {
        this.sessions.then(r -> {
            WorkflowJob p = (WorkflowJob)r.jenkins.createProject(WorkflowJob.class, "p");
            p.setDefinition((FlowDefinition)new CpsFlowDefinition("node {semaphore 'wait'}", true));
            WorkflowRun b = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).waitForStart();
            SemaphoreStep.waitForStart((String)"wait/1", (Run)b);
            p.makeDisabled(true);
        });
        this.sessions.then(r -> {
            WorkflowJob p = (WorkflowJob)r.jenkins.getItemByFullName("p", WorkflowJob.class);
            Assertions.assertTrue((boolean)p.isDisabled());
            WorkflowRun b = p.getBuildByNumber(1);
            Assertions.assertTrue((boolean)b.isBuilding());
            Assertions.assertTrue((boolean)b.executionLoaded);
            Assertions.assertFalse((boolean)b.completed);
            SemaphoreStep.success((String)"wait/1", null);
            r.assertBuildStatusSuccess((Run)((WorkflowRun)r.waitForCompletion((Run)b)));
            Assertions.assertTrue((boolean)b.completed);
        });
    }

    @Test
    void resumeDisabled() throws Throwable {
        this.sessions.then(r -> {
            WorkflowJob p = (WorkflowJob)r.jenkins.createProject(WorkflowJob.class, "p");
            p.setDefinition((FlowDefinition)new CpsFlowDefinition("node {semaphore 'wait'}", true));
            p.setResumeBlocked(true);
            WorkflowRun b = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).waitForStart();
            SemaphoreStep.waitForStart((String)"wait/1", (Run)b);
        });
        this.sessions.then(r -> {
            WorkflowJob p = (WorkflowJob)r.jenkins.getItemByFullName("p", WorkflowJob.class);
            Assertions.assertTrue((boolean)p.isResumeBlocked());
            WorkflowRun b = p.getBuildByNumber(1);
            r.waitForCompletion((Run)b);
            Assertions.assertTrue((boolean)b.completed);
            Assertions.assertFalse((boolean)b.isBuilding());
            Assertions.assertEquals((Object)Result.ABORTED, (Object)b.getResult());
            FlowExecution fe = b.getExecution();
            Assertions.assertTrue((boolean)b.executionLoaded);
            Assertions.assertNotNull((Object)fe.getOwner());
        });
    }

    @Test
    void lazyLoadExecution() throws Throwable {
        this.sessions.then(r -> {
            WorkflowJob p = (WorkflowJob)r.jenkins.createProject(WorkflowJob.class, "p");
            p.addProperty((JobProperty)new DurabilityHintJobProperty(FlowDurabilityHint.MAX_SURVIVABILITY));
            p.setDefinition((FlowDefinition)new CpsFlowDefinition("echo 'dosomething'", true));
            r.buildAndAssertSuccess((Job)p);
            WorkflowRun run = p.getLastBuild();
            Assertions.assertTrue((boolean)run.executionLoaded);
            Assertions.assertTrue((boolean)run.completed);
            Assertions.assertNotNull((Object)run.getExecution().getOwner());
            FlowExecution fe = run.getExecution();
            Assertions.assertTrue((boolean)run.executionLoaded);
            Assertions.assertNotNull((Object)run.getExecution().getOwner());
        });
        this.sessions.then(r -> {
            WorkflowJob p = (WorkflowJob)r.jenkins.getItemByFullName("p", WorkflowJob.class);
            WorkflowRun b = p.getBuildByNumber(1);
            Assertions.assertNotNull((Object)b.asFlowExecutionOwner());
            Assertions.assertNull((Object)b.execution.getOwner());
            Assertions.assertFalse((boolean)b.executionLoaded);
            Assertions.assertTrue((boolean)b.completed);
            Assertions.assertFalse((boolean)b.isBuilding());
            Assertions.assertNull((Object)b.asFlowExecutionOwner().getOrNull());
            FlowExecution fe = b.getExecution();
            Assertions.assertNotNull((Object)b.execution.getOwner());
            Assertions.assertTrue((boolean)b.executionLoaded);
            Assertions.assertNotNull((Object)b.asFlowExecutionOwner().getOrNull());
            Assertions.assertNotNull((Object)b.asFlowExecutionOwner().get());
        });
        this.sessions.then(r -> {
            WorkflowJob p = (WorkflowJob)r.jenkins.getItemByFullName("p", WorkflowJob.class);
            WorkflowRun b = p.getBuildByNumber(1);
            Assertions.assertNotNull((Object)b.asFlowExecutionOwner().get());
            Assertions.assertTrue((boolean)b.executionLoaded);
            Assertions.assertNotNull((Object)b.asFlowExecutionOwner().getOrNull());
        });
    }

    @Test
    void hardKill() throws Throwable {
        this.sessions.then(r -> {
            WorkflowJob p = (WorkflowJob)r.jenkins.createProject(WorkflowJob.class, "p");
            p.addProperty((JobProperty)new DurabilityHintJobProperty(FlowDurabilityHint.MAX_SURVIVABILITY));
            p.setDefinition((FlowDefinition)new CpsFlowDefinition("def seq = 0; while (true) {try {zombie id: ++seq} catch (x) {echo(/ignoring $x/)}}", true));
            WorkflowRun b = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).waitForStart();
            r.waitForMessage("[1] undead", (Run)b);
            Executor ex = b.getExecutor();
            Assertions.assertNotNull((Object)ex);
            ex.interrupt();
            r.waitForMessage("[1] bwahaha FlowInterruptedException #1", (Run)b);
            ex.interrupt();
            r.waitForMessage("[1] bwahaha FlowInterruptedException #2", (Run)b);
            b.doTerm();
            r.waitForMessage("[2] undead", (Run)b);
            ex.interrupt();
            r.waitForMessage("[2] bwahaha FlowInterruptedException #1", (Run)b);
            b.doKill();
            r.waitForMessage("Hard kill!", (Run)b);
            r.waitForCompletion((Run)b);
            r.assertBuildStatus(Result.ABORTED, (Run)b);
        });
        this.sessions.then(r -> {
            WorkflowJob p = (WorkflowJob)r.jenkins.getItemByFullName("p", WorkflowJob.class);
            WorkflowRun b = p.getBuildByNumber(1);
            Assertions.assertFalse((boolean)b.isBuilding());
            Assertions.assertFalse((boolean)b.executionLoaded);
        });
    }

    @Test
    void termAndKillInSidePanel() throws Throwable {
        this.sessions.then(r -> {
            WorkflowJob p = (WorkflowJob)r.jenkins.createProject(WorkflowJob.class, "p");
            p.setDefinition((FlowDefinition)new CpsFlowDefinition("def seq = 0; while (true) {try {zombie id: ++seq} catch (x) {echo(/ignoring $x/)}}", true));
            WorkflowRun b = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).waitForStart();
            r.waitForMessage("[1] undead", (Run)b);
            Executor ex = b.getExecutor();
            Assertions.assertNotNull((Object)ex);
            ex.interrupt();
            r.waitForMessage("[1] bwahaha FlowInterruptedException #1", (Run)b);
            ex.interrupt();
            r.waitForMessage("[1] bwahaha FlowInterruptedException #2", (Run)b);
            Assertions.assertFalse((boolean)this.hasTermOrKillLink(r, b, "term"));
            Assertions.assertFalse((boolean)this.hasTermOrKillLink(r, b, "kill"));
            r.waitForMessage("Click here to forcibly terminate running steps", (Run)b);
            Assertions.assertTrue((boolean)this.hasTermOrKillLink(r, b, "term"));
            Assertions.assertFalse((boolean)this.hasTermOrKillLink(r, b, "kill"));
            b.doTerm();
            r.waitForMessage("[2] undead", (Run)b);
            r.waitForMessage("Click here to forcibly kill entire build", (Run)b);
            Assertions.assertTrue((boolean)this.hasTermOrKillLink(r, b, "term"));
            Assertions.assertTrue((boolean)this.hasTermOrKillLink(r, b, "kill"));
            b.doKill();
            r.waitForMessage("Hard kill!", (Run)b);
            r.waitForCompletion((Run)b);
            r.assertBuildStatus(Result.ABORTED, (Run)b);
            Assertions.assertTrue((boolean)b.completed);
        });
    }

    @Test
    void interruptedWhileStartingMaxSurvivability() throws Throwable {
        this.sessions.then(r -> {
            Assumptions.assumeTrue((r.jenkins.pluginManager.getPlugin("workflow-cps-global-lib") == null ? 1 : 0) != 0, (String)"import from LibraryDecorator will not resolve in PCT");
            WorkflowJob p = (WorkflowJob)r.createProject(WorkflowJob.class, "p");
            p.setDefinition((FlowDefinition)new CpsFlowDefinition("import groovy.transform.*\nimport hudson.model.Executor\nimport hudson.model.Result\nimport jenkins.model.CauseOfInterruption\n@ASTTest(value={\n  def cause = new CauseOfInterruption.UserInterruption('unknown')\n  Executor.currentExecutor().interrupt(Result.ABORTED, cause)\n}) _\n", false));
            WorkflowRun b = (WorkflowRun)r.buildAndAssertStatus(Result.ABORTED, (Job)p);
            r.assertLogContains("Aborted by unknown", (Run)b);
        });
        this.sessions.then(r -> {
            WorkflowJob p = (WorkflowJob)r.jenkins.getItemByFullName("p", WorkflowJob.class);
            WorkflowRun b = p.getLastBuild();
            Assertions.assertFalse((boolean)b.isBuilding(), (String)"Build should be completed");
        });
    }

    @Test
    void interruptedWhileStartingPerformanceOptimized() throws Throwable {
        this.sessions.then(r -> {
            Assumptions.assumeTrue((r.jenkins.pluginManager.getPlugin("workflow-cps-global-lib") == null ? 1 : 0) != 0, (String)"import from LibraryDecorator will not resolve in PCT");
            WorkflowJob p = (WorkflowJob)r.createProject(WorkflowJob.class, "p");
            p.addProperty((JobProperty)new DurabilityHintJobProperty(FlowDurabilityHint.PERFORMANCE_OPTIMIZED));
            p.setDefinition((FlowDefinition)new CpsFlowDefinition("import groovy.transform.*\nimport hudson.model.Executor\nimport hudson.model.Result\nimport jenkins.model.CauseOfInterruption\n@ASTTest(value={\n  def cause = new CauseOfInterruption.UserInterruption('unknown')\n  Executor.currentExecutor().interrupt(Result.ABORTED, cause)\n}) _\n", false));
            WorkflowRun b = (WorkflowRun)r.buildAndAssertStatus(Result.ABORTED, (Job)p);
            r.assertLogContains("Aborted by unknown", (Run)b);
        });
        this.sessions.then(r -> {
            WorkflowJob p = (WorkflowJob)r.jenkins.getItemByFullName("p", WorkflowJob.class);
            WorkflowRun b = p.getLastBuild();
            Assertions.assertFalse((boolean)b.isBuilding(), (String)"Build should be completed");
        });
    }

    private boolean hasTermOrKillLink(JenkinsRule r, WorkflowRun b, String termOrKill) throws Exception {
        return !r.createWebClient().getPage((Run)b).getByXPath("//a[@href = '#' and contains(@data-url, '/" + b.getUrl() + termOrKill + "')]").isEmpty();
    }

    @Test
    void flowExecutionListener() throws Throwable {
        this.sessions.then(r -> {
            WorkflowJob p = (WorkflowJob)r.jenkins.createProject(WorkflowJob.class, "p");
            p.setDefinition((FlowDefinition)new CpsFlowDefinition("echo 'Running for listener'\nsleep 0\nsemaphore 'wait'\nsleep 0\nsemaphore 'post-resume'\nsleep 0\nerror 'fail'\n", true));
            WorkflowRun b = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).waitForStart();
            SemaphoreStep.waitForStart((String)"wait/1", (Run)b);
            ExecListener listener = (ExecListener)((Object)((Object)ExtensionList.lookup(FlowExecutionListener.class).get(ExecListener.class)));
            Assertions.assertNotNull((Object)((Object)listener));
            Assertions.assertTrue((boolean)listener.graphListener.wasCalledWithFlowStartNode);
            Assertions.assertEquals((int)1, (int)listener.created);
            Assertions.assertEquals((int)1, (int)listener.started);
            Assertions.assertEquals((int)0, (int)listener.resumed);
            Assertions.assertEquals((int)0, (int)listener.finished);
        });
        this.sessions.then(r -> {
            WorkflowJob p = (WorkflowJob)r.jenkins.getItemByFullName("p", WorkflowJob.class);
            WorkflowRun b = p.getLastBuild();
            Assertions.assertTrue((boolean)b.isBuilding());
            SemaphoreStep.success((String)"wait/1", null);
            SemaphoreStep.waitForStart((String)"post-resume/1", (Run)b);
            ExecListener listener = (ExecListener)((Object)((Object)ExtensionList.lookup(FlowExecutionListener.class).get(ExecListener.class)));
            Assertions.assertNotNull((Object)((Object)listener));
            Assertions.assertEquals((int)0, (int)listener.created);
            Assertions.assertEquals((int)0, (int)listener.started);
            Assertions.assertEquals((int)1, (int)listener.resumed);
            Assertions.assertEquals((int)0, (int)listener.finished);
            SemaphoreStep.success((String)"post-resume/1", null);
            r.assertBuildStatus(Result.FAILURE, (Run)((WorkflowRun)r.waitForCompletion((Run)b)));
            r.assertLogContains("Running for listener", (Run)b);
            Assertions.assertEquals((int)0, (int)listener.created);
            Assertions.assertEquals((int)0, (int)listener.started);
            Assertions.assertEquals((int)1, (int)listener.resumed);
            Assertions.assertEquals((int)1, (int)listener.finished);
            Assertions.assertTrue((boolean)listener.graphListener.wasCalledBeforeExecListener);
        });
    }

    @Test
    void reloadOwnerAndActions() throws Throwable {
        this.logging.record(WorkflowRun.class, Level.FINE);
        this.sessions.then(r -> {
            WorkflowJob p = (WorkflowJob)r.jenkins.createProject(WorkflowJob.class, "p");
            p.setDefinition((FlowDefinition)new CpsFlowDefinition("", true));
            WorkflowRun b = (WorkflowRun)r.buildAndAssertSuccess((Job)p);
            A a = new A();
            b.addAction((Action)a);
            b.save();
            MatcherAssert.assertThat((String)"right owner before reload", (Object)b.getExecution().getOwner(), (Matcher)Matchers.is((Object)b.asFlowExecutionOwner()));
            MatcherAssert.assertThat((String)"attached once", (Object)a.attached, (Matcher)Matchers.is((Object)1));
            MatcherAssert.assertThat((String)"not yet loaded", (Object)a.loaded, (Matcher)Matchers.is((Object)0));
            b.reload();
            MatcherAssert.assertThat((String)"right owner after reload", (Object)b.getExecution().getOwner(), (Matcher)Matchers.is((Object)b.asFlowExecutionOwner()));
            a = (A)b.getAction(A.class);
            MatcherAssert.assertThat((String)"not attached in this instance", (Object)a.attached, (Matcher)Matchers.is((Object)0));
            MatcherAssert.assertThat((String)"loaded", (Object)a.loaded, (Matcher)Matchers.is((Object)1));
        });
        this.sessions.then(r -> {
            WorkflowJob p = (WorkflowJob)r.jenkins.getItemByFullName("p", WorkflowJob.class);
            WorkflowRun b = p.getBuildByNumber(1);
            A a = (A)b.getAction(A.class);
            MatcherAssert.assertThat((String)"after restart, not attached in this instance", (Object)a.attached, (Matcher)Matchers.is((Object)0));
            MatcherAssert.assertThat((String)"after restart, loaded", (Object)a.loaded, (Matcher)Matchers.is((Object)1));
            b.reload();
            MatcherAssert.assertThat((String)"after restart, owner after reload", (Object)b.getExecution().getOwner(), (Matcher)Matchers.is((Object)b.asFlowExecutionOwner()));
            a = (A)b.getAction(A.class);
            MatcherAssert.assertThat((String)"after restart, not attached in this instance", (Object)a.attached, (Matcher)Matchers.is((Object)0));
            MatcherAssert.assertThat((String)"after restart, loaded", (Object)a.loaded, (Matcher)Matchers.is((Object)1));
        });
    }

    private static final class A
    extends InvisibleAction
    implements RunAction2 {
        volatile transient int attached;
        volatile transient int loaded;

        private A() {
        }

        public void onAttached(Run<?, ?> r) {
            ++this.attached;
        }

        public void onLoad(Run<?, ?> r) {
            ++this.loaded;
        }
    }

    @TestExtension(value={"flowExecutionListener"})
    public static class ExecListener
    extends FlowExecutionListener {
        int created;
        int started;
        int finished;
        int resumed;
        ExecGraphListener graphListener = new ExecGraphListener();

        public void onCreated(FlowExecution execution) {
            Assertions.assertTrue((boolean)execution.getCurrentHeads().isEmpty());
            this.addGraphListenerCheckList(execution);
            ++this.created;
        }

        public void onRunning(@NonNull FlowExecution execution) {
            this.addGraphListenerCheckList(execution);
            ++this.started;
        }

        public void onResumed(@NonNull FlowExecution execution) {
            this.addGraphListenerCheckList(execution);
            ++this.resumed;
        }

        private void addGraphListenerCheckList(@NonNull FlowExecution execution) {
            execution.addListener((GraphListener)this.graphListener);
            boolean listHasExec = false;
            for (FlowExecution e : FlowExecutionList.get()) {
                if (!e.equals(execution)) continue;
                listHasExec = true;
                break;
            }
            Assertions.assertTrue((boolean)listHasExec);
        }

        public void onCompleted(@NonNull FlowExecution execution) {
            ++this.finished;
            for (FlowExecution e : FlowExecutionList.get()) {
                Assertions.assertNotEquals((Object)e, (Object)execution);
            }
            Assertions.assertTrue((boolean)execution.isComplete());
            Assertions.assertNotNull((Object)execution.getCauseOfFailure());
            List heads = execution.getCurrentHeads();
            Assertions.assertEquals((int)1, (int)heads.size());
            Assertions.assertInstanceOf(FlowEndNode.class, heads.get(0));
            FlowEndNode node = (FlowEndNode)heads.get(0);
            Assertions.assertEquals((Object)Result.FAILURE, (Object)node.getResult());
        }
    }

    public static class ExecGraphListener
    implements GraphListener.Synchronous {
        boolean wasCalledBeforeExecListener;
        boolean wasCalledWithFlowStartNode;

        public void onNewHead(FlowNode node) {
            if (node instanceof FlowEndNode) {
                ExecListener listener = (ExecListener)((Object)ExtensionList.lookup(FlowExecutionListener.class).get(ExecListener.class));
                if (listener.finished == 0) {
                    this.wasCalledBeforeExecListener = true;
                }
            }
            if (node instanceof FlowStartNode) {
                this.wasCalledWithFlowStartNode = true;
            }
        }
    }

    public static class Zombie
    extends Step {
        @DataBoundSetter
        public int id;

        @DataBoundConstructor
        public Zombie() {
        }

        public StepExecution start(StepContext context) {
            return new Execution(context, this.id);
        }

        private static class Execution
        extends StepExecution {
            private static final long serialVersionUID = 1L;
            int id;
            int count;

            Execution(StepContext context, int id) {
                super(context);
                this.id = id;
            }

            public boolean start() throws Exception {
                ((TaskListener)this.getContext().get(TaskListener.class)).getLogger().printf("[%d] undead%n", this.id);
                return false;
            }

            public void stop(Throwable cause) throws Exception {
                ((TaskListener)this.getContext().get(TaskListener.class)).getLogger().printf("[%d] bwahaha %s #%d%n", this.id, cause.getClass().getSimpleName(), ++this.count);
            }
        }

        @TestExtension
        public static class DescriptorImpl
        extends StepDescriptor {
            public String getFunctionName() {
                return "zombie";
            }

            @NonNull
            public String getDisplayName() {
                return "zombie";
            }

            public Set<? extends Class<?>> getRequiredContext() {
                return Collections.singleton(TaskListener.class);
            }
        }
    }
}

