/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.job;

import hudson.model.Job;
import java.lang.ref.WeakReference;
import java.util.logging.Level;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.LogRecorder;
import org.jvnet.hudson.test.MemoryAssert;
import org.jvnet.hudson.test.junit.jupiter.BuildWatcherExtension;
import org.jvnet.hudson.test.junit.jupiter.WithJenkins;

@WithJenkins
class MemoryCleanupTest {
    @RegisterExtension
    private static final BuildWatcherExtension BUILD_WATCHER = new BuildWatcherExtension();
    private final LogRecorder logging = new LogRecorder();
    private JenkinsRule r;

    MemoryCleanupTest() {
    }

    @BeforeEach
    void beforeEach(JenkinsRule rule) {
        this.r = rule;
    }

    @Test
    void cleanup() throws Exception {
        this.logging.record("", Level.INFO).capture(256);
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("", true));
        WorkflowRun b1 = (WorkflowRun)this.r.buildAndAssertSuccess((Job)p);
        WeakReference<WorkflowRun> b1r = new WeakReference<WorkflowRun>(b1);
        b1.delete();
        b1 = null;
        this.r.jenkins.getQueue().clearLeftItems();
        try {
            MemoryAssert.assertGC(b1r, (boolean)false);
        }
        catch (NoClassDefFoundError x) {
            Assumptions.assumeTrue((boolean)"org/netbeans/insane/hook/MakeAccessible".equals(x.getMessage()), (String)("TODO https://github.com/jenkinsci/bom/issues/1551 " + String.valueOf(x)));
            throw x;
        }
    }
}

