/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.job.properties;

import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.triggers.TimerTrigger;
import hudson.triggers.Trigger;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.htmlunit.HttpMethod;
import org.htmlunit.WebRequest;
import org.htmlunit.util.NameValuePair;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.properties.MockTrigger;
import org.jenkinsci.plugins.workflow.job.properties.PipelineTriggersJobProperty;
import org.jenkinsci.plugins.workflow.job.properties.QueryingMockTrigger;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.junit.jupiter.BuildWatcherExtension;
import org.jvnet.hudson.test.junit.jupiter.WithJenkins;
import org.jvnet.hudson.test.recipes.LocalData;

@WithJenkins
class PipelineTriggersJobPropertyTest {
    @RegisterExtension
    private static final BuildWatcherExtension BUILD_WATCHER = new BuildWatcherExtension();
    private JenkinsRule r;

    PipelineTriggersJobPropertyTest() {
    }

    @BeforeEach
    void beforeEach(JenkinsRule rule) {
        this.r = rule;
    }

    @AfterEach
    void afterEach() {
        MockTrigger.startsAndStops = new ArrayList<Boolean>();
        QueryingMockTrigger.startsAndStops = new ArrayList<Boolean>();
    }

    @Test
    void loadCallsStartFalse() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        MockTrigger t = new MockTrigger();
        p.addTrigger((Trigger)t);
        p.save();
        p = (WorkflowJob)Items.load((ItemGroup)p.getParent(), (File)p.getRootDir());
        t = (MockTrigger)((Object)p.getTriggers().get(t.getDescriptor()));
        Assertions.assertNotNull((Object)((Object)t));
        Assertions.assertEquals((Object)"[null, false, null, false]", (Object)MockTrigger.startsAndStops.toString());
        Boolean currentStatus = t.currentStatus();
        Assertions.assertNotNull((Object)currentStatus);
        Assertions.assertFalse((boolean)currentStatus);
    }

    @Test
    void submitCallsStartTrue() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        MockTrigger t = new MockTrigger();
        p.addTrigger((Trigger)t);
        p.save();
        p = (WorkflowJob)this.r.configRoundtrip((Item)p);
        t = (MockTrigger)((Object)p.getTriggers().get(t.getDescriptor()));
        Assertions.assertNotNull((Object)((Object)t));
        Assertions.assertEquals((Object)"[null, false, null, true, null, false]", (Object)MockTrigger.startsAndStops.toString());
        Boolean currentStatus = t.currentStatus();
        Assertions.assertNotNull((Object)currentStatus);
        Assertions.assertFalse((boolean)currentStatus);
    }

    @Test
    void previousTriggerStopped() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        MockTrigger t = new MockTrigger();
        p.addTrigger((Trigger)t);
        p.save();
        MockTrigger t2 = new MockTrigger();
        p.addTrigger((Trigger)t2);
        p.save();
        Assertions.assertFalse((boolean)t.isStarted);
        Assertions.assertTrue((boolean)t2.isStarted);
    }

    @LocalData
    @Test
    void triggerMigration() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.jenkins.getItemByFullName("p", WorkflowJob.class);
        Assertions.assertNotNull((Object)p);
        PipelineTriggersJobProperty triggerProp = (PipelineTriggersJobProperty)p.getProperty(PipelineTriggersJobProperty.class);
        Assertions.assertNotNull((Object)triggerProp);
        Assertions.assertEquals((int)2, (int)triggerProp.getTriggers().size());
        Assertions.assertEquals((int)2, (int)p.getTriggers().size());
        TimerTrigger timerFromProp = this.getTriggerFromList(TimerTrigger.class, triggerProp.getTriggers());
        Assertions.assertNotNull((Object)timerFromProp);
        Assertions.assertEquals(TimerTrigger.class, timerFromProp.getClass());
        Trigger timerFromJob = (Trigger)p.getTriggers().get(timerFromProp.getDescriptor());
        Assertions.assertEquals((Object)timerFromProp, (Object)timerFromJob);
        MockTrigger mockFromProp = this.getTriggerFromList(MockTrigger.class, triggerProp.getTriggers());
        Assertions.assertNotNull((Object)((Object)mockFromProp));
        Assertions.assertEquals(MockTrigger.class, ((Object)((Object)mockFromProp)).getClass());
        Trigger mockFromJob = (Trigger)p.getTriggers().get(mockFromProp.getDescriptor());
        Assertions.assertEquals((Object)((Object)mockFromProp), (Object)mockFromJob);
        Assertions.assertNotNull((Object)mockFromProp.currentStatus());
        Assertions.assertEquals((Object)"[null, false, null, false]", (Object)MockTrigger.startsAndStops.toString());
        TimerTrigger newTimerTrigger = new TimerTrigger("@hourly");
        p.addTrigger((Trigger)newTimerTrigger);
        Assertions.assertEquals((int)2, (int)p.getTriggers().size());
        Assertions.assertNotNull(p.getTriggers().get(mockFromJob.getDescriptor()));
        Trigger newTimerFromJob = (Trigger)p.getTriggers().get(newTimerTrigger.getDescriptor());
        Assertions.assertEquals((Object)newTimerTrigger.getSpec(), (Object)newTimerFromJob.getSpec());
    }

    @Test
    void configRoundTrip() throws Exception {
        WorkflowJob defaultCase = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "defaultCase");
        Assertions.assertTrue((boolean)defaultCase.getTriggers().isEmpty());
        Assertions.assertNull((Object)defaultCase.getProperty(PipelineTriggersJobProperty.class));
        WorkflowJob roundTripDefault = (WorkflowJob)this.r.configRoundtrip((Item)defaultCase);
        Assertions.assertTrue((boolean)roundTripDefault.getTriggers().isEmpty());
        Assertions.assertNull((Object)defaultCase.getProperty(PipelineTriggersJobProperty.class));
        WorkflowJob withTriggerCase = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "withTriggerCase");
        withTriggerCase.addTrigger((Trigger)new MockTrigger());
        Assertions.assertEquals((int)1, (int)withTriggerCase.getTriggers().size());
        ArrayList origTriggers = new ArrayList(withTriggerCase.getTriggers().values());
        Assertions.assertEquals(MockTrigger.class, ((Trigger)origTriggers.get(0)).getClass());
        WorkflowJob roundTripWithTrigger = (WorkflowJob)this.r.configRoundtrip((Item)withTriggerCase);
        Assertions.assertEquals((int)1, (int)roundTripWithTrigger.getTriggers().size());
        ArrayList modTriggers = new ArrayList(roundTripWithTrigger.getTriggers().values());
        Assertions.assertEquals(MockTrigger.class, ((Trigger)modTriggers.get(0)).getClass());
        Assertions.assertNotNull((Object)((MockTrigger)((Object)modTriggers.get(0))).currentStatus());
        Assertions.assertEquals((Object)"[null, false, null, true, null, false]", (Object)MockTrigger.startsAndStops.toString());
    }

    @Test
    void triggerPresentDuringStart() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "triggerPresent");
        Assertions.assertNull((Object)((Object)this.getTriggerFromList(QueryingMockTrigger.class, p.getTriggersJobProperty().getTriggers())));
        JenkinsRule.WebClient wc = this.r.createWebClient();
        String newConfig = IOUtils.toString((InputStream)PipelineTriggersJobPropertyTest.class.getResourceAsStream("/org/jenkinsci/plugins/workflow/job/properties/PipelineTriggersJobPropertyTest/triggerPresentDuringStart.json"), (Charset)StandardCharsets.UTF_8);
        WebRequest request = new WebRequest(new URL(p.getAbsoluteUrl() + "configSubmit"), HttpMethod.POST);
        wc.addCrumb(request);
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(request.getRequestParameters());
        params.add(new NameValuePair("json", newConfig));
        request.setRequestParameters(params);
        wc.getPage(request);
        QueryingMockTrigger t = this.getTriggerFromList(QueryingMockTrigger.class, p.getTriggersJobProperty().getTriggers());
        Assertions.assertNotNull((Object)((Object)t));
        Assertions.assertTrue((boolean)t.isStarted);
        Assertions.assertTrue((boolean)t.foundSelf);
    }

    private <T extends Trigger<?>> T getTriggerFromList(Class<T> clazz, List<Trigger<?>> triggers) {
        for (Trigger<?> t : triggers) {
            if (!clazz.isInstance(t)) continue;
            return (T)((Trigger)clazz.cast(t));
        }
        return null;
    }
}

