/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.job.properties;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Item;
import jenkins.model.OptionalJobProperty;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.workflow.flow.DurabilityHintProvider;
import org.jenkinsci.plugins.workflow.flow.FlowDurabilityHint;
import org.jenkinsci.plugins.workflow.flow.GlobalDefaultFlowDurabilityLevel;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.properties.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

public class DurabilityHintJobProperty
extends OptionalJobProperty<WorkflowJob> {
    private final FlowDurabilityHint hint;

    public FlowDurabilityHint getHint() {
        return this.hint;
    }

    @DataBoundConstructor
    public DurabilityHintJobProperty(@NonNull FlowDurabilityHint hint) {
        this.hint = hint;
    }

    @Extension
    @Symbol(value={"durabilityHint"})
    public static class DescriptorImpl
    extends OptionalJobProperty.OptionalJobPropertyDescriptor
    implements DurabilityHintProvider {
        public FlowDurabilityHint[] getDurabilityHintValues() {
            return FlowDurabilityHint.values();
        }

        public static FlowDurabilityHint getDefaultDurabilityHint() {
            return GlobalDefaultFlowDurabilityLevel.getDefaultDurabilityHint();
        }

        @NonNull
        public String getDisplayName() {
            return Messages.speed_durability_override();
        }

        public int ordinal() {
            return 100;
        }

        @CheckForNull
        public FlowDurabilityHint suggestFor(@NonNull Item x) {
            if (x instanceof WorkflowJob) {
                DurabilityHintJobProperty prop = (DurabilityHintJobProperty)((WorkflowJob)x).getProperty(DurabilityHintJobProperty.class);
                return prop != null ? prop.getHint() : null;
            }
            return null;
        }
    }
}

