/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.job;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import hudson.model.Action;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import java.io.IOException;
import java.io.PrintStream;
import java.util.concurrent.Future;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionListener;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.jvnet.hudson.test.TestExtension;
import org.jvnet.hudson.test.junit.jupiter.BuildWatcherExtension;
import org.jvnet.hudson.test.junit.jupiter.JenkinsSessionExtension;

class WorkflowRunWithFlowExecutionListenerTest {
    @RegisterExtension
    private static final BuildWatcherExtension BUILD_WATCHER = new BuildWatcherExtension();
    @RegisterExtension
    private final JenkinsSessionExtension sessions = new JenkinsSessionExtension();

    WorkflowRunWithFlowExecutionListenerTest() {
    }

    @Test
    void testOnCompleteIsExecutedBeforeListenerIsClosed() throws Throwable {
        this.sessions.then(r -> {
            WorkflowJob p = (WorkflowJob)r.jenkins.createProject(WorkflowJob.class, "p");
            p.setDefinition((FlowDefinition)new CpsFlowDefinition("echo 'Running for listener'", true));
            WorkflowRun b = (WorkflowRun)r.assertBuildStatus(Result.SUCCESS, (Future)p.scheduleBuild2(0, new Action[0]));
            Listener listener = (Listener)((Object)((Object)ExtensionList.lookup(FlowExecutionListener.class).get(Listener.class)));
            Assertions.assertNotNull((Object)((Object)listener));
            r.waitForMessage("Finished: SUCCESS", (Run)b);
            r.assertLogContains("Running", (Run)b);
            r.assertLogContains("blah blah blah", (Run)b);
            r.assertLogContains("Build Number :1", (Run)b);
        });
    }

    @TestExtension(value={"testOnCompleteIsExecutedBeforeListenerIsClosed"})
    public static class Listener
    extends FlowExecutionListener {
        public void onCompleted(@NonNull FlowExecution execution) {
            super.onCompleted(execution);
            Queue.Executable executable = null;
            try {
                PrintStream logger = execution.getOwner().getListener().getLogger();
                logger.println("blah blah blah");
                executable = execution.getOwner().getExecutable();
                if (executable instanceof WorkflowRun) {
                    WorkflowRun run = (WorkflowRun)executable;
                    WorkflowJob workflowJob = (WorkflowJob)run.getParent();
                    int number = workflowJob.getLastBuild().number;
                    logger.println("Build Number :" + number);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

