/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.job.properties;

import hudson.model.Item;
import hudson.model.Job;
import hudson.model.JobProperty;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDurabilityHint;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.properties.DurabilityHintJobProperty;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.junit.jupiter.BuildWatcherExtension;
import org.jvnet.hudson.test.junit.jupiter.WithJenkins;

@WithJenkins
class DurabilityHintJobPropertyTest {
    @RegisterExtension
    private static final BuildWatcherExtension BUILD_WATCHER = new BuildWatcherExtension();
    private JenkinsRule r;

    DurabilityHintJobPropertyTest() {
    }

    @BeforeEach
    void beforeEach(JenkinsRule rule) {
        this.r = rule;
    }

    @Test
    void configRoundTripAndRun() throws Exception {
        WorkflowJob defaultCase = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "testCase");
        defaultCase.setDefinition((FlowDefinition)new CpsFlowDefinition("echo 'cheese is delicious'", true));
        Assertions.assertNull((Object)defaultCase.getProperty(DurabilityHintJobProperty.class));
        for (FlowDurabilityHint hint : FlowDurabilityHint.values()) {
            try {
                defaultCase.addProperty((JobProperty)new DurabilityHintJobProperty(hint));
                Assertions.assertEquals((Object)hint, (Object)((DurabilityHintJobProperty)defaultCase.getProperty(DurabilityHintJobProperty.class)).getHint());
                this.r.configRoundtrip((Item)defaultCase);
                Assertions.assertEquals((Object)hint, (Object)((DurabilityHintJobProperty)defaultCase.getProperty(DurabilityHintJobProperty.class)).getHint());
                this.r.buildAndAssertSuccess((Job)defaultCase);
                Assertions.assertEquals((Object)hint, (Object)defaultCase.getLastBuild().getExecution().getDurabilityHint());
                defaultCase.removeProperty(DurabilityHintJobProperty.class);
                Assertions.assertNull((Object)defaultCase.getProperty(DurabilityHintJobProperty.class));
            }
            catch (Exception ex) {
                throw new Exception("Error with FlowDurabilityHint " + String.valueOf(hint), ex);
            }
        }
    }
}

