/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.job.properties;

import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.queue.QueueTaskFuture;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import jenkins.model.BlockedBecauseOfBuildInProgress;
import jenkins.model.CauseOfInterruption;
import jenkins.model.InterruptedBuildAction;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.job.properties.DisableConcurrentBuildsJobProperty;
import org.jenkinsci.plugins.workflow.test.steps.SemaphoreStep;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.junit.jupiter.BuildWatcherExtension;
import org.jvnet.hudson.test.junit.jupiter.WithJenkins;
import org.jvnet.hudson.test.recipes.LocalData;

@WithJenkins
class DisableConcurrentBuildsJobPropertyTest {
    @RegisterExtension
    private static final BuildWatcherExtension BUILD_WATCHER = new BuildWatcherExtension();
    private JenkinsRule r;

    DisableConcurrentBuildsJobPropertyTest() {
    }

    @BeforeEach
    void beforeEach(JenkinsRule rule) {
        this.r = rule;
    }

    @LocalData
    @Test
    void concurrentBuildsMigrationOnByDefault() {
        WorkflowJob p = (WorkflowJob)this.r.jenkins.getItemByFullName("p", WorkflowJob.class);
        Assertions.assertNotNull((Object)p);
        Assertions.assertNull((Object)p.getProperty(DisableConcurrentBuildsJobProperty.class));
        Assertions.assertTrue((boolean)p.isConcurrentBuild());
    }

    @LocalData
    @Test
    void concurrentBuildsMigrationFromFalse() {
        WorkflowJob p = (WorkflowJob)this.r.jenkins.getItemByFullName("p", WorkflowJob.class);
        Assertions.assertNotNull((Object)p);
        Assertions.assertNotNull((Object)p.getProperty(DisableConcurrentBuildsJobProperty.class));
        Assertions.assertFalse((boolean)p.isConcurrentBuild());
    }

    @Test
    void configRoundTrip() throws Exception {
        WorkflowJob defaultCase = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "defaultCase");
        Assertions.assertTrue((boolean)defaultCase.isConcurrentBuild());
        WorkflowJob roundTripDefault = (WorkflowJob)this.r.configRoundtrip((Item)defaultCase);
        Assertions.assertTrue((boolean)roundTripDefault.isConcurrentBuild());
        WorkflowJob disabledCase = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "disableCase");
        disabledCase.setConcurrentBuild(false);
        Assertions.assertFalse((boolean)disabledCase.isConcurrentBuild());
        WorkflowJob roundTripDisabled = (WorkflowJob)this.r.configRoundtrip((Item)disabledCase);
        Assertions.assertFalse((boolean)roundTripDisabled.isConcurrentBuild());
        DisableConcurrentBuildsJobProperty prop = (DisableConcurrentBuildsJobProperty)roundTripDisabled.getProperty(DisableConcurrentBuildsJobProperty.class);
        Assertions.assertNotNull((Object)prop);
        Assertions.assertFalse((boolean)prop.isAbortPrevious());
        prop.setAbortPrevious(true);
        roundTripDisabled = (WorkflowJob)this.r.configRoundtrip((Item)roundTripDisabled);
        Assertions.assertTrue((boolean)roundTripDisabled.isConcurrentBuild());
        prop = (DisableConcurrentBuildsJobProperty)roundTripDisabled.getProperty(DisableConcurrentBuildsJobProperty.class);
        Assertions.assertNotNull((Object)prop);
        Assertions.assertTrue((boolean)prop.isAbortPrevious());
    }

    @Test
    void abortPrevious() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.createProject(WorkflowJob.class);
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("semaphore 'run'", true));
        Assertions.assertTrue((boolean)p.isConcurrentBuild());
        WorkflowRun b1 = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).waitForStart();
        SemaphoreStep.waitForStart((String)"run/1", (Run)b1);
        WorkflowRun b2 = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).waitForStart();
        SemaphoreStep.waitForStart((String)"run/2", (Run)b2);
        SemaphoreStep.success((String)"run/1", null);
        SemaphoreStep.success((String)"run/2", null);
        this.r.waitForCompletion((Run)b1);
        this.r.waitForCompletion((Run)b2);
        p.setConcurrentBuild(false);
        Assertions.assertFalse((boolean)p.isConcurrentBuild());
        WorkflowRun b3 = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).waitForStart();
        SemaphoreStep.waitForStart((String)"run/3", (Run)b3);
        SemaphoreStep.success((String)"run/4", null);
        QueueTaskFuture b4f = p.scheduleBuild2(0, new Action[0]);
        this.r.jenkins.getQueue().maintain();
        Assertions.assertEquals(Collections.singletonList(BlockedBecauseOfBuildInProgress.class), this.r.jenkins.getQueue().getItems((Queue.Task)p).stream().map(Queue.Item::getCauseOfBlockage).filter(Objects::nonNull).map(Object::getClass).collect(Collectors.toList()));
        SemaphoreStep.success((String)"run/3", null);
        this.r.waitForCompletion((Run)((WorkflowRun)b4f.waitForStart()));
        this.r.waitForCompletion((Run)b3);
        ((DisableConcurrentBuildsJobProperty)p.getProperty(DisableConcurrentBuildsJobProperty.class)).setAbortPrevious(true);
        Assertions.assertTrue((boolean)p.isConcurrentBuild());
        WorkflowRun b5 = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).waitForStart();
        SemaphoreStep.waitForStart((String)"run/5", (Run)b5);
        WorkflowRun b6 = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).waitForStart();
        SemaphoreStep.waitForStart((String)"run/6", (Run)b6);
        this.r.assertBuildStatus(Result.NOT_BUILT, (Run)((WorkflowRun)this.r.waitForCompletion((Run)b5)));
        InterruptedBuildAction iba = (InterruptedBuildAction)b5.getAction(InterruptedBuildAction.class);
        Assertions.assertNotNull((Object)iba);
        Assertions.assertEquals((int)1, (int)iba.getCauses().size());
        Assertions.assertEquals(DisableConcurrentBuildsJobProperty.CancelledCause.class, ((CauseOfInterruption)iba.getCauses().get(0)).getClass());
        Assertions.assertEquals((Object)b6, (Object)((DisableConcurrentBuildsJobProperty.CancelledCause)iba.getCauses().get(0)).getNewerBuild());
        SemaphoreStep.success((String)"run/6", null);
        this.r.assertBuildStatusSuccess((Run)((WorkflowRun)this.r.waitForCompletion((Run)b6)));
    }
}

