/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.job.console;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import hudson.Functions;
import hudson.console.ModelHyperlinkNote;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Job;
import hudson.model.Messages;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.security.SecurityRealm;
import hudson.slaves.SlaveComputer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.awaitility.Awaitility;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.htmlunit.html.HtmlPage;
import org.jenkinsci.plugins.workflow.actions.LogAction;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graphanalysis.DepthFirstScanner;
import org.jenkinsci.plugins.workflow.graphanalysis.FlowScanningUtils;
import org.jenkinsci.plugins.workflow.graphanalysis.NodeStepTypePredicate;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.StepExecutions;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.jenkinsci.plugins.workflow.test.steps.SemaphoreStep;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.LogRecorder;
import org.jvnet.hudson.test.TestExtension;
import org.jvnet.hudson.test.junit.jupiter.WithJenkins;
import org.kohsuke.stapler.DataBoundConstructor;

@WithJenkins
class DefaultLogStorageTest {
    private static final Logger LOGGER = Logger.getLogger(DefaultLogStorageTest.class.getName());
    private JenkinsRule r;
    private final LogRecorder logging = new LogRecorder();

    DefaultLogStorageTest() {
    }

    @BeforeEach
    void beforeEach(JenkinsRule rule) {
        this.r = rule;
    }

    @Test
    void consoleNotes() throws Exception {
        Cause.UserIdCause cause;
        this.r.jenkins.setSecurityRealm((SecurityRealm)this.r.createDummySecurityRealm());
        WorkflowJob p = (WorkflowJob)this.r.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("hyperlink()", true));
        User alice = User.getById((String)"alice", (boolean)true);
        try (ACLContext context = ACL.as((User)alice);){
            cause = new Cause.UserIdCause();
        }
        WorkflowRun b = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[]{new CauseAction((Cause)cause)}));
        HtmlPage page = this.r.createWebClient().goTo(b.getUrl() + "console");
        this.assertLogContains(page, Messages.Cause_UserIdCause_ShortDescription((Object)alice.getDisplayName()), alice.getUrl());
        this.assertLogContains(page, "Running inside " + b.getDisplayName(), b.getUrl());
        MatcherAssert.assertThat((Object)page.getWebResponse().getContentAsString().replace("\r\n", "\n"), (Matcher)Matchers.containsString((String)"<span class=\"pipeline-new-node\" nodeId=\"3\" enclosingId=\"2\">[Pipeline] hyperlink\n</span><span class=\"pipeline-node-3\">Running inside <a href="));
        DepthFirstScanner scanner = new DepthFirstScanner();
        scanner.setup((Collection)b.getExecution().getCurrentHeads());
        ArrayList nodes = Lists.newArrayList((Iterator)scanner.filter(FlowScanningUtils.hasActionPredicate(LogAction.class)));
        Assertions.assertEquals((int)1, (int)nodes.size());
        page = this.r.createWebClient().goTo(((FlowNode)nodes.get(0)).getUrl() + ((LogAction)((FlowNode)nodes.get(0)).getAction(LogAction.class)).getUrlName());
        this.assertLogContains(page, "Running inside " + b.getDisplayName(), b.getUrl());
        this.r.assertLogContains("\nRunning inside " + b.getDisplayName(), (Run)b);
    }

    private void assertLogContains(HtmlPage page, String plainText, String url) {
        String html = page.getWebResponse().getContentAsString();
        MatcherAssert.assertThat((String)(String.valueOf(page.getUrl()) + " looks OK as text:\n" + html), (Object)page.getDocumentElement().getTextContent(), (Matcher)Matchers.containsString((String)plainText));
        String absUrl = this.r.contextPath + "/" + url;
        Assertions.assertNotNull((Object)page.getAnchorByHref(absUrl), (String)("found " + absUrl + " in:\n" + html));
    }

    @Test
    void performance() throws Exception {
        Assumptions.assumeFalse((boolean)Functions.isWindows());
        WorkflowJob p = (WorkflowJob)this.r.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("giant(6); echo 'quick message at the end'", true));
        long start = System.nanoTime();
        WorkflowRun b = (WorkflowRun)this.r.buildAndAssertSuccess((Job)p);
        System.out.printf("Took %dms to run the build%n", (System.nanoTime() - start) / 1000L / 1000L);
        StringWriter sw = new StringWriter();
        start = System.nanoTime();
        b.getLogText().writeHtmlTo(0L, (Writer)sw);
        System.out.printf("Took %dms to write HTML of whole build%n", (System.nanoTime() - start) / 1000L / 1000L);
        MatcherAssert.assertThat((Object)sw.toString(), (Matcher)Matchers.containsString((String)"\n456788\n456789\n456790\n"));
        MatcherAssert.assertThat((Object)sw.toString(), (Matcher)Matchers.containsString((String)"\n999999\n</span>"));
        start = System.nanoTime();
        long length = b.getLogText().length();
        System.out.printf("Took %dms to compute length of whole build%n", (System.nanoTime() - start) / 1000L / 1000L);
        MatcherAssert.assertThat((Object)length, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(200000L)));
        long offset = length - 153600L;
        sw = new StringWriter();
        start = System.nanoTime();
        b.getLogText().writeHtmlTo(offset, (Writer)sw);
        System.out.printf("Took %dms to write truncated HTML of whole build%n", (System.nanoTime() - start) / 1000L / 1000L);
        MatcherAssert.assertThat((Object)sw.toString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"\n456789\n")));
        MatcherAssert.assertThat((Object)sw.toString(), (Matcher)Matchers.containsString((String)"\n999923\n"));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        start = System.nanoTime();
        IOUtils.copy((InputStream)b.getLogInputStream(), (OutputStream)baos);
        System.out.printf("Took %dms to write plain text of whole build%n", (System.nanoTime() - start) / 1000L / 1000L);
        MatcherAssert.assertThat((Object)baos.toString(), (Matcher)Matchers.containsString((String)"\n456789\n"));
        String rawLog = FileUtils.readFileToString((File)new File(b.getRootDir(), "log"), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)rawLog, (Matcher)Matchers.containsString((String)"0\n"));
        MatcherAssert.assertThat((Object)rawLog, (Matcher)Matchers.containsString((String)"\n999999\n"));
        MatcherAssert.assertThat((Object)rawLog, (Matcher)Matchers.containsString((String)"quick message at the end"));
        LogAction la = (LogAction)new DepthFirstScanner().findFirstMatch(b.getExecution(), (Predicate)new NodeStepTypePredicate("giant")).getAction(LogAction.class);
        Assertions.assertNotNull((Object)la);
        baos = new ByteArrayOutputStream();
        la.getLogText().writeRawLogTo(0L, (OutputStream)baos);
        MatcherAssert.assertThat((Object)baos.toString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Pipeline")));
        sw = new StringWriter();
        start = System.nanoTime();
        la.getLogText().writeHtmlTo(0L, (Writer)sw);
        System.out.printf("Took %dms to write HTML of one long node%n", (System.nanoTime() - start) / 1000L / 1000L);
        MatcherAssert.assertThat((Object)sw.toString(), (Matcher)Matchers.containsString((String)"\n456789\n"));
        start = System.nanoTime();
        length = la.getLogText().length();
        System.out.printf("Took %dms to compute length of one long node%n", (System.nanoTime() - start) / 1000L / 1000L);
        MatcherAssert.assertThat((Object)length, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(200000L)));
        sw = new StringWriter();
        offset = length - 153600L;
        start = System.nanoTime();
        la.getLogText().writeHtmlTo(offset, (Writer)sw);
        System.out.printf("Took %dms to write truncated HTML of one long node%n", (System.nanoTime() - start) / 1000L / 1000L);
        MatcherAssert.assertThat((Object)sw.toString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"\n456789\n")));
        MatcherAssert.assertThat((Object)sw.toString(), (Matcher)Matchers.containsString((String)"\n999923\n"));
        baos = new ByteArrayOutputStream();
        start = System.nanoTime();
        la.getLogText().writeRawLogTo(0L, (OutputStream)baos);
        System.out.printf("Took %dms to write plain text of one long node%n", (System.nanoTime() - start) / 1000L / 1000L);
        MatcherAssert.assertThat((Object)baos.toString(), (Matcher)Matchers.containsString((String)"\n456789\n"));
        la = (LogAction)new DepthFirstScanner().findFirstMatch(b.getExecution(), (Predicate)new NodeStepTypePredicate("echo")).getAction(LogAction.class);
        Assertions.assertNotNull((Object)la);
        sw = new StringWriter();
        start = System.nanoTime();
        la.getLogText().writeHtmlTo(0L, (Writer)sw);
        System.out.printf("Took %dms to write HTML of one short node%n", (System.nanoTime() - start) / 1000L / 1000L);
        MatcherAssert.assertThat((Object)sw.toString(), (Matcher)Matchers.containsString((String)"quick message at the end"));
        start = System.nanoTime();
        length = la.getLogText().length();
        System.out.printf("Took %dms to compute length of one short node%n", (System.nanoTime() - start) / 1000L / 1000L);
        MatcherAssert.assertThat((Object)length, (Matcher)Matchers.lessThan((Comparable)Long.valueOf(50L)));
    }

    @Disabled(value="for interactive use")
    @Timeout(value=600L)
    @Test
    void giantLogRunning() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("for (int i = 0; i < 10; i++) {giant(7)}", true));
        WorkflowRun b = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).waitForStart();
        LOGGER.info("Running");
        URI base = URI.create(p.getAbsoluteUrl() + "/1/");
        HttpClient client = HttpClient.newHttpClient();
        String start = "0";
        while (true) {
            LOGGER.info("progressiveHtml?start=" + start);
            HttpHeaders headers = client.send(HttpRequest.newBuilder(base.resolve("logText/progressiveHtml?start=" + start)).build(), HttpResponse.BodyHandlers.discarding()).headers();
            if (!Boolean.parseBoolean(headers.firstValue("X-More-Data").orElse("false"))) break;
            start = headers.firstValue("X-Text-Size").get();
        }
        LOGGER.info("Complete");
        this.r.assertBuildStatusSuccess((Run)((WorkflowRun)this.r.waitForCompletion((Run)b)));
    }

    @Disabled(value="for interactive use")
    @Timeout(value=600L)
    @Test
    void giantLogCompleted() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("giant(8)", true));
        LOGGER.info("running build");
        WorkflowRun b = (WorkflowRun)this.r.buildAndAssertSuccess((Job)p);
        LOGGER.info("completed");
        URI base = URI.create(p.getAbsoluteUrl() + "/1/");
        HttpClient client = HttpClient.newHttpClient();
        LOGGER.info("console");
        client.send(HttpRequest.newBuilder(base.resolve("console")).build(), HttpResponse.BodyHandlers.discarding());
        LOGGER.info("consoleFull");
        client.send(HttpRequest.newBuilder(base.resolve("consoleFull")).build(), HttpResponse.BodyHandlers.discarding());
        LOGGER.info("consoleText");
        client.send(HttpRequest.newBuilder(base.resolve("consoleText")).build(), HttpResponse.BodyHandlers.discarding());
        LOGGER.info("progressiveText");
        client.send(HttpRequest.newBuilder(base.resolve("logText/progressiveText")).build(), HttpResponse.BodyHandlers.discarding());
    }

    @Disabled(value="Currently not asserting anything, just here for interactive evaluation.")
    @Test
    void parallelLogStreaming() throws Exception {
        Assumptions.assumeFalse((boolean)Functions.isWindows());
        this.logging.record(SlaveComputer.class, Level.FINEST);
        int concurrency = 10;
        for (int i = 0; i < concurrency; ++i) {
            this.r.createSlave();
        }
        WorkflowJob p = (WorkflowJob)this.r.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("def branches = [:]\nfor (def i = 0; i < " + concurrency + "; i++) {\n    def branch = /branch$i/\n    branches[branch] = { \n        node('!master') {\n            withEnv([/BRANCH=$branch/]) {\n                timeout(activity: true, time: 2, unit: 'HOURS') {\n                    timestamps {\n                        sh '''\n                            set +x\n                            cat /dev/urandom | env LC_CTYPE=c tr -dc '[:alpha:]\\n' | awk '{print ENVIRON[\"BRANCH\"], $0; system(\"sleep .1\");}'\n                        '''\n                    }\n                }\n            }\n        }\n    }\n}\nparallel(branches)", true));
        WorkflowRun b = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).waitForStart();
        Awaitility.await().until(() -> new File(b.getRootDir(), "log").isFile());
        b.writeWholeLogTo((OutputStream)System.out);
    }

    @Test
    void doConsoleText() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("@NonCPS def giant() {(0..19999).join('\\n')}; echo giant(); semaphore 'wait'", true));
        WorkflowRun b = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).waitForStart();
        SemaphoreStep.waitForStart((String)"wait/1", (Run)b);
        MatcherAssert.assertThat((Object)this.r.createWebClient().goTo(b.getUrl() + "consoleText", "text/plain").getWebResponse().getContentAsString(), (Matcher)Matchers.containsString((String)"\n12345\n"));
        SemaphoreStep.success((String)"wait/1", null);
        this.r.assertBuildStatusSuccess((Run)((WorkflowRun)this.r.waitForCompletion((Run)b)));
    }

    @Test
    void getLogInputStream() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("@NonCPS def giant() {(0..19999).join('\\n')}; echo giant(); semaphore 'wait'", true));
        WorkflowRun b = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).waitForStart();
        SemaphoreStep.waitForStart((String)"wait/1", (Run)b);
        try (InputStream logStream = b.getLogInputStream();){
            MatcherAssert.assertThat((Object)IOUtils.toString((InputStream)logStream, (Charset)StandardCharsets.UTF_8), (Matcher)Matchers.containsString((String)"\n12345\n"));
        }
        SemaphoreStep.success((String)"wait/1", null);
        this.r.assertBuildStatusSuccess((Run)((WorkflowRun)this.r.waitForCompletion((Run)b)));
    }

    @Test
    void getLog() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("@NonCPS def giant() {(0..19999).join('\\n')}; echo giant(); semaphore 'wait'", true));
        WorkflowRun b = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).waitForStart();
        SemaphoreStep.waitForStart((String)"wait/1", (Run)b);
        MatcherAssert.assertThat((Object)b.getLog(), (Matcher)Matchers.containsString((String)"\n12345\n"));
        SemaphoreStep.success((String)"wait/1", null);
        this.r.assertBuildStatusSuccess((Run)((WorkflowRun)this.r.waitForCompletion((Run)b)));
    }

    public static final class GiantStep
    extends Step {
        final int digits;

        @DataBoundConstructor
        public GiantStep(int digits) {
            this.digits = digits;
        }

        public StepExecution start(StepContext context) throws Exception {
            return StepExecutions.synchronousNonBlockingVoid((StepContext)context, c -> {
                PrintStream ps = ((TaskListener)c.get(TaskListener.class)).getLogger();
                int i = 0;
                while ((double)i < Math.pow(10.0, this.digits)) {
                    ps.printf("%0" + this.digits + "d%n", i);
                    ++i;
                }
            });
        }

        @TestExtension
        public static final class DescriptorImpl
        extends StepDescriptor {
            public String getFunctionName() {
                return "giant";
            }

            public Set<? extends Class<?>> getRequiredContext() {
                return Set.of(TaskListener.class);
            }
        }
    }

    public static class HyperlinkingStep
    extends Step {
        @DataBoundConstructor
        public HyperlinkingStep() {
        }

        public StepExecution start(StepContext context) {
            return new Execution(context);
        }

        static class Execution
        extends SynchronousStepExecution<Void> {
            private static final long serialVersionUID = 1L;

            Execution(StepContext context) {
                super(context);
            }

            protected Void run() throws Exception {
                ((TaskListener)this.getContext().get(TaskListener.class)).getLogger().println("Running inside " + ModelHyperlinkNote.encodeTo((Run)((Run)this.getContext().get(Run.class))));
                return null;
            }
        }

        @TestExtension(value={"consoleNotes"})
        public static class DescriptorImpl
        extends StepDescriptor {
            public String getFunctionName() {
                return "hyperlink";
            }

            public Set<? extends Class<?>> getRequiredContext() {
                return ImmutableSet.of(TaskListener.class, Run.class);
            }
        }
    }
}

