/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.job;

import hudson.cli.CLICommandInvoker;
import hudson.model.Action;
import hudson.model.Executor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.git.GitSCM;
import hudson.scm.SCM;
import hudson.security.WhoAmI;
import hudson.triggers.SCMTrigger;
import hudson.triggers.Trigger;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import java.util.stream.Stream;
import jenkins.model.lazy.LazyBuildMixIn;
import jenkins.plugins.git.GitSampleRepoRule;
import jenkins.plugins.git.junit.jupiter.WithGitSampleRepo;
import net.sf.json.JSONObject;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.htmlunit.HttpMethod;
import org.htmlunit.WebRequest;
import org.htmlunit.html.HtmlCheckBoxInput;
import org.htmlunit.html.HtmlForm;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.cps.CpsScmFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.RunLoadCounter;
import org.jvnet.hudson.test.junit.jupiter.BuildWatcherExtension;
import org.jvnet.hudson.test.junit.jupiter.WithJenkins;

@WithJenkins
@WithGitSampleRepo
class WorkflowJobTest {
    private static final Logger LOGGER = Logger.getLogger(WorkflowJobTest.class.getName());
    @RegisterExtension
    private static final BuildWatcherExtension BUILD_WATCHER = new BuildWatcherExtension();
    private JenkinsRule r;
    private GitSampleRepoRule sampleRepo;

    WorkflowJobTest() {
    }

    @BeforeEach
    void beforeEach(JenkinsRule rule, GitSampleRepoRule repo) {
        this.r = rule;
        this.sampleRepo = repo;
    }

    @Test
    void getSCM() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("node {\n  checkout(new hudson.scm.NullSCM())\n}\n", false));
        Assertions.assertTrue((boolean)p.getSCMs().isEmpty(), (String)"No runs has been performed and there should be no SCMs");
        this.r.buildAndAssertSuccess((Job)p);
        Assertions.assertEquals((int)1, (int)p.getSCMs().size(), (String)"Expecting one SCM");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("error 'Fail!'", true));
        this.r.assertBuildStatus(Result.FAILURE, (Future)p.scheduleBuild2(0, new Action[0]));
        Assertions.assertEquals((int)1, (int)p.getSCMs().size(), (String)"Expecting one SCM even though last run failed");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("echo 'Pass!'", true));
        this.r.buildAndAssertSuccess((Job)p);
        Assertions.assertEquals((int)0, (int)p.getSCMs().size(), (String)"Expecting zero SCMs");
    }

    @Test
    void polling() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.write("Jenkinsfile", "echo 'first version'");
        this.sampleRepo.git(new String[]{"add", "Jenkinsfile"});
        this.sampleRepo.git(new String[]{"commit", "-m", "init"});
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        p.addTrigger((Trigger)new SCMTrigger(""));
        p.setDefinition((FlowDefinition)new CpsScmFlowDefinition((SCM)new GitSCM(this.sampleRepo.toString()), "Jenkinsfile"));
        this.r.assertLogContains("first version", this.r.buildAndAssertSuccess((Job)p));
        this.sampleRepo.write("Jenkinsfile", "echo 'second version'");
        this.sampleRepo.git(new String[]{"commit", "-a", "-m", "init"});
        this.r.jenkins.setQuietPeriod(Integer.valueOf(0));
        this.r.createWebClient().getPage(new WebRequest(this.r.createWebClient().createCrumbedUrl(p.getUrl() + "polling"), HttpMethod.POST));
        this.r.waitUntilNoActivity();
        WorkflowRun b2 = p.getLastBuild();
        Assertions.assertEquals((int)2, (int)b2.getNumber());
        this.r.assertLogContains("second version", (Run)b2);
    }

    @Test
    void nonEmptySCMListForGitSCMJobBeforeBuild() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        CpsScmFlowDefinition def = new CpsScmFlowDefinition((SCM)new GitSCM("I don't care"), "Jenkinsfile");
        Assertions.assertEquals((int)1, (int)def.getSCMs().size(), (String)"Expecting one SCM for definition");
        p.setDefinition((FlowDefinition)def);
        Assertions.assertEquals((int)1, (int)p.getSCMs().size(), (String)"Expecting one SCM");
    }

    @Test
    void neverBuiltSCMBasedJobMustBeTriggerableByHook() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.write("Jenkinsfile", "echo 'first version'");
        this.sampleRepo.git(new String[]{"add", "Jenkinsfile"});
        this.sampleRepo.git(new String[]{"commit", "-m", "init"});
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        p.addTrigger((Trigger)new SCMTrigger(""));
        p.setDefinition((FlowDefinition)new CpsScmFlowDefinition((SCM)new GitSCM(this.sampleRepo.toString()), "Jenkinsfile"));
        this.r.jenkins.setQuietPeriod(Integer.valueOf(0));
        this.r.createWebClient().getPage(new WebRequest(this.r.createWebClient().createCrumbedUrl(p.getUrl() + "polling"), HttpMethod.POST));
        this.r.waitUntilNoActivity();
        WorkflowRun b1 = p.getLastBuild();
        Assertions.assertEquals((int)1, (int)b1.getNumber());
        this.r.assertLogContains("first version", (Run)b1);
    }

    @Test
    void addAction() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        WhoAmI a = new WhoAmI();
        p.addAction((Action)a);
        Assertions.assertNotNull((Object)p.getAction(WhoAmI.class));
    }

    @Test
    void disabled() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        JenkinsRule.WebClient wc = this.r.createWebClient();
        this.assertDisabled(p, false, wc);
        HtmlForm form = wc.getPage((Item)p, "configure").getFormByName("config");
        HtmlCheckBoxInput checkbox = (HtmlCheckBoxInput)form.getInputByName("enable");
        Assertions.assertTrue((boolean)checkbox.isChecked());
        checkbox.setChecked(false);
        this.r.submit(form);
        this.assertDisabled(p, true, wc);
        form = wc.getPage((Item)p, "configure").getFormByName("config");
        checkbox = (HtmlCheckBoxInput)form.getInputByName("enable");
        Assertions.assertFalse((boolean)checkbox.isChecked());
        checkbox.setChecked(true);
        this.r.submit(form);
        this.assertDisabled(p, false, wc);
        wc.getPage(new WebRequest(wc.createCrumbedUrl(p.getUrl() + "disable"), HttpMethod.POST));
        this.assertDisabled(p, true, wc);
        Assertions.assertNull((Object)p.scheduleBuild2(0, new Action[0]));
        MatcherAssert.assertThat((Object)new CLICommandInvoker(this.r, "enable-job").invokeWithArgs(new String[]{"p"}), (Matcher)CLICommandInvoker.Matcher.succeededSilently());
        this.assertDisabled(p, false, wc);
    }

    private void assertDisabled(WorkflowJob p, boolean disabled, JenkinsRule.WebClient wc) throws Exception {
        MatcherAssert.assertThat((Object)p.isDisabled(), (Matcher)Matchers.is((Object)disabled));
        MatcherAssert.assertThat((Object)p.isBuildable(), (Matcher)Matchers.is((Object)(!disabled ? 1 : 0)));
        MatcherAssert.assertThat((Object)wc.getJSON(p.getUrl() + "api/json?tree=disabled,buildable").getJSONObject(), (Matcher)Matchers.is((Object)new JSONObject().accumulate("_class", (Object)WorkflowJob.class.getName()).accumulate("disabled", disabled).accumulate("buildable", !disabled)));
    }

    @Test
    void newBuildsShouldNotLoadOld() throws Throwable {
        WorkflowJob p = (WorkflowJob)this.r.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("", true));
        for (int i = 0; i < 10; ++i) {
            this.r.buildAndAssertSuccess((Job)p);
        }
        RunLoadCounter.assertMaxLoads((LazyBuildMixIn.LazyLoadingJob)p, (int)1, () -> {
            for (int i = 0; i < 5; ++i) {
                this.r.buildAndAssertSuccess((Job)p);
            }
            return null;
        });
    }

    @Test
    void deletionShouldWaitForBuildsToComplete() throws Throwable {
        WorkflowJob p = (WorkflowJob)this.r.createProject(WorkflowJob.class);
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("try {\n  echo 'about to sleep'\n  sleep 999\n} catch(e) {\n  echo 'aborting soon'\n  sleep 3\n}\n", true));
        WorkflowRun b = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).waitForStart();
        this.r.waitForMessage("about to sleep", (Run)b);
        LOGGER.info(() -> "Deleting " + String.valueOf(p));
        p.delete();
        LOGGER.info(() -> "Deleted " + String.valueOf(p));
        MatcherAssert.assertThat((Object)this.r.jenkins.getItemByFullName(p.getFullName()), (Matcher)Matchers.nullValue());
        List<Queue.Executable> executables = Stream.of(this.r.jenkins.getComputers()).flatMap(c -> c.getAllExecutors().stream()).map(Executor::getCurrentExecutable).filter(Objects::nonNull).toList();
        MatcherAssert.assertThat(executables, (Matcher)Matchers.empty());
    }
}

