/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.job;

import hudson.model.Action;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.model.Result;
import hudson.triggers.Trigger;
import java.util.concurrent.Future;
import jenkins.triggers.ReverseBuildTrigger;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.jvnet.hudson.test.TestExtension;
import org.jvnet.hudson.test.junit.jupiter.BuildWatcherExtension;
import org.jvnet.hudson.test.junit.jupiter.JenkinsSessionExtension;

class ReverseBuildTriggerTest {
    @RegisterExtension
    private static final BuildWatcherExtension BUILD_WATCHER = new BuildWatcherExtension();
    @RegisterExtension
    private final JenkinsSessionExtension sessions = new JenkinsSessionExtension();

    ReverseBuildTriggerTest() {
    }

    @Test
    void upstreamMapRebuilding() throws Throwable {
        this.sessions.then(r -> {
            r.jenkins.setQuietPeriod(Integer.valueOf(0));
            WorkflowJob us = (WorkflowJob)r.jenkins.createProject(WorkflowJob.class, "us");
            us.setDefinition((FlowDefinition)new CpsFlowDefinition("", true));
            us.addProperty((JobProperty)new SlowToLoad());
            WorkflowJob ds = (WorkflowJob)r.jenkins.createProject(WorkflowJob.class, "ds");
            ds.setDefinition((FlowDefinition)new CpsFlowDefinition("", true));
            ReverseBuildTrigger trigger = new ReverseBuildTrigger("us");
            trigger.setThreshold(Result.SUCCESS);
            ds.addTrigger((Trigger)trigger);
            r.assertBuildStatusSuccess((Future)us.scheduleBuild2(0, new Action[0]));
            r.waitUntilNoActivity();
            WorkflowRun ds1 = (WorkflowRun)ds.getLastCompletedBuild();
            Assertions.assertNotNull((Object)ds1);
            Assertions.assertEquals((int)1, (int)ds1.getNumber());
        });
        this.sessions.then(r -> {
            WorkflowJob us = (WorkflowJob)r.jenkins.getItemByFullName("us", WorkflowJob.class);
            Assertions.assertNotNull((Object)us);
            WorkflowJob ds = (WorkflowJob)r.jenkins.getItemByFullName("ds", WorkflowJob.class);
            Assertions.assertNotNull((Object)ds);
            r.assertBuildStatusSuccess((Future)us.scheduleBuild2(0, new Action[0]));
            r.waitUntilNoActivity();
            WorkflowRun ds2 = (WorkflowRun)ds.getLastCompletedBuild();
            Assertions.assertNotNull((Object)ds2);
            Assertions.assertEquals((int)2, (int)ds2.getNumber());
        });
    }

    public static class SlowToLoad
    extends JobProperty<WorkflowJob> {
        protected void setOwner(WorkflowJob owner) {
            super.setOwner((Job)owner);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException x) {
                throw new AssertionError((Object)x);
            }
        }

        @TestExtension(value={"upstreamMapRebuilding"})
        public static class DescriptorImpl
        extends JobPropertyDescriptor {
        }
    }
}

