/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.job;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Functions;
import hudson.XmlFile;
import hudson.model.Action;
import hudson.model.BallColor;
import hudson.model.Describable;
import hudson.model.Executor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.Slave;
import hudson.model.StringParameterDefinition;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.model.listeners.RunListener;
import hudson.model.queue.QueueTaskFuture;
import hudson.plugins.git.GitSCM;
import hudson.scm.SCM;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.security.AuthorizationStrategy;
import hudson.security.Permission;
import hudson.security.SecurityRealm;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import hudson.tasks.LogRotator;
import hudson.util.DescribableList;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.BuildDiscarder;
import jenkins.model.CauseOfInterruption;
import jenkins.model.InterruptedBuildAction;
import jenkins.model.Jenkins;
import jenkins.model.Messages;
import jenkins.plugins.git.GitSampleRepoRule;
import jenkins.plugins.git.junit.jupiter.WithGitSampleRepo;
import jenkins.security.QueueItemAuthenticatorConfiguration;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.awaitility.Awaitility;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.htmlunit.AlertHandler;
import org.htmlunit.Page;
import org.htmlunit.WebResponse;
import org.jenkinsci.plugins.scriptsecurity.scripts.ScriptApproval;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsScmFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.FlowGraphWalker;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graph.StepNode;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.job.properties.DisableConcurrentBuildsJobProperty;
import org.jenkinsci.plugins.workflow.support.actions.EnvironmentAction;
import org.jenkinsci.plugins.workflow.test.steps.SemaphoreStep;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.LogRecorder;
import org.jvnet.hudson.test.MockAuthorizationStrategy;
import org.jvnet.hudson.test.MockQueueItemAuthenticator;
import org.jvnet.hudson.test.TestExtension;
import org.jvnet.hudson.test.junit.jupiter.BuildWatcherExtension;
import org.jvnet.hudson.test.junit.jupiter.WithJenkins;
import org.xml.sax.SAXException;

@WithJenkins
@WithGitSampleRepo
class WorkflowRunTest {
    private static final Logger LOGGER = Logger.getLogger(WorkflowRunTest.class.getName());
    @RegisterExtension
    private static final BuildWatcherExtension BUILD_WATCHER = new BuildWatcherExtension();
    private final LogRecorder logging = new LogRecorder();
    private JenkinsRule r;
    private GitSampleRepoRule sampleRepo;

    WorkflowRunTest() {
    }

    @BeforeEach
    void beforeEach(JenkinsRule rule, GitSampleRepoRule repo) {
        this.r = rule;
        this.sampleRepo = repo;
    }

    @Test
    void basics() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("println('hello')", true));
        WorkflowRun b1 = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[0]));
        Assertions.assertFalse((boolean)b1.isBuilding());
        Assertions.assertFalse((boolean)b1.isInProgress());
        Assertions.assertFalse((boolean)b1.isLogUpdated());
        Assertions.assertTrue((boolean)b1.completed);
        Assertions.assertTrue((boolean)b1.executionLoaded);
        Assertions.assertTrue((b1.getDuration() > 0L ? 1 : 0) != 0);
        WorkflowRun b2 = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[0]));
        Assertions.assertEquals((Object)b1, (Object)b2.getPreviousBuild());
        Assertions.assertNull((Object)b1.getPreviousBuild());
        this.r.assertLogContains("hello", (Run)b1);
    }

    @Test
    void parameters() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("echo \"param=${PARAM}\"", true));
        p.addProperty((JobProperty)new ParametersDefinitionProperty(new ParameterDefinition[]{new StringParameterDefinition("PARAM", null)}));
        this.r.assertLogContains("param=value", this.r.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[]{new ParametersAction(new ParameterValue[]{new StringParameterValue("PARAM", "value")})})));
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("echo \"param=${env.PARAM}\"", true));
        this.r.assertLogContains("param=value", this.r.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[]{new ParametersAction(new ParameterValue[]{new StringParameterValue("PARAM", "value")})})));
    }

    @Disabled(value="TODO broken by call to EnvVars.resolve in WorkflowRun.getEnvironment")
    @Test
    void recursiveEnv() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        p.addProperty((JobProperty)new ParametersDefinitionProperty(new ParameterDefinition[]{new StringParameterDefinition("VAR", "val$$")}));
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("echo(/VAR=$VAR/)", true));
        this.r.assertLogContains("VAR=val$$", this.r.buildAndAssertSuccess((Job)p));
    }

    @Test
    void durationIsCalculated() throws Exception {
        WorkflowJob duration = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "duration");
        duration.setDefinition((FlowDefinition)new CpsFlowDefinition("echo \"duration should not be 0 in DurationRunListener\"", true));
        this.r.assertBuildStatusSuccess((Future)duration.scheduleBuild2(0, new Action[0]));
        Assertions.assertNotEquals((long)0L, (long)DurationRunListener.duration);
    }

    @Test
    void funnyParameters() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("echo \"a.b=${params['a.b']}\"", true));
        p.addProperty((JobProperty)new ParametersDefinitionProperty(new ParameterDefinition[]{new StringParameterDefinition("a.b", null)}));
        WorkflowRun b = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[]{new ParametersAction(new ParameterValue[]{new StringParameterValue("a.b", "v")})}));
        this.r.assertLogContains("a.b=v", (Run)b);
    }

    @Test
    void iconColor() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("println('hello')\nsemaphore 'wait'\nprintln('hello')\n", true));
        Assertions.assertSame((Object)BallColor.NOTBUILT, (Object)p.getIconColor());
        QueueTaskFuture q = p.scheduleBuild2(0, new Action[0]);
        WorkflowRun b1 = (WorkflowRun)q.getStartCondition().get();
        CpsFlowExecution e = (CpsFlowExecution)b1.getExecutionPromise().get();
        Assertions.assertFalse((boolean)b1.hasntStartedYet());
        this.assertColor(b1, BallColor.NOTBUILT_ANIME);
        SemaphoreStep.waitForStart((String)"wait/1", (Run)b1);
        Assertions.assertFalse((boolean)b1.hasntStartedYet());
        this.assertColor(b1, BallColor.NOTBUILT_ANIME);
        SemaphoreStep.success((String)"wait/1", null);
        q.get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)e.isComplete());
        Assertions.assertFalse((boolean)b1.hasntStartedYet());
        this.assertColor(b1, BallColor.BLUE);
        p.makeDisabled(true);
        Assertions.assertSame((Object)BallColor.DISABLED, (Object)p.getIconColor());
        p.makeDisabled(false);
        q = p.scheduleBuild2(0, new Action[0]);
        WorkflowRun b2 = (WorkflowRun)q.getStartCondition().get();
        e = (CpsFlowExecution)b2.getExecutionPromise().get();
        Assertions.assertFalse((boolean)b2.hasntStartedYet());
        this.assertColor(b2, BallColor.BLUE_ANIME);
        p.makeDisabled(true);
        Assertions.assertSame((Object)BallColor.DISABLED_ANIME, (Object)p.getIconColor());
        p.makeDisabled(false);
        SemaphoreStep.waitForStart((String)"wait/2", (Run)b2);
        Assertions.assertFalse((boolean)b2.hasntStartedYet());
        this.assertColor(b2, BallColor.BLUE_ANIME);
        SemaphoreStep.success((String)"wait/2", null);
        q.get(5L, TimeUnit.SECONDS);
        Assertions.assertFalse((boolean)b2.hasntStartedYet());
        this.assertColor(b2, BallColor.BLUE);
    }

    private void assertColor(WorkflowRun b, BallColor color) {
        Assertions.assertSame((Object)color, (Object)b.getIconColor());
        Assertions.assertSame((Object)color, (Object)((WorkflowJob)b.getParent()).getIconColor());
    }

    @Test
    void scriptApproval() throws Exception {
        this.r.jenkins.setSecurityRealm((SecurityRealm)this.r.createDummySecurityRealm());
        this.r.jenkins.setAuthorizationStrategy((AuthorizationStrategy)new MockAuthorizationStrategy().grant(new Permission[]{Jenkins.READ}).everywhere().to(new String[]{"dev"}).grant(Item.PERMISSIONS.getPermissions().toArray(new Permission[0])).everywhere().to(new String[]{"dev"}));
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        String groovy = "println 'hello'";
        try (ACLContext context = ACL.as((User)User.getById((String)"dev", (boolean)true));){
            p.setDefinition((FlowDefinition)new CpsFlowDefinition("println 'hello'", false));
        }
        this.r.assertLogContains("UnapprovedUsageException", this.r.assertBuildStatus(Result.FAILURE, (Run)((WorkflowRun)p.scheduleBuild2(0, new Action[0]).get())));
        Set pendingScripts = ScriptApproval.get().getPendingScripts();
        Assertions.assertEquals((int)1, (int)pendingScripts.size());
        ScriptApproval.PendingScript pendingScript = (ScriptApproval.PendingScript)pendingScripts.iterator().next();
        Assertions.assertEquals((Object)"println 'hello'", (Object)pendingScript.script);
        Assertions.assertEquals((Object)"dev", (Object)pendingScript.getContext().getUser());
        ScriptApproval.get().approveScript(pendingScript.getHash());
        this.r.assertLogContains("hello", this.r.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[0])));
    }

    @Test
    void failedToStartRun() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("{{stage 'dev'\ndef hello = new HelloWorld()\npublic class HelloWorld()\n{ // <- invalid class definition }\n}}\n", true));
        QueueTaskFuture workflowRunQueueTaskFuture = p.scheduleBuild2(0, new Action[0]);
        WorkflowRun run = (WorkflowRun)this.r.assertBuildStatus(Result.FAILURE, (Run)((WorkflowRun)workflowRunQueueTaskFuture.get()));
        Assertions.assertNull((Object)run.getExecution());
    }

    @Test
    void buildRecordAfterRename() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p1");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("echo 'hello world'", true));
        this.r.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[0]));
        p.renameTo("p2");
        this.r.jenkins.reload();
        p = (WorkflowJob)this.r.jenkins.getItemByFullName("p2", WorkflowJob.class);
        Assertions.assertNotNull((Object)p);
        WorkflowRun b = p.getLastBuild();
        Assertions.assertNotNull((Object)b);
        System.out.println(FileUtils.readFileToString((File)new File(b.getRootDir(), "build.xml"), (Charset)StandardCharsets.UTF_8));
        this.r.assertLogContains("hello world", (Run)b);
        FlowExecution exec = b.getExecution();
        Assertions.assertNotNull((Object)exec);
        FlowGraphWalker w = new FlowGraphWalker(exec);
        ArrayList<String> steps = new ArrayList<String>();
        for (FlowNode n : w) {
            if (!(n instanceof StepNode)) continue;
            steps.add(((StepNode)n).getDescriptor().getFunctionName());
        }
        Assertions.assertEquals((Object)"[echo]", (Object)((Object)steps).toString());
    }

    @Test
    void interruptWithResult() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("sleep 1; semaphore 'hang'", true));
        WorkflowRun b1 = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).waitForStart();
        Thread.sleep(500L);
        SemaphoreStep.waitForStart((String)"hang/1", (Run)b1);
        Thread.sleep(500L);
        Executor ex = b1.getExecutor();
        Assertions.assertNotNull((Object)ex);
        ex.interrupt(Result.NOT_BUILT, new CauseOfInterruption[]{new CauseOfInterruption.UserInterruption("bob")});
        this.r.assertBuildStatus(Result.NOT_BUILT, (Run)((WorkflowRun)this.r.waitForCompletion((Run)b1)));
        InterruptedBuildAction iba = (InterruptedBuildAction)b1.getAction(InterruptedBuildAction.class);
        Assertions.assertNotNull((Object)iba);
        Assertions.assertEquals(Collections.singletonList(new CauseOfInterruption.UserInterruption("bob")), (Object)iba.getCauses());
        Thread.sleep(500L);
        WorkflowRun b2 = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).waitForStart();
        Assertions.assertEquals((int)2, (int)b2.getNumber());
        Thread.sleep(500L);
        SemaphoreStep.waitForStart((String)"hang/2", (Run)b2);
        Thread.sleep(500L);
        ex = b2.getExecutor();
        Assertions.assertNotNull((Object)ex);
        ex.interrupt();
        this.r.assertBuildStatus(Result.ABORTED, (Run)((WorkflowRun)this.r.waitForCompletion((Run)b2)));
        iba = (InterruptedBuildAction)b2.getAction(InterruptedBuildAction.class);
        Assertions.assertNull((Object)iba);
    }

    @Test
    void interruptCause() throws Exception {
        this.r.jenkins.setSecurityRealm((SecurityRealm)this.r.createDummySecurityRealm());
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        ScriptApproval.get().approveSignature("method org.jenkinsci.plugins.workflow.steps.FlowInterruptedException getCauses");
        ScriptApproval.get().approveSignature("method jenkins.model.CauseOfInterruption$UserInterruption getUser");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("@NonCPS def users(e) {e.causes*.user}; try {semaphore 'wait'} catch (e) {echo(/users=${users(e)}/); throw e}", true));
        WorkflowRun b1 = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).waitForStart();
        SemaphoreStep.waitForStart((String)"wait/1", (Run)b1);
        try (ACLContext context = ACL.as((User)User.getById((String)"dev", (boolean)true));){
            b1.getExecutor().doStop();
        }
        this.r.assertBuildStatus(Result.ABORTED, (Run)((WorkflowRun)this.r.waitForCompletion((Run)b1)));
        this.r.assertLogContains("users=[dev]", (Run)b1);
        InterruptedBuildAction iba = (InterruptedBuildAction)b1.getAction(InterruptedBuildAction.class);
        Assertions.assertNotNull((Object)iba);
        Assertions.assertEquals(Collections.singletonList(new CauseOfInterruption.UserInterruption("dev")), (Object)iba.getCauses());
        String log = JenkinsRule.getLog((Run)b1);
        Assertions.assertEquals((int)1, (int)StringUtils.countMatches((CharSequence)log, (CharSequence)Messages.CauseOfInterruption_ShortDescription((Object)"dev")), (String)log);
    }

    @Test
    void globalNodePropertiesInEnv() throws Exception {
        DescribableList original = this.r.jenkins.getGlobalNodeProperties();
        EnvironmentVariablesNodeProperty envProp = new EnvironmentVariablesNodeProperty(new EnvironmentVariablesNodeProperty.Entry[]{new EnvironmentVariablesNodeProperty.Entry("KEY", "VALUE")});
        original.add((Object)envProp);
        WorkflowJob j = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "envVars");
        j.setDefinition((FlowDefinition)new CpsFlowDefinition("echo \"KEY is ${env.KEY}\"", true));
        WorkflowRun b = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)j.scheduleBuild2(0, new Action[0]));
        this.r.assertLogContains("KEY is " + (String)envProp.getEnvVars().get((Object)"KEY"), (Run)b);
    }

    @Test
    void culprits() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("import org.jvnet.hudson.test.FakeChangeLogSCM\nsemaphore 'waitFirst'\ndef testScm = new FakeChangeLogSCM()\ntestScm.addChange().withAuthor(/alice$BUILD_NUMBER/)\nnode {\n    checkout(testScm)\n    semaphore 'waitSecond'\n    def secondScm = new FakeChangeLogSCM()\n    secondScm.addChange().withAuthor(/bob$BUILD_NUMBER/)\n    checkout(secondScm)\n    semaphore 'waitThird'\n    def thirdScm = new FakeChangeLogSCM()\n    thirdScm.addChange().withAuthor(/charlie$BUILD_NUMBER/)\n    checkout(thirdScm)\n}\n", false));
        WorkflowRun b1 = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).waitForStart();
        SemaphoreStep.waitForStart((String)"waitFirst/1", (Run)b1);
        Assertions.assertTrue((boolean)b1.getCulpritIds().isEmpty());
        SemaphoreStep.success((String)"waitFirst/1", null);
        SemaphoreStep.waitForStart((String)"waitSecond/1", (Run)b1);
        this.assertCulprits(b1, "alice1");
        SemaphoreStep.success((String)"waitSecond/1", null);
        SemaphoreStep.waitForStart((String)"waitThird/1", (Run)b1);
        this.assertCulprits(b1, "alice1", "bob1");
        SemaphoreStep.failure((String)"waitThird/1", (Throwable)new AbortException());
        this.r.assertBuildStatus(Result.FAILURE, (Run)((WorkflowRun)this.r.waitForCompletion((Run)b1)));
        WorkflowRun b2 = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).waitForStart();
        SemaphoreStep.waitForStart((String)"waitFirst/2", (Run)b2);
        this.assertCulprits(b2, "alice1", "bob1");
        SemaphoreStep.success((String)"waitFirst/2", null);
        SemaphoreStep.waitForStart((String)"waitSecond/2", (Run)b2);
        this.assertCulprits(b2, "alice1", "bob1", "alice2");
        SemaphoreStep.success((String)"waitSecond/2", null);
        SemaphoreStep.waitForStart((String)"waitThird/2", (Run)b2);
        this.assertCulprits(b2, "alice1", "bob1", "alice2", "bob2");
        SemaphoreStep.success((String)"waitThird/2", (Object)b2);
        this.r.assertBuildStatusSuccess((Run)((WorkflowRun)this.r.waitForCompletion((Run)b2)));
        this.assertCulprits(b2, "alice1", "bob1", "alice2", "bob2", "charlie2");
    }

    private void assertCulprits(WorkflowRun b, String ... expectedIds) throws IOException, SAXException {
        TreeSet actual = new TreeSet(b.getCulpritIds());
        Assertions.assertEquals(actual, new TreeSet<String>(Arrays.asList(expectedIds)));
        if (expectedIds.length > 0) {
            JenkinsRule.WebClient wc = this.r.createWebClient();
            WebResponse response = wc.goTo(b.getUrl() + "api/json?tree=culprits[id]", "application/json").getWebResponse();
            JSONObject json = JSONObject.fromObject((Object)response.getContentAsString());
            Object culpritsArray = json.get("culprits");
            Assertions.assertNotNull((Object)culpritsArray);
            Assertions.assertInstanceOf(JSONArray.class, (Object)culpritsArray);
            TreeSet<String> fromApi = new TreeSet<String>();
            for (Object o : ((JSONArray)culpritsArray).toArray()) {
                Assertions.assertInstanceOf(JSONObject.class, (Object)o);
                Object id = ((JSONObject)o).get("id");
                if (!(id instanceof String)) continue;
                fromApi.add((String)id);
            }
            Assertions.assertEquals(fromApi, new TreeSet<String>(Arrays.asList(expectedIds)));
        }
    }

    @Test
    void noComputerBuildPermissionOnMaster() throws Exception {
        this.r.waitOnline((Slave)this.r.createSlave("remote", null, null));
        this.r.jenkins.setSecurityRealm((SecurityRealm)this.r.createDummySecurityRealm());
        this.r.jenkins.setAuthorizationStrategy((AuthorizationStrategy)new MockAuthorizationStrategy().grant(new Permission[]{Jenkins.ADMINISTER}).everywhere().to(new String[]{"admin"}));
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("", true));
        QueueItemAuthenticatorConfiguration.get().getAuthenticators().add((Object)new MockQueueItemAuthenticator(Collections.singletonMap("p", User.getById((String)"admin", (boolean)true).impersonate())));
        this.r.buildAndAssertSuccess((Job)p);
        QueueItemAuthenticatorConfiguration.get().getAuthenticators().replace((Describable)new MockQueueItemAuthenticator(Collections.singletonMap("p", User.getById((String)"dev", (boolean)true).impersonate())));
        this.r.buildAndAssertSuccess((Job)p);
    }

    @Test
    void unicode() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        String message = "\u00a1\u010cau \u2192 there!";
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("echo '" + message + "'", true));
        this.r.assertLogContains(message, this.r.buildAndAssertSuccess((Job)p));
    }

    @Test
    void getLogFile() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("echo 'sample text'", true));
        WorkflowRun b = (WorkflowRun)this.r.buildAndAssertSuccess((Job)p);
        Assertions.assertEquals((Object)IOUtils.toString((InputStream)b.getLogInputStream()), (Object)FileUtils.readFileToString((File)b.getLogFile()));
    }

    @Test
    void logAfterBuildComplete() throws Exception {
        this.logging.record(WorkflowRun.class, Level.WARNING).capture(1);
        WorkflowJob p = (WorkflowJob)this.r.createProject(WorkflowJob.class);
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("env.KEY = 'value'", true));
        WorkflowRun b = (WorkflowRun)this.r.buildAndAssertSuccess((Job)p);
        Assertions.assertEquals((Object)"value", (Object)((EnvironmentAction)b.getAction(EnvironmentAction.class)).getEnvironment().get((Object)"KEY"));
        Assertions.assertFalse((boolean)this.logging.getRecords().stream().findAny().isPresent());
        Assertions.assertFalse((boolean)b.isLogUpdated());
    }

    @Test
    void completedFlag() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("echo 'body irrelevant'", true));
        WorkflowRun b = (WorkflowRun)this.r.buildAndAssertSuccess((Job)p);
        MatcherAssert.assertThat((Object)((String)Awaitility.await().until(() -> ((CheckCompletedFlag)((Object)((Object)ExtensionList.lookupSingleton(CheckCompletedFlag.class)))).buildXml.get(b.getExternalizableId()), Matchers.notNullValue())), (Matcher)Matchers.containsString((String)"<completed>true</completed>"));
    }

    @Test
    void getScms() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.write("Jenkinsfile", "echo 'hello'");
        this.sampleRepo.git(new String[]{"add", "Jenkinsfile"});
        this.sampleRepo.git(new String[]{"commit", "--message=files"});
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        CpsScmFlowDefinition def = new CpsScmFlowDefinition((SCM)new GitSCM(this.sampleRepo.toString()), "Jenkinsfile");
        p.setDefinition((FlowDefinition)def);
        WorkflowRun b = (WorkflowRun)this.r.buildAndAssertSuccess((Job)p);
        List checkouts = b.getSCMs();
        Assertions.assertEquals((int)1, (int)checkouts.size());
        Assertions.assertEquals(GitSCM.class, ((SCM)checkouts.get(0)).getClass());
    }

    @Test
    void baselineResetSingleRepo() throws Exception {
        this.sampleRepo.init();
        StreamTaskListener listener = StreamTaskListener.fromStdout();
        WorkflowJob p = (WorkflowJob)this.r.createProject(WorkflowJob.class);
        for (boolean changelog : new boolean[]{true, false}) {
            for (boolean polling : new boolean[]{true, false}) {
                p.setDefinition((FlowDefinition)new CpsFlowDefinition("node {\n" + WorkflowRunTest.checkoutString(this.sampleRepo, changelog, polling) + "}\n", true));
                WorkflowRun b = (WorkflowRun)this.r.buildAndAssertSuccess((Job)p);
                MatcherAssert.assertThat((Object)b.checkouts((TaskListener)listener).size(), (Matcher)Matchers.equalTo((Object)1));
                MatcherAssert.assertThat((String)("Unexpected baseline with changelog: " + changelog + "and polling: " + polling), (Object)((WorkflowRun.SCMCheckout)b.checkouts((TaskListener)listener).get((int)0)).pollingBaseline, (Matcher)(changelog || polling ? Matchers.notNullValue() : Matchers.nullValue()));
            }
        }
    }

    @Test
    void baselineResetMultipleSameRepo() throws Exception {
        this.sampleRepo.init();
        StreamTaskListener listener = StreamTaskListener.fromStdout();
        WorkflowJob p = (WorkflowJob)this.r.createProject(WorkflowJob.class);
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("node {\n" + WorkflowRunTest.checkoutString(this.sampleRepo, true, true) + WorkflowRunTest.checkoutString(this.sampleRepo, true, true) + "}\n", true));
        WorkflowRun b1 = (WorkflowRun)this.r.buildAndAssertSuccess((Job)p);
        WorkflowRunTest.assertPollingBaselines(b1.checkouts((TaskListener)listener), Matchers.notNullValue(), Matchers.notNullValue());
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("node {\n" + WorkflowRunTest.checkoutString(this.sampleRepo, false, false) + WorkflowRunTest.checkoutString(this.sampleRepo, true, true) + "}\n", true));
        WorkflowRun b2 = (WorkflowRun)this.r.buildAndAssertSuccess((Job)p);
        WorkflowRunTest.assertPollingBaselines(b2.checkouts((TaskListener)listener), Matchers.nullValue(), Matchers.notNullValue());
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("node {\n" + WorkflowRunTest.checkoutString(this.sampleRepo, false, false) + WorkflowRunTest.checkoutString(this.sampleRepo, false, false) + "}\n", true));
        WorkflowRun b3 = (WorkflowRun)this.r.buildAndAssertSuccess((Job)p);
        WorkflowRunTest.assertPollingBaselines(b3.checkouts((TaskListener)listener), Matchers.nullValue(), Matchers.nullValue());
    }

    @SafeVarargs
    private static void assertPollingBaselines(List<WorkflowRun.SCMCheckout> checkouts, Matcher<Object> ... indexedMatchers) {
        MatcherAssert.assertThat((String)"Number of checkouts should match number of matchers", (Object)checkouts.size(), (Matcher)Matchers.equalTo((Object)indexedMatchers.length));
        for (int i = 0; i < checkouts.size(); ++i) {
            MatcherAssert.assertThat((String)("Unexpected baseline for checkout at index " + i), (Object)checkouts.get((int)i).pollingBaseline, indexedMatchers[i]);
        }
    }

    private static String checkoutString(GitSampleRepoRule repo, boolean changelog, boolean polling) {
        return "    checkout(changelog:" + changelog + ", poll:" + polling + ", scm: [$class: 'GitSCM', branches: [[name: '*/master']], , userRemoteConfigs: [[url: $/" + repo.fileUrl() + "/$]]])\n";
    }

    @Test
    void escapedDisplayNameAfterAbort() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "myJob");
        DisableConcurrentBuildsJobProperty jobProp = new DisableConcurrentBuildsJobProperty();
        jobProp.setAbortPrevious(true);
        p.addProperty((JobProperty)jobProp);
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("semaphore 'hang'", false));
        WorkflowRun b1 = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).waitForStart();
        SemaphoreStep.waitForStart((String)"hang/1", (Run)b1);
        WorkflowRun b2 = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).waitForStart();
        b2.save();
        SemaphoreStep.waitForStart((String)"hang/2", (Run)b2);
        this.r.assertBuildStatus(Result.NOT_BUILT, (Run)((WorkflowRun)this.r.waitForCompletion((Run)b1)));
        b2.doKill();
        b2.delete();
        Assertions.assertEquals((int)1, (int)p.getBuilds().size());
        JenkinsRule.WebClient webClient = this.r.createWebClient();
        Alerter alerter = new Alerter();
        webClient.setAlertHandler((AlertHandler)alerter);
        webClient.goTo(b1.getUrl());
        webClient.waitForBackgroundJavaScript(2000L);
        MatcherAssert.assertThat(alerter.messages, (Matcher)Matchers.empty());
    }

    @Test
    void logRotationOnlyProcessesCompletedBuilds() throws Throwable {
        int i;
        Assumptions.assumeFalse((Functions.isWindows() && "true".equals(System.getenv("CI")) ? 1 : 0) != 0, (String)"TODO #502: failing in VMs");
        this.logging.record(LogRotator.class, Level.FINER);
        WorkflowJob p = (WorkflowJob)this.r.createProject(WorkflowJob.class);
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("echo params.FOO; semaphore 'wait'", true));
        p.addProperty((JobProperty)new ParametersDefinitionProperty(List.of(new StringParameterDefinition("FOO"))));
        LogRotator logRotator = new LogRotator(-1, 0, -1, -1);
        logRotator.setRemoveLastBuild(true);
        p.setBuildDiscarder((BuildDiscarder)logRotator);
        int buildsToRun = 10;
        Run[] builds = new Run[buildsToRun];
        File[] buildDirs = new File[buildsToRun];
        for (i = 0; i < buildsToRun; ++i) {
            WorkflowRun b = (WorkflowRun)p.scheduleBuild2(0, new Action[]{new ParametersAction(List.of(new StringParameterValue("FOO", "b" + i)))}).waitForStart();
            builds[i] = b;
            buildDirs[i] = b.getRootDir();
            SemaphoreStep.waitForStart((String)("wait/" + (i + 1)), (Run)b);
        }
        for (i = 0; i < buildsToRun; ++i) {
            SemaphoreStep.success((String)("wait/" + (i + 1)), null);
        }
        LOGGER.info("Waiting for all builds to complete");
        for (i = 0; i < buildsToRun; ++i) {
            this.r.waitForCompletion(builds[i]);
        }
        LOGGER.info("Checking that all build directories are empty");
        for (i = 0; i < buildsToRun; ++i) {
            File dir = buildDirs[i];
            Awaitility.await((String)(String.valueOf(dir) + " should be empty")).until(() -> {
                String[] filesInBuildDir = dir.list();
                if (filesInBuildDir == null) {
                    filesInBuildDir = new String[]{};
                }
                return Arrays.asList(filesInBuildDir);
            }, Matchers.empty());
        }
    }

    @Extension
    public static final class DurationRunListener
    extends RunListener<Run<?, ?>> {
        static long duration = 0L;

        public void onCompleted(Run<?, ?> run, @NonNull TaskListener listener) {
            duration = run.getDuration();
        }
    }

    static class Alerter
    implements AlertHandler {
        List<String> messages = Collections.synchronizedList(new ArrayList());

        Alerter() {
        }

        public void handleAlert(Page page, String message) {
            this.messages.add(message);
        }
    }

    @TestExtension(value={"completedFlag"})
    public static final class CheckCompletedFlag
    extends RunListener<WorkflowRun> {
        final Map<String, String> buildXml = new HashMap<String, String>();

        public void onFinalized(WorkflowRun r) {
            block2: {
                try {
                    this.buildXml.put(r.getExternalizableId(), new XmlFile(new File(r.getRootDir(), "build.xml")).asString());
                }
                catch (IOException x) {
                    x.printStackTrace();
                    if ($assertionsDisabled) break block2;
                    throw new AssertionError((Object)x);
                }
            }
        }
    }

    @TestExtension(value={"escapedDisplayNameAfterAbort"})
    public static class XSSRunListener
    extends RunListener<Run> {
        public void onInitialize(Run run) {
            try {
                run.setDisplayName("<script> alert(\"Hello! I am an alert box!\");</script>");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

