/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.job;

import com.google.common.util.concurrent.ListenableFuture;
import hudson.model.Action;
import hudson.model.JobProperty;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.List;
import java.util.Stack;
import org.awaitility.Awaitility;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDurabilityHint;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionList;
import org.jenkinsci.plugins.workflow.graph.BlockStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowEndNode;
import org.jenkinsci.plugins.workflow.graph.FlowStartNode;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.job.properties.DurabilityHintJobProperty;
import org.jenkinsci.plugins.workflow.support.steps.input.InputAction;
import org.jenkinsci.plugins.workflow.support.steps.input.InputStepExecution;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.junit.jupiter.BuildWatcherExtension;
import org.jvnet.hudson.test.junit.jupiter.JenkinsSessionExtension;

class CpsPersistenceTest {
    @RegisterExtension
    private static final BuildWatcherExtension BUILD_WATCHER = new BuildWatcherExtension();
    @RegisterExtension
    private final JenkinsSessionExtension sessions = new JenkinsSessionExtension();
    private static final String DEFAULT_JOBNAME = "testJob";

    CpsPersistenceTest() {
    }

    private static boolean getCpsDoneFlag(CpsFlowExecution exec) throws Exception {
        Field doneField = exec.getClass().getDeclaredField("done");
        doneField.setAccessible(true);
        return doneField.getBoolean(exec);
    }

    private static Stack<BlockStartNode> getCpsBlockStartNodes(CpsFlowExecution exec) throws Exception {
        Field startField = exec.getClass().getDeclaredField("startNodes");
        startField.setAccessible(true);
        Object ob = startField.get(exec);
        if (ob instanceof Stack) {
            Stack result = (Stack)ob;
            return result;
        }
        return null;
    }

    private static void assertCompletedCleanly(WorkflowRun run) throws Exception {
        if (run.isBuilding()) {
            System.out.println("Run initially building, going to wait a second to see if it finishes, run=" + String.valueOf(run));
            Thread.sleep(1000L);
        }
        Assertions.assertFalse((boolean)run.isBuilding());
        Assertions.assertNotNull((Object)run.getResult());
        FlowExecution fe = run.getExecution();
        FlowExecutionList.get().forEach(f -> {
            if (fe != null && f == fe) {
                Assertions.fail((String)"FlowExecution still in FlowExecutionList!");
            }
        });
        Assertions.assertTrue((boolean)Queue.getInstance().isEmpty(), (String)"Queue not empty after completion!");
        if (fe instanceof CpsFlowExecution) {
            CpsFlowExecution cpsExec = (CpsFlowExecution)fe;
            Assertions.assertTrue((boolean)cpsExec.isComplete());
            Assertions.assertEquals((Object)Boolean.TRUE, (Object)CpsPersistenceTest.getCpsDoneFlag(cpsExec));
            Assertions.assertEquals((int)1, (int)cpsExec.getCurrentHeads().size());
            Assertions.assertTrue((boolean)cpsExec.isComplete());
            Assertions.assertInstanceOf(FlowEndNode.class, cpsExec.getCurrentHeads().get(0));
            Stack<BlockStartNode> starts = CpsPersistenceTest.getCpsBlockStartNodes(cpsExec);
            Assertions.assertTrue((starts == null || starts.isEmpty() ? 1 : 0) != 0);
            Thread.sleep(1000L);
            Assertions.assertFalse((boolean)cpsExec.blocksRestart());
        } else {
            System.out.println("WARNING: no FlowExecutionForBuild");
        }
    }

    private static WorkflowRun runBasicPauseOnInput(JenkinsRule j, String jobName, int[] jobIdNumber, FlowDurabilityHint durabilityHint) throws Exception {
        WorkflowJob job = (WorkflowJob)j.jenkins.createProject(WorkflowJob.class, jobName);
        job.setDefinition((FlowDefinition)new CpsFlowDefinition("input 'pause'", true));
        job.addProperty((JobProperty)new DurabilityHintJobProperty(durabilityHint));
        WorkflowRun run = (WorkflowRun)job.scheduleBuild2(0, new Action[0]).getStartCondition().get();
        ListenableFuture listener = run.getExecutionPromise();
        FlowExecution exec = (FlowExecution)listener.get();
        Awaitility.await().until(() -> !exec.getCurrentHeads().isEmpty() && !(exec.getCurrentHeads().get(0) instanceof FlowStartNode));
        Awaitility.await().until(() -> run.getAction(InputAction.class) != null);
        Thread.sleep(100L);
        if (durabilityHint != FlowDurabilityHint.PERFORMANCE_OPTIMIZED) {
            CpsFlowExecution execution = (CpsFlowExecution)run.getExecution();
            Method m = execution.getClass().getDeclaredMethod("getProgramDataFile", new Class[0]);
            m.setAccessible(true);
            File f = (File)m.invoke((Object)execution, new Object[0]);
            Awaitility.await().until(() -> Files.exists(f.toPath(), new LinkOption[0]));
        }
        jobIdNumber[0] = run.getNumber();
        return run;
    }

    private static WorkflowRun runBasicPauseOnInput(JenkinsRule j, String jobName, int[] jobIdNumber) throws Exception {
        return CpsPersistenceTest.runBasicPauseOnInput(j, jobName, jobIdNumber, FlowDurabilityHint.MAX_SURVIVABILITY);
    }

    private static InputStepExecution getInputStepExecution(WorkflowRun run, String inputMessage) throws Exception {
        InputAction ia = (InputAction)run.getAction(InputAction.class);
        List execList = ia.getExecutions();
        return execList.stream().filter(e -> inputMessage.equals(e.getInput().getMessage())).findFirst().orElse(null);
    }

    @Test
    void completedExecutionButRunIncomplete() throws Throwable {
        int[] build = new int[1];
        this.sessions.then(j -> {
            WorkflowRun run = CpsPersistenceTest.runBasicPauseOnInput(j, DEFAULT_JOBNAME, build);
            InputStepExecution exec = CpsPersistenceTest.getInputStepExecution(run, "pause");
            exec.doProceedEmpty();
            j.waitForCompletion((Run)run);
            Field completedField = run.getClass().getDeclaredField("completed");
            completedField.setAccessible(true);
            completedField.set(run, false);
            Field resultField = Run.class.getDeclaredField("result");
            resultField.setAccessible(true);
            resultField.set(run, null);
            run.save();
            j.restart();
        });
        this.sessions.then(j -> {
            WorkflowJob r = (WorkflowJob)j.jenkins.getItemByFullName(DEFAULT_JOBNAME, WorkflowJob.class);
            WorkflowRun run = r.getBuildByNumber(build[0]);
            CpsPersistenceTest.assertCompletedCleanly(run);
            Assertions.assertEquals((Object)Result.SUCCESS, (Object)run.getResult());
        });
        this.sessions.then(j -> {
            WorkflowJob r = (WorkflowJob)j.jenkins.getItemByFullName(DEFAULT_JOBNAME, WorkflowJob.class);
            WorkflowRun run = r.getBuildByNumber(build[0]);
            CpsPersistenceTest.assertCompletedCleanly(run);
            Assertions.assertEquals((Object)Result.SUCCESS, (Object)run.getResult());
        });
    }
}

