/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.steps;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.model.queue.ScheduleResult;
import hudson.remoting.VirtualChannel;
import hudson.slaves.OfflineCause;
import hudson.slaves.WorkspaceList;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jenkins.model.CauseOfInterruption;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.FilePathUtils;
import org.jenkinsci.plugins.workflow.steps.DynamicContext;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.support.steps.AgentOfflineException;
import org.jenkinsci.plugins.workflow.support.steps.ExecutorStepExecution;
import org.jenkinsci.plugins.workflow.support.steps.FilePathDynamicContext;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public final class ExecutorStepDynamicContext
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(ExecutorStepDynamicContext.class.getName());
    private static final long serialVersionUID = 1L;
    @NonNull
    final ExecutorStepExecution.PlaceholderTask task;
    @NonNull
    final String node;
    @NonNull
    final String path;
    final int depth;
    @Nullable
    private transient Executor executor;
    @Nullable
    private transient WorkspaceList.Lease lease;

    ExecutorStepDynamicContext(ExecutorStepExecution.PlaceholderTask task, WorkspaceList.Lease lease, Executor executor, int depth) {
        this.task = task;
        this.node = FilePathUtils.getNodeName((FilePath)lease.path);
        this.path = lease.path.getRemote();
        this.executor = executor;
        this.lease = lease;
        this.depth = depth;
    }

    void resume(StepContext context) throws Exception {
        Queue.Executable exec;
        if (this.executor != null) {
            throw new IllegalStateException("Already resumed");
        }
        ScheduleResult result = Queue.getInstance().schedule2((Queue.Task)this.task, 0, new Action[0]);
        Queue.Item item = result.getItem();
        if (item == null) {
            throw new IllegalStateException("queue refused " + String.valueOf(this.task));
        }
        LOGGER.fine(() -> (result.isCreated() ? "scheduled " : " using already-scheduled ") + String.valueOf(item) + " for " + this.path + " on " + this.node);
        TaskListener listener = (TaskListener)context.get(TaskListener.class);
        if (!this.node.isEmpty()) {
            listener.getLogger().println("Waiting for reconnection of " + this.node + " before proceeding with build");
        }
        try {
            exec = (Queue.Executable)item.getFuture().getStartCondition().get(ExecutorStepExecution.TIMEOUT_WAITING_FOR_NODE_MILLIS, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException x) {
            LOGGER.log(Level.FINE, x, () -> "failed to wait for " + String.valueOf(item) + "; outstanding queue items: " + Arrays.toString(Queue.getInstance().getItems()) + "; running executables: " + String.valueOf(Stream.of(Jenkins.get().getComputers()).flatMap(c -> c.getExecutors().stream()).collect(Collectors.toList())));
            listener.getLogger().println(this.node + " has been removed for " + Util.getTimeSpanString((long)ExecutorStepExecution.TIMEOUT_WAITING_FOR_NODE_MILLIS) + "; assuming it is not coming back, and terminating node step");
            throw new FlowInterruptedException(Result.ABORTED, true, new CauseOfInterruption[]{new ExecutorStepExecution.RemovedNodeTimeoutCause()});
        }
        catch (CancellationException x) {
            LOGGER.log(Level.FINE, "ceased to wait for " + this.node, x);
            throw new FlowInterruptedException(Result.ABORTED, true, new CauseOfInterruption[]{new ExecutorStepExecution.QueueTaskCancelled()});
        }
        this.executor = Executor.of((Queue.Executable)exec);
        if (this.executor == null) {
            throw new IOException(String.valueOf(exec) + " was scheduled but no executor claimed it");
        }
        Computer computer = this.executor.getOwner();
        VirtualChannel channel = computer.getChannel();
        if (channel == null) {
            throw new IOException(String.valueOf(computer) + " is offline");
        }
        FilePath fp = new FilePath(channel, this.path);
        WorkspaceList.Lease _lease = computer.getWorkspaceList().allocate(fp);
        if (!_lease.path.equals((Object)fp)) {
            _lease.release();
            throw new IOException("JENKINS-37121: something already locked " + String.valueOf(fp));
        }
        this.lease = _lease;
        LOGGER.fine(() -> "fully restored for " + this.path + " on " + this.node + " \u2192 " + computer.getName());
    }

    public String toString() {
        return "ExecutorStepDynamicContext[" + this.path + "@" + this.node + "]";
    }

    @Extension
    public static final class NodeTranslator
    extends DynamicContext.Typed<Node> {
        protected Class<Node> type() {
            return Node.class;
        }

        protected Node get(DynamicContext.DelegatedContext context) throws IOException, InterruptedException {
            ExecutorStepDynamicContext c = (ExecutorStepDynamicContext)context.get(ExecutorStepDynamicContext.class);
            if (c == null) {
                return null;
            }
            Jenkins j = Jenkins.get();
            return c.node.isEmpty() ? j : j.getNode(c.node);
        }
    }

    @Extension
    public static final class ComputerTranslator
    extends Translator<Computer> {
        protected Class<Computer> type() {
            return Computer.class;
        }

        @Override
        Computer get(ExecutorStepDynamicContext c) {
            return c.executor.getOwner();
        }
    }

    @Extension
    public static final class ExecutorTranslator
    extends Translator<Executor> {
        protected Class<Executor> type() {
            return Executor.class;
        }

        @Override
        Executor get(ExecutorStepDynamicContext c) {
            return c.executor;
        }
    }

    @Extension
    public static final class WorkspaceListLeaseTranslator
    extends Translator<WorkspaceList.Lease> {
        protected Class<WorkspaceList.Lease> type() {
            return WorkspaceList.Lease.class;
        }

        @Override
        WorkspaceList.Lease get(ExecutorStepDynamicContext c) {
            return c.lease;
        }
    }

    @Extension
    public static final class FilePathTranslator
    extends Translator<FilePath> {
        protected Class<FilePath> type() {
            return FilePath.class;
        }

        @Override
        protected FilePath get(DynamicContext.DelegatedContext context) throws IOException, InterruptedException {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("ESDC=" + String.valueOf(context.get(ExecutorStepDynamicContext.class)) + " FPR=" + String.valueOf(context.get(FilePathDynamicContext.FilePathRepresentation.class)));
            }
            return (FilePath)super.get(context);
        }

        @Override
        FilePath get(ExecutorStepDynamicContext c) throws IOException {
            if (c.lease.path.toComputer() == null) {
                OfflineCause oc;
                FilePath f = FilePathUtils.find((String)c.node, (String)c.path);
                if (f != null) {
                    LOGGER.fine(() -> c.node + " disconnected and reconnected; getting a new FilePath on " + c.path + " with the new Channel");
                    return f;
                }
                String message = "Unable to create live FilePath for " + c.node;
                Computer comp = Jenkins.get().getComputer(c.node);
                if (comp != null && (oc = comp.getOfflineCause()) != null) {
                    message = message + "; " + comp.getDisplayName() + " was marked offline: " + String.valueOf(oc);
                }
                AgentOfflineException e = new AgentOfflineException(message);
                if (comp != null) {
                    for (Computer.TerminationRequest tr : comp.getTerminatedBy()) {
                        e.addSuppressed((Throwable)tr);
                    }
                }
                throw e;
            }
            return c.lease.path;
        }
    }

    private static abstract class Translator<T>
    extends DynamicContext.Typed<T> {
        private Translator() {
        }

        protected T get(DynamicContext.DelegatedContext context) throws IOException, InterruptedException {
            ExecutorStepDynamicContext c = (ExecutorStepDynamicContext)context.get(ExecutorStepDynamicContext.class);
            if (c == null || c.lease == null) {
                return null;
            }
            return this.get(c);
        }

        abstract T get(ExecutorStepDynamicContext var1) throws IOException, InterruptedException;
    }
}

