/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps.durable_task;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import org.jenkinsci.plugins.durabletask.DurableTask;
import org.jenkinsci.plugins.durabletask.PowershellScript;
import org.jenkinsci.plugins.workflow.steps.durable_task.DurableTaskStep;
import org.kohsuke.stapler.DataBoundConstructor;

public class PowerShellCoreScriptStep
extends DurableTaskStep {
    private final String script;

    @DataBoundConstructor
    public PowerShellCoreScriptStep(String script) {
        if (script == null) {
            throw new IllegalArgumentException();
        }
        this.script = script;
    }

    public String getScript() {
        return this.script;
    }

    @Override
    protected DurableTask task() {
        PowershellScript powershellScript = new PowershellScript(this.script);
        powershellScript.setPowershellBinary("pwsh");
        return powershellScript;
    }

    @Extension
    public static final class DescriptorImpl
    extends DurableTaskStep.DurableTaskStepDescriptor {
        @NonNull
        public String getDisplayName() {
            return "PowerShell Core Script";
        }

        public String getFunctionName() {
            return "pwsh";
        }
    }
}

