/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps.global;

import hudson.Extension;
import hudson.model.Run;
import hudson.util.CopyOnWriteList;
import jakarta.inject.Inject;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.io.FilenameUtils;
import org.jenkinsci.plugins.workflow.cps.GlobalVariable;
import org.jenkinsci.plugins.workflow.cps.GlobalVariableSet;
import org.jenkinsci.plugins.workflow.cps.global.UserDefinedGlobalVariable;
import org.jenkinsci.plugins.workflow.cps.global.WorkflowLibRepository;

@Extension
public class UserDefinedGlobalVariableList
extends GlobalVariableSet {
    static final String PREFIX = "vars";
    @Inject
    private WorkflowLibRepository repo;
    private volatile CopyOnWriteList<GlobalVariable> ours;

    public synchronized void rebuild() {
        File[] children = this.repo.workspace.resolve(PREFIX).toFile().listFiles();
        if (children == null) {
            children = new File[]{};
        }
        ArrayList<UserDefinedGlobalVariable> list = new ArrayList<UserDefinedGlobalVariable>();
        for (File child : children) {
            if (!child.getName().endsWith(".groovy") || child.isDirectory()) continue;
            String name = FilenameUtils.getBaseName((String)child.getName());
            UserDefinedGlobalVariable uv = new UserDefinedGlobalVariable(name, this.repo.workspace.resolve(PREFIX).resolve(name + ".txt").toFile());
            list.add(uv);
        }
        if (this.ours == null) {
            this.ours = new CopyOnWriteList();
        }
        this.ours.replaceBy(list);
    }

    public Collection<GlobalVariable> forRun(Run<?, ?> run) {
        if (this.ours == null) {
            this.rebuild();
        }
        return this.ours.getView();
    }
}

