/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.model.EnvironmentSpecific;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.util.ListBoxModel;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jenkinsci.plugins.structs.SymbolLookup;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public final class ToolStep
extends Step {
    private final String name;
    @CheckForNull
    private String type;

    @DataBoundConstructor
    public ToolStep(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @CheckForNull
    public String getType() {
        return this.type;
    }

    @DataBoundSetter
    public void setType(String type) {
        this.type = Util.fixEmpty((String)type);
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public static final class Execution
    extends SynchronousNonBlockingStepExecution<String> {
        private final transient ToolStep step;
        private static final long serialVersionUID = 1L;

        Execution(ToolStep step, StepContext context) {
            super(context);
            this.step = step;
        }

        protected String run() throws Exception {
            String name = this.step.getName();
            String type = this.step.getType();
            for (ToolDescriptor desc : ToolInstallation.all()) {
                if (type != null && !desc.getId().equals(type) && !SymbolLookup.getSymbolValue((Object)desc).contains(type)) continue;
                for (ToolInstallation tool : desc.getInstallations()) {
                    if (!name.equals(tool.getName())) continue;
                    if (tool instanceof NodeSpecific) {
                        tool = (ToolInstallation)((NodeSpecific)tool).forNode((Node)this.getContext().get(Node.class), (TaskListener)this.getContext().get(TaskListener.class));
                    }
                    if (tool instanceof EnvironmentSpecific) {
                        tool = (ToolInstallation)((EnvironmentSpecific)tool).forEnvironment((EnvVars)this.getContext().get(EnvVars.class));
                    }
                    return tool.getHome();
                }
            }
            throw new AbortException("No " + (type != null ? type : "tool") + " named " + name + " found");
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "tool";
        }

        @NonNull
        public String getDisplayName() {
            return "Use a tool from a predefined Tool Installation";
        }

        public ListBoxModel doFillTypeItems() {
            ListBoxModel r = new ListBoxModel();
            r.add("<any>", "");
            for (ToolDescriptor desc : ToolInstallation.all()) {
                String idOrSymbol = desc.getId();
                Set symbols = SymbolLookup.getSymbolValue((Object)desc);
                if (!symbols.isEmpty()) {
                    idOrSymbol = (String)symbols.iterator().next();
                }
                r.add(desc.getDisplayName(), idOrSymbol);
            }
            return r;
        }

        public ListBoxModel doFillNameItems(@QueryParameter String type) {
            type = Util.fixEmpty((String)type);
            ListBoxModel r = new ListBoxModel();
            for (ToolDescriptor desc : ToolInstallation.all()) {
                if (type != null && !desc.getId().equals(type) && !SymbolLookup.getSymbolValue((Object)desc).contains(type)) continue;
                for (ToolInstallation tool : desc.getInstallations()) {
                    r.add(tool.getName());
                }
            }
            return r;
        }

        public Set<? extends Class<?>> getRequiredContext() {
            HashSet context = new HashSet();
            Collections.addAll(context, TaskListener.class, EnvVars.class, Node.class);
            return Collections.unmodifiableSet(context);
        }

        public String argumentsToString(Map<String, Object> namedArgs) {
            Object name = namedArgs.get("name");
            return name instanceof String ? (String)name : null;
        }
    }
}

