/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jenkinsci.plugins.workflow.flow.ErrorCondition;
import org.jenkinsci.plugins.workflow.steps.RetryStepExecution;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class RetryStep
extends Step {
    private final int count;
    private List<ErrorCondition> conditions;

    @DataBoundConstructor
    public RetryStep(int count) {
        this.count = count;
    }

    public int getCount() {
        return this.count;
    }

    public List<ErrorCondition> getConditions() {
        return this.conditions;
    }

    @DataBoundSetter
    public void setConditions(List<ErrorCondition> conditions) {
        this.conditions = conditions;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public StepExecution start(StepContext context) throws Exception {
        return new RetryStepExecution(this.count, context, this.conditions);
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "retry";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        @NonNull
        public String getDisplayName() {
            return "Retry the body up to N times";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.singleton(TaskListener.class);
        }

        public FormValidation doCheckCount(@QueryParameter int count) {
            if (count < 1) {
                return FormValidation.error((String)"Count must be positive.");
            }
            if (count == 1) {
                return FormValidation.warning((String)"Count of one means that the retry step has no effect. Use \u22652.");
            }
            return FormValidation.ok();
        }
    }
}

