/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.FilePath;
import hudson.slaves.WorkspaceList;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class PwdStep
extends Step {
    private boolean tmp;

    @DataBoundConstructor
    public PwdStep() {
    }

    public boolean isTmp() {
        return this.tmp;
    }

    @DataBoundSetter
    public void setTmp(boolean tmp) {
        this.tmp = tmp;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this.tmp, context);
    }

    public static class Execution
    extends SynchronousStepExecution<String> {
        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Only used when starting.")
        private final transient boolean tmp;
        private static final long serialVersionUID = 1L;

        Execution(boolean tmp, StepContext context) {
            super(context);
            this.tmp = tmp;
        }

        protected String run() throws Exception {
            FilePath cwd = (FilePath)this.getContext().get(FilePath.class);
            Objects.requireNonNull(cwd);
            if (this.tmp && (cwd = WorkspaceList.tempDir((FilePath)cwd)) == null) {
                throw new IOException("Failed to set up a temporary directory.");
            }
            return cwd.getRemote();
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "pwd";
        }

        @NonNull
        public String getDisplayName() {
            return "Determine current directory";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.singleton(FilePath.class);
        }

        public String argumentsToString(@NonNull Map<String, Object> namedArgs) {
            return null;
        }
    }
}

