/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import com.google.common.util.concurrent.FutureCallback;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Descriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.EnvironmentExpander;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;

public class EnvStep
extends Step {
    private final List<String> overrides;

    @DataBoundConstructor
    public EnvStep(List<String> overrides) {
        for (String pair : overrides) {
            if (pair.indexOf(61) != -1) continue;
            throw new IllegalArgumentException(pair);
        }
        this.overrides = new ArrayList<String>(overrides);
    }

    public List<String> getOverrides() {
        return this.overrides;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this.overrides, context);
    }

    public static class Execution
    extends AbstractStepExecutionImpl {
        private static final long serialVersionUID = 1L;
        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Only used when starting.")
        private final transient List<String> overrides;

        Execution(List<String> overrides, StepContext context) {
            super(context);
            this.overrides = overrides;
        }

        public boolean start() throws Exception {
            HashMap<String, String> overridesM = new HashMap<String, String>();
            for (String pair : this.overrides) {
                int split = pair.indexOf(61);
                assert (split != -1);
                overridesM.put(pair.substring(0, split), pair.substring(split + 1));
            }
            this.getContext().newBodyInvoker().withContext((Object)EnvironmentExpander.merge((EnvironmentExpander)((EnvironmentExpander)this.getContext().get(EnvironmentExpander.class)), (EnvironmentExpander)EnvironmentExpander.constant(overridesM))).withCallback(BodyExecutionCallback.wrap((FutureCallback)this.getContext())).start();
            return false;
        }

        public void onResume() {
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "withEnv";
        }

        @NonNull
        public String getDisplayName() {
            return "Set environment variables";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public Step newInstance(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            String overridesS = formData.getString("overrides");
            ArrayList<String> overrides = new ArrayList<String>();
            for (String line : overridesS.split("\r?\n")) {
                if ((line = line.trim()).isEmpty()) continue;
                overrides.add(line);
            }
            return new EnvStep(overrides);
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.emptySet();
        }

        public String argumentsToString(Map<String, Object> namedArgs) {
            Object overrides = namedArgs.get("overrides");
            if (overrides instanceof List) {
                StringBuilder b = new StringBuilder();
                for (Object pair : (List)overrides) {
                    int idx;
                    if (!(pair instanceof String) || (idx = ((String)pair).indexOf(61)) <= 0) continue;
                    if (b.length() > 0) {
                        b.append(", ");
                    }
                    b.append(pair.toString(), 0, idx);
                }
                return b.toString();
            }
            return null;
        }
    }

    @Deprecated
    @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="no longer used")
    private static final class ExpanderImpl
    extends EnvironmentExpander {
        private static final long serialVersionUID = 1L;
        private Map<String, String> overrides;

        private ExpanderImpl() {
        }

        public void expand(EnvVars env) throws IOException, InterruptedException {
            env.overrideAll(this.overrides);
        }
    }
}

