/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.Functions;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import org.jenkinsci.plugins.workflow.flow.ErrorCondition;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.jenkinsci.plugins.workflow.steps.StepContext;

public class RetryStepExecution
extends AbstractStepExecutionImpl {
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Only used when starting.")
    private final transient int count;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Only used when starting.")
    @CheckForNull
    private final transient List<ErrorCondition> conditions;
    private static final long serialVersionUID = 1L;

    RetryStepExecution(int count, StepContext context, List<ErrorCondition> conditions) {
        super(context);
        this.count = count;
        this.conditions = conditions;
    }

    public boolean start() throws Exception {
        StepContext context = this.getContext();
        context.newBodyInvoker().withCallback((BodyExecutionCallback)new Callback(this.count, this.conditions)).start();
        return false;
    }

    public void onResume() {
    }

    private static class Callback
    extends BodyExecutionCallback {
        private int left;
        @CheckForNull
        private final List<ErrorCondition> conditions;
        private static final long serialVersionUID = 1L;

        Callback(int count, List<ErrorCondition> conditions) {
            this.left = count;
            this.conditions = conditions;
        }

        public void onSuccess(StepContext context, Object result) {
            context.onSuccess(result);
        }

        public void onFailure(StepContext context, Throwable t) {
            try {
                --this.left;
                TaskListener l = (TaskListener)context.get(TaskListener.class);
                if (this.left > 0 && this.matchesConditions(t, context)) {
                    if (t instanceof AbortException) {
                        l.error(t.getMessage());
                    } else if (t instanceof FlowInterruptedException) {
                        FlowInterruptedException fie = (FlowInterruptedException)t;
                        fie.handle((Run)context.get(Run.class), l);
                    } else {
                        Functions.printStackTrace((Throwable)t, (PrintWriter)l.error("Execution failed"));
                    }
                    l.getLogger().println("Retrying");
                    context.newBodyInvoker().withCallback((BodyExecutionCallback)this).start();
                } else {
                    context.onFailure(t);
                }
            }
            catch (Throwable p) {
                context.onFailure(p);
            }
        }

        private boolean matchesConditions(Throwable t, StepContext context) throws IOException, InterruptedException {
            if (this.conditions == null || this.conditions.isEmpty()) {
                return !(t instanceof FlowInterruptedException) || !((FlowInterruptedException)t).isActualInterruption();
            }
            for (ErrorCondition ec : this.conditions) {
                if (!ec.test(t, context)) continue;
                return true;
            }
            return false;
        }
    }
}

