/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.Extension;
import hudson.Util;
import hudson.model.TaskListener;
import jakarta.mail.Address;
import jakarta.mail.Message;
import jakarta.mail.Transport;
import jakarta.mail.internet.MimeMessage;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import jenkins.plugins.mailer.tasks.MimeMessageBuilder;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class MailStep
extends Step {
    private String charset;
    public final String subject;
    public final String body;
    @DataBoundSetter
    public String from;
    @DataBoundSetter
    public String to;
    @DataBoundSetter
    public String cc;
    @DataBoundSetter
    public String bcc;
    @DataBoundSetter
    public String replyTo;
    private String mimeType;

    @DataBoundConstructor
    public MailStep(@NonNull String subject, @NonNull String body) {
        this.subject = subject;
        this.body = body;
    }

    @DataBoundSetter
    public void setCharset(String charset) {
        this.charset = Util.fixEmpty((String)charset);
    }

    public String getCharset() {
        return this.charset;
    }

    @DataBoundSetter
    public void setMimeType(String mimeType) {
        this.mimeType = Util.fixEmpty((String)mimeType);
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new MailStepExecution(this, context);
    }

    public static class MailStepExecution
    extends SynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        private final transient MailStep step;

        MailStepExecution(MailStep step, StepContext context) {
            super(context);
            this.step = step;
        }

        protected Void run() throws Exception {
            MimeMessage mimeMessage = this.buildMimeMessage();
            Transport.send((Message)mimeMessage);
            return null;
        }

        private MimeMessage buildMimeMessage() throws Exception {
            MimeMessage message;
            Address[] allRecipients;
            if (StringUtils.isBlank((CharSequence)this.step.subject) || StringUtils.isBlank((CharSequence)this.step.body)) {
                throw new AbortException("Email not sent. All mandatory properties must be supplied ('subject', 'body').");
            }
            MimeMessageBuilder messageBuilder = new MimeMessageBuilder().setListener((TaskListener)this.getContext().get(TaskListener.class));
            if (this.step.subject != null) {
                messageBuilder.setSubject(this.step.subject);
            }
            if (this.step.body != null) {
                messageBuilder.setBody(this.step.body);
            }
            if (this.step.from != null) {
                messageBuilder.setFrom(this.step.from);
            }
            if (this.step.replyTo != null) {
                messageBuilder.setReplyTo(this.step.replyTo);
            }
            if (this.step.to != null) {
                messageBuilder.addRecipients(this.step.to, Message.RecipientType.TO);
            }
            if (this.step.cc != null) {
                messageBuilder.addRecipients(this.step.cc, Message.RecipientType.CC);
            }
            if (this.step.bcc != null) {
                messageBuilder.addRecipients(this.step.bcc, Message.RecipientType.BCC);
            }
            if (this.step.charset != null) {
                messageBuilder.setCharset(this.step.charset);
            }
            if (this.step.mimeType != null) {
                messageBuilder.setMimeType(this.step.mimeType);
            }
            if ((allRecipients = (message = messageBuilder.buildMimeMessage()).getAllRecipients()) == null || allRecipients.length == 0) {
                throw new AbortException("Email not sent. No recipients of any kind specified ('to', 'cc', 'bcc').");
            }
            return message;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "mail";
        }

        @NonNull
        public String getDisplayName() {
            return "Mail";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.singleton(TaskListener.class);
        }

        public String argumentsToString(Map<String, Object> namedArgs) {
            Object subject = namedArgs.get("subject");
            return subject instanceof String ? (String)subject : null;
        }
    }
}

