/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.Extension;
import hudson.Functions;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jenkinsci.plugins.workflow.actions.WarningAction;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.CatchExecutionOptions;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public final class CatchErrorStep
extends Step
implements CatchExecutionOptions {
    private static final long serialVersionUID = 1L;
    @CheckForNull
    private String message;
    @NonNull
    private String buildResult = Result.FAILURE.toString();
    @NonNull
    private String stageResult = Result.SUCCESS.toString();
    private boolean catchInterruptions = true;
    private static final CatchExecutionOptions DEFAULT_OPTIONS = new CatchExecutionOptions(){
        private static final long serialVersionUID = 1L;

        @Override
        public String getMessage() {
            return null;
        }

        @Override
        @NonNull
        public Result getBuildResultOnError() {
            return Result.FAILURE;
        }

        @Override
        @NonNull
        public Result getStepResultOnError() {
            return Result.SUCCESS;
        }

        @Override
        public boolean isCatchInterruptions() {
            return true;
        }
    };

    @DataBoundConstructor
    public CatchErrorStep() {
    }

    @Override
    @CheckForNull
    public String getMessage() {
        return this.message;
    }

    @DataBoundSetter
    public void setMessage(String message) {
        this.message = Util.fixEmptyAndTrim((String)message);
    }

    @Override
    @NonNull
    public Result getBuildResultOnError() {
        return Result.fromString((String)this.buildResult);
    }

    @NonNull
    public String getBuildResult() {
        return this.buildResult;
    }

    @DataBoundSetter
    public void setBuildResult(String buildResult) {
        if (buildResult == null) {
            buildResult = Result.SUCCESS.toString();
        }
        if (!buildResult.equalsIgnoreCase(Result.fromString((String)buildResult).toString())) {
            throw new IllegalArgumentException("buildResult is invalid: " + buildResult + ". Valid options are SUCCESS, UNSTABLE, FAILURE, NOT_BUILT and ABORTED.");
        }
        this.buildResult = buildResult;
    }

    @Override
    @NonNull
    public Result getStepResultOnError() {
        return Result.fromString((String)this.stageResult);
    }

    @NonNull
    public String getStageResult() {
        return this.stageResult;
    }

    @DataBoundSetter
    public void setStageResult(String stageResult) {
        if (stageResult == null) {
            stageResult = Result.SUCCESS.toString();
        }
        if (!stageResult.equalsIgnoreCase(Result.fromString((String)stageResult).toString())) {
            throw new IllegalArgumentException("stageResult is invalid: " + stageResult + ". Valid options are SUCCESS, UNSTABLE, FAILURE, NOT_BUILT and ABORTED.");
        }
        this.stageResult = stageResult;
    }

    @Override
    public boolean isCatchInterruptions() {
        return this.catchInterruptions;
    }

    @DataBoundSetter
    public void setCatchInterruptions(boolean catchInterruptions) {
        this.catchInterruptions = catchInterruptions;
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ObjectInputStream.GetField fields = ois.readFields();
        this.message = (String)fields.get("message", null);
        this.catchInterruptions = fields.get("catchInterruptions", true);
        Object serializedBuildResult = fields.get("buildResult", "FAILURE");
        this.buildResult = serializedBuildResult instanceof Result ? ((Result)serializedBuildResult).toString() : (String)serializedBuildResult;
        Object serializedStageResult = fields.get("stageResult", "SUCCESS");
        this.stageResult = serializedStageResult instanceof Result ? ((Result)serializedStageResult).toString() : (String)serializedStageResult;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(context, this);
    }

    public static final class Execution
    extends AbstractStepExecutionImpl {
        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Only used at startup, serialized in Callback")
        private final transient CatchExecutionOptions options;
        private static final long serialVersionUID = 1L;

        Execution(StepContext context, CatchExecutionOptions options) {
            super(context);
            this.options = options;
        }

        public boolean start() throws Exception {
            StepContext context = this.getContext();
            context.newBodyInvoker().withCallback((BodyExecutionCallback)new Callback(this.options)).start();
            return false;
        }

        public void onResume() {
        }

        private static final class Callback
        extends BodyExecutionCallback {
            private static final long serialVersionUID = -5448044884830236797L;
            private CatchExecutionOptions options;

            public Callback(CatchExecutionOptions options) {
                this.options = options;
            }

            public Object readResolve() {
                if (this.options == null) {
                    this.options = DEFAULT_OPTIONS;
                }
                return this;
            }

            public void onSuccess(StepContext context, Object result) {
                context.onSuccess(null);
            }

            public void onFailure(StepContext context, Throwable t) {
                try {
                    if (!this.options.isCatchInterruptions() && t instanceof FlowInterruptedException && ((FlowInterruptedException)t).isActualInterruption()) {
                        context.onFailure(t);
                        return;
                    }
                    TaskListener listener = (TaskListener)context.get(TaskListener.class);
                    String message = this.options.getMessage();
                    if (message != null) {
                        listener.error(message);
                    }
                    Result buildResult = this.options.getBuildResultOnError();
                    Result stepResult = this.options.getStepResultOnError();
                    if (t instanceof AbortException) {
                        listener.error(t.getMessage());
                    } else if (t instanceof FlowInterruptedException) {
                        FlowInterruptedException fie = (FlowInterruptedException)t;
                        fie.handle((Run)context.get(Run.class), listener);
                        buildResult = fie.getResult();
                        stepResult = fie.getResult();
                    } else {
                        Functions.printStackTrace((Throwable)t, (PrintStream)listener.getLogger());
                    }
                    if (buildResult.isWorseThan(Result.SUCCESS)) {
                        Run build = (Run)context.get(Run.class);
                        Result currentResult = build.getResult();
                        if (currentResult == null || buildResult.isWorseThan(currentResult)) {
                            listener.getLogger().println("Setting overall build result to " + String.valueOf(buildResult));
                        }
                        build.setResult(buildResult);
                    }
                    if (stepResult.isWorseThan(Result.SUCCESS)) {
                        ((FlowNode)context.get(FlowNode.class)).addOrReplaceAction((Action)new WarningAction(stepResult).withMessage(message));
                    }
                    context.onSuccess(null);
                }
                catch (Exception x) {
                    context.onFailure((Throwable)x);
                }
            }
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "catchError";
        }

        @NonNull
        public String getDisplayName() {
            return "Catch error and set build result to failure";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public Set<? extends Class<?>> getRequiredContext() {
            HashSet context = new HashSet();
            Collections.addAll(context, FlowNode.class, Run.class, TaskListener.class);
            return Collections.unmodifiableSet(context);
        }

        public ListBoxModel doFillBuildResultItems() {
            ListBoxModel r = new ListBoxModel();
            for (Result result : Arrays.asList(Result.SUCCESS, Result.UNSTABLE, Result.FAILURE, Result.NOT_BUILT, Result.ABORTED)) {
                r.add(result.toString());
            }
            return r;
        }

        public ListBoxModel doFillStageResultItems() {
            return this.doFillBuildResultItems();
        }
    }
}

