/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.steps.stash;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.flow.StashManager;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public class UnstashStep
extends Step {
    @NonNull
    private final String name;

    @DataBoundConstructor
    public UnstashStep(@NonNull String name) {
        Jenkins.checkGoodName((String)name);
        this.name = name;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this.name, context);
    }

    public static class Execution
    extends SynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Only used when starting.")
        private final transient String name;

        Execution(String name, StepContext context) {
            super(context);
            this.name = name;
        }

        protected Void run() throws Exception {
            StashManager.unstash((Run)((Run)this.getContext().get(Run.class)), (String)this.name, (FilePath)((FilePath)this.getContext().get(FilePath.class)), (Launcher)((Launcher)this.getContext().get(Launcher.class)), (EnvVars)((EnvVars)this.getContext().get(EnvVars.class)), (TaskListener)((TaskListener)this.getContext().get(TaskListener.class)));
            return null;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "unstash";
        }

        @NonNull
        public String getDisplayName() {
            return "Restore files previously stashed";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            HashSet context = new HashSet();
            Collections.addAll(context, Run.class, FilePath.class, Launcher.class, EnvVars.class, TaskListener.class);
            return Collections.unmodifiableSet(context);
        }
    }
}

