/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import jenkins.MasterToSlaveFileCallable;
import jenkins.util.BuildListenerAdapter;
import org.jenkinsci.plugins.workflow.steps.ArtifactArchiverStep;
import org.jenkinsci.plugins.workflow.steps.Messages;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;

public class ArtifactArchiverStepExecution
extends SynchronousNonBlockingStepExecution<Void> {
    private final transient ArtifactArchiverStep step;
    private static final long serialVersionUID = 1L;

    ArtifactArchiverStepExecution(ArtifactArchiverStep step, StepContext context) {
        super(context);
        this.step = step;
    }

    protected Void run() throws Exception {
        Map files;
        FilePath ws = (FilePath)this.getContext().get(FilePath.class);
        ws.mkdirs();
        TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
        if (listener != null) {
            listener.getLogger().println(Messages.ArtifactArchiverStepExecution_Deprecated());
        }
        if ((files = (Map)ws.act((FilePath.FileCallable)new ListFiles(this.step.getIncludes(), this.step.getExcludes()))).isEmpty()) {
            if (this.step.getExcludes() != null && !this.step.getExcludes().equals("")) {
                listener.getLogger().println(Messages.ArtifactArchiverStepExecution_NoFilesWithExcludes(this.step.getIncludes(), this.step.getExcludes()));
            } else {
                listener.getLogger().println(Messages.ArtifactArchiverStepExecution_NoFiles(this.step.getIncludes()));
            }
        } else {
            ((Run)this.getContext().get(Run.class)).pickArtifactManager().archive(ws, (Launcher)this.getContext().get(Launcher.class), (BuildListener)new BuildListenerAdapter((TaskListener)this.getContext().get(TaskListener.class)), files);
        }
        return null;
    }

    private static final class ListFiles
    extends MasterToSlaveFileCallable<Map<String, String>> {
        private static final long serialVersionUID = 1L;
        private final String includes;
        private final String excludes;

        ListFiles(String includes, String excludes) {
            this.includes = includes;
            this.excludes = excludes;
        }

        public Map<String, String> invoke(File basedir, VirtualChannel channel) throws IOException, InterruptedException {
            HashMap<String, String> r = new HashMap<String, String>();
            for (String f : Util.createFileSet((File)basedir, (String)this.includes, (String)this.excludes).getDirectoryScanner().getIncludedFiles()) {
                f = f.replace(File.separatorChar, '/');
                r.put(f, f);
            }
            return r;
        }
    }
}

