/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.log;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SpanCoalescerTest {
    private static final Pattern COALESCIBLE = Pattern.compile("<span class=\"pipeline-node-(?<id>[^\"]+)\">(?<first>.*?)</span><span class=\"pipeline-node-\\k<id>\">", 32);

    SpanCoalescerTest() {
    }

    @Test
    void works() {
        SpanCoalescerTest.assertUncoalesced("plain\n");
        SpanCoalescerTest.assertUncoalesced("<span class=\"pipeline-node-1\">one\n</span>");
        SpanCoalescerTest.assertUncoalesced("plain\n<span class=\"pipeline-node-1\">1a\n1b\n</span><span class=\"pipeline-node-2\">2a\n2b\n</span>more plain\n");
        SpanCoalescerTest.assertUncoalesced("<span class=\"pipeline-node-1\">1a\n</span>plain\n<span class=\"pipeline-node-2\">2a\n</span>");
        SpanCoalescerTest.assertCoalesced("plain\n<span class=\"pipeline-node-1\">1a\n1b\n</span><span class=\"pipeline-node-1\">1c\n1d\n</span>more plain\n", "plain\n<span class=\"pipeline-node-1\">1a\n1b\n1c\n1d\n</span>more plain\n");
        SpanCoalescerTest.assertCoalesced("<span class=\"pipeline-node-1\">1a\n</span><span class=\"pipeline-node-1\">1b\n</span><span class=\"pipeline-node-2\">2a\n</span><span class=\"pipeline-node-3\">3a\n</span><span class=\"pipeline-node-3\">3b\n</span>", "<span class=\"pipeline-node-1\">1a\n1b\n</span><span class=\"pipeline-node-2\">2a\n</span><span class=\"pipeline-node-3\">3a\n3b\n</span>");
    }

    private static void assertUncoalesced(String text) {
        Assertions.assertEquals((Object)text, (Object)SpanCoalescerTest.coalesceSpans(text));
    }

    private static void assertCoalesced(String text, String collapsed) {
        Assertions.assertEquals((Object)collapsed, (Object)SpanCoalescerTest.coalesceSpans(text));
    }

    static String coalesceSpans(String text) {
        Matcher m;
        while ((m = COALESCIBLE.matcher(text)).find()) {
            text = m.replaceFirst("<span class=\"pipeline-node-${id}\">${first}");
        }
        return text;
    }
}

