/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.log;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.console.AnnotatedLargeText;
import hudson.console.HyperlinkNote;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.VirtualChannel;
import hudson.slaves.DumbSlave;
import java.io.EOFException;
import java.io.File;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.logging.Level;
import jenkins.model.CauseOfInterruption;
import jenkins.security.MasterToSlaveCallable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.io.output.NullWriter;
import org.apache.commons.io.output.WriterOutputStream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.flow.GraphListener;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.log.LogStorage;
import org.jenkinsci.plugins.workflow.log.SpanCoalescerTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.LogRecorder;
import org.jvnet.hudson.test.junit.jupiter.WithJenkins;
import org.springframework.security.core.Authentication;

@WithJenkins
public abstract class LogStorageTestBase {
    protected static LogRecorder logging = new LogRecorder();
    protected JenkinsRule r;

    @BeforeEach
    void setUp(JenkinsRule rule) throws Exception {
        this.r = rule;
    }

    protected abstract LogStorage createStorage();

    @Test
    void smokes() throws Exception {
        LogStorage ls = this.createStorage();
        BuildListener overall = ls.overallListener();
        overall.getLogger().println("starting");
        TaskListener step1 = ls.nodeListener((FlowNode)new MockNode("1"));
        step1.getLogger().println("one #1");
        TaskListener step2 = ls.nodeListener((FlowNode)new MockNode("2"));
        step2.getLogger().println("two #1");
        long betweenStep2Lines = this.text().writeHtmlTo(0L, (Writer)NullWriter.INSTANCE);
        step2.getLogger().println("two #2");
        overall.getLogger().println("interrupting");
        long overallHtmlPos = this.assertOverallLog(0L, this.lines("starting", "<span class=\"pipeline-node-1\">one #1", "</span><span class=\"pipeline-node-2\">two #1", "two #2", "</span>interrupting"), true);
        Assertions.assertEquals((long)overallHtmlPos, (long)this.assertOverallLog(overallHtmlPos, "", true));
        this.assertLength(overallHtmlPos);
        try {
            this.assertOverallLog(999L, "", true);
            this.assertOverallLog(999L, "", false);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        long step1Pos = this.assertStepLog("1", 0L, this.lines("one #1"), true);
        long step2Pos = this.assertStepLog("2", 0L, this.lines("two #1", "two #2"), true);
        step1.getLogger().println("one #2");
        step1.getLogger().println("one #3");
        overall.getLogger().println("pausing");
        overallHtmlPos = this.assertOverallLog(overallHtmlPos, this.lines("<span class=\"pipeline-node-1\">one #2", "one #3", "</span>pausing"), true);
        step1Pos = this.assertStepLog("1", step1Pos, this.lines("one #2", "one #3"), true);
        this.assertLength("1", step1Pos);
        try {
            this.assertStepLog("1", 999L, "", true);
            this.assertStepLog("1", 999L, "", false);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        step2Pos = this.assertStepLog("2", step2Pos, "", true);
        LogStorageTestBase.close((TaskListener)overall);
        ls = this.createStorage();
        overall = ls.overallListener();
        overall.getLogger().println("resuming");
        step1 = ls.nodeListener((FlowNode)new MockNode("1"));
        step1.getLogger().println("one #4");
        LogStorageTestBase.close(step1);
        TaskListener step3 = ls.nodeListener((FlowNode)new MockNode("3"));
        step3.getLogger().println("three #1");
        LogStorageTestBase.close(step3);
        overall.getLogger().println("ending");
        LogStorageTestBase.close((TaskListener)overall);
        overallHtmlPos = this.assertOverallLog(overallHtmlPos, this.lines("resuming", "<span class=\"pipeline-node-1\">one #4", "</span><span class=\"pipeline-node-3\">three #1", "</span>ending"), true);
        Assertions.assertEquals((long)overallHtmlPos, (long)this.assertOverallLog(overallHtmlPos, "", true));
        this.assertLength(overallHtmlPos);
        step1Pos = this.assertStepLog("1", step1Pos, this.lines("one #4"), true);
        this.assertLength("1", step1Pos);
        this.assertStepLog("1", 0L, this.lines("one #1", "one #2", "one #3", "one #4"), false);
        step2Pos = this.assertStepLog("2", step2Pos, "", true);
        this.assertStepLog("3", 0L, this.lines("three #1"), true);
        ls = this.createStorage();
        TaskListener step4 = ls.nodeListener((FlowNode)new MockNode("4"));
        step4.getLogger().println(HyperlinkNote.encodeTo((String)"http://nowhere.net/", (String)"nikde"));
        LogStorageTestBase.close((TaskListener)overall);
        long step4Pos = this.assertStepLog("4", 0L, this.lines("<a href='http://nowhere.net/'>nikde</a>"), true);
        this.assertLength("4", step4Pos);
        overall = ls.overallListener();
        overall.getLogger().println("really ending");
        LogStorageTestBase.close((TaskListener)overall);
        overallHtmlPos = this.assertOverallLog(overallHtmlPos, this.lines("<span class=\"pipeline-node-4\"><a href='http://nowhere.net/'>nikde</a>", "</span>really ending"), true);
        Assertions.assertEquals((long)overallHtmlPos, (long)this.assertOverallLog(overallHtmlPos, "", true));
        this.assertLength(overallHtmlPos);
    }

    protected static void close(TaskListener listener) throws Exception {
        if (listener instanceof AutoCloseable) {
            ((AutoCloseable)listener).close();
        }
    }

    @Test
    void remoting() throws Exception {
        logging.capture(100).record(Channel.class, Level.WARNING);
        LogStorage ls = this.createStorage();
        BuildListener overall = ls.overallListener();
        overall.getLogger().println("overall from controller");
        TaskListener step = ls.nodeListener((FlowNode)new MockNode("1"));
        step.getLogger().println("step from controller");
        long overallPos = this.assertOverallLog(0L, this.lines("overall from controller", "<span class=\"pipeline-node-1\">step from controller", "</span>").stripTrailing(), true);
        long stepPos = this.assertStepLog("1", 0L, this.lines("step from controller"), true);
        DumbSlave s = this.r.createOnlineSlave();
        this.r.showAgentLogs((Slave)s, this.agentLoggers());
        VirtualChannel channel = s.getChannel();
        channel.call((Callable)new RemotePrint("overall from agent", (TaskListener)overall));
        channel.call((Callable)new RemotePrint("step from agent", step));
        channel.call((Callable)new GC());
        overallPos = this.assertOverallLog(overallPos, this.lines("overall from agent", "<span class=\"pipeline-node-1\">step from agent", "</span>").stripTrailing(), true);
        stepPos = this.assertStepLog("1", stepPos, this.lines("step from agent"), true);
        Assertions.assertEquals((long)overallPos, (long)this.assertOverallLog(overallPos, "", true));
        Assertions.assertEquals((long)stepPos, (long)this.assertStepLog("1", stepPos, "", true));
        MatcherAssert.assertThat((Object)logging.getMessages(), (Matcher)Matchers.empty());
    }

    protected Map<String, Level> agentLoggers() {
        return Collections.singletonMap(LogStorageTestBase.class.getPackage().getName(), Level.FINER);
    }

    @Test
    void mangledLines() throws Exception {
        Random r = new Random();
        BiFunction<Character, TaskListener, Thread> thread = (c, l) -> new Thread(() -> {
            for (int i = 0; i < 1000; ++i) {
                l.getLogger().print(c);
                if (r.nextDouble() < 0.1) {
                    l.getLogger().println();
                }
                if (!(r.nextDouble() < 0.1)) continue;
                try {
                    Thread.sleep(r.nextInt(10));
                    continue;
                }
                catch (InterruptedException x) {
                    x.printStackTrace();
                }
            }
        });
        ArrayList<Thread> threads = new ArrayList<Thread>();
        LogStorage ls = this.createStorage();
        threads.add(thread.apply(Character.valueOf('.'), (TaskListener)ls.overallListener()));
        threads.add(thread.apply(Character.valueOf('1'), ls.nodeListener((FlowNode)new MockNode("1"))));
        threads.add(thread.apply(Character.valueOf('2'), ls.nodeListener((FlowNode)new MockNode("2"))));
        threads.forEach(Thread::start);
        threads.forEach(t -> {
            try {
                t.join();
            }
            catch (InterruptedException x) {
                x.printStackTrace();
            }
        });
        long pos = this.text().writeHtmlTo(0L, (Writer)NullWriter.INSTANCE);
        this.text().writeRawLogTo(0L, (OutputStream)NullOutputStream.INSTANCE);
        pos = this.text("1").writeHtmlTo(0L, (Writer)NullWriter.INSTANCE);
        this.text("1").writeRawLogTo(0L, (OutputStream)NullOutputStream.INSTANCE);
        pos = this.text("2").writeHtmlTo(0L, (Writer)NullWriter.INSTANCE);
        this.text("2").writeRawLogTo(0L, (OutputStream)NullOutputStream.INSTANCE);
    }

    @Test
    void getLogFile() throws Exception {
        LogStorage ls = this.createStorage();
        BuildListener overall = ls.overallListener();
        overall.getLogger().println("starting");
        TaskListener step1 = ls.nodeListener((FlowNode)new MockNode("1"));
        step1.getLogger().println("from step");
        step1.getLogger().flush();
        overall.getLogger().println("finishing");
        overall.getLogger().flush();
        WorkflowJob fakeProject = (WorkflowJob)this.r.createProject(WorkflowJob.class, "fake");
        fakeProject.setDefinition((FlowDefinition)new CpsFlowDefinition("", true));
        WorkflowRun fakeBuild = (WorkflowRun)this.r.buildAndAssertSuccess((Job)fakeProject);
        this.assertOverallLog(0L, FileUtils.readFileToString((File)ls.getLogFile((FlowExecutionOwner.Executable)fakeBuild, false)), false);
        LogStorageTestBase.close((TaskListener)overall);
        ls = this.createStorage();
        this.assertOverallLog(0L, FileUtils.readFileToString((File)ls.getLogFile((FlowExecutionOwner.Executable)fakeBuild, true)), false);
        LogStorageTestBase.close((TaskListener)overall);
    }

    protected final long assertOverallLog(long start, String expected, boolean html) throws Exception {
        return this.assertLog(this::text, start, expected, html, html);
    }

    protected final long assertStepLog(String id, long start, String expected, boolean html) throws Exception {
        return this.assertLog(() -> this.text(id), start, expected, html, false);
    }

    private long assertLog(java.util.concurrent.Callable<AnnotatedLargeText<?>> text, long start, String expected, boolean html, boolean coalesceSpans) throws Exception {
        AnnotatedLargeText<?> oneText;
        long pos = start;
        StringWriter sw = new StringWriter();
        do {
            oneText = text.call();
            pos = html ? oneText.writeHtmlTo(pos, (Writer)sw) : oneText.writeRawLogTo(pos, (OutputStream)((WriterOutputStream.Builder)WriterOutputStream.builder().setWriter((Writer)sw)).setCharset(StandardCharsets.UTF_8).get());
        } while (!oneText.isComplete());
        String result = sw.toString();
        if (coalesceSpans) {
            result = SpanCoalescerTest.coalesceSpans(result);
        }
        Assertions.assertEquals((Object)expected, (Object)result);
        return pos;
    }

    protected final void assertLength(long length) {
        this.assertLength(this.text(), length);
    }

    protected final void assertLength(String id, long length) {
        this.assertLength(this.text(id), length);
    }

    private void assertLength(AnnotatedLargeText<?> text, long length) {
        Assertions.assertEquals((long)length, (long)text.length());
    }

    private AnnotatedLargeText<?> text() {
        return this.createStorage().overallLog(null, true);
    }

    private AnnotatedLargeText<?> text(String id) {
        return this.createStorage().stepLog((FlowNode)new MockNode(id), true);
    }

    protected String lines(CharSequence ... lines) {
        return String.join((CharSequence)System.lineSeparator(), lines) + System.lineSeparator();
    }

    protected static class MockNode
    extends FlowNode {
        MockNode(String id) {
            super((FlowExecution)new MockFlowExecution(), id, new FlowNode[0]);
        }

        protected String getTypeDisplayName() {
            return null;
        }
    }

    private static final class RemotePrint
    extends MasterToSlaveCallable<Void, Exception> {
        private final String message;
        private final TaskListener listener;

        RemotePrint(String message, TaskListener listener) {
            this.message = message;
            this.listener = listener;
        }

        public Void call() {
            this.listener.getLogger().println(this.message);
            this.listener.getLogger().flush();
            return null;
        }
    }

    private static final class GC
    extends MasterToSlaveCallable<Void, Exception> {
        private GC() {
        }

        public Void call() {
            System.gc();
            System.runFinalization();
            return null;
        }
    }

    private static class MockFlowExecution
    extends FlowExecution {
        private MockFlowExecution() {
        }

        public void start() {
            throw new UnsupportedOperationException();
        }

        public FlowExecutionOwner getOwner() {
            return null;
        }

        public List<FlowNode> getCurrentHeads() {
            throw new UnsupportedOperationException();
        }

        public boolean isCurrentHead(FlowNode n) {
            throw new UnsupportedOperationException();
        }

        public void interrupt(Result r, CauseOfInterruption ... causes) {
            throw new UnsupportedOperationException();
        }

        public void addListener(GraphListener listener) {
            throw new UnsupportedOperationException();
        }

        public FlowNode getNode(String id) {
            throw new UnsupportedOperationException();
        }

        @NonNull
        public Authentication getAuthentication2() {
            throw new UnsupportedOperationException();
        }

        public List<Action> loadActions(FlowNode node) {
            throw new UnsupportedOperationException();
        }

        public void saveActions(FlowNode node, List<Action> actions) {
            throw new UnsupportedOperationException();
        }
    }
}

