/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.log;

import hudson.model.BuildListener;
import hudson.model.TaskListener;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.log.FileLogStorage;
import org.jenkinsci.plugins.workflow.log.LogStorage;
import org.jenkinsci.plugins.workflow.log.LogStorageTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.CleanupMode;
import org.junit.jupiter.api.io.TempDir;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.junit.jupiter.WithJenkins;

@WithJenkins
class FileLogStorageTest
extends LogStorageTestBase {
    @TempDir(cleanup=CleanupMode.NEVER)
    private File tmp;
    private File log;

    FileLogStorageTest() {
    }

    @Override
    @BeforeEach
    void setUp(JenkinsRule rule) throws Exception {
        super.setUp(rule);
        this.log = File.createTempFile("junit", null, this.tmp);
    }

    @Override
    protected LogStorage createStorage() {
        return FileLogStorage.forFile((File)this.log);
    }

    @Test
    void oldFormat() throws Exception {
        LogStorage ls = this.createStorage();
        BuildListener overall = ls.overallListener();
        overall.getLogger().println("stuff");
        FileLogStorageTest.close((TaskListener)overall);
        Assertions.assertTrue((boolean)new File(String.valueOf(this.log) + "-index").delete());
        this.assertOverallLog(0L, this.lines("stuff"), true);
    }

    @Test
    void corruptIndex() throws Exception {
        FileUtils.writeStringToFile((File)this.log, (String)"before\n1\nbetween1\n2\nbetween2\n3\nafter", (Charset)StandardCharsets.UTF_8);
        FileUtils.writeStringToFile((File)new File(String.valueOf(this.log) + "-index"), (String)"7 1\n?\n18 2\n20\n29 3\n31", (Charset)StandardCharsets.UTF_8);
        this.assertStepLog("1", 0L, "", false);
        this.assertStepLog("2", 0L, "2\n", false);
        this.assertStepLog("3", 0L, "3\n", false);
    }

    @Test
    public void samePositionInIndex() throws Exception {
        FileUtils.writeStringToFile((File)this.log, (String)"before\n1\nbetween1\n2\nbetween2\n3\nafter", (Charset)StandardCharsets.UTF_8);
        FileUtils.writeStringToFile((File)new File(String.valueOf(this.log) + "-index"), (String)"7 1\n7\n18 2\n20\n29 3\n31", (Charset)StandardCharsets.UTF_8);
        this.assertStepLog("1", 0L, "", false);
        this.assertStepLog("2", 0L, "2\n", false);
        this.assertStepLog("3", 0L, "3\n", false);
    }

    @Test
    void decrementedPositionInIndex() throws Exception {
        FileUtils.writeStringToFile((File)this.log, (String)"before\n1\nbetween1\n2\nbetween2\n3\nafter", (Charset)StandardCharsets.UTF_8);
        FileUtils.writeStringToFile((File)new File(String.valueOf(this.log) + "-index"), (String)"7 1\n0\n18 2\n20\n29 3\n31", (Charset)StandardCharsets.UTF_8);
        this.assertStepLog("1", 0L, "", false);
        this.assertStepLog("2", 0L, "2\n", false);
        this.assertStepLog("3", 0L, "3\n", false);
    }

    @Test
    void corruptIndexAtEnd() throws Exception {
        FileUtils.writeStringToFile((File)this.log, (String)"before\n1\nafter", (Charset)StandardCharsets.UTF_8);
        FileUtils.writeStringToFile((File)new File(String.valueOf(this.log) + "-index"), (String)"7 1\n?", (Charset)StandardCharsets.UTF_8);
        this.assertStepLog("1", 0L, "", false);
    }

    @Test
    void samePositionInIndexAtEnd() throws Exception {
        FileUtils.writeStringToFile((File)this.log, (String)"before\n1\nafter", (Charset)StandardCharsets.UTF_8);
        FileUtils.writeStringToFile((File)new File(String.valueOf(this.log) + "-index"), (String)"7 1\n7", (Charset)StandardCharsets.UTF_8);
        this.assertStepLog("1", 0L, "", false);
    }

    @Test
    void decrementedPositionInIndexAtEnd() throws Exception {
        FileUtils.writeStringToFile((File)this.log, (String)"before\n1\nafter", (Charset)StandardCharsets.UTF_8);
        FileUtils.writeStringToFile((File)new File(String.valueOf(this.log) + "-index"), (String)"7 1\n0", (Charset)StandardCharsets.UTF_8);
        this.assertStepLog("1", 0L, "", false);
    }

    @Test
    void interruptionDoesNotCloseStream() throws Exception {
        LogStorage ls = this.createStorage();
        BuildListener overall = ls.overallListener();
        overall.getLogger().println("overall 1");
        Thread.currentThread().interrupt();
        TaskListener stepLog = ls.nodeListener((FlowNode)new LogStorageTestBase.MockNode("1"));
        stepLog.getLogger().println("step 1");
        Assertions.assertTrue((boolean)Thread.interrupted());
        FileLogStorageTest.close(stepLog);
        overall.getLogger().println("overall 2");
        FileLogStorageTest.close((TaskListener)overall);
        this.assertOverallLog(0L, this.lines("overall 1", "<span class=\"pipeline-node-1\">step 1", "</span>overall 2"), true);
    }
}

