/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.graphanalysis;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graphanalysis.ForkScanner;
import org.jenkinsci.plugins.workflow.graphanalysis.SimpleChunkVisitor;
import org.junit.jupiter.api.Assertions;

public class TestVisitor
implements SimpleChunkVisitor {
    Boolean isFromCompleteRun = null;
    public static final EnumSet<CallType> CHUNK_EVENTS = EnumSet.of(CallType.ATOM_NODE, CallType.CHUNK_START, CallType.CHUNK_END);
    public ArrayList<CallEntry> calls = new ArrayList();

    public void setIsFromCompleteRun(boolean isCompleteRun) {
        this.isFromCompleteRun = isCompleteRun;
    }

    public void chunkStart(@NonNull FlowNode startNode, @CheckForNull FlowNode beforeBlock, @NonNull ForkScanner scanner) {
        this.calls.add(new CallEntry(CallType.CHUNK_START, startNode, beforeBlock));
    }

    public void chunkEnd(@NonNull FlowNode endNode, @CheckForNull FlowNode afterChunk, @NonNull ForkScanner scanner) {
        this.calls.add(new CallEntry(CallType.CHUNK_END, endNode, afterChunk));
    }

    public void parallelStart(@NonNull FlowNode parallelStartNode, @NonNull FlowNode branchNode, @NonNull ForkScanner scanner) {
        this.calls.add(new CallEntry(CallType.PARALLEL_START, parallelStartNode, branchNode));
    }

    public void parallelEnd(@NonNull FlowNode parallelStartNode, @NonNull FlowNode parallelEndNode, @NonNull ForkScanner scanner) {
        this.calls.add(new CallEntry(CallType.PARALLEL_END, parallelStartNode, parallelEndNode));
    }

    public void parallelBranchStart(@NonNull FlowNode parallelStartNode, @NonNull FlowNode branchStartNode, @NonNull ForkScanner scanner) {
        this.calls.add(new CallEntry(CallType.PARALLEL_BRANCH_START, parallelStartNode, branchStartNode));
    }

    public void parallelBranchEnd(@NonNull FlowNode parallelStartNode, @NonNull FlowNode branchEndNode, @NonNull ForkScanner scanner) {
        this.calls.add(new CallEntry(CallType.PARALLEL_BRANCH_END, parallelStartNode, branchEndNode));
    }

    public void atomNode(@CheckForNull FlowNode before, @NonNull FlowNode atomNode, @CheckForNull FlowNode after, @NonNull ForkScanner scan) {
        this.calls.add(new CallEntry(CallType.ATOM_NODE, before, atomNode, after));
    }

    public void reset() {
        this.calls.clear();
        this.isFromCompleteRun = null;
    }

    public List<CallEntry> filteredCallsByType(CallType type) {
        ArrayList<CallEntry> output = new ArrayList<CallEntry>();
        for (CallEntry ce : this.calls) {
            if (ce.type != type) continue;
            output.add(ce);
        }
        return output;
    }

    public void assertNoDupes() {
        ArrayList entries = new ArrayList();
        HashSet<Integer> visitedAtomNodes = new HashSet<Integer>();
        HashSet<Integer> visitedChunkStartNodes = new HashSet<Integer>();
        HashSet<Integer> visitedChunkEndNodes = new HashSet<Integer>();
        for (CallEntry ce : this.calls) {
            boolean added;
            int idToCheck;
            if (entries.contains(ce)) {
                Assertions.fail((String)("Duplicate call: " + ce.toString()));
            }
            if (!CHUNK_EVENTS.contains((Object)ce.type)) continue;
            int n = idToCheck = ce.type == CallType.ATOM_NODE ? ce.ids[1] : ce.ids[0];
            if (ce.type == CallType.ATOM_NODE) {
                if (visitedAtomNodes.contains(idToCheck)) {
                    Assertions.fail((String)("Duplicate atomNode callback for node " + idToCheck + " with " + String.valueOf(ce)));
                } else if (visitedChunkStartNodes.contains(idToCheck)) {
                    Assertions.fail((String)("Illegal atomNode callback where chunkStart callback existed for node " + idToCheck + " with " + String.valueOf(ce)));
                } else if (visitedChunkEndNodes.contains(idToCheck)) {
                    Assertions.fail((String)("Illegal atomNode callback where chunkEnd callback existed for node " + idToCheck + " with " + String.valueOf(ce)));
                }
                visitedAtomNodes.add(idToCheck);
                continue;
            }
            if (visitedAtomNodes.contains(idToCheck)) {
                Assertions.fail((String)("Illegal chunk start/end callback where atomNode callback existed for node " + idToCheck + " with " + String.valueOf(ce)));
            }
            if (ce.type == CallType.CHUNK_START) {
                added = visitedChunkStartNodes.add(idToCheck);
                Assertions.assertTrue((boolean)added, (String)("Duplicate chunkStart callback for node " + idToCheck + " with " + String.valueOf(ce)));
                continue;
            }
            added = visitedChunkEndNodes.add(idToCheck);
            Assertions.assertTrue((boolean)added, (String)("Duplicate chunkEnd callback for node " + idToCheck + " with " + String.valueOf(ce)));
        }
    }

    public void assertNoIllegalNullsInEvents() {
        for (CallEntry ce : this.calls) {
            Integer id = ce.getNodeId();
            Assertions.assertNotNull((Object)id, (String)("Callback with illegally null node: " + String.valueOf(ce)));
            if (ce.type != CallType.PARALLEL_START && ce.type != CallType.PARALLEL_END && ce.type != CallType.PARALLEL_BRANCH_START && ce.type != CallType.PARALLEL_BRANCH_END) continue;
            Assertions.assertNotEquals((int)-1, (int)ce.ids[0], (String)("Parallel event with illegally null parallel start node ID: " + String.valueOf(ce)));
        }
    }

    public void assertAllNodesGotChunkEvents(Iterable<FlowNode> nodes) {
        HashSet<String> ids = new HashSet<String>();
        for (CallEntry ce : this.calls) {
            if (!CHUNK_EVENTS.contains((Object)ce.type)) continue;
            int idToCheck = ce.type == CallType.ATOM_NODE ? ce.ids[1] : ce.ids[0];
            ids.add(Integer.toString(idToCheck));
        }
        for (FlowNode f : nodes) {
            if (ids.contains(f.getId())) continue;
            Assertions.fail((String)("No chunk callbacks for flownode: " + String.valueOf(f)));
        }
    }

    public void assertMatchingParallelBranchStartEnd() {
        List ends;
        HashMap branchStartIds = new HashMap();
        HashMap branchEndIds = new HashMap();
        for (CallEntry callEntry : this.calls) {
            if (callEntry.type == CallType.PARALLEL_BRANCH_END) {
                ends = (ArrayList<Integer>)branchEndIds.get(callEntry.ids[0]);
                if (ends == null) {
                    ends = new ArrayList<Integer>();
                }
                ends.add(callEntry.ids[1]);
                branchEndIds.put(callEntry.ids[0], ends);
                continue;
            }
            if (callEntry.type != CallType.PARALLEL_BRANCH_START) continue;
            ends = (List)branchStartIds.get(callEntry.ids[0]);
            if (ends == null) {
                ends = new ArrayList();
            }
            ends.add(callEntry.ids[1]);
            branchStartIds.put(callEntry.ids[0], ends);
        }
        if (this.isFromCompleteRun != null && this.isFromCompleteRun.booleanValue()) {
            for (Map.Entry entry : branchStartIds.entrySet()) {
                ends = (List)branchEndIds.get(entry.getKey());
                if (this.isFromCompleteRun != null && this.isFromCompleteRun.booleanValue()) {
                    Assertions.assertNotNull(ends);
                    continue;
                }
                if (ends == null) continue;
                Assertions.assertEquals((int)((List)entry.getValue()).size(), (int)ends.size(), (String)("Parallels must have matching numbers of start and end events, but don't -- for parallel starting with: " + String.valueOf(entry.getKey())));
            }
        }
        for (Map.Entry entry : branchEndIds.entrySet()) {
            List starts = (List)branchStartIds.get(entry.getKey());
            Assertions.assertNotNull((Object)starts, (String)("Parallels with a branch end event(s) but no matching branch start event(s), parallel start node id: " + String.valueOf(entry.getKey())));
        }
    }

    public void assertMatchingParallelStartEnd() {
        ArrayDeque<Integer> openParallelStarts = new ArrayDeque<Integer>();
        for (CallEntry ce : this.calls) {
            if (ce.type == CallType.PARALLEL_END) {
                openParallelStarts.push(ce.ids[0]);
                continue;
            }
            if (ce.type != CallType.PARALLEL_START) continue;
            if (!openParallelStarts.isEmpty()) {
                Assertions.assertEquals((Integer)((Integer)openParallelStarts.peekFirst()), (Integer)ce.ids[0], (String)"Parallel start and end events must point to the same parallel start node ID");
                openParallelStarts.pop();
                continue;
            }
            if (this.isFromCompleteRun == null || !this.isFromCompleteRun.booleanValue()) continue;
            Assertions.fail((String)("Found a parallel start without a matching end, with CallEntry: " + String.valueOf(ce)));
        }
        if (!openParallelStarts.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Integer parallelStartId : openParallelStarts) {
                sb.append(parallelStartId).append(',');
            }
            Assertions.fail((String)("Parallel ends with no starts, for parallel(s) with start nodes IDs: " + String.valueOf(sb)));
        }
    }

    public static class CallEntry {
        CallType type;
        int[] ids = new int[]{-1, -1, -1, -1};

        public void setIds(FlowNode ... nodes) {
            for (int i = 0; i < nodes.length; ++i) {
                this.ids[i] = nodes[i] == null ? -1 : Integer.parseInt(nodes[i].getId());
            }
        }

        public CallEntry(CallType type, FlowNode ... nodes) {
            this.type = type;
            this.setIds(nodes);
        }

        public CallEntry(CallType type, int ... vals) {
            this.type = type;
            System.arraycopy(vals, 0, this.ids, 0, vals.length);
        }

        public boolean equals(Object o) {
            if (!(o instanceof CallEntry)) {
                return false;
            }
            CallEntry entry = (CallEntry)o;
            return this.type == entry.type && Arrays.equals(this.ids, entry.ids);
        }

        public void assertEquals(CallEntry test) {
            Assertions.assertNotNull((Object)test);
            Assertions.assertNotNull((Object)((Object)test.type));
            Assertions.assertArrayEquals((int[])this.ids, (int[])test.ids);
        }

        @CheckForNull
        public Integer getNodeId() {
            int idOfInterest = -1;
            idOfInterest = this.type == CallType.ATOM_NODE || this.type == CallType.PARALLEL_END || this.type == CallType.PARALLEL_BRANCH_START || this.type == CallType.PARALLEL_BRANCH_END ? this.ids[1] : this.ids[0];
            return idOfInterest == -1 ? null : Integer.valueOf(idOfInterest);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("CallEntry: ").append((Object)this.type).append('-');
            switch (this.type.ordinal()) {
                case 0: {
                    builder.append("Before/Current/After:").append(this.ids[0]).append('/').append(this.ids[1]).append('/').append(this.ids[2]);
                    break;
                }
                case 1: {
                    builder.append("StartNode/BeforeNode:").append(this.ids[0]).append('/').append(this.ids[1]);
                    break;
                }
                case 2: {
                    builder.append("EndNode/AfterNode:").append(this.ids[0]).append('/').append(this.ids[1]);
                    break;
                }
                case 3: {
                    builder.append("ParallelStartNode/OneBranchStartNode:").append(this.ids[0]).append('/').append(this.ids[1]);
                    break;
                }
                case 4: {
                    builder.append("ParallelStartNode/ParallelEndNode:").append(this.ids[0]).append('/').append(this.ids[1]);
                    break;
                }
                case 5: {
                    builder.append("ParallelStart/BranchStart:").append(this.ids[0]).append('/').append(this.ids[1]);
                    break;
                }
                case 6: {
                    builder.append("ParallelStart/BranchEnd:").append(this.ids[0]).append('/').append(this.ids[1]);
                }
            }
            return builder.toString();
        }
    }

    public static enum CallType {
        ATOM_NODE,
        CHUNK_START,
        CHUNK_END,
        PARALLEL_START,
        PARALLEL_END,
        PARALLEL_BRANCH_START,
        PARALLEL_BRANCH_END;

    }
}

