/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.graphanalysis;

import com.google.common.collect.Iterables;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Run;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jenkinsci.plugins.workflow.actions.ThreadNameAction;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.cps.nodes.StepEndNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepStartNode;
import org.jenkinsci.plugins.workflow.cps.steps.ParallelStep;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.BlockStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graphanalysis.BlockChunkFinder;
import org.jenkinsci.plugins.workflow.graphanalysis.ChunkFinder;
import org.jenkinsci.plugins.workflow.graphanalysis.DepthFirstScanner;
import org.jenkinsci.plugins.workflow.graphanalysis.FlowScanningUtils;
import org.jenkinsci.plugins.workflow.graphanalysis.FlowTestUtils;
import org.jenkinsci.plugins.workflow.graphanalysis.ForkScanner;
import org.jenkinsci.plugins.workflow.graphanalysis.LabelledChunkFinder;
import org.jenkinsci.plugins.workflow.graphanalysis.NoOpChunkFinder;
import org.jenkinsci.plugins.workflow.graphanalysis.NodeStepTypePredicate;
import org.jenkinsci.plugins.workflow.graphanalysis.SimpleChunkVisitor;
import org.jenkinsci.plugins.workflow.graphanalysis.TestVisitor;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.steps.EchoStep;
import org.jenkinsci.plugins.workflow.test.steps.SemaphoreStep;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.junit.jupiter.BuildWatcherExtension;
import org.jvnet.hudson.test.junit.jupiter.WithJenkins;

@WithJenkins
class ForkScannerTest {
    @RegisterExtension
    private static final BuildWatcherExtension buildWatcher = new BuildWatcherExtension();
    private JenkinsRule r;
    WorkflowRun SIMPLE_PARALLEL_RUN;
    WorkflowRun NESTED_PARALLEL_RUN;
    private final Function<FlowNode, String> NODE_TO_ID = input -> input != null ? input.getId() : null;
    private final Function<TestVisitor.CallEntry, String> CALL_TO_NODE_ID = input -> input != null && input.getNodeId() != null ? input.getNodeId().toString() : null;

    ForkScannerTest() {
    }

    public static Predicate<TestVisitor.CallEntry> predicateForCallEntryType(final TestVisitor.CallType type) {
        return new Predicate<TestVisitor.CallEntry>(){
            final TestVisitor.CallType myType;
            {
                this.myType = type;
            }

            @Override
            public boolean test(TestVisitor.CallEntry input) {
                return input.type != null && input.type == this.myType;
            }
        };
    }

    @BeforeEach
    void setUp(JenkinsRule rule) throws Exception {
        WorkflowRun b;
        this.r = rule;
        this.r.jenkins.getInjector().injectMembers((Object)this);
        WorkflowJob job = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "SimpleParallel");
        job.setDefinition((FlowDefinition)new CpsFlowDefinition("echo 'first'\ndef steps = [:]\nsteps['1'] = {\n    echo 'do 1 stuff'\n}\nsteps['2'] = {\n    echo '2a'\n    echo '2b'\n}\nparallel steps\necho 'final'", true));
        this.SIMPLE_PARALLEL_RUN = b = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)job.scheduleBuild2(0, new Action[0]));
        job = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "NestedParallel");
        job.setDefinition((FlowDefinition)new CpsFlowDefinition("echo 'first'\ndef steps = [:]\nsteps['1'] = {\n    echo 'do 1 stuff'\n}\nsteps['2'] = {\n    echo '2a'\n    echo '2b'\n    def nested = [:]\n    nested['2-1'] = {\n        echo 'do 2-1'\n    }\n    nested['2-2'] = {\n        sleep 1\n        echo '2 section 2'\n    }\n    parallel nested\n}\nparallel steps\necho 'final'", true));
        this.NESTED_PARALLEL_RUN = b = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)job.scheduleBuild2(0, new Action[0]));
    }

    private void assertIncompleteParallelsHaveEventsForEnd(List<FlowNode> heads, TestVisitor test) {
        List<String> parallelEnds = test.filteredCallsByType(TestVisitor.CallType.PARALLEL_END).stream().map(this.CALL_TO_NODE_ID).toList();
        boolean hasMatchingEnd = false;
        for (FlowNode f : heads) {
            if (!parallelEnds.contains(f.getId())) continue;
            hasMatchingEnd = true;
            break;
        }
        Assertions.assertTrue((boolean)hasMatchingEnd, (String)"If there are multiple heads, we MUST be in a parallel and have an event for the end");
        List<String> branchEnds = test.filteredCallsByType(TestVisitor.CallType.PARALLEL_BRANCH_END).stream().map(this.CALL_TO_NODE_ID).toList();
        for (FlowNode f : heads) {
            Assertions.assertTrue((boolean)branchEnds.contains(f.getId()), (String)("Must have a parallel branch end for each branch we know of, but didn't, for nodeId: " + f.getId()));
        }
    }

    private void sanityTestIterationAndVisiter(List<FlowNode> heads) {
        ForkScanner scan = new ForkScanner();
        TestVisitor test = new TestVisitor();
        scan.setup(heads);
        scan.visitSimpleChunks((SimpleChunkVisitor)test, (ChunkFinder)new NoOpChunkFinder());
        test.isFromCompleteRun = scan.isWalkingFromFinish();
        if (heads.size() > 1) {
            this.assertIncompleteParallelsHaveEventsForEnd(heads, test);
        }
        test.assertNoIllegalNullsInEvents();
        test.assertNoDupes();
        int nodeCount = new DepthFirstScanner().allNodes(heads).size();
        Assertions.assertEquals((int)nodeCount, (int)new ForkScanner().allNodes(heads).size(), (String)"ForkScanner should visit the same number of nodes as DepthFirstScanner");
        test.assertMatchingParallelStartEnd();
        test.assertAllNodesGotChunkEvents(new DepthFirstScanner().allNodes(heads));
        this.assertNoMissingParallelEvents(heads);
        if (!heads.isEmpty()) {
            test.assertMatchingParallelBranchStartEnd();
        }
        test.reset();
        scan.setup(heads);
        test.isFromCompleteRun = scan.isWalkingFromFinish();
        scan.visitSimpleChunks((SimpleChunkVisitor)test, (ChunkFinder)new LabelledChunkFinder());
        test.assertNoIllegalNullsInEvents();
        test.assertNoDupes();
        int lastId = -1;
        for (int i = 0; i < test.calls.size(); ++i) {
            TestVisitor.CallEntry entry = test.calls.get(i);
            if (lastId > 0) {
                lastId = entry.getNodeId();
            }
            if (!TestVisitor.CHUNK_EVENTS.contains((Object)entry.type)) continue;
            Assertions.assertEquals((Object)((Object)TestVisitor.CallType.CHUNK_END), (Object)((Object)entry.type));
            break;
        }
        Assertions.assertEquals((int)nodeCount, (int)new ForkScanner().allNodes(heads).size());
        test.assertMatchingParallelStartEnd();
        test.assertMatchingParallelBranchStartEnd();
        test.assertAllNodesGotChunkEvents(new DepthFirstScanner().allNodes(heads));
        this.assertNoMissingParallelEvents(heads);
    }

    @Test
    void testForkedScanner() throws Exception {
        FlowExecution exec = this.SIMPLE_PARALLEL_RUN.getExecution();
        List heads = this.SIMPLE_PARALLEL_RUN.getExecution().getCurrentHeads();
        ForkScanner scanner = new ForkScanner();
        scanner.setup((Collection)heads, null);
        Assertions.assertNull((Object)scanner.currentParallelStart);
        Assertions.assertNull((Object)scanner.currentParallelStartNode);
        Assertions.assertNotNull((Object)scanner.parallelBlockStartStack);
        Assertions.assertEquals((int)0, (int)scanner.parallelBlockStartStack.size());
        Assertions.assertTrue((boolean)scanner.isWalkingFromFinish());
        this.sanityTestIterationAndVisiter(heads);
        scanner.setup(exec.getNode("13"));
        Assertions.assertFalse((boolean)scanner.isWalkingFromFinish());
        Assertions.assertNull((Object)scanner.currentType);
        Assertions.assertEquals((Object)ForkScanner.NodeType.PARALLEL_END, (Object)scanner.nextType);
        Assertions.assertEquals((Object)"13", (Object)scanner.next().getId());
        Assertions.assertNotNull((Object)scanner.parallelBlockStartStack);
        Assertions.assertEquals((int)0, (int)scanner.parallelBlockStartStack.size());
        Assertions.assertEquals((Object)exec.getNode("4"), (Object)scanner.currentParallelStartNode);
        this.sanityTestIterationAndVisiter(Collections.singletonList(exec.getNode("13")));
        ForkScanner.ParallelBlockStart start = scanner.currentParallelStart;
        Assertions.assertEquals((int)1, (int)start.unvisited.size());
        Assertions.assertEquals((Object)exec.getNode("4"), (Object)start.forkStart);
        Assertions.assertEquals((Object)exec.getNode("12"), (Object)scanner.next());
        Assertions.assertEquals((Object)ForkScanner.NodeType.PARALLEL_BRANCH_END, (Object)scanner.getCurrentType());
        Assertions.assertEquals((Object)ForkScanner.NodeType.NORMAL, (Object)scanner.getNextType());
        Assertions.assertEquals((Object)exec.getNode("11"), (Object)scanner.next());
        Assertions.assertEquals((Object)ForkScanner.NodeType.NORMAL, (Object)scanner.getCurrentType());
        Assertions.assertEquals((Object)exec.getNode("10"), (Object)scanner.next());
        Assertions.assertEquals((Object)ForkScanner.NodeType.NORMAL, (Object)scanner.getCurrentType());
        Assertions.assertEquals((Object)ForkScanner.NodeType.PARALLEL_BRANCH_START, (Object)scanner.getNextType());
        Assertions.assertEquals((Object)exec.getNode("7"), (Object)scanner.next());
        Assertions.assertEquals((Object)ForkScanner.NodeType.PARALLEL_BRANCH_START, (Object)scanner.getCurrentType());
        Assertions.assertEquals((Object)ForkScanner.NodeType.PARALLEL_BRANCH_END, (Object)scanner.getNextType());
        Assertions.assertEquals((Object)exec.getNode("9"), (Object)scanner.next());
        Assertions.assertEquals((Object)ForkScanner.NodeType.PARALLEL_BRANCH_END, (Object)scanner.getCurrentType());
        Assertions.assertEquals((Object)exec.getNode("8"), (Object)scanner.next());
        Assertions.assertEquals((Object)ForkScanner.NodeType.NORMAL, (Object)scanner.getCurrentType());
        Assertions.assertEquals((Object)exec.getNode("6"), (Object)scanner.next());
        Assertions.assertEquals((Object)ForkScanner.NodeType.PARALLEL_BRANCH_START, (Object)scanner.getCurrentType());
        Assertions.assertEquals((Object)ForkScanner.NodeType.PARALLEL_START, (Object)scanner.getNextType());
    }

    @Test
    void testFlowSegmentSplit() throws Exception {
        FlowExecution exec = this.SIMPLE_PARALLEL_RUN.getExecution();
        HashMap<FlowNode, ForkScanner.FlowSegment> nodeMap = new HashMap<FlowNode, ForkScanner.FlowSegment>();
        ForkScanner.FlowSegment mainBranch = new ForkScanner.FlowSegment();
        ForkScanner.FlowSegment sideBranch = new ForkScanner.FlowSegment();
        FlowNode BRANCH1_END = exec.getNode("9");
        FlowNode BRANCH2_END = exec.getNode("12");
        FlowNode START_PARALLEL = exec.getNode("4");
        mainBranch.add(BRANCH1_END);
        mainBranch.add(exec.getNode("8"));
        mainBranch.add(exec.getNode("6"));
        mainBranch.add(exec.getNode("4"));
        mainBranch.add(exec.getNode("3"));
        for (FlowNode f : mainBranch.visited) {
            nodeMap.put(f, mainBranch);
        }
        FlowTestUtils.assertNodeOrder("Visited nodes", (Iterable<FlowNode>)mainBranch.visited, 9, 8, 6, 4, 3);
        sideBranch.add(BRANCH2_END);
        sideBranch.add(exec.getNode("11"));
        sideBranch.add(exec.getNode("10"));
        sideBranch.add(exec.getNode("7"));
        for (FlowNode f : sideBranch.visited) {
            nodeMap.put(f, sideBranch);
        }
        FlowTestUtils.assertNodeOrder("Visited nodes", (Iterable<FlowNode>)sideBranch.visited, 12, 11, 10, 7);
        ForkScanner.Fork forked = mainBranch.split(nodeMap, (BlockStartNode)exec.getNode("4"), (ForkScanner.FlowPiece)sideBranch);
        ForkScanner.FlowSegment splitSegment = (ForkScanner.FlowSegment)nodeMap.get(BRANCH1_END);
        Assertions.assertNull((Object)splitSegment.after);
        FlowTestUtils.assertNodeOrder("Branch 1 split after fork", (Iterable<FlowNode>)splitSegment.visited, 9, 8, 6);
        Assertions.assertEquals((Object)forked, (Object)mainBranch.after);
        FlowTestUtils.assertNodeOrder("Head of flow, pre-fork", (Iterable<FlowNode>)mainBranch.visited, 3);
        Assertions.assertEquals((Object)forked, nodeMap.get(START_PARALLEL));
        Object[] follows = new ForkScanner.FlowPiece[]{splitSegment, sideBranch};
        Assertions.assertArrayEquals((Object[])follows, (Object[])forked.following.toArray());
        Assertions.assertEquals((Object)sideBranch, nodeMap.get(BRANCH2_END));
        FlowTestUtils.assertNodeOrder("Branch 2", (Iterable<FlowNode>)sideBranch.visited, 12, 11, 10, 7);
        nodeMap.clear();
        mainBranch = new ForkScanner.FlowSegment();
        sideBranch = new ForkScanner.FlowSegment();
        mainBranch.visited.add(exec.getNode("6"));
        mainBranch.visited.add(START_PARALLEL);
        sideBranch.visited.add(exec.getNode("7"));
        for (FlowNode f : mainBranch.visited) {
            nodeMap.put(f, mainBranch);
        }
        nodeMap.put(exec.getNode("7"), sideBranch);
        forked = mainBranch.split(nodeMap, (BlockStartNode)exec.getNode("4"), (ForkScanner.FlowPiece)sideBranch);
        follows = new ForkScanner.FlowSegment[]{mainBranch, sideBranch};
        Assertions.assertArrayEquals((Object[])follows, (Object[])forked.following.toArray());
        FlowTestUtils.assertNodeOrder("Branch1", (Iterable<FlowNode>)mainBranch.visited, 6);
        Assertions.assertNull((Object)mainBranch.after);
        FlowTestUtils.assertNodeOrder("Branch2", (Iterable<FlowNode>)sideBranch.visited, 7);
        Assertions.assertNull((Object)sideBranch.after);
        Assertions.assertEquals((Object)forked, nodeMap.get(START_PARALLEL));
        Assertions.assertEquals((Object)mainBranch, nodeMap.get(exec.getNode("6")));
        Assertions.assertEquals((Object)sideBranch, nodeMap.get(exec.getNode("7")));
    }

    @Test
    void testEmptyParallel() throws Exception {
        WorkflowJob job = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "EmptyParallel");
        job.setDefinition((FlowDefinition)new CpsFlowDefinition("parallel 'empty1': {}, 'empty2':{} \necho 'done' ", true));
        WorkflowRun b = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)job.scheduleBuild2(0, new Action[0]));
        ForkScanner scan = new ForkScanner();
        List outputs = scan.filteredNodes((Collection)b.getExecution().getCurrentHeads(), x -> true);
        Assertions.assertEquals((int)9, (int)outputs.size());
    }

    private void assertNoMissingParallelEvents(List<FlowNode> heads) {
        DepthFirstScanner allScan = new DepthFirstScanner();
        TestVisitor visit = new TestVisitor();
        ForkScanner forkScan = new ForkScanner();
        List matches = allScan.filteredNodes(heads, FlowScanningUtils.hasActionPredicate(ThreadNameAction.class));
        forkScan.setup(heads);
        forkScan.visitSimpleChunks((SimpleChunkVisitor)visit, (ChunkFinder)new LabelledChunkFinder());
        Set callIds = visit.filteredCallsByType(TestVisitor.CallType.PARALLEL_BRANCH_START).stream().map(this.CALL_TO_NODE_ID).collect(Collectors.toSet());
        for (String id : matches.stream().map(this.NODE_TO_ID).toList()) {
            if (callIds.contains(id)) continue;
            Assertions.fail((String)("Parallel Branch start node without an appropriate parallelBranchStart callback: " + id));
        }
        matches = allScan.filteredNodes(heads, input -> input instanceof StepStartNode && ((StepStartNode)input).getDescriptor() instanceof ParallelStep.DescriptorImpl && input.getPersistentAction(ThreadNameAction.class) == null);
        List parallelEnds = allScan.filteredNodes(heads, input -> input instanceof StepEndNode && ((StepEndNode)input).getDescriptor() instanceof ParallelStep.DescriptorImpl && ((StepStartNode)((StepEndNode)input).getStartNode()).getPersistentAction(ThreadNameAction.class) == null);
        visit.reset();
        forkScan.setup(heads);
        forkScan.visitSimpleChunks((SimpleChunkVisitor)visit, (ChunkFinder)new LabelledChunkFinder());
        callIds = visit.filteredCallsByType(TestVisitor.CallType.PARALLEL_START).stream().map(this.CALL_TO_NODE_ID).collect(Collectors.toSet());
        for (String id : matches.stream().map(this.NODE_TO_ID).toList()) {
            if (callIds.contains(id)) continue;
            Assertions.fail((String)("Parallel start node without an appropriate parallelStart callback: " + id));
        }
        callIds = visit.filteredCallsByType(TestVisitor.CallType.PARALLEL_END).stream().map(this.CALL_TO_NODE_ID).collect(Collectors.toSet());
        for (String id : parallelEnds.stream().map(this.NODE_TO_ID).toList()) {
            if (callIds.contains(id)) continue;
            Assertions.fail((String)("Parallel END node without an appropriate parallelEnd callback: " + id));
        }
    }

    @Test
    void testSingleNestedParallelBranches() throws Exception {
        String script = "node {\n     echo ('Testing')\n     parallel nestedBranch: {\n       echo 'nested Branch'\n       stage ('nestedBranchStage') { \n           echo 'running nestedBranchStage'\n           parallel secondLevelNestedBranch1: {\n               echo 'secondLevelNestedBranch1'\n           }\n       }\n     }, failFast: false\n}";
        WorkflowJob job = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "SingleNestedParallelBranch");
        job.setDefinition((FlowDefinition)new CpsFlowDefinition(script, true));
        WorkflowRun b = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)job.scheduleBuild2(0, new Action[0]));
        FlowNode echoNode = new DepthFirstScanner().findFirstMatch(b.getExecution(), (com.google.common.base.Predicate)new NodeStepTypePredicate(EchoStep.DescriptorImpl.byFunctionName((String)"echo")));
        Assertions.assertNotNull((Object)echoNode);
        this.sanityTestIterationAndVisiter(b.getExecution().getCurrentHeads());
        this.sanityTestIterationAndVisiter(Collections.singletonList(echoNode));
        TestVisitor visitor = new TestVisitor();
        ForkScanner scanner = new ForkScanner();
        scanner.setup((Collection)b.getExecution().getCurrentHeads());
        scanner.visitSimpleChunks((SimpleChunkVisitor)visitor, (ChunkFinder)new NoOpChunkFinder());
        Assertions.assertEquals((int)2, (int)visitor.filteredCallsByType(TestVisitor.CallType.PARALLEL_START).size());
        Assertions.assertEquals((int)2, (int)visitor.filteredCallsByType(TestVisitor.CallType.PARALLEL_END).size());
        Assertions.assertEquals((int)2, (int)visitor.filteredCallsByType(TestVisitor.CallType.PARALLEL_BRANCH_START).size());
        Assertions.assertEquals((int)2, (int)visitor.filteredCallsByType(TestVisitor.CallType.PARALLEL_BRANCH_END).size());
    }

    @Test
    void testLeastCommonAncestor() throws Exception {
        FlowExecution exec = this.SIMPLE_PARALLEL_RUN.getExecution();
        ForkScanner scan = new ForkScanner();
        LinkedHashSet<FlowNode> heads = new LinkedHashSet<FlowNode>(Arrays.asList(exec.getNode("12"), exec.getNode("9")));
        ArrayDeque starts = scan.leastCommonAncestor(heads);
        Assertions.assertEquals((int)1, (int)starts.size());
        ForkScanner.ParallelBlockStart start = (ForkScanner.ParallelBlockStart)starts.peek();
        Assertions.assertEquals((int)2, (int)start.unvisited.size());
        Assertions.assertEquals((Object)exec.getNode("4"), (Object)start.forkStart);
        Assertions.assertArrayEquals((Object[])heads.toArray(), (Object[])start.unvisited.toArray());
        heads = new LinkedHashSet<FlowNode>(Collections.singletonList(exec.getNode("4")));
        scan.setup(heads);
        Assertions.assertNull((Object)scan.currentParallelStart);
        Assertions.assertTrue((scan.parallelBlockStartStack == null || scan.parallelBlockStartStack.isEmpty() ? 1 : 0) != 0);
        heads = new LinkedHashSet<FlowNode>(Arrays.asList(exec.getNode("6"), exec.getNode("7")));
        starts = scan.leastCommonAncestor(heads);
        Assertions.assertEquals((int)1, (int)starts.size());
        ForkScanner.ParallelBlockStart pbs = (ForkScanner.ParallelBlockStart)starts.pop();
        Assertions.assertEquals((Object)exec.getNode("4"), (Object)pbs.forkStart);
        Assertions.assertEquals((int)2, (int)pbs.unvisited.size());
        Assertions.assertTrue((boolean)pbs.unvisited.contains(exec.getNode("6")));
        Assertions.assertTrue((boolean)pbs.unvisited.contains(exec.getNode("7")));
        this.sanityTestIterationAndVisiter(new ArrayList<FlowNode>(heads));
        exec = this.NESTED_PARALLEL_RUN.getExecution();
        heads = new LinkedHashSet<FlowNode>(Arrays.asList(exec.getNode("9"), exec.getNode("17"), exec.getNode("20")));
        starts = scan.leastCommonAncestor(heads);
        Assertions.assertEquals((int)2, (int)starts.size());
        ForkScanner.ParallelBlockStart inner = (ForkScanner.ParallelBlockStart)starts.getFirst();
        ForkScanner.ParallelBlockStart outer = (ForkScanner.ParallelBlockStart)starts.getLast();
        Assertions.assertEquals((int)2, (int)inner.unvisited.size());
        Assertions.assertEquals((Object)exec.getNode("12"), (Object)inner.forkStart);
        Assertions.assertEquals((int)1, (int)outer.unvisited.size());
        Assertions.assertEquals((Object)exec.getNode("9"), outer.unvisited.peek());
        Assertions.assertEquals((Object)exec.getNode("4"), (Object)outer.forkStart);
        this.sanityTestIterationAndVisiter(new ArrayList<FlowNode>(heads));
        heads = new LinkedHashSet<FlowNode>(Arrays.asList(exec.getNode("9"), exec.getNode("17"), exec.getNode("20")));
        starts = scan.leastCommonAncestor(heads);
        Assertions.assertEquals((int)2, (int)starts.size());
        this.sanityTestIterationAndVisiter(new ArrayList<FlowNode>(heads));
    }

    @Test
    void testVariousParallelCombos() throws Exception {
        WorkflowJob job = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "ParallelTimingBug");
        job.setDefinition((FlowDefinition)new CpsFlowDefinition("echo 'test stage'\n    parallel 'unit': {\n          retry(1) {\n            sleep 1;\n            sleep 10; echo 'hello';\n          }\n        }, 'otherunit': {\n            retry(1) {\n              sleep 1;\n              sleep 5;\n              echo 'goodbye'\n            }\n        }", true));
        WorkflowRun b = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)job.scheduleBuild2(0, new Action[0]));
        FlowExecution exec = b.getExecution();
        ForkScanner scan = new ForkScanner();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 5; ++j) {
                int branchANodeId = i + 20;
                int branchBNodeId = j + 15;
                System.out.println("Starting test with nodes " + branchANodeId + "," + branchBNodeId);
                ArrayList<FlowNode> starts = new ArrayList<FlowNode>();
                FlowTestUtils.addNodesById(starts, exec, branchANodeId, branchBNodeId);
                List all = scan.filteredNodes(starts, x -> true);
                Assertions.assertEquals((int)new HashSet(all).size(), (int)all.size());
                scan.reset();
            }
        }
    }

    @Test
    void testMissingHeadErrorWithZeroBranchParallel() throws Exception {
        WorkflowJob job = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "MissingHeadBug");
        job.setDefinition((FlowDefinition)new CpsFlowDefinition("stage('Stage A') {\n    echo \"A\"\n}\n// Works\nstage('Stage B') {\n    parallel a: {\n        echo \"B.A\"\n    }, b: {\n        echo \"B.B\"\n    }\n}\n// Breaks\nstage('Stage C') {\n    def steps = [:]\n    // Empty map\n    parallel steps\n}\n", true));
        WorkflowRun run = (WorkflowRun)this.r.buildAndAssertSuccess((Job)job);
        FlowExecution exec = run.getExecution();
        this.sanityTestIterationAndVisiter(exec.getCurrentHeads());
    }

    @Test
    void testParallelPredicate() throws Exception {
        FlowExecution exec = this.SIMPLE_PARALLEL_RUN.getExecution();
        Assertions.assertTrue((boolean)new ForkScanner.IsParallelStartPredicate().apply(exec.getNode("4")));
        Assertions.assertFalse((boolean)new ForkScanner.IsParallelStartPredicate().apply(exec.getNode("6")));
        Assertions.assertFalse((boolean)new ForkScanner.IsParallelStartPredicate().apply(exec.getNode("8")));
    }

    @Test
    void testGetNodeType() throws Exception {
        FlowExecution exec = this.SIMPLE_PARALLEL_RUN.getExecution();
        Assertions.assertEquals((Object)ForkScanner.NodeType.NORMAL, (Object)ForkScanner.getNodeType((FlowNode)exec.getNode("2")));
        Assertions.assertEquals((Object)ForkScanner.NodeType.PARALLEL_START, (Object)ForkScanner.getNodeType((FlowNode)exec.getNode("4")));
        Assertions.assertEquals((Object)ForkScanner.NodeType.PARALLEL_BRANCH_START, (Object)ForkScanner.getNodeType((FlowNode)exec.getNode("6")));
        Assertions.assertEquals((Object)ForkScanner.NodeType.PARALLEL_BRANCH_END, (Object)ForkScanner.getNodeType((FlowNode)exec.getNode("9")));
        Assertions.assertEquals((Object)ForkScanner.NodeType.PARALLEL_END, (Object)ForkScanner.getNodeType((FlowNode)exec.getNode("13")));
        Assertions.assertEquals((Object)ForkScanner.NodeType.NORMAL, (Object)ForkScanner.getNodeType((FlowNode)exec.getNode("8")));
    }

    @Test
    void testSimpleVisitor() throws Exception {
        FlowExecution exec = this.SIMPLE_PARALLEL_RUN.getExecution();
        ForkScanner f = new ForkScanner();
        f.setup((Collection)exec.getCurrentHeads());
        Assertions.assertArrayEquals((Object[])new HashSet(exec.getCurrentHeads()).toArray(), (Object[])new HashSet(f.currentParallelHeads()).toArray());
        List expectedHeads = f.currentParallelHeads();
        this.sanityTestIterationAndVisiter(exec.getCurrentHeads());
        TestVisitor visitor = new TestVisitor();
        f.visitSimpleChunks((SimpleChunkVisitor)visitor, (ChunkFinder)new BlockChunkFinder());
        Assertions.assertEquals((int)19, (int)visitor.calls.size());
        TestVisitor.CallEntry last = new TestVisitor.CallEntry(TestVisitor.CallType.CHUNK_END, 15, -1, -1, -1);
        last.assertEquals(visitor.calls.get(0));
        TestVisitor.CallEntry first = new TestVisitor.CallEntry(TestVisitor.CallType.CHUNK_START, 2, -1, -1, -1);
        first.assertEquals(visitor.calls.get(18));
        long chunkStartCount = visitor.calls.stream().filter(ForkScannerTest.predicateForCallEntryType(TestVisitor.CallType.CHUNK_START)).count();
        long chunkEndCount = visitor.calls.stream().filter(ForkScannerTest.predicateForCallEntryType(TestVisitor.CallType.CHUNK_END)).count();
        Assertions.assertEquals((long)4L, (long)chunkStartCount);
        Assertions.assertEquals((long)4L, (long)chunkEndCount);
        List<TestVisitor.CallEntry> atomNodeCalls = visitor.calls.stream().filter(ForkScannerTest.predicateForCallEntryType(TestVisitor.CallType.ATOM_NODE)).toList();
        Assertions.assertEquals((int)5, (int)atomNodeCalls.size());
        for (TestVisitor.CallEntry ce : atomNodeCalls) {
            int beforeId = ce.ids[0];
            int atomNodeId = ce.ids[1];
            int afterId = ce.ids[2];
            int alwaysEmpty = ce.ids[3];
            Assertions.assertTrue((beforeId > 0 ? 1 : 0) != 0, (String)(String.valueOf(ce) + " beforeNodeId <= 0: " + beforeId));
            Assertions.assertTrue((atomNodeId > 0 ? 1 : 0) != 0, (String)(String.valueOf(ce) + " atomNodeId <= 0: " + atomNodeId));
            Assertions.assertTrue((afterId > 0 ? 1 : 0) != 0, (String)(String.valueOf(ce) + " afterNodeId <= 0: " + afterId));
            Assertions.assertEquals((int)-1, (int)alwaysEmpty);
            Assertions.assertTrue((atomNodeId < afterId ? 1 : 0) != 0, (String)(String.valueOf(ce) + "AtomNodeId >= afterNodeId"));
            Assertions.assertTrue((beforeId < atomNodeId ? 1 : 0) != 0, (String)(String.valueOf(ce) + "beforeNodeId >= atomNodeId"));
        }
        List<TestVisitor.CallEntry> parallelCalls = visitor.calls.stream().filter(input -> input.type != null && input.type != TestVisitor.CallType.ATOM_NODE && input.type != TestVisitor.CallType.CHUNK_START && input.type != TestVisitor.CallType.CHUNK_END).toList();
        Assertions.assertEquals((int)6, (int)parallelCalls.size());
        new TestVisitor.CallEntry(TestVisitor.CallType.PARALLEL_END, 4, 13).assertEquals(parallelCalls.get(0));
        new TestVisitor.CallEntry(TestVisitor.CallType.PARALLEL_BRANCH_END, 4, 12).assertEquals(parallelCalls.get(1));
        new TestVisitor.CallEntry(TestVisitor.CallType.PARALLEL_BRANCH_START, 4, 7).assertEquals(parallelCalls.get(2));
        new TestVisitor.CallEntry(TestVisitor.CallType.PARALLEL_BRANCH_END, 4, 9).assertEquals(parallelCalls.get(3));
        new TestVisitor.CallEntry(TestVisitor.CallType.PARALLEL_BRANCH_START, 4, 6).assertEquals(parallelCalls.get(4));
        new TestVisitor.CallEntry(TestVisitor.CallType.PARALLEL_START, 4, 6).assertEquals(parallelCalls.get(5));
    }

    @Test
    void testTripleParallel() throws Exception {
        WorkflowJob job = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "TripleParallel");
        job.setDefinition((FlowDefinition)new CpsFlowDefinition("echo 'test stage'\nparallel 'unit':{\n  echo \"Unit testing...\"\n},'integration':{\n    echo \"Integration testing...\"\n}, 'ui':{\n    echo \"UI testing...\"\n}", true));
        WorkflowRun b = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)job.scheduleBuild2(0, new Action[0]));
        FlowExecution exec = b.getExecution();
        ForkScanner f = new ForkScanner();
        List heads = exec.getCurrentHeads();
        f.setup((Collection)heads);
        TestVisitor visitor = new TestVisitor();
        f.visitSimpleChunks((SimpleChunkVisitor)visitor, (ChunkFinder)new BlockChunkFinder());
        this.sanityTestIterationAndVisiter(heads);
        List<Object> parallels = visitor.calls.stream().filter(ForkScannerTest.predicateForCallEntryType(TestVisitor.CallType.PARALLEL_BRANCH_START).or(ForkScannerTest.predicateForCallEntryType(TestVisitor.CallType.PARALLEL_BRANCH_END))).collect(Collectors.toList());
        Assertions.assertEquals((int)6, (int)parallels.size());
        ArrayList<FlowNode> ends = new ArrayList<FlowNode>();
        ends.add(exec.getNode("11"));
        ends.add(exec.getNode("12"));
        ends.add(exec.getNode("14"));
        Assertions.assertEquals((int)new DepthFirstScanner().allNodes(ends).size(), (int)new ForkScanner().allNodes(ends).size());
        visitor = new TestVisitor();
        f.setup(ends);
        f.visitSimpleChunks((SimpleChunkVisitor)visitor, (ChunkFinder)new BlockChunkFinder());
        this.sanityTestIterationAndVisiter(ends);
        parallels = visitor.calls.stream().filter(ForkScannerTest.predicateForCallEntryType(TestVisitor.CallType.PARALLEL_BRANCH_START).or(ForkScannerTest.predicateForCallEntryType(TestVisitor.CallType.PARALLEL_BRANCH_END))).toList();
        Assertions.assertEquals((int)6, (int)parallels.size());
        Assertions.assertEquals((int)18, (int)visitor.calls.size());
        FlowNode[] branchHeads = new FlowNode[]{exec.getNode("7"), exec.getNode("8"), exec.getNode("9")};
        ArrayDeque starts = f.leastCommonAncestor(new HashSet<FlowNode>(Arrays.asList(branchHeads)));
        Assertions.assertEquals((int)1, (int)starts.size());
        ForkScanner.ParallelBlockStart pbs = (ForkScanner.ParallelBlockStart)starts.pop();
        Assertions.assertEquals((Object)exec.getNode("4"), (Object)pbs.forkStart);
        Assertions.assertEquals((int)3, (int)pbs.unvisited.size());
        Assertions.assertTrue((boolean)pbs.unvisited.contains(exec.getNode("7")));
        Assertions.assertTrue((boolean)pbs.unvisited.contains(exec.getNode("8")));
        Assertions.assertTrue((boolean)pbs.unvisited.contains(exec.getNode("9")));
    }

    private void testParallelFindsLast(WorkflowJob job, String semaphoreName) throws Exception {
        ForkScanner scan = new ForkScanner();
        LabelledChunkFinder labelFinder = new LabelledChunkFinder();
        System.out.println("Testing that semaphore step is always the last step for chunk with " + job.getName());
        WorkflowRun run = (WorkflowRun)job.scheduleBuild2(0, new Action[0]).getStartCondition().get();
        SemaphoreStep.waitForStart((String)(semaphoreName + "/1"), (Run)run);
        FlowNode semaphoreNode = (FlowNode)Iterables.tryFind((Iterable)run.getExecution().getCurrentHeads(), (com.google.common.base.Predicate)new NodeStepTypePredicate("semaphore")).orNull();
        TestVisitor visitor = new TestVisitor();
        List heads = run.getExecution().getCurrentHeads();
        scan.setup((Collection)heads);
        Assertions.assertEquals((int)(run.getExecution().getCurrentHeads().size() - 1), (int)scan.currentParallelStart.unvisited.size());
        scan.visitSimpleChunks((SimpleChunkVisitor)visitor, (ChunkFinder)labelFinder);
        TestVisitor.CallEntry parallelEnd = visitor.calls.get(0);
        Assertions.assertEquals((Object)((Object)TestVisitor.CallType.PARALLEL_END), (Object)((Object)parallelEnd.type));
        Assertions.assertEquals((Object)semaphoreNode.getId(), (Object)parallelEnd.getNodeId().toString(), (String)("Wrong End Node: (" + parallelEnd.getNodeId() + ")"));
        Assertions.assertEquals((Object)semaphoreNode.getId(), (Object)parallelEnd.getNodeId().toString());
        SemaphoreStep.success((String)(semaphoreName + "/1"), null);
        this.r.waitForCompletion((Run)run);
        this.sanityTestIterationAndVisiter(heads);
    }

    @Test
    void testParallelsWithDuplicateEvents() throws Exception {
        WorkflowJob job = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "ParallelInsanity");
        job.setDefinition((FlowDefinition)new CpsFlowDefinition("echo 'first stage'\nparallel left : {\n  echo 'run a bit'\n  echo 'run a bit more'\n  semaphore 'wait1'\n}, right : {\n  echo 'wozzle'\n  semaphore 'wait2'\n}\necho 'last stage'\necho \"last done\"\n", true));
        ForkScanner scan = new ForkScanner();
        NoOpChunkFinder labelFinder = new NoOpChunkFinder();
        WorkflowRun run = (WorkflowRun)job.scheduleBuild2(0, new Action[0]).getStartCondition().get();
        SemaphoreStep.waitForStart((String)"wait1/1", (Run)run);
        SemaphoreStep.waitForStart((String)"wait2/1", (Run)run);
        TestVisitor test = new TestVisitor();
        List heads = run.getExecution().getCurrentHeads();
        scan.setup((Collection)heads);
        scan.visitSimpleChunks((SimpleChunkVisitor)test, (ChunkFinder)labelFinder);
        SemaphoreStep.success((String)"wait1/1", null);
        SemaphoreStep.success((String)"wait2/1", null);
        this.r.waitForCompletion((Run)run);
        int atomEventCount = 0;
        int parallelBranchEndCount = 0;
        int parallelStartCount = 0;
        for (TestVisitor.CallEntry ce : test.calls) {
            switch (ce.type) {
                case ATOM_NODE: {
                    ++atomEventCount;
                    break;
                }
                case PARALLEL_BRANCH_END: {
                    ++parallelBranchEndCount;
                    break;
                }
                case PARALLEL_START: {
                    ++parallelStartCount;
                    break;
                }
            }
        }
        this.sanityTestIterationAndVisiter(heads);
        Assertions.assertEquals((int)10, (int)atomEventCount);
        Assertions.assertEquals((int)1, (int)parallelStartCount);
        Assertions.assertEquals((int)2, (int)parallelBranchEndCount);
    }

    @Test
    void testPartlyCompletedParallels() throws Exception {
        String jobScript = "echo 'first stage'\nparallel 'long' : { sleep 60; }, \n         'short': { sleep 2; }";
        ForkScanner scan = new ForkScanner();
        TestVisitor tv = new TestVisitor();
        WorkflowJob job = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "parallelTimes");
        job.setDefinition((FlowDefinition)new CpsFlowDefinition(jobScript, true));
        WorkflowRun run = (WorkflowRun)job.scheduleBuild2(0, new Action[0]).getStartCondition().get();
        Thread.sleep(4000L);
        FlowExecution exec = run.getExecution();
        List heads = exec.getCurrentHeads();
        scan.setup((Collection)heads);
        scan.visitSimpleChunks((SimpleChunkVisitor)tv, (ChunkFinder)new NoOpChunkFinder());
        FlowNode endNode = exec.getNode(tv.filteredCallsByType(TestVisitor.CallType.PARALLEL_END).get(0).getNodeId().toString());
        Assertions.assertEquals((Object)"sleep", (Object)endNode.getDisplayFunctionName());
        this.sanityTestIterationAndVisiter(heads);
        run.doKill();
    }

    @Test
    void testParallelCorrectEndNodeForVisitor() throws Exception {
        WorkflowJob jobPauseFirst = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "PauseFirst");
        jobPauseFirst.setDefinition((FlowDefinition)new CpsFlowDefinition("echo 'primero stage'\nparallel 'wait' : {sleep 1; semaphore 'wait1';},\n 'final': { echo 'succeed';}", true));
        WorkflowJob jobPauseSecond = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "PauseSecond");
        jobPauseSecond.setDefinition((FlowDefinition)new CpsFlowDefinition("echo 'primero stage'\nparallel 'success' : {echo 'succeed'},\n 'pause':{ sleep 1; semaphore 'wait2'; }\n", true));
        WorkflowJob jobPauseMiddle = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "PauseMiddle");
        jobPauseMiddle.setDefinition((FlowDefinition)new CpsFlowDefinition("echo 'primero stage'\nparallel 'success' : {echo 'succeed'},\n 'pause':{ sleep 1; semaphore 'wait3'; },\n 'final': { echo 'succeed-final';}", true));
        this.testParallelFindsLast(jobPauseFirst, "wait1");
        this.testParallelFindsLast(jobPauseSecond, "wait2");
        this.testParallelFindsLast(jobPauseMiddle, "wait3");
    }

    @Test
    void inProgressParallelInParallel() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.createProject(WorkflowJob.class);
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("stage('MyStage') {\n  parallel(\n    outerA: {\n      semaphore('outerA')\n    },\n    outerB: {\n      echo('outerB')\n    },\n    outerC: {\n      parallel(\n        innerA: {\n          semaphore('innerA')\n        },\n        innerB: {\n          echo('innerB')\n        }\n      )\n    }\n  )\n}\n", true));
        WorkflowRun b = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).waitForStart();
        SemaphoreStep.waitForStart((String)"outerA/1", (Run)b);
        SemaphoreStep.waitForStart((String)"innerA/1", (Run)b);
        ForkScanner scanner = new ForkScanner();
        this.sanityTestIterationAndVisiter(b.getExecution().getCurrentHeads());
        SemaphoreStep.success((String)"outerA/1", null);
        SemaphoreStep.success((String)"innerA/1", null);
        this.r.assertBuildStatusSuccess((Run)((WorkflowRun)this.r.waitForCompletion((Run)b)));
        this.sanityTestIterationAndVisiter(b.getExecution().getCurrentHeads());
        ForkScannerTest.assertBranchOrder(b.getExecution(), "innerB", "innerA", "outerC", "outerB", "outerA");
    }

    @Disabled(value="outerA gets skipped when iterating, see warning in ForkScanner Javadoc")
    @Test
    void inProgressParallelInParallelOneNestedBranch() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.createProject(WorkflowJob.class);
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("parallel(\n  'outerA': {\n    parallel(\n      'innerA': {\n        semaphore('innerA')\n      }\n    )\n  },\n  'outerB': {\n  }\n)", true));
        WorkflowRun b = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).waitForStart();
        SemaphoreStep.waitForStart((String)"innerA/1", (Run)b);
        this.sanityTestIterationAndVisiter(b.getExecution().getCurrentHeads());
        ForkScannerTest.assertBranchOrder(b.getExecution(), "innerA", "outerA", "outerB");
        SemaphoreStep.success((String)"innerA/1", null);
        this.r.assertBuildStatusSuccess((Run)((WorkflowRun)this.r.waitForCompletion((Run)b)));
        this.sanityTestIterationAndVisiter(b.getExecution().getCurrentHeads());
        ForkScannerTest.assertBranchOrder(b.getExecution(), "outerB", "innerA", "outerA");
    }

    @Disabled(value="Actual ordering is all complete branches and then all incomplete branches, see warning in ForkScanner Javadoc")
    @Test
    void parallelBranchOrdering() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.createProject(WorkflowJob.class);
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("parallel(\n  '1': { echo '1' },\n  '2': { semaphore('2') },\n  '3': { echo '3' },\n  '4': { semaphore('4') },\n  '5': { echo '5' },\n)", true));
        WorkflowRun b = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).waitForStart();
        SemaphoreStep.waitForStart((String)"2/1", (Run)b);
        SemaphoreStep.waitForStart((String)"4/1", (Run)b);
        this.sanityTestIterationAndVisiter(b.getExecution().getCurrentHeads());
        ForkScannerTest.assertBranchOrder(b.getExecution(), "5", "4", "3", "2", "1");
        SemaphoreStep.success((String)"2/1", null);
        SemaphoreStep.success((String)"4/1", null);
        this.r.assertBuildStatusSuccess((Run)((WorkflowRun)this.r.waitForCompletion((Run)b)));
        this.sanityTestIterationAndVisiter(b.getExecution().getCurrentHeads());
        ForkScannerTest.assertBranchOrder(b.getExecution(), "5", "4", "3", "2", "1");
    }

    private static void assertBranchOrder(FlowExecution execution, String ... expectedBranchNames) {
        ForkScanner scanner = new ForkScanner();
        scanner.setup((Collection)execution.getCurrentHeads());
        String[] branches = (String[])StreamSupport.stream(scanner.spliterator(), false).map(n -> (ThreadNameAction)n.getPersistentAction(ThreadNameAction.class)).filter(Objects::nonNull).map(ThreadNameAction::getThreadName).toList().toArray(String[]::new);
        MatcherAssert.assertThat((Object)branches, (Matcher)Matchers.equalTo((Object)expectedBranchNames));
    }
}

