/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.flow;

import com.google.common.util.concurrent.ListenableFuture;
import hudson.AbortException;
import hudson.ExtensionList;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.StringParameterDefinition;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import hudson.model.queue.QueueTaskFuture;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import jenkins.model.Jenkins;
import org.awaitility.Awaitility;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionList;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.pickles.Pickle;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.StepExecutions;
import org.jenkinsci.plugins.workflow.support.pickles.SingleTypedPickleFactory;
import org.jenkinsci.plugins.workflow.support.pickles.TryRepeatedly;
import org.jenkinsci.plugins.workflow.test.steps.SemaphoreStep;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.jvnet.hudson.test.LogRecorder;
import org.jvnet.hudson.test.MemoryAssert;
import org.jvnet.hudson.test.TestExtension;
import org.jvnet.hudson.test.junit.jupiter.BuildWatcherExtension;
import org.jvnet.hudson.test.junit.jupiter.JenkinsSessionExtension;
import org.jvnet.hudson.test.recipes.LocalData;
import org.kohsuke.stapler.DataBoundConstructor;

class FlowExecutionListTest {
    @RegisterExtension
    private static final BuildWatcherExtension buildWatcher = new BuildWatcherExtension();
    @RegisterExtension
    private final JenkinsSessionExtension sessions = new JenkinsSessionExtension();
    private final LogRecorder logging = new LogRecorder().record(FlowExecutionList.class, Level.FINE);

    FlowExecutionListTest() {
    }

    @Test
    void simultaneousRegister() throws Throwable {
        this.sessions.then(j -> {
            WorkflowJob p = (WorkflowJob)j.createProject(WorkflowJob.class, "p");
            p.setDefinition((FlowDefinition)new CpsFlowDefinition("", true));
            j.buildAndAssertSuccess((Job)p);
            p.setDefinition((FlowDefinition)new CpsFlowDefinition("echo params.key; sleep 5", true));
            p.addProperty((JobProperty)new ParametersDefinitionProperty(new ParameterDefinition[]{new StringParameterDefinition("key", null)}));
            QueueTaskFuture f1 = p.scheduleBuild2(0, new Action[]{new ParametersAction(new ParameterValue[]{new StringParameterValue("key", "one")})});
            QueueTaskFuture f2 = p.scheduleBuild2(0, new Action[]{new ParametersAction(new ParameterValue[]{new StringParameterValue("key", "two")})});
            f1.waitForStart();
            f2.waitForStart();
            WorkflowRun b2 = p.getBuildByNumber(2);
            Assertions.assertNotNull((Object)b2);
            WorkflowRun b3 = p.getBuildByNumber(3);
            Assertions.assertNotNull((Object)b3);
            j.waitForMessage("Sleeping for ", (Run)b2);
            j.waitForMessage("Sleeping for ", (Run)b3);
        });
        this.sessions.then(j -> {
            WorkflowJob p = (WorkflowJob)j.jenkins.getItemByFullName("p", WorkflowJob.class);
            WorkflowRun b2 = p.getBuildByNumber(2);
            WorkflowRun b3 = p.getBuildByNumber(3);
            j.assertBuildStatusSuccess((Run)((WorkflowRun)j.waitForCompletion((Run)b2)));
            j.assertBuildStatusSuccess((Run)((WorkflowRun)j.waitForCompletion((Run)b3)));
        });
    }

    @Test
    void forceLoadRunningExecutionsAfterRestart() throws Throwable {
        this.logging.capture(50);
        this.sessions.then(r -> {
            WorkflowJob p = (WorkflowJob)r.jenkins.createProject(WorkflowJob.class, "p");
            p.setDefinition((FlowDefinition)new CpsFlowDefinition("semaphore('wait')", true));
            WorkflowRun b = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).waitForStart();
            SemaphoreStep.waitForStart((String)"wait/1", (Run)b);
        });
        this.sessions.then(r -> {
            Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(() -> ((LogRecorder)this.logging).getMessages(), Matchers.hasItem((Matcher)Matchers.containsString((String)"Will resume [org.jenkinsci.plugins.workflow.test.steps.SemaphoreStep")));
            WorkflowJob p = (WorkflowJob)r.jenkins.getItemByFullName("p", WorkflowJob.class);
            SemaphoreStep.success((String)"wait/1", null);
            WorkflowRun b = p.getBuildByNumber(1);
            r.waitForCompletion((Run)b);
            r.assertBuildStatus(Result.SUCCESS, (Run)b);
        });
    }

    @Test
    void resumeStepExecutions() throws Throwable {
        this.sessions.then(r -> {
            WorkflowJob p = (WorkflowJob)r.jenkins.createProject(WorkflowJob.class, "p");
            p.setDefinition((FlowDefinition)new CpsFlowDefinition("noResume()", true));
            WorkflowRun b = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).waitForStart();
            r.waitForMessage("Starting non-resumable step", (Run)b);
            FlowExecutionList.get().unregister(b.asFlowExecutionOwner());
        });
        this.sessions.then(r -> {
            WorkflowJob p = (WorkflowJob)r.jenkins.getItemByFullName("p", WorkflowJob.class);
            WorkflowRun b = p.getBuildByNumber(1);
            r.waitForCompletion((Run)b);
            r.assertBuildStatus(Result.FAILURE, (Run)b);
            r.assertLogContains("Unable to resume NonResumableStep", (Run)b);
        });
    }

    @LocalData
    @Test
    void resumeStepExecutionsWithCorruptFlowGraphWithCycle() throws Throwable {
        this.logging.capture(50);
        this.sessions.then(r -> {
            WorkflowJob p = (WorkflowJob)r.jenkins.getItemByFullName("test0", WorkflowJob.class);
            WorkflowRun b = p.getBuildByNumber(1);
            r.waitForCompletion((Run)b);
            MatcherAssert.assertThat((Object)this.logging.getMessages(), (Matcher)Matchers.hasItem((Matcher)Matchers.containsString((String)"Unable to compute enclosing blocks")));
            List<String> loggedExceptions = this.logging.getRecords().stream().map(LogRecord::getThrown).filter(Objects::nonNull).map(Throwable::toString).toList();
            MatcherAssert.assertThat(loggedExceptions, (Matcher)Matchers.hasItem((Matcher)Matchers.containsString((String)"Cycle in flow graph")));
        });
    }

    @Test
    void stepExecutionIteratorDoesNotLeakBuildsWhenCpsVmIsStuck() throws Throwable {
        ForkJoinPool.commonPool().execute(() -> {});
        this.sessions.then(r -> {
            WorkflowJob notStuck = (WorkflowJob)r.createProject(WorkflowJob.class, "not-stuck");
            notStuck.setDefinition((FlowDefinition)new CpsFlowDefinition("semaphore 'wait'", true));
            WorkflowRun notStuckBuild = (WorkflowRun)notStuck.scheduleBuild2(0, new Action[0]).waitForStart();
            SemaphoreStep.waitForStart((String)"wait/1", (Run)notStuckBuild);
            WeakReference<WorkflowRun> notStuckBuildRef = new WeakReference<WorkflowRun>(notStuckBuild);
            WorkflowJob stuck = (WorkflowJob)r.createProject(WorkflowJob.class, "stuck");
            stuck.setDefinition((FlowDefinition)new CpsFlowDefinition("blockSynchronously 'stuck'", false));
            WorkflowRun stuckBuild = (WorkflowRun)stuck.scheduleBuild2(0, new Action[0]).waitForStart();
            Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(() -> SynchronousBlockingStep.isStarted("stuck"));
            StepExecution.acceptAll(e -> {});
            SemaphoreStep.success((String)"wait/1", null);
            r.waitForCompletion((Run)notStuckBuild);
            notStuck.getLazyBuildMixIn().removeRun((Run)notStuckBuild);
            notStuckBuild = null;
            Jenkins.get().getQueue().clearLeftItems();
            MemoryAssert.assertGC(notStuckBuildRef, (boolean)false);
            SynchronousBlockingStep.unblock("stuck");
            r.waitForCompletion((Run)stuckBuild);
        });
    }

    @Test
    void stepExecutionIteratorDoesNotLeakBuildsWhenProgramPromiseIsStuck() throws Throwable {
        ForkJoinPool.commonPool().execute(() -> {});
        this.sessions.then(r -> {
            WorkflowJob stuck = (WorkflowJob)r.createProject(WorkflowJob.class, "stuck");
            stuck.setDefinition((FlowDefinition)new CpsFlowDefinition("def x = new org.jenkinsci.plugins.workflow.flow.FlowExecutionListTest.StuckPickle.Marker()\nsemaphore 'stuckWait'\necho x.getClass().getName()", false));
            WorkflowRun stuckBuild = (WorkflowRun)stuck.scheduleBuild2(0, new Action[0]).waitForStart();
            SemaphoreStep.waitForStart((String)"stuckWait/1", (Run)stuckBuild);
        });
        this.sessions.then(r -> {
            WorkflowJob notStuck = (WorkflowJob)r.createProject(WorkflowJob.class, "not-stuck");
            notStuck.setDefinition((FlowDefinition)new CpsFlowDefinition("semaphore 'wait'", true));
            WorkflowRun notStuckBuild = (WorkflowRun)notStuck.scheduleBuild2(0, new Action[0]).waitForStart();
            SemaphoreStep.waitForStart((String)"wait/1", (Run)notStuckBuild);
            WeakReference<WorkflowRun> notStuckBuildRef = new WeakReference<WorkflowRun>(notStuckBuild);
            WorkflowJob stuck = (WorkflowJob)r.jenkins.getItemByFullName("stuck", WorkflowJob.class);
            WorkflowRun stuckBuild = stuck.getBuildByNumber(1);
            StepExecution.acceptAll(e -> {});
            SemaphoreStep.success((String)"wait/1", null);
            r.waitForCompletion((Run)notStuckBuild);
            notStuck.getLazyBuildMixIn().removeRun((Run)notStuckBuild);
            notStuckBuild = null;
            Jenkins.get().getQueue().clearLeftItems();
            MemoryAssert.assertGC(notStuckBuildRef, (boolean)false);
            r.waitForMessage("Still trying to load StuckPickle for", (Run)stuckBuild);
            ((StuckPickle.Factory)((Object)((Object)ExtensionList.lookupSingleton(StuckPickle.Factory.class)))).resolved = new StuckPickle.Marker();
            SemaphoreStep.success((String)"stuckWait/1", null);
            r.waitForCompletion((Run)stuckBuild);
        });
    }

    public static class StuckPickle
    extends Pickle {
        public ListenableFuture<Marker> rehydrate(final FlowExecutionOwner owner) {
            return new TryRepeatedly<Marker>(this, 1){
                final /* synthetic */ StuckPickle this$0;
                {
                    this.this$0 = this$0;
                    super(delay);
                }

                protected Marker tryResolve() {
                    return ((Factory)((Object)ExtensionList.lookupSingleton(Factory.class))).resolved;
                }

                protected FlowExecutionOwner getOwner() {
                    return owner;
                }

                public String toString() {
                    return "StuckPickle for " + String.valueOf(owner);
                }
            };
        }

        @TestExtension(value={"stepExecutionIteratorDoesNotLeakBuildsWhenProgramPromiseIsStuck"})
        public static final class Factory
        extends SingleTypedPickleFactory<Marker> {
            public Marker resolved;

            protected Pickle pickle(Marker object) {
                return new StuckPickle();
            }
        }

        public static class Marker {
        }
    }

    public static class SynchronousBlockingStep
    extends Step
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final Map<String, State> blocked = new HashMap<String, State>();
        private final String id;

        @DataBoundConstructor
        public SynchronousBlockingStep(String id) {
            this.id = id;
            if (blocked.put(id, State.NOT_STARTED) != null) {
                throw new IllegalArgumentException("Attempting to reuse ID: " + id);
            }
        }

        public StepExecution start(StepContext context) throws Exception {
            return StepExecutions.synchronous((StepContext)context, c -> {
                blocked.put(this.id, State.BLOCKED);
                ((TaskListener)c.get(TaskListener.class)).getLogger().println(this.id + " blocked");
                while (blocked.get(this.id) == State.BLOCKED) {
                    Thread.sleep(100L);
                }
                ((TaskListener)c.get(TaskListener.class)).getLogger().println(this.id + " unblocked ");
                return null;
            });
        }

        public static boolean isStarted(String id) {
            State state = blocked.get(id);
            return state != null && state != State.NOT_STARTED;
        }

        public static void unblock(String id) {
            blocked.put(id, State.UNBLOCKED);
        }

        private static enum State {
            NOT_STARTED,
            BLOCKED,
            UNBLOCKED;

        }

        @TestExtension(value={"stepExecutionIteratorDoesNotLeakBuildsWhenCpsVmIsStuck"})
        public static class DescriptorImpl
        extends StepDescriptor {
            public Set<? extends Class<?>> getRequiredContext() {
                return Collections.singleton(TaskListener.class);
            }

            public String getFunctionName() {
                return "blockSynchronously";
            }
        }
    }

    public static class NonResumableStep
    extends Step
    implements Serializable {
        private static final long serialVersionUID = 1L;

        @DataBoundConstructor
        public NonResumableStep() {
        }

        public StepExecution start(StepContext sc) {
            return new ExecutionImpl(sc);
        }

        private static class ExecutionImpl
        extends StepExecution
        implements Serializable {
            private static final long serialVersionUID = 1L;

            private ExecutionImpl(StepContext sc) {
                super(sc);
            }

            public boolean start() throws Exception {
                ((TaskListener)this.getContext().get(TaskListener.class)).getLogger().println("Starting non-resumable step");
                return false;
            }

            public void onResume() {
                this.getContext().onFailure((Throwable)new AbortException("Unable to resume NonResumableStep"));
            }
        }

        @TestExtension
        public static class DescriptorImpl
        extends StepDescriptor {
            public Set<? extends Class<?>> getRequiredContext() {
                return Collections.singleton(TaskListener.class);
            }

            public String getFunctionName() {
                return "noResume";
            }
        }
    }
}

