/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.flow;

import hudson.Functions;
import hudson.model.Descriptor;
import hudson.model.User;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.security.AuthorizationStrategy;
import hudson.security.Permission;
import hudson.security.SecurityRealm;
import java.util.Collection;
import java.util.Optional;
import jenkins.model.Jenkins;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jenkinsci.plugins.workflow.flow.FlowDurabilityHint;
import org.jenkinsci.plugins.workflow.flow.GlobalDefaultFlowDurabilityLevel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.jvnet.hudson.test.MockAuthorizationStrategy;
import org.jvnet.hudson.test.junit.jupiter.JenkinsSessionExtension;

class DurabilityBasicsTest {
    @RegisterExtension
    private final JenkinsSessionExtension sessions = new JenkinsSessionExtension();

    DurabilityBasicsTest() {
    }

    @Test
    void configRoundTrip() throws Throwable {
        this.sessions.then(j -> {
            GlobalDefaultFlowDurabilityLevel.DescriptorImpl level = (GlobalDefaultFlowDurabilityLevel.DescriptorImpl)j.jenkins.getExtensionList(GlobalDefaultFlowDurabilityLevel.DescriptorImpl.class).get(0);
            level.setDurabilityHint(FlowDurabilityHint.PERFORMANCE_OPTIMIZED);
            j.configRoundtrip();
            Assertions.assertEquals((Object)FlowDurabilityHint.PERFORMANCE_OPTIMIZED, (Object)level.getDurabilityHint());
            level.setDurabilityHint(null);
            j.configRoundtrip();
            Assertions.assertNull((Object)level.getDurabilityHint());
            level.setDurabilityHint(FlowDurabilityHint.PERFORMANCE_OPTIMIZED);
            Assertions.assertEquals((Object)FlowDurabilityHint.PERFORMANCE_OPTIMIZED, (Object)level.getDurabilityHint());
        });
        this.sessions.then(j -> {
            GlobalDefaultFlowDurabilityLevel.DescriptorImpl level = (GlobalDefaultFlowDurabilityLevel.DescriptorImpl)j.jenkins.getExtensionList(GlobalDefaultFlowDurabilityLevel.DescriptorImpl.class).get(0);
            Assertions.assertEquals((Object)FlowDurabilityHint.PERFORMANCE_OPTIMIZED, (Object)level.getDurabilityHint());
        });
    }

    @Test
    void defaultHandling() throws Throwable {
        this.sessions.then(j -> {
            Assertions.assertEquals((Object)GlobalDefaultFlowDurabilityLevel.SUGGESTED_DURABILITY_HINT, (Object)GlobalDefaultFlowDurabilityLevel.getDefaultDurabilityHint());
            GlobalDefaultFlowDurabilityLevel.DescriptorImpl level = (GlobalDefaultFlowDurabilityLevel.DescriptorImpl)j.jenkins.getExtensionList(GlobalDefaultFlowDurabilityLevel.DescriptorImpl.class).get(0);
            level.setDurabilityHint(FlowDurabilityHint.PERFORMANCE_OPTIMIZED);
            Assertions.assertEquals((Object)FlowDurabilityHint.PERFORMANCE_OPTIMIZED, (Object)GlobalDefaultFlowDurabilityLevel.getDefaultDurabilityHint());
        });
    }

    @Test
    void managePermissionShouldAccessGlobalConfig() throws Throwable {
        this.sessions.then(j -> {
            Collection descriptors;
            String USER = "user";
            String MANAGER = "manager";
            j.jenkins.setSecurityRealm((SecurityRealm)j.createDummySecurityRealm());
            j.jenkins.setAuthorizationStrategy((AuthorizationStrategy)new MockAuthorizationStrategy().grant(new Permission[]{Jenkins.READ}).everywhere().to(new String[]{"user"}).grant(new Permission[]{Jenkins.READ}).everywhere().to(new String[]{"manager"}).grant(new Permission[]{Jenkins.MANAGE}).everywhere().to(new String[]{"manager"}));
            try (ACLContext c = ACL.as((User)User.getById((String)"user", (boolean)true));){
                descriptors = Functions.getSortedDescriptorsForGlobalConfigUnclassified();
                MatcherAssert.assertThat((String)"Global configuration should not be accessible to READ users", (Object)descriptors, (Matcher)Matchers.empty());
            }
            c = ACL.as((User)User.getById((String)"manager", (boolean)true));
            try {
                descriptors = Functions.getSortedDescriptorsForGlobalConfigUnclassified();
                Optional<Descriptor> found = descriptors.stream().filter(descriptor -> descriptor instanceof GlobalDefaultFlowDurabilityLevel.DescriptorImpl).findFirst();
                Assertions.assertTrue((boolean)found.isPresent(), (String)"Global configuration should be accessible to MANAGE users");
            }
            finally {
                if (c != null) {
                    c.close();
                }
            }
        });
    }
}

