/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.actions;

import groovy.lang.MissingMethodException;
import hudson.FilePath;
import hudson.Functions;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.ProxyException;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import jenkins.MasterToSlaveFileCallable;
import org.codehaus.groovy.runtime.NullObject;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jenkinsci.plugins.workflow.actions.ErrorAction;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.FlowGraphWalker;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.StepExecutions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.jvnet.hudson.test.LogRecorder;
import org.jvnet.hudson.test.TestExtension;
import org.jvnet.hudson.test.junit.jupiter.BuildWatcherExtension;
import org.jvnet.hudson.test.junit.jupiter.InboundAgentExtension;
import org.jvnet.hudson.test.junit.jupiter.JenkinsSessionExtension;
import org.kohsuke.stapler.DataBoundConstructor;

class ErrorActionTest {
    @RegisterExtension
    private static final BuildWatcherExtension buildWatcher = new BuildWatcherExtension();
    @RegisterExtension
    private final JenkinsSessionExtension rr = new JenkinsSessionExtension();
    @RegisterExtension
    private final InboundAgentExtension agents = new InboundAgentExtension();
    private final LogRecorder logging = new LogRecorder().record(ErrorAction.class, Level.FINE);

    ErrorActionTest() {
    }

    private List<ErrorAction> extractErrorActions(FlowExecution exec) {
        ArrayList<ErrorAction> ret = new ArrayList<ErrorAction>();
        FlowGraphWalker walker = new FlowGraphWalker(exec);
        for (FlowNode n : walker) {
            ErrorAction e = (ErrorAction)n.getAction(ErrorAction.class);
            if (e == null) continue;
            ret.add(e);
        }
        return ret;
    }

    @Test
    void simpleException() throws Throwable {
        this.rr.then(r -> {
            String EXPECTED = "For testing purpose";
            WorkflowJob job = (WorkflowJob)r.jenkins.createProject(WorkflowJob.class, "p");
            job.setDefinition((FlowDefinition)new CpsFlowDefinition(String.format("node {\n  throw new Exception('%s');\n}", "For testing purpose"), true));
            WorkflowRun b = (WorkflowRun)r.assertBuildStatus(Result.FAILURE, (Run)((WorkflowRun)job.scheduleBuild2(0, new Action[0]).get()));
            List<ErrorAction> errorActionList = this.extractErrorActions(b.asFlowExecutionOwner().get());
            MatcherAssert.assertThat(errorActionList, (Matcher)Matchers.not((Matcher)Matchers.empty()));
            for (ErrorAction e : errorActionList) {
                Assertions.assertEquals(Exception.class, e.getError().getClass());
                Assertions.assertEquals((Object)"For testing purpose", (Object)e.getError().getMessage());
            }
        });
    }

    @Test
    void unserializableForSecurityReason() throws Throwable {
        this.rr.then(r -> {
            String FAILING_EXPRESSION = "(2 + 2) == 5";
            WorkflowJob job = (WorkflowJob)r.jenkins.createProject(WorkflowJob.class, "p");
            job.setDefinition((FlowDefinition)new CpsFlowDefinition(String.format("node {\n  assert %s;\n}", "(2 + 2) == 5"), true));
            WorkflowRun b = (WorkflowRun)r.assertBuildStatus(Result.FAILURE, (Run)((WorkflowRun)job.scheduleBuild2(0, new Action[0]).get()));
            r.assertLogContains("(2 + 2) == 5", (Run)b);
            List<ErrorAction> errorActionList = this.extractErrorActions(b.asFlowExecutionOwner().get());
            MatcherAssert.assertThat(errorActionList, (Matcher)Matchers.not((Matcher)Matchers.empty()));
            for (ErrorAction e : errorActionList) {
                Assertions.assertEquals(ProxyException.class, e.getError().getClass());
            }
        });
    }

    @Test
    void wrappedUnserializableException() throws Throwable {
        this.rr.then(r -> {
            WorkflowJob p = (WorkflowJob)r.jenkins.createProject(WorkflowJob.class, "p");
            p.setDefinition((FlowDefinition)new CpsFlowDefinition("catchError {\n  try {\n    try {\n      throw new NullPointerException('oops')\n    } catch (e) {\n      throw new org.codehaus.groovy.runtime.InvokerInvocationException(e)\n    }\n  } catch (e) {\n    throw new IllegalArgumentException(e)\n  }\n}\necho 'got to the end'", false));
            WorkflowRun b = (WorkflowRun)r.assertBuildStatus(Result.FAILURE, (Run)((WorkflowRun)p.scheduleBuild2(0, new Action[0]).get()));
            r.assertLogContains("got to the end", (Run)b);
            r.assertLogContains("java.lang.NullPointerException: oops", (Run)b);
        });
    }

    @Test
    void nestedFieldUnserializable() throws Throwable {
        this.rr.then(r -> {
            WorkflowJob p = (WorkflowJob)r.jenkins.createProject(WorkflowJob.class, "p");
            p.setDefinition((FlowDefinition)new CpsFlowDefinition("catchError {\n  throw new " + X.class.getCanonicalName() + "()\n}\necho 'got to the end'", false));
            WorkflowRun b = (WorkflowRun)r.assertBuildStatus(Result.FAILURE, (Run)((WorkflowRun)p.scheduleBuild2(0, new Action[0]).get()));
            r.assertLogContains("got to the end", (Run)b);
            r.assertLogContains(X.class.getName(), (Run)b);
            List<ErrorAction> errorActionList = this.extractErrorActions(b.asFlowExecutionOwner().get());
            MatcherAssert.assertThat(errorActionList, (Matcher)Matchers.not((Matcher)Matchers.empty()));
            for (ErrorAction e : errorActionList) {
                Assertions.assertEquals(ProxyException.class, e.getError().getClass());
            }
        });
    }

    @Test
    void userDefinedError() throws Throwable {
        this.rr.then(r -> {
            WorkflowJob p = (WorkflowJob)r.createProject(WorkflowJob.class);
            p.setDefinition((FlowDefinition)new CpsFlowDefinition("class MyException extends Exception {\n  MyException(String message) { super(message) }\n}\nthrow new MyException('test')\n", true));
            WorkflowRun b = (WorkflowRun)r.assertBuildStatus(Result.FAILURE, (Future)p.scheduleBuild2(0, new Action[0]));
            MatcherAssert.assertThat((Object)b.getExecution().getCauseOfFailure(), (Matcher)Matchers.instanceOf(ProxyException.class));
        });
    }

    @Test
    void missingPropertyExceptionMemoryLeak() throws Throwable {
        this.rr.then(r -> {
            WorkflowJob p = (WorkflowJob)r.createProject(WorkflowJob.class);
            p.setDefinition((FlowDefinition)new CpsFlowDefinition("FOO", false));
            WorkflowRun b = (WorkflowRun)r.assertBuildStatus(Result.FAILURE, (Future)p.scheduleBuild2(0, new Action[0]));
            MatcherAssert.assertThat((Object)b.getExecution().getCauseOfFailure(), (Matcher)Matchers.instanceOf(ProxyException.class));
        });
    }

    @Test
    void findOriginOfAsyncErrorAcrossRestart() throws Throwable {
        String name = "restart";
        AtomicReference origin = new AtomicReference();
        this.rr.then(r -> {
            String script = Functions.isWindows() ? "bat 'exit 1'" : "sh 'exit 1'";
            WorkflowJob p = (WorkflowJob)r.createProject(WorkflowJob.class, name);
            p.setDefinition((FlowDefinition)new CpsFlowDefinition("parallel(one: { node {" + script + "} }, two: { node {" + script + "} })", true));
            WorkflowRun b = (WorkflowRun)r.buildAndAssertStatus(Result.FAILURE, (Job)p);
            FlowNode originNode = ErrorAction.findOrigin((Throwable)b.getExecution().getCauseOfFailure(), (FlowExecution)b.getExecution());
            origin.set(originNode.getId());
        });
        this.rr.then(r -> {
            WorkflowJob p = (WorkflowJob)r.jenkins.getItemByFullName(name, WorkflowJob.class);
            WorkflowRun b = p.getLastBuild();
            FlowNode originNode = ErrorAction.findOrigin((Throwable)b.getExecution().getCauseOfFailure(), (FlowExecution)b.getExecution());
            Assertions.assertEquals(origin.get(), (Object)originNode.getId());
        });
    }

    @Test
    void findOriginOfSyncErrorAcrossRestart() throws Throwable {
        String name = "restart";
        AtomicReference origin = new AtomicReference();
        this.rr.then(r -> {
            WorkflowJob p = (WorkflowJob)r.createProject(WorkflowJob.class, name);
            p.setDefinition((FlowDefinition)new CpsFlowDefinition("parallel(one: { error 'one' }, two: { error 'two' })", true));
            WorkflowRun b = (WorkflowRun)r.buildAndAssertStatus(Result.FAILURE, (Job)p);
            FlowNode originNode = ErrorAction.findOrigin((Throwable)b.getExecution().getCauseOfFailure(), (FlowExecution)b.getExecution());
            origin.set(originNode.getId());
        });
        this.rr.then(r -> {
            WorkflowJob p = (WorkflowJob)r.jenkins.getItemByFullName(name, WorkflowJob.class);
            WorkflowRun b = p.getLastBuild();
            FlowNode originNode = ErrorAction.findOrigin((Throwable)b.getExecution().getCauseOfFailure(), (FlowExecution)b.getExecution());
            Assertions.assertEquals(origin.get(), (Object)originNode.getId());
        });
    }

    @Test
    void findOriginFromBodyExecutionCallback() throws Throwable {
        this.rr.then(r -> {
            this.agents.createAgent(r, "remote");
            WorkflowJob p = (WorkflowJob)r.createProject(WorkflowJob.class);
            p.setDefinition((FlowDefinition)new CpsFlowDefinition("callsFindOrigin {node('remote') {fails()}}", true));
            WorkflowRun b = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).waitForStart();
            r.waitForMessage("Acting slowly in ", (Run)b);
            this.agents.stop("remote");
            r.assertBuildStatus(Result.FAILURE, (Run)((WorkflowRun)r.waitForCompletion((Run)b)));
            r.assertLogContains("Found in: fails", (Run)b);
        });
    }

    @Test
    void cyclicErrorsAreSupported() throws Throwable {
        Exception cyclic1 = new Exception();
        Exception cyclic2 = new Exception(cyclic1);
        cyclic1.initCause(cyclic2);
        Assertions.assertNotNull((Object)new ErrorAction((Throwable)cyclic1));
        Assertions.assertNotNull((Object)new ErrorAction((Throwable)cyclic2));
    }

    @Test
    void unserializableCyclicErrorsAreSupported() throws Throwable {
        MissingMethodException unserializable = new MissingMethodException("thisMethodDoesNotExist", String.class, new Object[0]);
        Exception cyclic = new Exception((Throwable)unserializable);
        unserializable.initCause(cyclic);
        Assertions.assertNotNull((Object)new ErrorAction((Throwable)unserializable));
        Assertions.assertNotNull((Object)new ErrorAction((Throwable)cyclic));
    }

    public static class X
    extends Exception {
        final NullObject nil = NullObject.getNullObject();
    }

    public static final class FailingStep
    extends Step {
        @DataBoundConstructor
        public FailingStep() {
        }

        public StepExecution start(StepContext context) throws Exception {
            return StepExecutions.synchronousNonBlockingVoid((StepContext)context, c -> ((FilePath)c.get(FilePath.class)).act((FilePath.FileCallable)new Sleep((TaskListener)c.get(TaskListener.class))));
        }

        private static final class Sleep
        extends MasterToSlaveFileCallable<Void> {
            private final TaskListener l;

            Sleep(TaskListener l) {
                this.l = l;
            }

            public Void invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
                this.l.getLogger().println("Acting slowly in " + String.valueOf(f));
                this.l.getLogger().flush();
                Thread.sleep(Long.MAX_VALUE);
                return null;
            }
        }

        @TestExtension(value={"findOriginFromBodyExecutionCallback"})
        public static final class DescriptorImpl
        extends StepDescriptor {
            public String getFunctionName() {
                return "fails";
            }

            public Set<? extends Class<?>> getRequiredContext() {
                return Set.of(FilePath.class);
            }
        }
    }

    public static final class WrapperStep
    extends Step {
        @DataBoundConstructor
        public WrapperStep() {
        }

        public StepExecution start(StepContext context) throws Exception {
            return new ExecutionImpl(context);
        }

        private static final class ExecutionImpl
        extends StepExecution {
            ExecutionImpl(StepContext context) {
                super(context);
            }

            public boolean start() throws Exception {
                this.getContext().newBodyInvoker().withCallback((BodyExecutionCallback)new Callback()).start();
                return false;
            }
        }

        @TestExtension(value={"findOriginFromBodyExecutionCallback"})
        public static final class DescriptorImpl
        extends StepDescriptor {
            public String getFunctionName() {
                return "callsFindOrigin";
            }

            public Set<? extends Class<?>> getRequiredContext() {
                return Set.of();
            }

            public boolean takesImplicitBlockArgument() {
                return true;
            }
        }

        private static class Callback
        extends BodyExecutionCallback {
            private Callback() {
            }

            public void onSuccess(StepContext context, Object result) {
                context.onSuccess(result);
            }

            public void onFailure(StepContext context, Throwable t) {
                block2: {
                    try {
                        TaskListener l = (TaskListener)context.get(TaskListener.class);
                        Functions.printStackTrace((Throwable)t, (PrintWriter)l.error("Original failure:"));
                        l.getLogger().println("Found in: " + ErrorAction.findOrigin((Throwable)t, (FlowExecution)((FlowExecution)context.get(FlowExecution.class))).getDisplayFunctionName());
                    }
                    catch (Exception x) {
                        if ($assertionsDisabled) break block2;
                        throw new AssertionError((Object)x);
                    }
                }
                context.onFailure(t);
            }
        }
    }
}

