/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.log;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.FutureCallback;
import hudson.console.ConsoleLogFilter;
import hudson.console.LineTransformationOutputStream;
import hudson.model.AbstractBuild;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import jenkins.security.MasterToSlaveCallable;
import jenkins.util.JenkinsJVM;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.log.TaskListenerDecorator;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.BuildWatcher;
import org.jvnet.hudson.test.For;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.TestExtension;
import org.kohsuke.stapler.DataBoundConstructor;

@For(value={TaskListenerDecorator.class})
public class TaskListenerDecoratorOrderTest {
    @ClassRule
    public static BuildWatcher buildWatcher = new BuildWatcher();
    @Rule
    public JenkinsRule r = new JenkinsRule();

    @Test
    public void verifyTaskListenerDecoratorOrder() throws Exception {
        this.r.createSlave("remote", null, null);
        WorkflowJob p = (WorkflowJob)this.r.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("filter {node('remote') {remotePrint()}}", true));
        WorkflowRun b = (WorkflowRun)this.r.buildAndAssertSuccess((Job)p);
        this.r.assertLogContains("[ApplyOrderDecoratorFactory: job/p/1/] Started", (Run)b);
        this.r.assertLogContains("[ApplyOrderDecoratorFactory: job/p/1/] [StepLevelDecorator] Running on remote in", (Run)b);
        this.r.assertLogContains("[ApplyOrderDecoratorFactory: job/p/1/ via remote] [StepLevelDecorator via remote] printed a message on master=false", (Run)b);
        ApplyOrderDecoratorFactory muteOrderDecoratorFactory = (ApplyOrderDecoratorFactory)this.r.jenkins.getExtensionList(TaskListenerDecorator.Factory.class).get(ApplyOrderDecoratorFactory.class);
        muteOrderDecoratorFactory.applyFirst = false;
        b = (WorkflowRun)this.r.buildAndAssertSuccess((Job)p);
        this.r.assertLogContains("[StepLevelDecorator] [ApplyOrderDecoratorFactory: job/p/2/] Running", (Run)b);
        this.r.assertLogContains("[StepLevelDecorator via remote] [ApplyOrderDecoratorFactory: job/p/2/ via remote] printed a message on master=false", (Run)b);
    }

    @TestExtension
    public static final class ApplyOrderDecoratorFactory
    implements TaskListenerDecorator.Factory {
        private boolean applyFirst = true;

        public TaskListenerDecorator of(FlowExecutionOwner owner) {
            try {
                return new DecoratorImpl("ApplyOrderDecoratorFactory: " + owner.getUrl());
            }
            catch (IOException x) {
                throw new AssertionError((Object)x);
            }
        }

        protected void setApplyFirst(boolean applyFirst) {
            this.applyFirst = applyFirst;
        }

        public boolean isAppliedBeforeMainDecorator() {
            return this.applyFirst;
        }
    }

    public static final class RemotePrintStep
    extends Step {
        @DataBoundConstructor
        public RemotePrintStep() {
        }

        public StepExecution start(StepContext context) throws Exception {
            return new Execution(context);
        }

        private static final class Execution
        extends SynchronousNonBlockingStepExecution<Void> {
            private static final long serialVersionUID = 1L;

            Execution(StepContext context) {
                super(context);
            }

            protected Void run() throws Exception {
                return (Void)((Node)this.getContext().get(Node.class)).getChannel().call((Callable)new PrintCallable((TaskListener)this.getContext().get(TaskListener.class)));
            }
        }

        @TestExtension
        public static final class DescriptorImpl
        extends StepDescriptor {
            public Set<? extends Class<?>> getRequiredContext() {
                return ImmutableSet.of(Node.class, TaskListener.class);
            }

            public String getFunctionName() {
                return "remotePrint";
            }
        }

        private static final class PrintCallable
        extends MasterToSlaveCallable<Void, RuntimeException> {
            private static final long serialVersionUID = 1L;
            private final TaskListener listener;

            PrintCallable(TaskListener listener) {
                this.listener = listener;
            }

            public Void call() throws RuntimeException {
                this.listener.getLogger().println("printed a message on master=" + JenkinsJVM.isJenkinsJVM());
                this.listener.getLogger().flush();
                return null;
            }
        }
    }

    public static final class FilterStep
    extends Step {
        @DataBoundConstructor
        public FilterStep() {
        }

        public StepExecution start(StepContext context) throws Exception {
            return new Execution(context);
        }

        private static final class Execution
        extends StepExecution {
            private static final long serialVersionUID = 1L;

            Execution(StepContext context) {
                super(context);
            }

            public boolean start() throws Exception {
                this.getContext().newBodyInvoker().withContext((Object)new Filter("StepLevelDecorator")).withCallback(BodyExecutionCallback.wrap((FutureCallback)this.getContext())).start();
                return false;
            }
        }

        @TestExtension
        public static final class DescriptorImpl
        extends StepDescriptor {
            public Set<? extends Class<?>> getRequiredContext() {
                return Collections.emptySet();
            }

            public String getFunctionName() {
                return "filter";
            }

            public boolean takesImplicitBlockArgument() {
                return true;
            }
        }

        private static final class Filter
        extends ConsoleLogFilter
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private final String message;

            Filter(String message) {
                this.message = message;
            }

            private Object writeReplace() {
                Channel ch = Channel.current();
                return ch != null ? new Filter(this.message + " via " + ch.getName()) : this;
            }

            public OutputStream decorateLogger(AbstractBuild _ignore, OutputStream logger) throws IOException, InterruptedException {
                return new DecoratorImpl(this.message).decorate(logger);
            }

            public String toString() {
                return "Filter[" + this.message + "]";
            }
        }
    }

    private static final class DecoratorImpl
    extends TaskListenerDecorator {
        private static final long serialVersionUID = 1L;
        private final String tagName;

        DecoratorImpl(String tagName) {
            this.tagName = tagName;
        }

        private Object writeReplace() {
            Channel ch = Channel.current();
            return ch != null ? new DecoratorImpl(this.tagName + " via " + ch.getName()) : this;
        }

        public OutputStream decorate(final OutputStream logger) throws IOException, InterruptedException {
            return new LineTransformationOutputStream(this){
                final /* synthetic */ DecoratorImpl this$0;
                {
                    this.this$0 = this$0;
                }

                protected void eol(byte[] b, int len) throws IOException {
                    logger.write(("[" + this.this$0.tagName + "] ").getBytes());
                    logger.write(b, 0, len);
                }

                public void close() throws IOException {
                    super.close();
                    logger.close();
                }

                public void flush() throws IOException {
                    logger.flush();
                }
            };
        }

        public String toString() {
            return "DecoratorImpl[" + this.tagName + "]";
        }
    }
}

