/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.graphanalysis;

import com.google.common.collect.Iterables;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Run;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jenkinsci.plugins.workflow.actions.ThreadNameAction;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.cps.nodes.StepEndNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepStartNode;
import org.jenkinsci.plugins.workflow.cps.steps.ParallelStep;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.BlockStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graphanalysis.BlockChunkFinder;
import org.jenkinsci.plugins.workflow.graphanalysis.ChunkFinder;
import org.jenkinsci.plugins.workflow.graphanalysis.DepthFirstScanner;
import org.jenkinsci.plugins.workflow.graphanalysis.FlowScanningUtils;
import org.jenkinsci.plugins.workflow.graphanalysis.FlowTestUtils;
import org.jenkinsci.plugins.workflow.graphanalysis.ForkScanner;
import org.jenkinsci.plugins.workflow.graphanalysis.LabelledChunkFinder;
import org.jenkinsci.plugins.workflow.graphanalysis.NoOpChunkFinder;
import org.jenkinsci.plugins.workflow.graphanalysis.NodeStepTypePredicate;
import org.jenkinsci.plugins.workflow.graphanalysis.SimpleChunkVisitor;
import org.jenkinsci.plugins.workflow.graphanalysis.TestVisitor;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.steps.EchoStep;
import org.jenkinsci.plugins.workflow.test.steps.SemaphoreStep;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.BuildWatcher;
import org.jvnet.hudson.test.JenkinsRule;

public class ForkScannerTest {
    @ClassRule
    public static BuildWatcher buildWatcher = new BuildWatcher();
    @Rule
    public JenkinsRule r = new JenkinsRule();
    WorkflowRun SIMPLE_PARALLEL_RUN;
    WorkflowRun NESTED_PARALLEL_RUN;
    private final Function<FlowNode, String> NODE_TO_ID = input -> input != null ? input.getId() : null;
    private final Function<TestVisitor.CallEntry, String> CALL_TO_NODE_ID = input -> input != null && input.getNodeId() != null ? input.getNodeId().toString() : null;

    public static Predicate<TestVisitor.CallEntry> predicateForCallEntryType(final TestVisitor.CallType type) {
        return new Predicate<TestVisitor.CallEntry>(){
            final TestVisitor.CallType myType;
            {
                this.myType = type;
            }

            @Override
            public boolean test(TestVisitor.CallEntry input) {
                return input.type != null && input.type == this.myType;
            }
        };
    }

    @Before
    public void setUp() throws Exception {
        WorkflowRun b;
        this.r.jenkins.getInjector().injectMembers((Object)this);
        WorkflowJob job = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "SimpleParallel");
        job.setDefinition((FlowDefinition)new CpsFlowDefinition("echo 'first'\ndef steps = [:]\nsteps['1'] = {\n    echo 'do 1 stuff'\n}\nsteps['2'] = {\n    echo '2a'\n    echo '2b'\n}\nparallel steps\necho 'final'", true));
        this.SIMPLE_PARALLEL_RUN = b = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)job.scheduleBuild2(0, new Action[0]));
        job = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "NestedParallel");
        job.setDefinition((FlowDefinition)new CpsFlowDefinition("echo 'first'\ndef steps = [:]\nsteps['1'] = {\n    echo 'do 1 stuff'\n}\nsteps['2'] = {\n    echo '2a'\n    echo '2b'\n    def nested = [:]\n    nested['2-1'] = {\n        echo 'do 2-1'\n    } \n    nested['2-2'] = {\n        sleep 1\n        echo '2 section 2'\n    }\n    parallel nested\n}\nparallel steps\necho 'final'", true));
        this.NESTED_PARALLEL_RUN = b = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)job.scheduleBuild2(0, new Action[0]));
    }

    private void assertIncompleteParallelsHaveEventsForEnd(List<FlowNode> heads, TestVisitor test) {
        List parallelEnds = test.filteredCallsByType(TestVisitor.CallType.PARALLEL_END).stream().map(this.CALL_TO_NODE_ID).collect(Collectors.toList());
        boolean hasMatchingEnd = false;
        for (FlowNode f : heads) {
            if (!parallelEnds.contains(f.getId())) continue;
            hasMatchingEnd = true;
            break;
        }
        Assert.assertTrue((String)"If there are multiple heads, we MUST be in a parallel and have an event for the end", (boolean)hasMatchingEnd);
        List branchEnds = test.filteredCallsByType(TestVisitor.CallType.PARALLEL_BRANCH_END).stream().map(this.CALL_TO_NODE_ID).collect(Collectors.toList());
        for (FlowNode f : heads) {
            Assert.assertTrue((String)("Must have a parallel branch end for each branch we know of, but didn't, for nodeId: " + f.getId()), (boolean)branchEnds.contains(f.getId()));
        }
    }

    private void sanityTestIterationAndVisiter(List<FlowNode> heads) {
        ForkScanner scan = new ForkScanner();
        TestVisitor test = new TestVisitor();
        scan.setup(heads);
        scan.visitSimpleChunks((SimpleChunkVisitor)test, (ChunkFinder)new NoOpChunkFinder());
        test.isFromCompleteRun = scan.isWalkingFromFinish();
        if (heads.size() > 1) {
            this.assertIncompleteParallelsHaveEventsForEnd(heads, test);
        }
        test.assertNoIllegalNullsInEvents();
        test.assertNoDupes();
        int nodeCount = new DepthFirstScanner().allNodes(heads).size();
        Assert.assertEquals((String)"ForkScanner should visit the same number of nodes as DepthFirstScanner", (long)nodeCount, (long)new ForkScanner().allNodes(heads).size());
        test.assertMatchingParallelStartEnd();
        test.assertAllNodesGotChunkEvents(new DepthFirstScanner().allNodes(heads));
        this.assertNoMissingParallelEvents(heads);
        if (heads.size() > 0) {
            test.assertMatchingParallelBranchStartEnd();
        }
        test.reset();
        scan.setup(heads);
        test.isFromCompleteRun = scan.isWalkingFromFinish();
        scan.visitSimpleChunks((SimpleChunkVisitor)test, (ChunkFinder)new LabelledChunkFinder());
        test.assertNoIllegalNullsInEvents();
        test.assertNoDupes();
        int lastId = -1;
        for (int i = 0; i < test.calls.size(); ++i) {
            TestVisitor.CallEntry entry = test.calls.get(i);
            if (lastId > 0) {
                lastId = entry.getNodeId();
            }
            if (!TestVisitor.CHUNK_EVENTS.contains((Object)entry.type)) continue;
            Assert.assertEquals((Object)((Object)TestVisitor.CallType.CHUNK_END), (Object)((Object)entry.type));
            break;
        }
        Assert.assertEquals((long)nodeCount, (long)new ForkScanner().allNodes(heads).size());
        test.assertMatchingParallelStartEnd();
        test.assertMatchingParallelBranchStartEnd();
        test.assertAllNodesGotChunkEvents(new DepthFirstScanner().allNodes(heads));
        this.assertNoMissingParallelEvents(heads);
    }

    @Test
    public void testForkedScanner() throws Exception {
        FlowExecution exec = this.SIMPLE_PARALLEL_RUN.getExecution();
        List heads = this.SIMPLE_PARALLEL_RUN.getExecution().getCurrentHeads();
        ForkScanner scanner = new ForkScanner();
        scanner.setup((Collection)heads, null);
        Assert.assertNull((Object)scanner.currentParallelStart);
        Assert.assertNull((Object)scanner.currentParallelStartNode);
        Assert.assertNotNull((Object)scanner.parallelBlockStartStack);
        Assert.assertEquals((long)0L, (long)scanner.parallelBlockStartStack.size());
        Assert.assertTrue((boolean)scanner.isWalkingFromFinish());
        this.sanityTestIterationAndVisiter(heads);
        scanner.setup(exec.getNode("13"));
        Assert.assertFalse((boolean)scanner.isWalkingFromFinish());
        Assert.assertNull((Object)scanner.currentType);
        Assert.assertEquals((Object)ForkScanner.NodeType.PARALLEL_END, (Object)scanner.nextType);
        Assert.assertEquals((Object)"13", (Object)scanner.next().getId());
        Assert.assertNotNull((Object)scanner.parallelBlockStartStack);
        Assert.assertEquals((long)0L, (long)scanner.parallelBlockStartStack.size());
        Assert.assertEquals((Object)exec.getNode("4"), (Object)scanner.currentParallelStartNode);
        this.sanityTestIterationAndVisiter(Collections.singletonList(exec.getNode("13")));
        ForkScanner.ParallelBlockStart start = scanner.currentParallelStart;
        Assert.assertEquals((long)1L, (long)start.unvisited.size());
        Assert.assertEquals((Object)exec.getNode("4"), (Object)start.forkStart);
        Assert.assertEquals((Object)exec.getNode("12"), (Object)scanner.next());
        Assert.assertEquals((Object)ForkScanner.NodeType.PARALLEL_BRANCH_END, (Object)scanner.getCurrentType());
        Assert.assertEquals((Object)ForkScanner.NodeType.NORMAL, (Object)scanner.getNextType());
        Assert.assertEquals((Object)exec.getNode("11"), (Object)scanner.next());
        Assert.assertEquals((Object)ForkScanner.NodeType.NORMAL, (Object)scanner.getCurrentType());
        Assert.assertEquals((Object)exec.getNode("10"), (Object)scanner.next());
        Assert.assertEquals((Object)ForkScanner.NodeType.NORMAL, (Object)scanner.getCurrentType());
        Assert.assertEquals((Object)ForkScanner.NodeType.PARALLEL_BRANCH_START, (Object)scanner.getNextType());
        Assert.assertEquals((Object)exec.getNode("7"), (Object)scanner.next());
        Assert.assertEquals((Object)ForkScanner.NodeType.PARALLEL_BRANCH_START, (Object)scanner.getCurrentType());
        Assert.assertEquals((Object)ForkScanner.NodeType.PARALLEL_BRANCH_END, (Object)scanner.getNextType());
        Assert.assertEquals((Object)exec.getNode("9"), (Object)scanner.next());
        Assert.assertEquals((Object)ForkScanner.NodeType.PARALLEL_BRANCH_END, (Object)scanner.getCurrentType());
        Assert.assertEquals((Object)exec.getNode("8"), (Object)scanner.next());
        Assert.assertEquals((Object)ForkScanner.NodeType.NORMAL, (Object)scanner.getCurrentType());
        Assert.assertEquals((Object)exec.getNode("6"), (Object)scanner.next());
        Assert.assertEquals((Object)ForkScanner.NodeType.PARALLEL_BRANCH_START, (Object)scanner.getCurrentType());
        Assert.assertEquals((Object)ForkScanner.NodeType.PARALLEL_START, (Object)scanner.getNextType());
    }

    @Test
    public void testFlowSegmentSplit() throws Exception {
        FlowExecution exec = this.SIMPLE_PARALLEL_RUN.getExecution();
        HashMap<FlowNode, ForkScanner.FlowSegment> nodeMap = new HashMap<FlowNode, ForkScanner.FlowSegment>();
        ForkScanner.FlowSegment mainBranch = new ForkScanner.FlowSegment();
        ForkScanner.FlowSegment sideBranch = new ForkScanner.FlowSegment();
        FlowNode BRANCH1_END = exec.getNode("9");
        FlowNode BRANCH2_END = exec.getNode("12");
        FlowNode START_PARALLEL = exec.getNode("4");
        mainBranch.add(BRANCH1_END);
        mainBranch.add(exec.getNode("8"));
        mainBranch.add(exec.getNode("6"));
        mainBranch.add(exec.getNode("4"));
        mainBranch.add(exec.getNode("3"));
        for (FlowNode f : mainBranch.visited) {
            nodeMap.put(f, mainBranch);
        }
        FlowTestUtils.assertNodeOrder("Visited nodes", (Iterable<FlowNode>)mainBranch.visited, 9, 8, 6, 4, 3);
        sideBranch.add(BRANCH2_END);
        sideBranch.add(exec.getNode("11"));
        sideBranch.add(exec.getNode("10"));
        sideBranch.add(exec.getNode("7"));
        for (FlowNode f : sideBranch.visited) {
            nodeMap.put(f, sideBranch);
        }
        FlowTestUtils.assertNodeOrder("Visited nodes", (Iterable<FlowNode>)sideBranch.visited, 12, 11, 10, 7);
        ForkScanner.Fork forked = mainBranch.split(nodeMap, (BlockStartNode)exec.getNode("4"), (ForkScanner.FlowPiece)sideBranch);
        ForkScanner.FlowSegment splitSegment = (ForkScanner.FlowSegment)nodeMap.get(BRANCH1_END);
        Assert.assertNull((Object)splitSegment.after);
        FlowTestUtils.assertNodeOrder("Branch 1 split after fork", (Iterable<FlowNode>)splitSegment.visited, 9, 8, 6);
        Assert.assertEquals((Object)forked, (Object)mainBranch.after);
        FlowTestUtils.assertNodeOrder("Head of flow, pre-fork", (Iterable<FlowNode>)mainBranch.visited, 3);
        Assert.assertEquals((Object)forked, nodeMap.get(START_PARALLEL));
        Object[] follows = new ForkScanner.FlowPiece[]{splitSegment, sideBranch};
        Assert.assertArrayEquals((Object[])follows, (Object[])forked.following.toArray());
        Assert.assertEquals((Object)sideBranch, nodeMap.get(BRANCH2_END));
        FlowTestUtils.assertNodeOrder("Branch 2", (Iterable<FlowNode>)sideBranch.visited, 12, 11, 10, 7);
        nodeMap.clear();
        mainBranch = new ForkScanner.FlowSegment();
        sideBranch = new ForkScanner.FlowSegment();
        mainBranch.visited.add(exec.getNode("6"));
        mainBranch.visited.add(START_PARALLEL);
        sideBranch.visited.add(exec.getNode("7"));
        for (FlowNode f : mainBranch.visited) {
            nodeMap.put(f, mainBranch);
        }
        nodeMap.put(exec.getNode("7"), sideBranch);
        forked = mainBranch.split(nodeMap, (BlockStartNode)exec.getNode("4"), (ForkScanner.FlowPiece)sideBranch);
        follows = new ForkScanner.FlowSegment[]{mainBranch, sideBranch};
        Assert.assertArrayEquals((Object[])follows, (Object[])forked.following.toArray());
        FlowTestUtils.assertNodeOrder("Branch1", (Iterable<FlowNode>)mainBranch.visited, 6);
        Assert.assertNull((Object)mainBranch.after);
        FlowTestUtils.assertNodeOrder("Branch2", (Iterable<FlowNode>)sideBranch.visited, 7);
        Assert.assertNull((Object)sideBranch.after);
        Assert.assertEquals((Object)forked, nodeMap.get(START_PARALLEL));
        Assert.assertEquals((Object)mainBranch, nodeMap.get(exec.getNode("6")));
        Assert.assertEquals((Object)sideBranch, nodeMap.get(exec.getNode("7")));
    }

    @Test
    public void testEmptyParallel() throws Exception {
        WorkflowJob job = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "EmptyParallel");
        job.setDefinition((FlowDefinition)new CpsFlowDefinition("parallel 'empty1': {}, 'empty2':{} \necho 'done' ", true));
        WorkflowRun b = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)job.scheduleBuild2(0, new Action[0]));
        ForkScanner scan = new ForkScanner();
        List outputs = scan.filteredNodes((Collection)b.getExecution().getCurrentHeads(), x -> true);
        Assert.assertEquals((long)9L, (long)outputs.size());
    }

    private void assertNoMissingParallelEvents(List<FlowNode> heads) {
        DepthFirstScanner allScan = new DepthFirstScanner();
        TestVisitor visit = new TestVisitor();
        ForkScanner forkScan = new ForkScanner();
        List matches = allScan.filteredNodes(heads, FlowScanningUtils.hasActionPredicate(ThreadNameAction.class));
        forkScan.setup(heads);
        forkScan.visitSimpleChunks((SimpleChunkVisitor)visit, (ChunkFinder)new LabelledChunkFinder());
        Set callIds = visit.filteredCallsByType(TestVisitor.CallType.PARALLEL_BRANCH_START).stream().map(this.CALL_TO_NODE_ID).collect(Collectors.toSet());
        for (String id : matches.stream().map(this.NODE_TO_ID).collect(Collectors.toList())) {
            if (callIds.contains(id)) continue;
            Assert.fail((String)("Parallel Branch start node without an appropriate parallelBranchStart callback: " + id));
        }
        matches = allScan.filteredNodes(heads, input -> input instanceof StepStartNode && ((StepStartNode)input).getDescriptor() instanceof ParallelStep.DescriptorImpl && input.getPersistentAction(ThreadNameAction.class) == null);
        List parallelEnds = allScan.filteredNodes(heads, input -> input instanceof StepEndNode && ((StepEndNode)input).getDescriptor() instanceof ParallelStep.DescriptorImpl && ((StepStartNode)((StepEndNode)input).getStartNode()).getPersistentAction(ThreadNameAction.class) == null);
        visit.reset();
        forkScan.setup(heads);
        forkScan.visitSimpleChunks((SimpleChunkVisitor)visit, (ChunkFinder)new LabelledChunkFinder());
        callIds = visit.filteredCallsByType(TestVisitor.CallType.PARALLEL_START).stream().map(this.CALL_TO_NODE_ID).collect(Collectors.toSet());
        for (String id : matches.stream().map(this.NODE_TO_ID).collect(Collectors.toList())) {
            if (callIds.contains(id)) continue;
            Assert.fail((String)("Parallel start node without an appropriate parallelStart callback: " + id));
        }
        callIds = visit.filteredCallsByType(TestVisitor.CallType.PARALLEL_END).stream().map(this.CALL_TO_NODE_ID).collect(Collectors.toSet());
        for (String id : parallelEnds.stream().map(this.NODE_TO_ID).collect(Collectors.toList())) {
            if (callIds.contains(id)) continue;
            Assert.fail((String)("Parallel END node without an appropriate parallelEnd callback: " + id));
        }
    }

    @Test
    public void testSingleNestedParallelBranches() throws Exception {
        String script = "node {\n     echo ('Testing')\n     parallel nestedBranch: {\n       echo 'nested Branch'\n       stage ('nestedBranchStage') { \n           echo 'running nestedBranchStage'\n           parallel secondLevelNestedBranch1: {\n               echo 'secondLevelNestedBranch1'\n           }\n       }\n     }, failFast: false\n}";
        WorkflowJob job = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "SingleNestedParallelBranch");
        job.setDefinition((FlowDefinition)new CpsFlowDefinition(script, true));
        WorkflowRun b = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)job.scheduleBuild2(0, new Action[0]));
        FlowNode echoNode = new DepthFirstScanner().findFirstMatch(b.getExecution(), (com.google.common.base.Predicate)new NodeStepTypePredicate(EchoStep.DescriptorImpl.byFunctionName((String)"echo")));
        Assert.assertNotNull((Object)echoNode);
        this.sanityTestIterationAndVisiter(b.getExecution().getCurrentHeads());
        this.sanityTestIterationAndVisiter(Collections.singletonList(echoNode));
        TestVisitor visitor = new TestVisitor();
        ForkScanner scanner = new ForkScanner();
        scanner.setup((Collection)b.getExecution().getCurrentHeads());
        scanner.visitSimpleChunks((SimpleChunkVisitor)visitor, (ChunkFinder)new NoOpChunkFinder());
        Assert.assertEquals((long)2L, (long)visitor.filteredCallsByType(TestVisitor.CallType.PARALLEL_START).size());
        Assert.assertEquals((long)2L, (long)visitor.filteredCallsByType(TestVisitor.CallType.PARALLEL_END).size());
        Assert.assertEquals((long)2L, (long)visitor.filteredCallsByType(TestVisitor.CallType.PARALLEL_BRANCH_START).size());
        Assert.assertEquals((long)2L, (long)visitor.filteredCallsByType(TestVisitor.CallType.PARALLEL_BRANCH_END).size());
    }

    @Test
    public void testLeastCommonAncestor() throws Exception {
        FlowExecution exec = this.SIMPLE_PARALLEL_RUN.getExecution();
        ForkScanner scan = new ForkScanner();
        LinkedHashSet<FlowNode> heads = new LinkedHashSet<FlowNode>(Arrays.asList(exec.getNode("12"), exec.getNode("9")));
        ArrayDeque starts = scan.leastCommonAncestor(heads);
        Assert.assertEquals((long)1L, (long)starts.size());
        ForkScanner.ParallelBlockStart start = (ForkScanner.ParallelBlockStart)starts.peek();
        Assert.assertEquals((long)2L, (long)start.unvisited.size());
        Assert.assertEquals((Object)exec.getNode("4"), (Object)start.forkStart);
        Assert.assertArrayEquals((Object[])heads.toArray(), (Object[])start.unvisited.toArray());
        heads = new LinkedHashSet<FlowNode>(Collections.singletonList(exec.getNode("4")));
        scan.setup(heads);
        Assert.assertNull((Object)scan.currentParallelStart);
        Assert.assertTrue((scan.parallelBlockStartStack == null || scan.parallelBlockStartStack.isEmpty() ? 1 : 0) != 0);
        heads = new LinkedHashSet<FlowNode>(Arrays.asList(exec.getNode("6"), exec.getNode("7")));
        starts = scan.leastCommonAncestor(heads);
        Assert.assertEquals((long)1L, (long)starts.size());
        ForkScanner.ParallelBlockStart pbs = (ForkScanner.ParallelBlockStart)starts.pop();
        Assert.assertEquals((Object)exec.getNode("4"), (Object)pbs.forkStart);
        Assert.assertEquals((long)2L, (long)pbs.unvisited.size());
        Assert.assertTrue((boolean)pbs.unvisited.contains(exec.getNode("6")));
        Assert.assertTrue((boolean)pbs.unvisited.contains(exec.getNode("7")));
        this.sanityTestIterationAndVisiter(new ArrayList<FlowNode>(heads));
        exec = this.NESTED_PARALLEL_RUN.getExecution();
        heads = new LinkedHashSet<FlowNode>(Arrays.asList(exec.getNode("9"), exec.getNode("17"), exec.getNode("20")));
        starts = scan.leastCommonAncestor(heads);
        Assert.assertEquals((long)2L, (long)starts.size());
        ForkScanner.ParallelBlockStart inner = (ForkScanner.ParallelBlockStart)starts.getFirst();
        ForkScanner.ParallelBlockStart outer = (ForkScanner.ParallelBlockStart)starts.getLast();
        Assert.assertEquals((long)2L, (long)inner.unvisited.size());
        Assert.assertEquals((Object)exec.getNode("12"), (Object)inner.forkStart);
        Assert.assertEquals((long)1L, (long)outer.unvisited.size());
        Assert.assertEquals((Object)exec.getNode("9"), outer.unvisited.peek());
        Assert.assertEquals((Object)exec.getNode("4"), (Object)outer.forkStart);
        this.sanityTestIterationAndVisiter(new ArrayList<FlowNode>(heads));
        heads = new LinkedHashSet<FlowNode>(Arrays.asList(exec.getNode("9"), exec.getNode("17"), exec.getNode("20")));
        starts = scan.leastCommonAncestor(heads);
        Assert.assertEquals((long)2L, (long)starts.size());
        this.sanityTestIterationAndVisiter(new ArrayList<FlowNode>(heads));
    }

    @Test
    public void testVariousParallelCombos() throws Exception {
        WorkflowJob job = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "ParallelTimingBug");
        job.setDefinition((FlowDefinition)new CpsFlowDefinition("echo 'test stage' \n    parallel 'unit': {\n          retry(1) {\n            sleep 1;\n            sleep 10; echo 'hello'; \n          }\n        }, 'otherunit': {\n            retry(1) {\n              sleep 1;\n              sleep 5; \n              echo 'goodbye'   \n            }\n        }", true));
        WorkflowRun b = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)job.scheduleBuild2(0, new Action[0]));
        FlowExecution exec = b.getExecution();
        ForkScanner scan = new ForkScanner();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 5; ++j) {
                int branchANodeId = i + 20;
                int branchBNodeId = j + 15;
                System.out.println("Starting test with nodes " + branchANodeId + "," + branchBNodeId);
                ArrayList<FlowNode> starts = new ArrayList<FlowNode>();
                FlowTestUtils.addNodesById(starts, exec, branchANodeId, branchBNodeId);
                List all = scan.filteredNodes(starts, x -> true);
                Assert.assertEquals((long)new HashSet(all).size(), (long)all.size());
                scan.reset();
            }
        }
    }

    @Test
    public void testMissingHeadErrorWithZeroBranchParallel() throws Exception {
        WorkflowJob job = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "MissingHeadBug");
        job.setDefinition((FlowDefinition)new CpsFlowDefinition("stage('Stage A') {\n    echo \"A\"\n}\n// Works\nstage('Stage B') {\n    parallel a: {\n        echo \"B.A\"\n    }, b: {\n        echo \"B.B\"\n    }\n}\n// Breaks\nstage('Stage C') {\n    def steps = [:]\n    // Empty map\n    parallel steps\n}\n", true));
        WorkflowRun run = (WorkflowRun)this.r.buildAndAssertSuccess((Job)job);
        FlowExecution exec = run.getExecution();
        this.sanityTestIterationAndVisiter(exec.getCurrentHeads());
    }

    @Test
    public void testParallelPredicate() throws Exception {
        FlowExecution exec = this.SIMPLE_PARALLEL_RUN.getExecution();
        Assert.assertTrue((boolean)new ForkScanner.IsParallelStartPredicate().apply(exec.getNode("4")));
        Assert.assertFalse((boolean)new ForkScanner.IsParallelStartPredicate().apply(exec.getNode("6")));
        Assert.assertFalse((boolean)new ForkScanner.IsParallelStartPredicate().apply(exec.getNode("8")));
    }

    @Test
    public void testGetNodeType() throws Exception {
        FlowExecution exec = this.SIMPLE_PARALLEL_RUN.getExecution();
        Assert.assertEquals((Object)ForkScanner.NodeType.NORMAL, (Object)ForkScanner.getNodeType((FlowNode)exec.getNode("2")));
        Assert.assertEquals((Object)ForkScanner.NodeType.PARALLEL_START, (Object)ForkScanner.getNodeType((FlowNode)exec.getNode("4")));
        Assert.assertEquals((Object)ForkScanner.NodeType.PARALLEL_BRANCH_START, (Object)ForkScanner.getNodeType((FlowNode)exec.getNode("6")));
        Assert.assertEquals((Object)ForkScanner.NodeType.PARALLEL_BRANCH_END, (Object)ForkScanner.getNodeType((FlowNode)exec.getNode("9")));
        Assert.assertEquals((Object)ForkScanner.NodeType.PARALLEL_END, (Object)ForkScanner.getNodeType((FlowNode)exec.getNode("13")));
        Assert.assertEquals((Object)ForkScanner.NodeType.NORMAL, (Object)ForkScanner.getNodeType((FlowNode)exec.getNode("8")));
    }

    @Test
    public void testSimpleVisitor() throws Exception {
        FlowExecution exec = this.SIMPLE_PARALLEL_RUN.getExecution();
        ForkScanner f = new ForkScanner();
        f.setup((Collection)exec.getCurrentHeads());
        Assert.assertArrayEquals((Object[])new HashSet(exec.getCurrentHeads()).toArray(), (Object[])new HashSet(f.currentParallelHeads()).toArray());
        List expectedHeads = f.currentParallelHeads();
        this.sanityTestIterationAndVisiter(exec.getCurrentHeads());
        TestVisitor visitor = new TestVisitor();
        f.visitSimpleChunks((SimpleChunkVisitor)visitor, (ChunkFinder)new BlockChunkFinder());
        Assert.assertEquals((long)19L, (long)visitor.calls.size());
        TestVisitor.CallEntry last = new TestVisitor.CallEntry(TestVisitor.CallType.CHUNK_END, 15, -1, -1, -1);
        last.assertEquals(visitor.calls.get(0));
        TestVisitor.CallEntry first = new TestVisitor.CallEntry(TestVisitor.CallType.CHUNK_START, 2, -1, -1, -1);
        first.assertEquals(visitor.calls.get(18));
        long chunkStartCount = visitor.calls.stream().filter(ForkScannerTest.predicateForCallEntryType(TestVisitor.CallType.CHUNK_START)).count();
        long chunkEndCount = visitor.calls.stream().filter(ForkScannerTest.predicateForCallEntryType(TestVisitor.CallType.CHUNK_END)).count();
        Assert.assertEquals((long)4L, (long)chunkStartCount);
        Assert.assertEquals((long)4L, (long)chunkEndCount);
        List atomNodeCalls = visitor.calls.stream().filter(ForkScannerTest.predicateForCallEntryType(TestVisitor.CallType.ATOM_NODE)).collect(Collectors.toList());
        Assert.assertEquals((long)5L, (long)atomNodeCalls.size());
        for (TestVisitor.CallEntry ce : atomNodeCalls) {
            int beforeId = ce.ids[0];
            int atomNodeId = ce.ids[1];
            int afterId = ce.ids[2];
            int alwaysEmpty = ce.ids[3];
            Assert.assertTrue((String)(String.valueOf(ce) + " beforeNodeId <= 0: " + beforeId), (beforeId > 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)(String.valueOf(ce) + " atomNodeId <= 0: " + atomNodeId), (atomNodeId > 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)(String.valueOf(ce) + " afterNodeId <= 0: " + afterId), (afterId > 0 ? 1 : 0) != 0);
            Assert.assertEquals((long)-1L, (long)alwaysEmpty);
            Assert.assertTrue((String)(String.valueOf(ce) + "AtomNodeId >= afterNodeId"), (atomNodeId < afterId ? 1 : 0) != 0);
            Assert.assertTrue((String)(String.valueOf(ce) + "beforeNodeId >= atomNodeId"), (beforeId < atomNodeId ? 1 : 0) != 0);
        }
        List parallelCalls = visitor.calls.stream().filter(input -> input.type != null && input.type != TestVisitor.CallType.ATOM_NODE && input.type != TestVisitor.CallType.CHUNK_START && input.type != TestVisitor.CallType.CHUNK_END).collect(Collectors.toList());
        Assert.assertEquals((long)6L, (long)parallelCalls.size());
        new TestVisitor.CallEntry(TestVisitor.CallType.PARALLEL_END, 4, 13).assertEquals((TestVisitor.CallEntry)parallelCalls.get(0));
        new TestVisitor.CallEntry(TestVisitor.CallType.PARALLEL_BRANCH_END, 4, 12).assertEquals((TestVisitor.CallEntry)parallelCalls.get(1));
        new TestVisitor.CallEntry(TestVisitor.CallType.PARALLEL_BRANCH_START, 4, 7).assertEquals((TestVisitor.CallEntry)parallelCalls.get(2));
        new TestVisitor.CallEntry(TestVisitor.CallType.PARALLEL_BRANCH_END, 4, 9).assertEquals((TestVisitor.CallEntry)parallelCalls.get(3));
        new TestVisitor.CallEntry(TestVisitor.CallType.PARALLEL_BRANCH_START, 4, 6).assertEquals((TestVisitor.CallEntry)parallelCalls.get(4));
        new TestVisitor.CallEntry(TestVisitor.CallType.PARALLEL_START, 4, 6).assertEquals((TestVisitor.CallEntry)parallelCalls.get(5));
    }

    @Test
    public void testTripleParallel() throws Exception {
        WorkflowJob job = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "TripleParallel");
        job.setDefinition((FlowDefinition)new CpsFlowDefinition("echo 'test stage'\nparallel 'unit':{\n  echo \"Unit testing...\"\n},'integration':{\n    echo \"Integration testing...\"\n}, 'ui':{\n    echo \"UI testing...\"\n}", true));
        WorkflowRun b = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)job.scheduleBuild2(0, new Action[0]));
        FlowExecution exec = b.getExecution();
        ForkScanner f = new ForkScanner();
        List heads = exec.getCurrentHeads();
        f.setup((Collection)heads);
        TestVisitor visitor = new TestVisitor();
        f.visitSimpleChunks((SimpleChunkVisitor)visitor, (ChunkFinder)new BlockChunkFinder());
        this.sanityTestIterationAndVisiter(heads);
        List parallels = visitor.calls.stream().filter(ForkScannerTest.predicateForCallEntryType(TestVisitor.CallType.PARALLEL_BRANCH_START).or(ForkScannerTest.predicateForCallEntryType(TestVisitor.CallType.PARALLEL_BRANCH_END))).collect(Collectors.toList());
        Assert.assertEquals((long)6L, (long)parallels.size());
        ArrayList<FlowNode> ends = new ArrayList<FlowNode>();
        ends.add(exec.getNode("11"));
        ends.add(exec.getNode("12"));
        ends.add(exec.getNode("14"));
        Assert.assertEquals((long)new DepthFirstScanner().allNodes(ends).size(), (long)new ForkScanner().allNodes(ends).size());
        visitor = new TestVisitor();
        f.setup(ends);
        f.visitSimpleChunks((SimpleChunkVisitor)visitor, (ChunkFinder)new BlockChunkFinder());
        this.sanityTestIterationAndVisiter(ends);
        parallels = visitor.calls.stream().filter(ForkScannerTest.predicateForCallEntryType(TestVisitor.CallType.PARALLEL_BRANCH_START).or(ForkScannerTest.predicateForCallEntryType(TestVisitor.CallType.PARALLEL_BRANCH_END))).collect(Collectors.toList());
        Assert.assertEquals((long)6L, (long)parallels.size());
        Assert.assertEquals((long)18L, (long)visitor.calls.size());
        FlowNode[] branchHeads = new FlowNode[]{exec.getNode("7"), exec.getNode("8"), exec.getNode("9")};
        ArrayDeque starts = f.leastCommonAncestor(new HashSet<FlowNode>(Arrays.asList(branchHeads)));
        Assert.assertEquals((long)1L, (long)starts.size());
        ForkScanner.ParallelBlockStart pbs = (ForkScanner.ParallelBlockStart)starts.pop();
        Assert.assertEquals((Object)exec.getNode("4"), (Object)pbs.forkStart);
        Assert.assertEquals((long)3L, (long)pbs.unvisited.size());
        Assert.assertTrue((boolean)pbs.unvisited.contains(exec.getNode("7")));
        Assert.assertTrue((boolean)pbs.unvisited.contains(exec.getNode("8")));
        Assert.assertTrue((boolean)pbs.unvisited.contains(exec.getNode("9")));
    }

    private void testParallelFindsLast(WorkflowJob job, String semaphoreName) throws Exception {
        ForkScanner scan = new ForkScanner();
        LabelledChunkFinder labelFinder = new LabelledChunkFinder();
        System.out.println("Testing that semaphore step is always the last step for chunk with " + job.getName());
        WorkflowRun run = (WorkflowRun)job.scheduleBuild2(0, new Action[0]).getStartCondition().get();
        SemaphoreStep.waitForStart((String)(semaphoreName + "/1"), (Run)run);
        FlowNode semaphoreNode = (FlowNode)Iterables.tryFind((Iterable)run.getExecution().getCurrentHeads(), (com.google.common.base.Predicate)new NodeStepTypePredicate("semaphore")).orNull();
        TestVisitor visitor = new TestVisitor();
        List heads = run.getExecution().getCurrentHeads();
        scan.setup((Collection)heads);
        Assert.assertEquals((long)(run.getExecution().getCurrentHeads().size() - 1), (long)scan.currentParallelStart.unvisited.size());
        scan.visitSimpleChunks((SimpleChunkVisitor)visitor, (ChunkFinder)labelFinder);
        TestVisitor.CallEntry parallelEnd = visitor.calls.get(0);
        Assert.assertEquals((Object)((Object)TestVisitor.CallType.PARALLEL_END), (Object)((Object)parallelEnd.type));
        Assert.assertEquals((String)("Wrong End Node: (" + parallelEnd.getNodeId() + ")"), (Object)semaphoreNode.getId(), (Object)parallelEnd.getNodeId().toString());
        Assert.assertEquals((Object)semaphoreNode.getId(), (Object)parallelEnd.getNodeId().toString());
        SemaphoreStep.success((String)(semaphoreName + "/1"), null);
        this.r.waitForCompletion((Run)run);
        this.sanityTestIterationAndVisiter(heads);
    }

    @Test
    public void testParallelsWithDuplicateEvents() throws Exception {
        WorkflowJob job = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "ParallelInsanity");
        job.setDefinition((FlowDefinition)new CpsFlowDefinition("echo 'first stage'\nparallel left : {\n  echo 'run a bit'\n  echo 'run a bit more'\n  semaphore 'wait1'\n}, right : {\n  echo 'wozzle'\n  semaphore 'wait2'\n}\necho 'last stage'\necho \"last done\"\n", true));
        ForkScanner scan = new ForkScanner();
        NoOpChunkFinder labelFinder = new NoOpChunkFinder();
        WorkflowRun run = (WorkflowRun)job.scheduleBuild2(0, new Action[0]).getStartCondition().get();
        SemaphoreStep.waitForStart((String)"wait1/1", (Run)run);
        SemaphoreStep.waitForStart((String)"wait2/1", (Run)run);
        TestVisitor test = new TestVisitor();
        List heads = run.getExecution().getCurrentHeads();
        scan.setup((Collection)heads);
        scan.visitSimpleChunks((SimpleChunkVisitor)test, (ChunkFinder)labelFinder);
        SemaphoreStep.success((String)"wait1/1", null);
        SemaphoreStep.success((String)"wait2/1", null);
        this.r.waitForCompletion((Run)run);
        int atomEventCount = 0;
        int parallelBranchEndCount = 0;
        int parallelStartCount = 0;
        for (TestVisitor.CallEntry ce : test.calls) {
            switch (ce.type) {
                case ATOM_NODE: {
                    ++atomEventCount;
                    break;
                }
                case PARALLEL_BRANCH_END: {
                    ++parallelBranchEndCount;
                    break;
                }
                case PARALLEL_START: {
                    ++parallelStartCount;
                    break;
                }
            }
        }
        this.sanityTestIterationAndVisiter(heads);
        Assert.assertEquals((long)10L, (long)atomEventCount);
        Assert.assertEquals((long)1L, (long)parallelStartCount);
        Assert.assertEquals((long)2L, (long)parallelBranchEndCount);
    }

    @Test
    public void testPartlyCompletedParallels() throws Exception {
        String jobScript = "echo 'first stage'\nparallel 'long' : { sleep 60; }, \n         'short': { sleep 2; }";
        ForkScanner scan = new ForkScanner();
        TestVisitor tv = new TestVisitor();
        WorkflowJob job = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "parallelTimes");
        job.setDefinition((FlowDefinition)new CpsFlowDefinition(jobScript, true));
        WorkflowRun run = (WorkflowRun)job.scheduleBuild2(0, new Action[0]).getStartCondition().get();
        Thread.sleep(4000L);
        FlowExecution exec = run.getExecution();
        List heads = exec.getCurrentHeads();
        scan.setup((Collection)heads);
        scan.visitSimpleChunks((SimpleChunkVisitor)tv, (ChunkFinder)new NoOpChunkFinder());
        FlowNode endNode = exec.getNode(tv.filteredCallsByType(TestVisitor.CallType.PARALLEL_END).get(0).getNodeId().toString());
        Assert.assertEquals((Object)"sleep", (Object)endNode.getDisplayFunctionName());
        this.sanityTestIterationAndVisiter(heads);
        run.doKill();
    }

    @Test
    public void testParallelCorrectEndNodeForVisitor() throws Exception {
        WorkflowJob jobPauseFirst = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "PauseFirst");
        jobPauseFirst.setDefinition((FlowDefinition)new CpsFlowDefinition("echo 'primero stage'\nparallel 'wait' : {sleep 1; semaphore 'wait1';}, \n 'final': { echo 'succeed';} ", true));
        WorkflowJob jobPauseSecond = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "PauseSecond");
        jobPauseSecond.setDefinition((FlowDefinition)new CpsFlowDefinition("echo 'primero stage'\nparallel 'success' : {echo 'succeed'}, \n 'pause':{ sleep 1; semaphore 'wait2'; }\n", true));
        WorkflowJob jobPauseMiddle = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "PauseMiddle");
        jobPauseMiddle.setDefinition((FlowDefinition)new CpsFlowDefinition("echo 'primero stage'\nparallel 'success' : {echo 'succeed'}, \n 'pause':{ sleep 1; semaphore 'wait3'; }, \n 'final': { echo 'succeed-final';} ", true));
        this.testParallelFindsLast(jobPauseFirst, "wait1");
        this.testParallelFindsLast(jobPauseSecond, "wait2");
        this.testParallelFindsLast(jobPauseMiddle, "wait3");
    }

    @Test
    public void inProgressParallelInParallel() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.createProject(WorkflowJob.class);
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("stage('MyStage') {\n  parallel(\n    outerA: {\n      semaphore('outerA')\n    },\n    outerB: {\n      echo('outerB')\n    },\n    outerC: {\n      parallel(\n        innerA: {\n          semaphore('innerA')\n        },\n        innerB: {\n          echo('innerB')\n        }\n      )\n    }\n  )\n}\n", true));
        WorkflowRun b = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).waitForStart();
        SemaphoreStep.waitForStart((String)"outerA/1", (Run)b);
        SemaphoreStep.waitForStart((String)"innerA/1", (Run)b);
        ForkScanner scanner = new ForkScanner();
        this.sanityTestIterationAndVisiter(b.getExecution().getCurrentHeads());
        SemaphoreStep.success((String)"outerA/1", null);
        SemaphoreStep.success((String)"innerA/1", null);
        this.r.assertBuildStatusSuccess((Run)((WorkflowRun)this.r.waitForCompletion((Run)b)));
        this.sanityTestIterationAndVisiter(b.getExecution().getCurrentHeads());
        ForkScannerTest.assertBranchOrder(b.getExecution(), "innerB", "innerA", "outerC", "outerB", "outerA");
    }

    @Ignore(value="outerA gets skipped when iterating, see warning in ForkScanner Javadoc")
    @Test
    public void inProgressParallelInParallelOneNestedBranch() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.createProject(WorkflowJob.class);
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("parallel(\n  'outerA': {\n    parallel(\n      'innerA': {\n        semaphore('innerA')\n      }\n    )\n  },\n  'outerB': {\n  }\n)", true));
        WorkflowRun b = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).waitForStart();
        SemaphoreStep.waitForStart((String)"innerA/1", (Run)b);
        this.sanityTestIterationAndVisiter(b.getExecution().getCurrentHeads());
        ForkScannerTest.assertBranchOrder(b.getExecution(), "innerA", "outerA", "outerB");
        SemaphoreStep.success((String)"innerA/1", null);
        this.r.assertBuildStatusSuccess((Run)((WorkflowRun)this.r.waitForCompletion((Run)b)));
        this.sanityTestIterationAndVisiter(b.getExecution().getCurrentHeads());
        ForkScannerTest.assertBranchOrder(b.getExecution(), "outerB", "innerA", "outerA");
    }

    @Ignore(value="Actual ordering is all complete branches and then all incomplete branches, see warning in ForkScanner Javadoc")
    @Test
    public void parallelBranchOrdering() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.createProject(WorkflowJob.class);
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("parallel(\n  '1': { echo '1' },\n  '2': { semaphore('2') },\n  '3': { echo '3' },\n  '4': { semaphore('4') },\n  '5': { echo '5' },\n)", true));
        WorkflowRun b = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).waitForStart();
        SemaphoreStep.waitForStart((String)"2/1", (Run)b);
        SemaphoreStep.waitForStart((String)"4/1", (Run)b);
        this.sanityTestIterationAndVisiter(b.getExecution().getCurrentHeads());
        ForkScannerTest.assertBranchOrder(b.getExecution(), "5", "4", "3", "2", "1");
        SemaphoreStep.success((String)"2/1", null);
        SemaphoreStep.success((String)"4/1", null);
        this.r.assertBuildStatusSuccess((Run)((WorkflowRun)this.r.waitForCompletion((Run)b)));
        this.sanityTestIterationAndVisiter(b.getExecution().getCurrentHeads());
        ForkScannerTest.assertBranchOrder(b.getExecution(), "5", "4", "3", "2", "1");
    }

    private static void assertBranchOrder(FlowExecution execution, String ... expectedBranchNames) {
        ForkScanner scanner = new ForkScanner();
        scanner.setup((Collection)execution.getCurrentHeads());
        String[] branches = (String[])StreamSupport.stream(scanner.spliterator(), false).map(n -> (ThreadNameAction)n.getPersistentAction(ThreadNameAction.class)).filter(Objects::nonNull).map(ThreadNameAction::getThreadName).collect(Collectors.toList()).toArray(String[]::new);
        MatcherAssert.assertThat((Object)branches, (Matcher)Matchers.equalTo((Object)expectedBranchNames));
    }
}

