/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.graph;

import com.google.common.base.Predicate;
import hudson.model.Action;
import hudson.model.BallColor;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jenkinsci.plugins.workflow.actions.ArgumentsAction;
import org.jenkinsci.plugins.workflow.actions.WarningAction;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.BlockStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graph.StandardGraphLookupView;
import org.jenkinsci.plugins.workflow.graphanalysis.DepthFirstScanner;
import org.jenkinsci.plugins.workflow.graphanalysis.NodeStepTypePredicate;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.test.steps.SemaphoreStep;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.model.Statement;
import org.jvnet.hudson.test.LoggerRule;
import org.jvnet.hudson.test.RestartableJenkinsRule;
import org.jvnet.hudson.test.TestExtension;
import org.kohsuke.stapler.DataBoundConstructor;

public class FlowNodeTest {
    @Rule
    public RestartableJenkinsRule rr = new RestartableJenkinsRule();
    @Rule
    public LoggerRule logging = new LoggerRule().record(FlowNode.class, Level.FINER);

    @Test
    public void isActive() {
        this.rr.addStep(new Statement(){

            public void evaluate() throws Throwable {
                WorkflowJob p = (WorkflowJob)FlowNodeTest.this.rr.j.createProject(WorkflowJob.class, "p");
                p.setDefinition((FlowDefinition)new CpsFlowDefinition("semaphore 'pre-outer'\nstage('outer') {\n  semaphore 'pre-inner'\n  stage('inner') {\n    semaphore 'inner'\n  }\n  semaphore 'post-inner'\n}\nsemaphore 'post-outer'\nparallel a: {\n  semaphore 'branch-a'\n}, b: {\n  semaphore 'branch-b'\n}\nsemaphore 'last'", true));
                WorkflowRun b = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).waitForStart();
                SemaphoreStep.waitForStart((String)"pre-outer/1", (Run)b);
                FlowNodeTest.assertActiveSteps(b, "Start of Pipeline", "semaphore: pre-outer");
                SemaphoreStep.success((String)"pre-outer/1", null);
                SemaphoreStep.waitForStart((String)"pre-inner/1", (Run)b);
            }
        });
        this.rr.addStep(new Statement(){

            public void evaluate() throws Throwable {
                WorkflowRun b = ((WorkflowJob)FlowNodeTest.this.rr.j.jenkins.getItemByFullName("p", WorkflowJob.class)).getLastBuild();
                FlowNodeTest.assertActiveSteps(b, "Start of Pipeline", "stage: outer", "{ (outer)", "semaphore: pre-inner");
                SemaphoreStep.success((String)"pre-inner/1", null);
                SemaphoreStep.waitForStart((String)"inner/1", (Run)b);
                FlowNodeTest.assertActiveSteps(b, "Start of Pipeline", "stage: outer", "{ (outer)", "stage: inner", "{ (inner)", "semaphore: inner");
                SemaphoreStep.success((String)"inner/1", null);
                SemaphoreStep.waitForStart((String)"post-inner/1", (Run)b);
                FlowNodeTest.assertActiveSteps(b, "Start of Pipeline", "stage: outer", "{ (outer)", "semaphore: post-inner");
                SemaphoreStep.success((String)"post-inner/1", null);
                SemaphoreStep.waitForStart((String)"post-outer/1", (Run)b);
                FlowNodeTest.assertActiveSteps(b, "Start of Pipeline", "semaphore: post-outer");
                SemaphoreStep.success((String)"post-outer/1", null);
                SemaphoreStep.waitForStart((String)"branch-a/1", (Run)b);
                SemaphoreStep.waitForStart((String)"branch-b/1", (Run)b);
            }
        });
        this.rr.addStep(new Statement(){

            public void evaluate() throws Throwable {
                WorkflowRun b = ((WorkflowJob)FlowNodeTest.this.rr.j.jenkins.getItemByFullName("p", WorkflowJob.class)).getLastBuild();
                FlowNodeTest.assertActiveSteps(b, "{ (Branch: a)", "semaphore: branch-a", "Start of Pipeline", "parallel", "{ (Branch: b)", "semaphore: branch-b");
                SemaphoreStep.success((String)"branch-a/1", null);
                SemaphoreStep.success((String)"branch-b/1", null);
                SemaphoreStep.waitForStart((String)"last/1", (Run)b);
                FlowNodeTest.assertActiveSteps(b, "Start of Pipeline", "semaphore: last");
                SemaphoreStep.success((String)"last/1", null);
                FlowNodeTest.this.rr.j.waitForCompletion((Run)b);
                FlowNodeTest.assertActiveSteps(b, new String[0]);
            }
        });
    }

    private static void assertActiveSteps(WorkflowRun b, String ... expected) throws Exception {
        List<String> expectedList = Arrays.asList(expected);
        Collections.sort(expectedList);
        ArrayList<Object> actual = new ArrayList<Object>();
        DepthFirstScanner scan = new DepthFirstScanner();
        for (FlowNode n : scan.allNodes(b.getExecution())) {
            if (!n.isActive()) continue;
            String args = ArgumentsAction.getStepArgumentsAsString((FlowNode)n);
            String name = n.getDisplayFunctionName();
            actual.add(args != null ? name + ": " + args : name);
        }
        Collections.sort(actual);
        Assert.assertEquals(expectedList, actual);
        Method m = FlowExecution.class.getDeclaredMethod("getInternalGraphLookup", null);
        m.setAccessible(true);
        Object ob = m.invoke((Object)b.getExecution(), null);
        StandardGraphLookupView view = (StandardGraphLookupView)ob;
        ((StandardGraphLookupView)ob).clearCache();
        actual.clear();
        for (FlowNode n : scan.allNodes(b.getExecution())) {
            if (!n.isActive()) continue;
            String args = ArgumentsAction.getStepArgumentsAsString((FlowNode)n);
            String name = n.getDisplayFunctionName();
            actual.add(args != null ? name + ": " + args : name);
        }
        Collections.sort(actual);
        Assert.assertEquals(expectedList, actual);
    }

    @Test
    public void enclosingBlocksSingleBlock() {
        this.rr.addStep(new Statement(){

            public void evaluate() throws Throwable {
                WorkflowJob job = (WorkflowJob)FlowNodeTest.this.rr.j.createProject(WorkflowJob.class, "enclosingBlocks");
                job.setDefinition((FlowDefinition)new CpsFlowDefinition("catchError {echo 'bob';}", true));
                WorkflowRun r = (WorkflowRun)FlowNodeTest.this.rr.j.buildAndAssertSuccess((Job)job);
                FlowExecution execution = r.getExecution();
                FlowNodeTest.this.assertExpectedEnclosing(execution, "2", null);
                FlowNodeTest.this.assertExpectedEnclosing(execution, "3", "2");
                FlowNodeTest.this.assertExpectedEnclosing(execution, "4", "3");
                FlowNodeTest.this.assertExpectedEnclosing(execution, "5", "4");
                FlowNodeTest.this.assertExpectedEnclosing(execution, "6", "3");
                FlowNodeTest.this.assertExpectedEnclosing(execution, "7", "2");
                FlowNodeTest.this.assertExpectedEnclosing(execution, "8", null);
            }
        });
    }

    @Test
    public void enclosingBlocks() {
        this.rr.addStep(new Statement(){

            public void evaluate() throws Throwable {
                WorkflowJob job = (WorkflowJob)FlowNodeTest.this.rr.j.createProject(WorkflowJob.class, "enclosingBlocks");
                job.setDefinition((FlowDefinition)new CpsFlowDefinition("stage('outermost') {\n  echo 'in outermost'\n  parallel(a: {\n    stage('inner-a') {\n      echo 'in inner-a'\n      stage('innermost-a') {\n        echo 'in innermost-a'\n      }\n    }\n  },\n  b: {\n    stage('inner-b') {\n      echo 'in inner-b'\n      stage('innermost-b') {\n        echo 'in innermost-b'\n      }\n    }\n  })\n}\n", true));
                WorkflowRun r = (WorkflowRun)FlowNodeTest.this.rr.j.buildAndAssertSuccess((Job)job);
                FlowExecution execution = r.getExecution();
                FlowNodeTest.this.assertExpectedEnclosing(execution, "2", null);
                FlowNodeTest.this.assertExpectedEnclosing(execution, "3", "2");
                FlowNodeTest.this.assertExpectedEnclosing(execution, "4", "3");
                FlowNodeTest.this.assertExpectedEnclosing(execution, "5", "4");
                FlowNodeTest.this.assertExpectedEnclosing(execution, "6", "4");
                FlowNodeTest.this.assertExpectedEnclosing(execution, "8", "6");
                FlowNodeTest.this.assertExpectedEnclosing(execution, "9", "6");
                FlowNodeTest.this.assertExpectedEnclosing(execution, "10", "8");
                FlowNodeTest.this.assertExpectedEnclosing(execution, "11", "10");
                FlowNodeTest.this.assertExpectedEnclosing(execution, "12", "9");
                FlowNodeTest.this.assertExpectedEnclosing(execution, "13", "12");
                FlowNodeTest.this.assertExpectedEnclosing(execution, "14", "11");
                FlowNodeTest.this.assertExpectedEnclosing(execution, "15", "11");
                FlowNodeTest.this.assertExpectedEnclosing(execution, "16", "15");
                FlowNodeTest.this.assertExpectedEnclosing(execution, "17", "13");
                FlowNodeTest.this.assertExpectedEnclosing(execution, "18", "13");
                FlowNodeTest.this.assertExpectedEnclosing(execution, "19", "18");
                FlowNodeTest.this.assertExpectedEnclosing(execution, "20", "16");
                FlowNodeTest.this.assertExpectedEnclosing(execution, "21", "15");
                FlowNodeTest.this.assertExpectedEnclosing(execution, "22", "19");
                FlowNodeTest.this.assertExpectedEnclosing(execution, "23", "18");
                FlowNodeTest.this.assertExpectedEnclosing(execution, "24", "11");
                FlowNodeTest.this.assertExpectedEnclosing(execution, "25", "13");
                FlowNodeTest.this.assertExpectedEnclosing(execution, "26", "10");
                FlowNodeTest.this.assertExpectedEnclosing(execution, "27", "12");
                FlowNodeTest.this.assertExpectedEnclosing(execution, "28", "8");
                FlowNodeTest.this.assertExpectedEnclosing(execution, "29", "9");
                FlowNodeTest.this.assertExpectedEnclosing(execution, "30", "6");
                FlowNodeTest.this.assertExpectedEnclosing(execution, "31", "6");
                FlowNodeTest.this.assertExpectedEnclosing(execution, "32", "4");
                FlowNodeTest.this.assertExpectedEnclosing(execution, "33", "3");
                FlowNodeTest.this.assertExpectedEnclosing(execution, "34", "2");
                FlowNodeTest.this.assertExpectedEnclosing(execution, "35", null);
            }
        });
    }

    @Test
    public void useAbortedStatusWhenFailFast() {
        this.rr.then(r -> {
            WorkflowJob job = (WorkflowJob)r.jenkins.createProject(WorkflowJob.class, "p");
            job.setDefinition((FlowDefinition)new CpsFlowDefinition("jobs = [failFast:true]\njobs['one'] = {\n  sleep 5\n}\njobs['two'] = {\n  error 'failing'\n}\nparallel jobs", true));
            WorkflowRun b = (WorkflowRun)r.assertBuildStatus(Result.FAILURE, (Run)((WorkflowRun)job.scheduleBuild2(0, new Action[0]).get()));
            List coreStepNodes = new DepthFirstScanner().filteredNodes(b.getExecution(), (Predicate)new NodeStepTypePredicate("sleep"));
            MatcherAssert.assertThat((Object)coreStepNodes, (Matcher)Matchers.hasSize((int)1));
            Assert.assertEquals((Object)"sleep", (Object)((FlowNode)coreStepNodes.get(0)).getDisplayFunctionName());
            Assert.assertNotNull((Object)((FlowNode)coreStepNodes.get(0)).getError());
            Assert.assertNotNull((Object)((FlowNode)coreStepNodes.get(0)).getError().getError());
            Assert.assertEquals((Object)BallColor.ABORTED, (Object)((FlowNode)coreStepNodes.get(0)).getIconColor());
        });
    }

    @Test
    public void iconColorUsesWarningActionResult() {
        this.rr.then(r -> {
            WorkflowJob job = (WorkflowJob)r.jenkins.createProject(WorkflowJob.class, "p");
            job.setDefinition((FlowDefinition)new CpsFlowDefinition("warning('UNSTABLE')\nwarning('FAILURE')\n", true));
            WorkflowRun b = (WorkflowRun)r.assertBuildStatus(Result.SUCCESS, (Run)((WorkflowRun)job.scheduleBuild2(0, new Action[0]).get()));
            List nodes = new DepthFirstScanner().filteredNodes(b.getExecution(), (Predicate)new NodeStepTypePredicate("warning"));
            MatcherAssert.assertThat((Object)nodes, (Matcher)Matchers.hasSize((int)2));
            this.assertWarning((FlowNode)nodes.get(0), Result.FAILURE, BallColor.RED);
            this.assertWarning((FlowNode)nodes.get(1), Result.UNSTABLE, BallColor.YELLOW);
        });
    }

    @Test
    public void nodeWithNoParentsInBruteForceScanForEnclosingBlock() {
        this.logging.capture(10);
        this.rr.thenWithHardShutdown(j -> {
            WorkflowJob job = (WorkflowJob)j.jenkins.createProject(WorkflowJob.class, "p");
            job.setDefinition((FlowDefinition)new CpsFlowDefinition("echo 'to-corrupt'\nsleep 1\nsemaphore 'marker'", true));
            WorkflowRun run = (WorkflowRun)job.scheduleBuild2(0, new Action[0]).waitForStart();
            SemaphoreStep.waitForStart((String)"marker/1", (Run)run);
            CpsFlowExecution cpsExec = (CpsFlowExecution)run.getExecution();
            Files.write(cpsExec.getStorageDir().toPath().resolve("3.xml"), "garbage".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        });
        this.rr.then(j -> {
            WorkflowJob job = (WorkflowJob)j.jenkins.getItemByFullName("p", WorkflowJob.class);
            WorkflowRun run = job.getBuildByNumber(1);
            CpsFlowExecution cpsExec = (CpsFlowExecution)run.getExecution();
            MatcherAssert.assertThat((Object)((FlowNode)cpsExec.getCurrentHeads().get(0)).getEnclosingBlocks(), (Matcher)Matchers.hasSize((int)0));
            MatcherAssert.assertThat((Object)this.logging.getMessages(), (Matcher)Matchers.hasItem((Object)"failed to load parents of 4"));
        });
    }

    @Test
    public void addOrReplaceActionWorks() {
        this.rr.then(r -> {
            WorkflowJob j = (WorkflowJob)r.createProject(WorkflowJob.class);
            j.setDefinition((FlowDefinition)new CpsFlowDefinition("doubleWarning()", true));
            r.buildAndAssertSuccess((Job)j);
        });
    }

    private void assertWarning(FlowNode node, Result expectedResult, BallColor expectedColor) {
        WarningAction warningAction = (WarningAction)node.getPersistentAction(WarningAction.class);
        Assert.assertNotNull((Object)warningAction);
        Assert.assertEquals((Object)expectedResult, (Object)warningAction.getResult());
        Assert.assertEquals((Object)expectedColor, (Object)node.getIconColor());
    }

    private void assertExpectedEnclosing(FlowExecution execution, String nodeId, String enclosingId) throws Exception {
        FlowNode node = execution.getNode(nodeId);
        Assert.assertNotNull((Object)node);
        String secondEnclosingId = node.getEnclosingId();
        Assert.assertEquals((String)MessageFormat.format("Node {0}: enclosingID doesn't match between first and second fetches", node), (Object)enclosingId, (Object)secondEnclosingId);
        if (enclosingId == null) {
            Assert.assertTrue((String)MessageFormat.format("Node {0} and enclosingId {1}: null enclosing ID, but non-empty list of enclosing IDs", node, enclosingId), (boolean)node.getAllEnclosingIds().isEmpty());
            Assert.assertTrue((String)MessageFormat.format("Node {0} and enclosingId {1}: null enclosing ID, but non-empty list of enclosing blocks", node, enclosingId), (boolean)node.getEnclosingBlocks().isEmpty());
        } else {
            FlowNode enclosingNode = execution.getNode(enclosingId);
            Assert.assertNotNull((String)MessageFormat.format("Node {0} and enclosingId {1}: no node with enclosing ID exists", node, enclosingId), (Object)enclosingNode);
            List enclosingIds = node.getAllEnclosingIds();
            List<String> enclosingIdsIncludingNode = this.enclosingIdsIncludingNode(enclosingNode);
            ArrayList<String> iteratedEnclosingBlockIds = new ArrayList<String>();
            for (BlockStartNode bsn : node.iterateEnclosingBlocks()) {
                iteratedEnclosingBlockIds.add(bsn.getId());
            }
            Assert.assertArrayEquals((Object[])enclosingIds.toArray(), (Object[])enclosingIdsIncludingNode.toArray());
            Assert.assertArrayEquals((Object[])this.enclosingIdsIncludingNode(enclosingNode).toArray(), (Object[])node.getAllEnclosingIds().toArray());
            Assert.assertArrayEquals((Object[])this.enclosingBlocksIncludingNode(enclosingNode).toArray(), (Object[])node.getEnclosingBlocks().toArray());
            Assert.assertArrayEquals((Object[])this.enclosingIdsIncludingNode(enclosingNode).toArray(), (Object[])iteratedEnclosingBlockIds.toArray());
        }
    }

    private List<String> enclosingIdsIncludingNode(FlowNode node) {
        ArrayList<String> encl = new ArrayList<String>();
        encl.add(node.getId());
        encl.addAll(node.getAllEnclosingIds());
        return encl;
    }

    private List<FlowNode> enclosingBlocksIncludingNode(FlowNode node) {
        ArrayList<FlowNode> encl = new ArrayList<FlowNode>();
        encl.add(node);
        encl.addAll(node.getEnclosingBlocks());
        return encl;
    }

    public static class DoubleWarningStep
    extends Step {
        @DataBoundConstructor
        public DoubleWarningStep() {
        }

        public StepExecution start(StepContext context) {
            return new StepExecution(context){

                public boolean start() throws Exception {
                    ((FlowNode)this.getContext().get(FlowNode.class)).addAction((Action)new WarningAction(Result.FAILURE).withMessage("First"));
                    ((FlowNode)this.getContext().get(FlowNode.class)).addOrReplaceAction((Action)new WarningAction(Result.FAILURE).withMessage("Second"));
                    this.getContext().onSuccess(null);
                    return true;
                }
            };
        }

        @TestExtension(value={"addOrReplaceActionWorks"})
        public static class DescriptorImpl
        extends StepDescriptor {
            public String getFunctionName() {
                return "doubleWarning";
            }

            public Set<? extends Class<?>> getRequiredContext() {
                return Collections.singleton(FlowNode.class);
            }
        }
    }

    public static class WarningStep
    extends Step {
        private final Result result;

        @DataBoundConstructor
        public WarningStep(String result) {
            this.result = Result.fromString((String)result);
        }

        public StepExecution start(StepContext sc) {
            class Execution
            extends StepExecution {
                private final Result result;

                public Execution(StepContext sc, Result result) {
                    super(sc);
                    this.result = result;
                }

                public boolean start() throws Exception {
                    ((FlowNode)this.getContext().get(FlowNode.class)).addAction((Action)new WarningAction(this.result));
                    this.getContext().onSuccess(null);
                    return true;
                }
            }
            return new Execution(sc, this.result);
        }

        @TestExtension(value={"iconColorUsesWarningActionResult"})
        public static class DescriptorImpl
        extends StepDescriptor {
            public String getFunctionName() {
                return "warning";
            }

            public Set<? extends Class<?>> getRequiredContext() {
                return Collections.singleton(FlowNode.class);
            }
        }
    }
}

