/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.graphanalysis;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import hudson.model.Action;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.Future;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.FlowGraphWalker;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graphanalysis.AbstractFlowScanner;
import org.jenkinsci.plugins.workflow.graphanalysis.DepthFirstScanner;
import org.jenkinsci.plugins.workflow.graphanalysis.Filterator;
import org.jenkinsci.plugins.workflow.graphanalysis.FlowNodeVisitor;
import org.jenkinsci.plugins.workflow.graphanalysis.FlowTestUtils;
import org.jenkinsci.plugins.workflow.graphanalysis.ForkScanner;
import org.jenkinsci.plugins.workflow.graphanalysis.LinearBlockHoppingScanner;
import org.jenkinsci.plugins.workflow.graphanalysis.LinearScanner;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.BuildWatcher;
import org.jvnet.hudson.test.JenkinsRule;

public class FlowScannerTest {
    @ClassRule
    public static BuildWatcher buildWatcher = new BuildWatcher();
    @Rule
    public JenkinsRule r = new JenkinsRule();

    @Test
    public void testAbstractScanner() throws Exception {
        int i;
        WorkflowJob job = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "SimpleLinear");
        job.setDefinition((FlowDefinition)new CpsFlowDefinition("sleep 2 \necho 'donothing'\necho 'doitagain'", true));
        WorkflowRun b = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)job.scheduleBuild2(0, new Action[0]));
        FlowExecution exec = b.getExecution();
        List heads = exec.getCurrentHeads();
        FlowNode intermediateNode = exec.getNode("4");
        LinearScanner linear = new LinearScanner();
        Assert.assertEquals(Collections.emptySet(), (Object)linear.convertToFastCheckable(null));
        Assert.assertEquals(Collections.emptySet(), (Object)linear.convertToFastCheckable(new ArrayList()));
        Collection coll = linear.convertToFastCheckable(Collections.singletonList(intermediateNode));
        Assert.assertTrue((String)"Singleton set used for one element", (boolean)(coll instanceof AbstractSet));
        Assert.assertEquals((long)1L, (long)coll.size());
        List<FlowNode> multipleItems = Arrays.asList(exec.getNode("3"), exec.getNode("2"));
        coll = linear.convertToFastCheckable(multipleItems);
        Assert.assertTrue((String)"Original used for short list", (boolean)(coll instanceof List));
        Assert.assertEquals((long)2L, (long)coll.size());
        coll = linear.convertToFastCheckable(new LinkedHashSet<FlowNode>(multipleItems));
        Assert.assertTrue((String)"Original used where set", (boolean)(coll instanceof LinkedHashSet));
        multipleItems = new ArrayList<FlowNode>();
        for (i = 0; i < 3; ++i) {
            multipleItems.add(intermediateNode);
        }
        coll = linear.convertToFastCheckable(multipleItems);
        Assert.assertTrue((String)"Original used for short list", (boolean)(coll instanceof List));
        Assert.assertEquals((long)3L, (long)coll.size());
        multipleItems = new ArrayList<FlowNode>();
        for (i = 0; i < 10; ++i) {
            multipleItems.add(intermediateNode);
        }
        coll = linear.convertToFastCheckable(multipleItems);
        Assert.assertTrue((String)"Original used for short list", (boolean)(coll instanceof HashSet));
        Assert.assertEquals((long)1L, (long)coll.size());
        FlowNode lastNode = (FlowNode)heads.get(0);
        FlowNode nullNode = null;
        Collection nullColl = null;
        Assert.assertTrue((boolean)linear.setup((Collection)heads, null));
        Assert.assertTrue((boolean)linear.setup((Collection)heads, Collections.emptySet()));
        Assert.assertFalse((boolean)linear.setup(nullColl, (Collection)heads));
        Assert.assertFalse((boolean)linear.setup(nullColl, null));
        Assert.assertFalse((boolean)linear.setup((Collection)heads, (Collection)heads));
        Assert.assertTrue((boolean)linear.setup((Collection)heads));
        Assert.assertFalse((boolean)linear.setup(nullColl));
        Assert.assertFalse((boolean)linear.setup(Collections.emptySet()));
        Assert.assertTrue((boolean)linear.setup(lastNode));
        Assert.assertTrue((boolean)linear.setup(lastNode, nullColl));
        Assert.assertFalse((boolean)linear.setup(nullNode));
        Assert.assertFalse((boolean)linear.setup(nullNode, (Collection)heads));
        Assert.assertFalse((boolean)linear.setup(nullNode, nullColl));
        Assert.assertTrue((boolean)linear.setup(Arrays.asList(intermediateNode, lastNode), Collections.singleton(intermediateNode)));
        Assert.assertEquals((Object)lastNode, (Object)linear.myCurrent);
        int[] ids = new int[]{6, 5, 4, 3, 2};
        FlowNode firstEchoNode = exec.getNode("5");
        FlowExecution nullExecution = null;
        Assert.assertEquals((Object)firstEchoNode, (Object)linear.findFirstMatch((Collection)heads, Collections.emptySet(), FlowTestUtils.MATCH_ECHO_STEP));
        Assert.assertEquals((Object)firstEchoNode, (Object)linear.findFirstMatch((Collection)heads, FlowTestUtils.MATCH_ECHO_STEP));
        Assert.assertEquals((Object)firstEchoNode, (Object)linear.findFirstMatch(lastNode, FlowTestUtils.MATCH_ECHO_STEP));
        Assert.assertEquals((Object)firstEchoNode, (Object)linear.findFirstMatch(exec, FlowTestUtils.MATCH_ECHO_STEP));
        Assert.assertNull((Object)linear.findFirstMatch(nullColl, FlowTestUtils.MATCH_ECHO_STEP));
        Assert.assertNull((Object)linear.findFirstMatch(Collections.emptySet(), FlowTestUtils.MATCH_ECHO_STEP));
        Assert.assertNull((Object)linear.findFirstMatch(nullNode, FlowTestUtils.MATCH_ECHO_STEP));
        Assert.assertNull((Object)linear.findFirstMatch(nullExecution, FlowTestUtils.MATCH_ECHO_STEP));
        FlowTestUtils.assertNodeOrder("Filtered echo nodes", (Iterable<FlowNode>)linear.filteredNodes((Collection)heads, FlowTestUtils.MATCH_ECHO_STEP), 5, 4);
        FlowTestUtils.assertNodeOrder("Filtered echo nodes", (Iterable<FlowNode>)linear.filteredNodes((Collection)heads, Collections.singleton(intermediateNode), FlowTestUtils.MATCH_ECHO_STEP), 5);
        Assert.assertEquals((long)0L, (long)linear.filteredNodes((Collection)heads, null, Predicates.alwaysFalse()).size());
        Assert.assertEquals((long)0L, (long)linear.filteredNodes(nullNode, FlowTestUtils.MATCH_ECHO_STEP).size());
        Assert.assertEquals((long)0L, (long)linear.filteredNodes(Collections.emptySet(), FlowTestUtils.MATCH_ECHO_STEP).size());
        linear.setup((Collection)heads);
        ArrayList<FlowNode> collected = new ArrayList<FlowNode>();
        Filterator filt = linear.filter(FlowTestUtils.MATCH_ECHO_STEP);
        while (filt.hasNext()) {
            collected.add((FlowNode)filt.next());
        }
        FlowTestUtils.assertNodeOrder("Filterator filtered echo nodes", collected, 5, 4);
        FlowTestUtils.CollectingVisitor visitor = new FlowTestUtils.CollectingVisitor();
        linear.visitAll(Collections.emptySet(), (FlowNodeVisitor)visitor);
        Assert.assertEquals((long)0L, (long)visitor.getVisited().size());
        visitor.reset();
        linear.visitAll((Collection)heads, (FlowNodeVisitor)visitor);
        FlowTestUtils.assertNodeOrder("Visiting all nodes", visitor.getVisited(), 6, 5, 4, 3, 2);
        visitor.reset();
        linear.visitAll((Collection)heads, Collections.singleton(intermediateNode), (FlowNodeVisitor)visitor);
        FlowTestUtils.assertNodeOrder("Visiting all nodes with blacklist", visitor.getVisited(), 6, 5);
        linear.myNext = null;
        Assert.assertFalse((boolean)linear.hasNext());
        try {
            linear.next();
            Assert.fail((String)"Should throw NoSuchElement exception");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        Assert.assertSame((Object)linear.iterator(), (Object)linear);
        try {
            linear.remove();
            Assert.fail((String)"Should throw UnsupportedOperation exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testSimpleScan() throws Exception {
        WorkflowJob job = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "Convoluted");
        job.setDefinition((FlowDefinition)new CpsFlowDefinition("sleep 2 \necho 'donothing'\necho 'doitagain'", true));
        WorkflowRun b = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)job.scheduleBuild2(0, new Action[0]));
        FlowExecution exec = b.getExecution();
        AbstractFlowScanner[] scans = new AbstractFlowScanner[]{new LinearScanner(), new DepthFirstScanner(), new ForkScanner()};
        List heads = exec.getCurrentHeads();
        for (AbstractFlowScanner scan : scans) {
            System.out.println("Iteration test with scanner: " + String.valueOf(scan.getClass()));
            scan.setup((Collection)heads, null);
            FlowTestUtils.assertNodeOrder("Testing full scan for scanner " + String.valueOf(scan.getClass()), (Iterable<FlowNode>)scan, 6, 5, 4, 3, 2);
            Assert.assertFalse((boolean)scan.hasNext());
            scan.setup((Collection)heads, Collections.singleton(exec.getNode("4")));
            FlowTestUtils.assertNodeOrder("Testing full scan for scanner " + String.valueOf(scan.getClass()), (Iterable<FlowNode>)scan, 6, 5);
            FlowNode f = scan.findFirstMatch((Collection)heads, Collections.singleton(exec.getNode("6")), Predicates.alwaysTrue());
            Assert.assertNull((Object)f);
        }
    }

    @Test
    public void testBasicScanWithBlock() throws Exception {
        WorkflowJob job = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "Convoluted");
        job.setDefinition((FlowDefinition)new CpsFlowDefinition("echo 'first'\ntimeout(time: 10, unit: 'SECONDS') {\n    echo 'second'\n    echo 'third'\n}\nsleep 1", true));
        WorkflowRun b = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)job.scheduleBuild2(0, new Action[0]));
        Predicate<FlowNode> matchEchoStep = FlowTestUtils.predicateMatchStepDescriptor("org.jenkinsci.plugins.workflow.steps.EchoStep");
        FlowExecution exec = b.getExecution();
        List heads = exec.getCurrentHeads();
        LinearScanner linearScanner = new LinearScanner();
        linearScanner.setup((Collection)heads);
        FlowTestUtils.assertNodeOrder("Linear scan with block", (Iterable<FlowNode>)linearScanner, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2);
        linearScanner.setup(exec.getNode("7"));
        FlowTestUtils.assertNodeOrder("Linear scan with block from middle ", (Iterable<FlowNode>)linearScanner, 7, 6, 5, 4, 3, 2);
        LinearBlockHoppingScanner linearBlockHoppingScanner = new LinearBlockHoppingScanner();
        FlowNode headCandidate = exec.getNode("8");
        Assert.assertEquals((Object)exec.getNode("4"), (Object)linearBlockHoppingScanner.jumpBlockScan(headCandidate, Collections.emptySet()));
        Assert.assertTrue((String)"Setup should return true if we can iterate", (boolean)linearBlockHoppingScanner.setup(headCandidate, null));
        linearBlockHoppingScanner.setup((Collection)heads);
        Assert.assertFalse((boolean)linearBlockHoppingScanner.hasNext());
        linearBlockHoppingScanner.setup(exec.getNode("8"));
        FlowTestUtils.assertNodeOrder("Hopping over one block", (Iterable<FlowNode>)linearBlockHoppingScanner, 4, 3, 2);
        linearBlockHoppingScanner.setup(exec.getNode("7"));
        FlowTestUtils.assertNodeOrder("Hopping over one block", (Iterable<FlowNode>)linearBlockHoppingScanner, 7, 6, 5, 4, 3, 2);
        linearBlockHoppingScanner.setup(exec.getNode("8"), Collections.singleton(exec.getNode("5")));
        Assert.assertFalse((boolean)linearBlockHoppingScanner.hasNext());
        linearBlockHoppingScanner.setup(exec.getNode("8"), Collections.singleton(exec.getNode("4")));
        Assert.assertFalse((boolean)linearBlockHoppingScanner.hasNext());
    }

    @Test
    public void testParallelScan() throws Exception {
        WorkflowJob job = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "Convoluted");
        job.setDefinition((FlowDefinition)new CpsFlowDefinition("echo 'first'\ndef steps = [:]\nsteps['1'] = {\n    echo 'do 1 stuff'\n}\nsteps['2'] = {\n    echo '2a'\n    echo '2b'\n}\nparallel steps\necho 'final'", true));
        WorkflowRun b = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)job.scheduleBuild2(0, new Action[0]));
        FlowExecution exec = b.getExecution();
        List heads = b.getExecution().getCurrentHeads();
        LinearScanner scanner = new LinearScanner();
        scanner.setup((Collection)heads);
        FlowTestUtils.assertNodeOrder("Linear", (Iterable<FlowNode>)scanner, 15, 14, 13, 9, 8, 6, 4, 3, 2);
        scanner.setup((Collection)heads, Collections.singleton(exec.getNode("9")));
        FlowTestUtils.assertNodeOrder("Linear", (Iterable<FlowNode>)scanner, 15, 14, 13, 12, 11, 10, 7, 4, 3, 2);
        scanner = new DepthFirstScanner();
        scanner.setup((Collection)heads);
        FlowTestUtils.assertNodeOrder("FlowGraphWalker", (Iterable<FlowNode>)new FlowGraphWalker(exec), 15, 14, 13, 9, 8, 6, 4, 3, 2, 12, 11, 10, 7);
        FlowTestUtils.assertNodeOrder("Depth first", (Iterable<FlowNode>)new FlowGraphWalker(exec), 15, 14, 13, 9, 8, 6, 4, 3, 2, 12, 11, 10, 7);
        scanner.setup((Collection)heads, Collections.singleton(exec.getNode("9")));
        FlowTestUtils.assertNodeOrder("Linear", (Iterable<FlowNode>)scanner, 15, 14, 13, 12, 11, 10, 7, 4, 3, 2);
        scanner.setup(Arrays.asList(exec.getNode("9"), exec.getNode("12")));
        FlowTestUtils.assertNodeOrder("Depth-first scanner from inside parallels", (Iterable<FlowNode>)scanner, 9, 8, 6, 4, 3, 2, 12, 11, 10, 7);
        scanner = new ForkScanner();
        scanner.setup((Collection)heads);
        FlowTestUtils.assertNodeOrder("ForkedScanner", (Iterable<FlowNode>)scanner, 15, 14, 13, 12, 11, 10, 7, 9, 8, 6, 4, 3, 2);
        scanner.setup((Collection)heads, Collections.singleton(exec.getNode("9")));
        FlowTestUtils.assertNodeOrder("ForkedScanner", (Iterable<FlowNode>)scanner, 15, 14, 13, 12, 11, 10, 7, 4, 3, 2);
        scanner.setup(exec.getNode("14"));
        FlowTestUtils.assertNodeOrder("ForkedScanner", (Iterable<FlowNode>)scanner, 14, 13, 12, 11, 10, 7, 9, 8, 6, 4, 3, 2);
        List<FlowNode> startingPoints = Arrays.asList(exec.getNode("9"), exec.getNode("12"));
        scanner.setup(startingPoints);
        FlowTestUtils.assertNodeOrder("ForkedScanner", (Iterable<FlowNode>)scanner, 9, 8, 6, 12, 11, 10, 7, 4, 3, 2);
        startingPoints = Arrays.asList(exec.getNode("9"), exec.getNode("11"));
        scanner.setup(startingPoints);
        FlowTestUtils.assertNodeOrder("ForkedScanner", (Iterable<FlowNode>)scanner, 9, 8, 6, 11, 10, 7, 4, 3, 2);
        List<FlowNode> blackList = Arrays.asList(exec.getNode("6"), exec.getNode("7"));
        Assert.assertEquals((long)4L, (long)scanner.filteredNodes((Collection)heads, blackList, FlowTestUtils.MATCH_ECHO_STEP).size());
        Assert.assertEquals((long)4L, (long)scanner.filteredNodes((Collection)heads, Collections.singletonList(exec.getNode("4")), FlowTestUtils.MATCH_ECHO_STEP).size());
        blackList = Arrays.asList(exec.getNode("6"), exec.getNode("10"));
        Assert.assertEquals((long)3L, (long)scanner.filteredNodes((Collection)heads, blackList, FlowTestUtils.MATCH_ECHO_STEP).size());
    }

    @Test
    public void testNestedParallelScan() throws Exception {
        WorkflowJob job = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "Convoluted");
        job.setDefinition((FlowDefinition)new CpsFlowDefinition("echo 'first'\ndef steps = [:]\nsteps['1'] = {\n    echo 'do 1 stuff'\n}\nsteps['2'] = {\n    echo '2a'\n    def nested = [:]\n    nested['2-1'] = {\n        echo 'do 2-1'\n    } \n    nested['2-2'] = {\n        sleep 1\n        echo '2 section 2'\n    }\n    echo '2b'\n    parallel nested\n}\nparallel steps\necho 'final'", true));
        WorkflowRun b = (WorkflowRun)this.r.assertBuildStatusSuccess((Future)job.scheduleBuild2(0, new Action[0]));
        FlowExecution exec = b.getExecution();
        List<FlowNode> heads = b.getExecution().getCurrentHeads();
        DepthFirstScanner scanner = new DepthFirstScanner();
        List matches = scanner.filteredNodes((Collection)heads, null, FlowTestUtils.MATCH_ECHO_STEP);
        Assert.assertEquals((long)7L, (long)matches.size());
        scanner.setup((Collection)heads);
        Assert.assertTrue((String)"FlowGraphWalker differs from DepthFirstScanner", (boolean)Iterators.elementsEqual((Iterator)new FlowGraphWalker(exec).iterator(), (Iterator)scanner.iterator()));
        scanner = new ForkScanner();
        matches = scanner.filteredNodes((Collection)heads, null, FlowTestUtils.MATCH_ECHO_STEP);
        Assert.assertEquals((long)7L, (long)matches.size());
        heads = Arrays.asList(exec.getNode("20"), exec.getNode("17"), exec.getNode("9"));
        matches = scanner.filteredNodes(heads, null, FlowTestUtils.MATCH_ECHO_STEP);
        Assert.assertEquals((long)6L, (long)matches.size());
    }
}

