/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.graphanalysis;

import com.google.common.base.Predicate;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.jenkinsci.plugins.workflow.cps.nodes.StepAtomNode;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graphanalysis.FlowNodeVisitor;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.junit.Assert;

public class FlowTestUtils {
    public static Predicate<FlowNode> MATCH_ECHO_STEP = FlowTestUtils.predicateMatchStepDescriptor("org.jenkinsci.plugins.workflow.steps.EchoStep");

    public static Predicate<FlowNode> predicateMatchStepDescriptor(@NonNull String descriptorId) {
        return input -> {
            if (input instanceof StepAtomNode) {
                StepAtomNode san = (StepAtomNode)input;
                StepDescriptor sd = san.getDescriptor();
                return sd != null && descriptorId.equals(sd.getId());
            }
            return false;
        };
    }

    public static void assertNodeOrder(String description, Iterable<FlowNode> nodes, String ... nodeIds) {
        ArrayList<String> realIds = new ArrayList<String>();
        for (FlowNode f : nodes) {
            Assert.assertNotNull((Object)f);
            realIds.add(f.getId());
        }
        Assert.assertArrayEquals((String)description, (Object[])nodeIds, (Object[])realIds.toArray());
    }

    public static void assertNodeOrder(String description, Iterable<FlowNode> nodes, int ... nodeIds) {
        String[] nodeIdStrings = new String[nodeIds.length];
        for (int i = 0; i < nodeIdStrings.length; ++i) {
            nodeIdStrings[i] = Integer.toString(nodeIds[i]);
        }
        FlowTestUtils.assertNodeOrder(description, nodes, nodeIdStrings);
    }

    public static void addNodesById(Collection<FlowNode> coll, FlowExecution exec, int ... iotas) {
        try {
            for (int nodeId : iotas) {
                coll.add(exec.getNode(Integer.toString(nodeId)));
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Failed to load node by id", ioe);
        }
    }

    public static final class CollectingVisitor
    implements FlowNodeVisitor {
        ArrayList<FlowNode> visited = new ArrayList();

        public boolean visit(@NonNull FlowNode f) {
            this.visited.add(f);
            return true;
        }

        public void reset() {
            this.visited.clear();
        }

        public ArrayList<FlowNode> getVisited() {
            return this.visited;
        }
    }
}

