/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.remoting.Callable;
import hudson.util.DirScanner;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.URLStreamHandler;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.ArtifactManager;
import jenkins.model.ArtifactManagerFactory;
import jenkins.model.ArtifactManagerFactoryDescriptor;
import jenkins.model.Jenkins;
import jenkins.util.VirtualFile;
import org.apache.commons.io.IOUtils;
import org.apache.http.ConnectionClosedException;
import org.apache.http.HttpEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.bootstrap.HttpServer;
import org.apache.http.impl.bootstrap.ServerBootstrap;

public final class DirectArtifactManagerFactory
extends ArtifactManagerFactory {
    private static final Logger LOGGER = Logger.getLogger(DirectArtifactManagerFactory.class.getName());
    private static final AtomicInteger blockOpen = new AtomicInteger();
    private final transient URL baseURL;

    public DirectArtifactManagerFactory() throws Exception {
        HttpServer server = ServerBootstrap.bootstrap().registerHandler("*", (request, response, _context) -> {
            String method = request.getRequestLine().getMethod();
            String contents = URLDecoder.decode(request.getRequestLine().getUri().substring(1), "UTF-8");
            switch (method) {
                case "GET": {
                    response.setStatusCode(200);
                    response.setEntity((HttpEntity)new StringEntity(contents));
                    LOGGER.log(Level.INFO, "Serving \u2018{0}\u2019", contents);
                    return;
                }
            }
            throw new IllegalStateException();
        }).setExceptionLogger(x -> {
            if (x instanceof ConnectionClosedException) {
                LOGGER.info(x.toString());
            } else {
                LOGGER.log(Level.INFO, "error thrown in HTTP service", x);
            }
        }).create();
        server.start();
        this.baseURL = new URL("http", server.getInetAddress().getHostName(), server.getLocalPort(), "/");
        LOGGER.log(Level.INFO, "Mock server running at {0}", this.baseURL);
    }

    public ArtifactManager managerFor(Run<?, ?> build) {
        return new DirectArtifactManager(build, this.baseURL);
    }

    public static <T> T whileBlockingOpen(java.util.concurrent.Callable<T> block) throws Exception {
        blockOpen.incrementAndGet();
        try {
            T t = block.call();
            return t;
        }
        finally {
            blockOpen.decrementAndGet();
        }
    }

    private static final class DirectArtifactManager
    extends ArtifactManager {
        private transient File dir;
        private final transient URL baseURL;

        DirectArtifactManager(Run<?, ?> build, URL baseURL) {
            this.baseURL = baseURL;
            this.onLoad(build);
        }

        public void archive(FilePath workspace, Launcher launcher, BuildListener listener, Map<String, String> artifacts) throws IOException, InterruptedException {
            workspace.copyRecursiveTo((DirScanner)new FilePath.ExplicitlySpecifiedDirScanner(artifacts), new FilePath(this.dir), "copying");
        }

        public VirtualFile root() {
            return new NoOpenVF(VirtualFile.forFile((File)this.dir), this.baseURL);
        }

        public void onLoad(Run<?, ?> build) {
            this.dir = new File(Jenkins.get().getRootDir(), Util.getDigestOf((String)build.getExternalizableId()));
        }

        public boolean delete() throws IOException {
            if (!this.dir.exists()) {
                return false;
            }
            Util.deleteRecursive((File)this.dir);
            return true;
        }
    }

    private static final class NoOpenVF
    extends VirtualFile {
        private final VirtualFile delegate;
        private final URL baseURL;

        NoOpenVF(VirtualFile delegate, URL baseURL) {
            this.delegate = delegate;
            this.baseURL = baseURL;
        }

        public InputStream open() throws IOException {
            if (blockOpen.get() > 0) {
                throw new IllegalStateException("should not be called; use toExternalURL instead");
            }
            return this.delegate.open();
        }

        public URL toExternalURL() throws IOException {
            if (blockOpen.get() > 0) {
                String contents;
                try (InputStream is = this.delegate.open();){
                    contents = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                }
                return new URL(null, String.valueOf(this.baseURL) + URLEncoder.encode(contents, "UTF-8"), new URLStreamHandler(){

                    @Override
                    protected URLConnection openConnection(URL u) throws IOException {
                        throw new IOException("not allowed to open " + String.valueOf(u) + " from this JVM");
                    }
                });
            }
            return this.delegate.toExternalURL();
        }

        @NonNull
        public String getName() {
            return this.delegate.getName();
        }

        @NonNull
        public URI toURI() {
            return this.delegate.toURI();
        }

        public VirtualFile getParent() {
            return new NoOpenVF(this.delegate.getParent(), this.baseURL);
        }

        public boolean isDirectory() throws IOException {
            return this.delegate.isDirectory();
        }

        public boolean isFile() throws IOException {
            return this.delegate.isFile();
        }

        public String readLink() throws IOException {
            return this.delegate.readLink();
        }

        public boolean exists() throws IOException {
            return this.delegate.exists();
        }

        @NonNull
        public VirtualFile[] list() throws IOException {
            return (VirtualFile[])Arrays.stream(this.delegate.list()).map(vf -> new NoOpenVF((VirtualFile)vf, this.baseURL)).toArray(VirtualFile[]::new);
        }

        @NonNull
        public Collection<String> list(@NonNull String includes, String excludes, boolean useDefaultExcludes) throws IOException {
            return this.delegate.list(includes, excludes, useDefaultExcludes);
        }

        @NonNull
        public VirtualFile child(@NonNull String string) {
            return new NoOpenVF(this.delegate.child(string), this.baseURL);
        }

        public long length() throws IOException {
            return this.delegate.length();
        }

        public long lastModified() throws IOException {
            return this.delegate.lastModified();
        }

        public int mode() throws IOException {
            return this.delegate.mode();
        }

        public boolean canRead() throws IOException {
            return this.delegate.canRead();
        }

        public <V> V run(Callable<V, IOException> clbl) throws IOException {
            return (V)this.delegate.run(clbl);
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends ArtifactManagerFactoryDescriptor {
    }
}

